/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;

public class Boundary {
    private long boundaryId;
    private String name;
    private String altName;
    private int adminLevel;
    private long labelId;
    private long adminCenterId;
    private City.CityType cityType;
    private Multipolygon multipolygon;

    public Boundary(MultipolygonBuilder m) {
        this.multipolygon = m.build();
    }

    public boolean containsPoint(double latitude, double longitude) {
        return this.multipolygon.containsPoint(latitude, longitude);
    }

    public void mergeWith(Boundary boundary) {
        this.multipolygon.mergeWith(boundary.multipolygon);
    }

    public boolean containsPoint(LatLon location) {
        return this.multipolygon.containsPoint(location);
    }

    public long getBoundaryId() {
        return this.boundaryId;
    }

    public void setBoundaryId(long boundaryId) {
        this.boundaryId = boundaryId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }

    public String getAltName() {
        return this.altName;
    }

    public int getAdminLevel() {
        return this.adminLevel;
    }

    public boolean hasAdminLevel() {
        return this.adminLevel > 0;
    }

    public void setAdminLevel(int adminLevel) {
        this.adminLevel = adminLevel;
    }

    public String toString() {
        return this.getName() + " alevel:" + this.getAdminLevel() + " type: has opened polygons:" + this.multipolygon.hasOpenedPolygons() + " no. of outer polygons:" + this.multipolygon.countOuterPolygons();
    }

    public void setAdminCenterId(long l) {
        this.adminCenterId = l;
    }

    public boolean hasAdminCenterId() {
        return this.adminCenterId != 0L || this.hasLabelId();
    }

    public long getAdminCenterId() {
        return this.adminCenterId != 0L ? this.adminCenterId : this.labelId;
    }

    public void setLabelId(long l) {
        this.labelId = l;
    }

    public boolean hasLabelId() {
        return this.labelId != 0L;
    }

    public long getLabelId() {
        return this.labelId;
    }

    public void setCityType(City.CityType cityType) {
        this.cityType = cityType;
    }

    public City.CityType getCityType() {
        return this.cityType;
    }

    public LatLon getCenterPoint() {
        return this.multipolygon.getCenterPoint();
    }

    public LatLon getPolyCenterPoint() {
        return this.multipolygon.getPolyCenter();
    }

    public Multipolygon getMultipolygon() {
        return this.multipolygon;
    }
}

