/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.PascalArray2;
import io.github.cosinekitty.astronomy.Spherical;
import io.github.cosinekitty.astronomy.Time;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\b\u0010 \u001a\u00020!H\u0002J(\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,H\u0002J\u0018\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0002JF\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,J.\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,J\b\u0010:\u001a\u00020!H\u0002J\b\u0010;\u001a\u00020!H\u0002J\u0006\u0010<\u001a\u00020=R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&\u00a8\u0006>"}, d2={"Lio/github/cosinekitty/astronomy/MoonContext;", "", "time", "Lio/github/cosinekitty/astronomy/Time;", "<init>", "(Lio/github/cosinekitty/astronomy/Time;)V", "T", "", "DGAM", "DLAM", "N", "GAM1C", "SINPI", "L0", "L", "LS", "F", "D", "DL0", "DL", "DLS", "DF", "DD", "DS", "CO", "Lio/github/cosinekitty/astronomy/PascalArray2;", "SI", "ARC", "sine", "phi", "frac", "x", "longPeriodic", "", "xTerm", "getXTerm", "()D", "setXTerm", "(D)V", "yTerm", "getYTerm", "setYTerm", "term", "p", "", "q", "r", "s", "addTheta", "c2", "s2", "addSol", "coeffl", "coeffs", "coeffg", "coeffp", "addn", "coeffn", "solarN", "planetary", "calcMoon", "Lio/github/cosinekitty/astronomy/Spherical;", "OsmAnd-shared"})
final class MoonContext {
    private double T;
    private double DGAM;
    private double DLAM;
    private double N;
    private double GAM1C;
    private double SINPI;
    private double L0;
    private double L;
    private double LS;
    private double F;
    private double D;
    private double DL0;
    private double DL;
    private double DLS;
    private double DF;
    private double DD;
    private double DS;
    @NotNull
    private final PascalArray2 CO;
    @NotNull
    private final PascalArray2 SI;
    private final double ARC;
    private double xTerm;
    private double yTerm;

    public MoonContext(@NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.CO = new PascalArray2(-6, 6, 1, 4);
        this.SI = new PascalArray2(-6, 6, 1, 4);
        this.ARC = 206264.80624709636;
        this.T = time.julianCenturies$OsmAnd_shared();
        double T2 = this.T * this.T;
        this.DLAM = 0.0;
        this.DS = 0.0;
        this.GAM1C = 0.0;
        this.SINPI = 3422.7;
        this.longPeriodic();
        this.L0 = Math.PI * 2 * this.frac(0.60643382 + 1336.85522467 * this.T - 3.13E-6 * T2) + this.DL0 / this.ARC;
        this.L = Math.PI * 2 * this.frac(0.37489701 + 1325.55240982 * this.T + 2.565E-5 * T2) + this.DL / this.ARC;
        this.LS = Math.PI * 2 * this.frac(0.99312619 + 99.99735956 * this.T - 4.4E-7 * T2) + this.DLS / this.ARC;
        this.F = Math.PI * 2 * this.frac(0.25909118 + 1342.2278298 * this.T - 8.92E-6 * T2) + this.DF / this.ARC;
        this.D = Math.PI * 2 * this.frac(0.82736186 + 1236.85308708 * this.T - 3.97E-6 * T2) + this.DD / this.ARC;
        block5: for (int I = 1; I < 5; ++I) {
            double ARG = 0.0;
            int MAX = 0;
            double FAC = 0.0;
            switch (I) {
                case 1: {
                    ARG = this.L;
                    MAX = 4;
                    FAC = 1.000002208;
                    break;
                }
                case 2: {
                    ARG = this.LS;
                    MAX = 3;
                    FAC = 0.997504612 - 0.002495388 * this.T;
                    break;
                }
                case 3: {
                    ARG = this.F;
                    MAX = 4;
                    FAC = 1.000002708 + 139.978 * this.DGAM;
                    break;
                }
                default: {
                    ARG = this.D;
                    MAX = 6;
                    FAC = 1.0;
                }
            }
            this.CO.set(0, I, 1.0);
            this.CO.set(1, I, Math.cos(ARG) * FAC);
            this.SI.set(0, I, 0.0);
            this.SI.set(1, I, Math.sin(ARG) * FAC);
            int J = 2;
            int n = MAX;
            if (J <= n) {
                while (true) {
                    double c1 = this.CO.get(J - 1, I);
                    double s1 = this.SI.get(J - 1, I);
                    double c2 = this.CO.get(1, I);
                    double s2 = this.SI.get(1, I);
                    this.CO.set(J, I, c1 * c2 - s1 * s2);
                    this.SI.set(J, I, s1 * c2 + c1 * s2);
                    if (J == n) break;
                    ++J;
                }
            }
            if ((J = 1) > (n = MAX)) continue;
            while (true) {
                this.CO.set(-J, I, this.CO.get(J, I));
                this.SI.set(-J, I, -this.SI.get(J, I));
                if (J == n) continue block5;
                ++J;
            }
        }
        this.xTerm = Double.NaN;
        this.yTerm = Double.NaN;
    }

    private final double sine(double phi) {
        return Math.sin(Math.PI * 2 * phi);
    }

    private final double frac(double x) {
        return x - Math.floor(x);
    }

    private final void longPeriodic() {
        double S1 = this.sine(0.19833 + 0.05611 * this.T);
        double S2 = this.sine(0.27869 + 0.04508 * this.T);
        double S3 = this.sine(0.16827 - 0.36903 * this.T);
        double S4 = this.sine(0.34734 - 5.37261 * this.T);
        double S5 = this.sine(0.10498 - 5.37899 * this.T);
        double S6 = this.sine(0.42681 - 0.41855 * this.T);
        double S7 = this.sine(0.14943 - 5.37511 * this.T);
        this.DL0 = 0.84 * S1 + 0.31 * S2 + 14.27 * S3 + 7.26 * S4 + 0.28 * S5 + 0.24 * S6;
        this.DL = 2.94 * S1 + 0.31 * S2 + 14.27 * S3 + 9.34 * S4 + 1.12 * S5 + 0.83 * S6;
        this.DLS = -6.4 * S1 - 1.89 * S6;
        this.DF = 0.21 * S1 + 0.31 * S2 + 14.27 * S3 - 88.7 * S4 - 15.3 * S5 + 0.24 * S6 - 1.86 * S7;
        this.DD = this.DL0 - this.DLS;
        this.DGAM = -3.332E-6 * this.sine(0.59734 - 5.37261 * this.T) - 5.39E-7 * this.sine(0.35498 - 5.37899 * this.T) - 6.4E-8 * this.sine(0.39943 - 5.37511 * this.T);
    }

    public final double getXTerm() {
        return this.xTerm;
    }

    public final void setXTerm(double d) {
        this.xTerm = d;
    }

    public final double getYTerm() {
        return this.yTerm;
    }

    public final void setYTerm(double d) {
        this.yTerm = d;
    }

    private final void term(int p, int q, int r, int s) {
        this.xTerm = 1.0;
        this.yTerm = 0.0;
        if (p != 0) {
            this.addTheta(this.CO.get(p, 1), this.SI.get(p, 1));
        }
        if (q != 0) {
            this.addTheta(this.CO.get(q, 2), this.SI.get(q, 2));
        }
        if (r != 0) {
            this.addTheta(this.CO.get(r, 3), this.SI.get(r, 3));
        }
        if (s != 0) {
            this.addTheta(this.CO.get(s, 4), this.SI.get(s, 4));
        }
    }

    private final void addTheta(double c2, double s2) {
        double c1 = this.xTerm;
        double s1 = this.yTerm;
        this.xTerm = c1 * c2 - s1 * s2;
        this.yTerm = s1 * c2 + c1 * s2;
    }

    public final void addSol(double coeffl, double coeffs, double coeffg, double coeffp, int p, int q, int r, int s) {
        this.term(p, q, r, s);
        this.DLAM += coeffl * this.yTerm;
        this.DS += coeffs * this.yTerm;
        this.GAM1C += coeffg * this.xTerm;
        this.SINPI += coeffp * this.xTerm;
    }

    public final void addn(double coeffn, int p, int q, int r, int s) {
        this.term(p, q, r, s);
        this.N += coeffn * this.yTerm;
    }

    private final void solarN() {
        this.N = 0.0;
        this.addn(-526.069, 0, 0, 1, -2);
        this.addn(-3.352, 0, 0, 1, -4);
        this.addn(44.297, 1, 0, 1, -2);
        this.addn(-6.0, 1, 0, 1, -4);
        this.addn(20.599, -1, 0, 1, 0);
        this.addn(-30.598, -1, 0, 1, -2);
        this.addn(-24.649, -2, 0, 1, 0);
        this.addn(-2.0, -2, 0, 1, -2);
        this.addn(-22.571, 0, 1, 1, -2);
        this.addn(10.985, 0, -1, 1, -2);
    }

    private final void planetary() {
        this.DLAM += 0.82 * this.sine(0.7736 - 62.5512 * this.T) + 0.31 * this.sine(0.0466 - 125.1025 * this.T) + 0.35 * this.sine(0.5785 - 25.1042 * this.T) + 0.66 * this.sine(0.4591 + 1335.8075 * this.T) + 0.64 * this.sine(0.313 - 91.568 * this.T) + 1.14 * this.sine(0.148 + 1331.2898 * this.T) + 0.21 * this.sine(0.5918 + 1056.5859 * this.T) + 0.44 * this.sine(0.5784 + 1322.8595 * this.T) + 0.24 * this.sine(0.2275 - 5.7374 * this.T) + 0.28 * this.sine(0.2965 + 2.6929 * this.T) + 0.33 * this.sine(0.3132 + 6.3368 * this.T);
    }

    @NotNull
    public final Spherical calcMoon() {
        Astronomy.access$addSolarTerms(this);
        this.solarN();
        this.planetary();
        double S = this.F + this.DS / this.ARC;
        double latSeconds = (1.000002708 + 139.978 * this.DGAM) * (18519.699999999997 + this.GAM1C) * Math.sin(S) - 6.24 * Math.sin((double)3 * S) + this.N;
        return new Spherical(latSeconds / 3600.0, 360.0 * this.frac((this.L0 + this.DLAM / this.ARC) / (Math.PI * 2)), this.ARC * 4.263520978299708E-5 / (0.999953253 * this.SINPI));
    }
}

