/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import net.osmand.gpx.GPXUtilities;

class SplitSegment {
    GPXUtilities.TrkSegment segment;
    double startCoeff = 0.0;
    int startPointInd;
    double endCoeff = 0.0;
    int endPointInd;
    double metricEnd;
    double secondaryMetricEnd;

    public SplitSegment(GPXUtilities.TrkSegment segment) {
        this.startPointInd = 0;
        this.startCoeff = 0.0;
        this.endPointInd = segment.points.size() - 2;
        this.endCoeff = 1.0;
        this.segment = segment;
    }

    public SplitSegment(int startInd, int endInd, GPXUtilities.TrkSegment segment) {
        this.startPointInd = startInd;
        this.startCoeff = 0.0;
        this.endPointInd = endInd - 2;
        this.endCoeff = 1.0;
        this.segment = segment;
    }

    public SplitSegment(GPXUtilities.TrkSegment segment, int pointInd, double cf) {
        this.segment = segment;
        this.startPointInd = pointInd;
        this.startCoeff = cf;
    }

    public int getNumberOfPoints() {
        return this.endPointInd - this.startPointInd + 2;
    }

    public GPXUtilities.WptPt get(int j) {
        int ind = j + this.startPointInd;
        if (j == 0) {
            if (this.startCoeff == 0.0) {
                return this.segment.points.get(ind);
            }
            return this.approx(this.segment.points.get(ind), this.segment.points.get(ind + 1), this.startCoeff);
        }
        if (j == this.getNumberOfPoints() - 1) {
            if (this.endCoeff == 1.0) {
                return this.segment.points.get(ind);
            }
            return this.approx(this.segment.points.get(ind - 1), this.segment.points.get(ind), this.endCoeff);
        }
        return this.segment.points.get(ind);
    }

    private GPXUtilities.WptPt approx(GPXUtilities.WptPt w1, GPXUtilities.WptPt w2, double cf) {
        long time = this.value(w1.time, w2.time, 0L, cf);
        double speed = this.value(w1.speed, w2.speed, 0.0, cf);
        double ele = this.value(w1.ele, w2.ele, 0.0, cf);
        double hdop = this.value(w1.hdop, w2.hdop, 0.0, cf);
        double lat = this.value(w1.lat, w2.lat, -360.0, cf);
        double lon = this.value(w1.lon, w2.lon, -360.0, cf);
        return new GPXUtilities.WptPt(lat, lon, time, ele, speed, hdop);
    }

    private double value(double vl, double vl2, double none, double cf) {
        if (vl == none || Double.isNaN(vl)) {
            return vl2;
        }
        if (vl2 == none || Double.isNaN(vl2)) {
            return vl;
        }
        return vl + cf * (vl2 - vl);
    }

    private long value(long vl, long vl2, long none, double cf) {
        if (vl == none) {
            return vl2;
        }
        if (vl2 == none) {
            return vl;
        }
        return vl + (long)(cf * (double)(vl2 - vl));
    }

    public double setLastPoint(int pointInd, double endCf) {
        this.endCoeff = endCf;
        this.endPointInd = pointInd;
        return this.endCoeff;
    }
}

