/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import net.osmand.IProgress;
import net.osmand.binary.MapZooms;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.preparation.BasemapProcessor;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexAddressCreator;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.IndexHeightData;
import net.osmand.obf.preparation.IndexPoiCreator;
import net.osmand.obf.preparation.IndexRouteCreator;
import net.osmand.obf.preparation.IndexRouteRelationCreator;
import net.osmand.obf.preparation.IndexRouteRelationCreatorV1;
import net.osmand.obf.preparation.IndexTransportCreator;
import net.osmand.obf.preparation.IndexVectorMapCreator;
import net.osmand.obf.preparation.MissingWikiTagsProcessor;
import net.osmand.obf.preparation.OsmDbAccessor;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.OsmDbCreator;
import net.osmand.obf.preparation.PropagateToNodes;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.IOsmStorageFilter;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmBaseStoragePbf;
import net.osmand.util.Algorithms;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xmlpull.v1.XmlPullParserException;
import rtree.RTreeException;

public class IndexCreator {
    private static final Log log = LogFactory.getLog(IndexCreator.class);
    private DBDialect osmDBdialect = DBDialect.SQLITE;
    private DBDialect mapIndexDBDialect = DBDialect.SQLITE;
    public static boolean REMOVE_POI_DB = true;
    public static final int BATCH_SIZE = 5000;
    public static final int BATCH_SIZE_OSM = 10000;
    public static final String TEMP_NODES_DB = "nodes.tmp.odb";
    public static final int STEP_MAIN = 4;
    private File workingDir = null;
    private String regionName;
    private String mapFileName = null;
    private Long lastModifiedDate = null;
    private IndexCreatorSettings settings;
    IndexTransportCreator indexTransportCreator;
    IndexPoiCreator indexPoiCreator;
    IndexAddressCreator indexAddressCreator;
    IndexVectorMapCreator indexMapCreator;
    IndexRouteRelationCreator indexRouteRelationCreatorV2;
    IndexRouteRelationCreatorV1 indexRouteRelationCreatorV1;
    IndexRouteCreator indexRouteCreator;
    IndexHeightData heightData = null;
    PropagateToNodes propagateToNodes;
    private File dbFile;
    private File mapFile;
    private RandomAccessFile mapRAFile;
    private Connection mapConnection;
    private boolean recreateOnlyBinaryFile = false;
    private boolean deleteOsmDB = true;
    private boolean deleteDatabaseIndexes = true;
    private String TIGER_OSMAND_TAG = "tiger:osmand";

    public IndexCreator(File workingDir, IndexCreatorSettings settings) {
        this.workingDir = workingDir;
        this.settings = settings;
        if (settings.srtmDataFolderUrl == null && new File(workingDir, "srtm").exists()) {
            settings.srtmDataFolderUrl = new File(workingDir, "srtm").getAbsolutePath();
        }
        if (settings.srtmDataFolderUrl != null) {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("TIFF");
            while (readers.hasNext()) {
                System.out.println("Tiff reader: " + String.valueOf(readers.next()));
            }
            this.heightData = new IndexHeightData();
            this.heightData.setSrtmData(settings.srtmDataFolderUrl, workingDir);
        }
    }

    public IndexCreatorSettings getSettings() {
        return this.settings;
    }

    public String getRegionName() {
        if (this.regionName == null) {
            return "Region";
        }
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    private Object getDatabaseConnection(String fileName, DBDialect dialect) throws SQLException {
        return dialect.getDatabaseConnection(fileName, log);
    }

    public void setNodesDBFile(File file) {
        this.dbFile = file;
    }

    public void setDeleteOsmDB(boolean deleteOsmDB) {
        this.deleteOsmDB = deleteOsmDB;
    }

    public void setMapFileName(String mapFileName) {
        this.mapFileName = mapFileName;
    }

    public String getMapFileName() {
        if (this.mapFileName == null) {
            return this.getRegionName() + ".obf";
        }
        return this.mapFileName;
    }

    public String getTempMapDBFileName() {
        return this.getMapFileName() + ".tmp";
    }

    public void setDialects(DBDialect osmDBdialect, DBDialect mapIndexDBDialect) {
        if (osmDBdialect != null) {
            this.osmDBdialect = osmDBdialect;
        }
        if (mapIndexDBDialect != null) {
            this.mapIndexDBDialect = mapIndexDBDialect;
        }
    }

    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public static String getPoiFileName(String regionName) {
        return regionName + ".poi.odb";
    }

    public String getPoiFileName() {
        return IndexCreator.getPoiFileName(this.getRegionName());
    }

    private File getPoiFile() {
        return new File(this.workingDir, this.getPoiFileName());
    }

    public String getRTreeMapIndexNonPackFileName() {
        return this.mapFile.getAbsolutePath() + ".rtree";
    }

    public String getRTreeRouteIndexNonPackFileName() {
        return this.mapFile.getAbsolutePath() + ".rte";
    }

    public String getRTreeRouteIndexPackFileName() {
        return this.mapFile.getAbsolutePath() + ".prte";
    }

    public String getRTreeTransportStopsFileName() {
        return this.mapFile.getAbsolutePath() + ".trans";
    }

    public String getRTreeTransportStopsPackFileName() {
        return this.mapFile.getAbsolutePath() + ".ptrans";
    }

    public String getRTreeMapIndexPackFileName() {
        return this.mapFile.getAbsolutePath() + ".prtree";
    }

    private void iterateMainEntity(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        this.calculateRegionTagAndTransliterate(e, icc);
        if (e.getTag(this.TIGER_OSMAND_TAG) != null) {
            if (this.settings.indexAddress) {
                this.indexAddressCreator.iterateMainEntity(e, ctx, icc);
            }
            return;
        }
        if (this.heightData != null && e instanceof Way && !this.settings.keepOnlyRouteRelationObjects) {
            this.heightData.proccess((Way)e);
        }
        if (this.propagateToNodes != null && e instanceof Node) {
            this.propagateToNodes.propagateTagsToNode((Node)e, true);
        }
        if (this.settings.indexPOI) {
            this.indexPoiCreator.iterateEntity(e, ctx, icc);
        }
        if (this.settings.indexTransport) {
            this.indexTransportCreator.iterateMainEntity(e, ctx, icc);
        }
        if (this.settings.indexMap && (this.settings.boundary == null || this.checkBoundary(e))) {
            this.indexMapCreator.iterateMainEntity(e, ctx, icc);
            this.indexRouteRelationCreatorV1.iterateMainEntity(e, ctx, icc);
        }
        if (this.settings.indexAddress) {
            this.indexAddressCreator.iterateMainEntity(e, ctx, icc);
        }
        if (this.settings.indexRouting) {
            this.indexRouteCreator.iterateMainEntity(e, ctx, icc);
        }
    }

    private void calculateRegionTagAndTransliterate(Entity e, IndexCreationContext icc) {
        if (this.settings.addRegionTag) {
            icc.calcRegionTag(e, true);
        }
        icc.translitJapaneseNames(e);
        icc.translitChineseNames(e);
    }

    private boolean checkBoundary(Entity e) {
        if (this.settings.boundary != null) {
            if (e instanceof Way) {
                for (Node n : ((Way)e).getNodes()) {
                    if (!this.settings.boundary.containsPoint(n.getLatitude(), n.getLongitude())) continue;
                    return true;
                }
                return false;
            }
            if (e instanceof Node) {
                return this.settings.boundary.containsPoint(((Node)e).getLatitude(), ((Node)e).getLongitude());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmDbCreator extractOsmToNodesDB(OsmDbAccessor accessor, File readFile, IProgress progress, IOsmStorageFilter addFilter, int idSourceMapInd, int idShift, final boolean generateNewIds, OsmDbCreator previous) throws IOException, SQLException, XmlPullParserException {
        OsmDbCreator dbCreator;
        FilterInputStream stream;
        boolean pbfFile = false;
        BufferedInputStream streamFile = stream = new BufferedInputStream(new FileInputStream(readFile), 32768);
        long st = System.currentTimeMillis();
        if (readFile.getName().endsWith(".bz2")) {
            stream = new BZip2CompressorInputStream((InputStream)stream);
        } else if (readFile.getName().endsWith(".gz")) {
            stream = new GZIPInputStream(stream);
        } else if (readFile.getName().endsWith(".pbf")) {
            pbfFile = true;
        }
        OsmBaseStoragePbf storage = pbfFile ? new OsmBaseStoragePbf() : new OsmBaseStorage();
        storage.setSupressWarnings(this.settings.suppressWarningsForDuplicateIds);
        if (addFilter != null) {
            storage.getFilters().add(addFilter);
        }
        storage.getFilters().add(new IOsmStorageFilter(){

            public boolean acceptEntityToLoad(OsmBaseStorage storage, Entity.EntityId entityId, Entity entity) {
                if (IndexCreator.this.indexAddressCreator != null && entityId.getType() == Entity.EntityType.NODE) {
                    Node n = (Node)entity;
                    if (!generateNewIds) {
                        n = new Node(n, n.getId() << 6);
                    }
                    IndexCreator.this.indexAddressCreator.registerCityNodes(n);
                }
                return true;
            }
        });
        OsmDbCreator osmDbCreator = dbCreator = generateNewIds ? new OsmDbCreator(idSourceMapInd, idShift) : new OsmDbCreator();
        if (!this.settings.ignorePropagate) {
            dbCreator.setPropagateToNodes(this.propagateToNodes);
        }
        accessor.setCreator(dbCreator);
        try {
            this.setGeneralProgress(progress, "[15 / 100]");
            progress.startTask(this.settings.getString("IndexCreator.LOADING_FILE") + readFile.getAbsolutePath(), -1);
            dbCreator.initDatabase(this.osmDBdialect, accessor.getDbConn(), idSourceMapInd == 0, previous);
            storage.getFilters().add(dbCreator);
            if (pbfFile) {
                storage.parseOSMPbf(stream, progress, false);
            } else {
                storage.parseOSM(stream, progress, streamFile, false);
            }
            dbCreator.finishLoading();
            this.osmDBdialect.commitDatabase(accessor.getDbConn());
            if (log.isInfoEnabled()) {
                log.info((Object)("File parsed : " + (System.currentTimeMillis() - st)));
            }
            progress.finishTask();
            OsmDbCreator osmDbCreator2 = dbCreator;
            return osmDbCreator2;
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info((Object)("File indexed : " + (System.currentTimeMillis() - st)));
            }
        }
    }

    private OsmDbAccessor initDbAccessor(File[] readFile, IProgress progress, IOsmStorageFilter addFilter, boolean generateUniqueIdsForEachFile) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        int idShift;
        OsmDbAccessor accessor = new OsmDbAccessor();
        if (this.settings.wikidataMappingUrl != null) {
            accessor.setTagsPrepration(new MissingWikiTagsProcessor(this.settings.wikidataMappingUrl, this.settings.wikirankingMappingUrl));
        } else if (!Algorithms.isEmpty((CharSequence)System.getenv("WIKIDATA_MAPPING_URL"))) {
            accessor.setTagsPrepration(new MissingWikiTagsProcessor(System.getenv("WIKIDATA_MAPPING_URL"), System.getenv("WIKIRANKING_MAPPING_URL")));
        } else {
            log.info((Object)"Not using wikidata database to map missing wikidata tags");
        }
        if (this.dbFile == null) {
            this.dbFile = new File(this.workingDir, TEMP_NODES_DB);
        }
        if (this.osmDBdialect.databaseFileExists(this.dbFile)) {
            this.osmDBdialect.removeDatabase(this.dbFile);
        }
        Connection dbConn = (Connection)this.getDatabaseConnection(this.dbFile.getAbsolutePath(), this.osmDBdialect);
        accessor.setDbConn(dbConn, this.osmDBdialect);
        OsmDbCreator dbCreator = null;
        int n = readFile.length < 16 ? 4 : (idShift = readFile.length < 64 ? 6 : 11);
        if (readFile.length > 2048) {
            throw new UnsupportedOperationException();
        }
        int idSourceMapInd = 0;
        for (File read : readFile) {
            dbCreator = this.extractOsmToNodesDB(accessor, read, progress, addFilter, idSourceMapInd, idShift, generateUniqueIdsForEachFile, null);
            accessor.updateCounts(dbCreator);
            if (readFile.length > 1) {
                log.info((Object)("Processing " + (idSourceMapInd + 1) + " file out of " + readFile.length));
            }
            ++idSourceMapInd;
        }
        this.osmDBdialect.commitDatabase(dbConn);
        accessor.initDatabase();
        return accessor;
    }

    private void createDatabaseIndexesStructure() throws SQLException, IOException {
        this.mapFile = new File(this.workingDir, this.getMapFileName());
        this.mapFile.getParentFile().mkdirs();
        File tempDBMapFile = new File(this.workingDir, this.getTempMapDBFileName());
        this.mapIndexDBDialect.removeDatabase(tempDBMapFile);
        this.mapConnection = (Connection)this.getDatabaseConnection(tempDBMapFile.getAbsolutePath(), this.mapIndexDBDialect);
        this.mapConnection.setAutoCommit(false);
        if (this.settings.indexMap) {
            this.indexMapCreator.createDatabaseStructure(this.mapConnection, this.mapIndexDBDialect, this.getRTreeMapIndexNonPackFileName());
        }
        if (this.settings.indexRouting) {
            this.indexRouteCreator.createDatabaseStructure(this.mapConnection, this.mapIndexDBDialect, this.getRTreeRouteIndexNonPackFileName());
        }
        if (this.settings.indexAddress) {
            this.indexAddressCreator.createDatabaseStructure(this.mapConnection, this.mapIndexDBDialect);
        }
        if (this.settings.indexPOI) {
            this.indexPoiCreator.createDatabaseStructure(this.getPoiFile());
        }
        if (this.settings.indexTransport) {
            this.indexTransportCreator.createDatabaseStructure(this.mapConnection, this.mapIndexDBDialect, this.getRTreeTransportStopsFileName());
        }
    }

    public void generateBasemapIndex(final boolean mini, IProgress progress, IOsmStorageFilter addFilter, MapZooms mapZooms, MapRenderingTypesEncoder renderingTypes, Log logMapDataWarn, String regionName, File ... readFiles) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        if (logMapDataWarn == null) {
            logMapDataWarn = log;
        }
        if (renderingTypes == null) {
            renderingTypes = new MapRenderingTypesEncoder("basemap");
        }
        if (mapZooms == null) {
            mapZooms = MapZooms.getDefault();
        }
        try {
            IndexPoiCreator poiCreator;
            final BasemapProcessor processor = new BasemapProcessor(logMapDataWarn, mapZooms, renderingTypes, this.settings.zoomWaySmoothness);
            IndexPoiCreator indexPoiCreator = poiCreator = this.settings.indexPOI ? new IndexPoiCreator(this.settings, renderingTypes) : null;
            if (this.settings.indexPOI) {
                poiCreator.createDatabaseStructure(this.getPoiFile());
            }
            OsmDbAccessor accessor = this.initDbAccessor(readFiles, progress, addFilter, true);
            final IndexCreationContext icc = new IndexCreationContext(this, regionName, true);
            this.setGeneralProgress(progress, "[50 / 100]");
            progress.startTask(this.settings.getString("IndexCreator.PROCESS_OSM_NODES"), accessor.getAllNodes());
            accessor.iterateOverEntities(progress, Entity.EntityType.NODE, new OsmDbAccessor.OsmDbVisitor(){

                @Override
                public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                    IndexCreator.this.calculateRegionTagAndTransliterate(e, icc);
                    processor.processEntity(mini, e);
                    if (IndexCreator.this.settings.indexPOI) {
                        poiCreator.iterateEntity(e, ctx, icc);
                    }
                }
            });
            this.setGeneralProgress(progress, "[70 / 100]");
            progress.startTask(this.settings.getString("IndexCreator.PROCESS_OSM_WAYS"), accessor.getAllWays());
            accessor.iterateOverEntities(progress, Entity.EntityType.WAY, new OsmDbAccessor.OsmDbVisitor(){

                @Override
                public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                    IndexCreator.this.calculateRegionTagAndTransliterate(e, icc);
                    processor.processEntity(mini, e);
                    if (IndexCreator.this.settings.indexPOI) {
                        poiCreator.iterateEntity(e, ctx, icc);
                    }
                }
            });
            this.setGeneralProgress(progress, "[90 / 100]");
            progress.startTask(this.settings.getString("IndexCreator.PROCESS_OSM_REL"), accessor.getAllRelations());
            accessor.iterateOverEntities(progress, Entity.EntityType.RELATION, new OsmDbAccessor.OsmDbVisitor(){

                @Override
                public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                    ctx.loadEntityRelation((Relation)e);
                    IndexCreator.this.calculateRegionTagAndTransliterate(e, icc);
                    processor.processEntity(mini, e);
                }
            });
            accessor.closeReadingConnection();
            this.mapFile = new File(this.workingDir, this.getMapFileName());
            this.mapFile.getParentFile().mkdirs();
            if (this.mapFile.exists()) {
                this.mapFile.delete();
            }
            this.mapRAFile = new RandomAccessFile(this.mapFile, "rw");
            BinaryMapIndexWriter writer = new BinaryMapIndexWriter(this.mapRAFile, this.lastModifiedDate == null ? System.currentTimeMillis() : this.lastModifiedDate);
            this.setGeneralProgress(progress, "[95 of 100]");
            progress.startTask("Writing map index to binary file...", -1);
            processor.writeBasemapFile(writer, regionName);
            if (this.settings.indexPOI) {
                poiCreator.writeBinaryPoiIndex(null, writer, regionName, progress);
            }
            progress.finishTask();
            writer.close();
            this.mapRAFile.close();
            log.info((Object)"Finish writing binary file");
        }
        catch (RuntimeException e) {
            log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
    }

    public File generateIndexes(File readFile, IProgress progress, IOsmStorageFilter addFilter, MapZooms mapZooms, MapRenderingTypesEncoder renderingTypes, Log logMapDataWarn) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        return this.generateIndexes(new File[]{readFile}, progress, addFilter, mapZooms, renderingTypes, logMapDataWarn, false);
    }

    /*
     * Unable to fully structure code
     */
    public File generateIndexes(File[] readFile, IProgress progress, IOsmStorageFilter addFilter, MapZooms mapZooms, MapRenderingTypesEncoder renderingTypes, Log logMapDataWarn, boolean generateUniqueIds) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        if (logMapDataWarn == null) {
            logMapDataWarn = IndexCreator.log;
        }
        if (mapZooms == null) {
            mapZooms = MapZooms.getDefault();
        }
        if (readFile != null && readFile.length > 0 && this.regionName == null && (i = readFile[0].getName().indexOf(46)) > -1) {
            this.regionName = Algorithms.capitalizeFirstLetterAndLowercase((String)readFile[0].getName().substring(0, i));
        }
        icc = new IndexCreationContext(this, this.regionName, false);
        if (renderingTypes == null) {
            renderingTypes = new MapRenderingTypesEncoder(null, this.regionName);
        }
        this.propagateToNodes = new PropagateToNodes(renderingTypes);
        this.indexTransportCreator = new IndexTransportCreator(this.settings);
        this.indexPoiCreator = new IndexPoiCreator(this.settings, renderingTypes);
        this.indexAddressCreator = new IndexAddressCreator(logMapDataWarn, this.settings);
        this.indexMapCreator = new IndexVectorMapCreator(logMapDataWarn, mapZooms, renderingTypes, this.settings, this.propagateToNodes, this.getLastModifiedDate());
        this.indexRouteCreator = new IndexRouteCreator(renderingTypes, logMapDataWarn, this.settings, this.propagateToNodes);
        this.indexRouteRelationCreatorV1 = new IndexRouteRelationCreatorV1(logMapDataWarn, mapZooms, renderingTypes, this.settings);
        this.indexRouteRelationCreatorV2 = new IndexRouteRelationCreator(this.indexPoiCreator, this.indexMapCreator, this.getLastModifiedDate());
        if (!this.settings.extraRelations.isEmpty()) {
            for (File inputFile : this.settings.extraRelations) {
                reader = new OsmBaseStorage();
                fis = new FileInputStream(inputFile);
                if (inputFile.getName().endsWith(".gz")) {
                    fis = new GZIPInputStream(fis);
                } else if (inputFile.getName().endsWith(".bz2")) {
                    fis = new BZip2CompressorInputStream(fis);
                }
                reader.parseOSM(fis, progress);
                fis.close();
                this.indexRouteCreator.indexExtraRelations(reader);
            }
        }
        try {
            if (this.recreateOnlyBinaryFile) {
                this.mapFile = new File(this.workingDir, this.getMapFileName());
                tempDBMapFile = new File(this.workingDir, this.getTempMapDBFileName());
                this.mapConnection = (Connection)this.getDatabaseConnection(tempDBMapFile.getAbsolutePath(), this.mapIndexDBDialect);
                this.mapConnection.setAutoCommit(false);
                try {
                    if (this.settings.indexMap) {
                        this.indexMapCreator.createRTreeFiles(this.getRTreeMapIndexPackFileName());
                    }
                    if (this.settings.indexRouting) {
                        this.indexRouteCreator.createRTreeFiles(this.getRTreeRouteIndexPackFileName());
                    }
                    if (!this.settings.indexTransport) ** GOTO lbl77
                    this.indexTransportCreator.createRTreeFile(this.getRTreeTransportStopsPackFileName());
                }
                catch (RTreeException e) {
                    IndexCreator.log.error((Object)"Error flushing", (Throwable)e);
                    throw new IOException(e);
                }
            } else {
                this.createDatabaseIndexesStructure();
                accessor = this.initDbAccessor(readFile, progress, addFilter, generateUniqueIds);
                this.writeAllCities(accessor, progress);
                this.indexRelations(accessor, progress, icc);
                this.iterateMainEntities(accessor, progress, icc);
                accessor.closeReadingConnection();
                if (accessor.getDbConn() != null) {
                    this.osmDBdialect.commitDatabase(accessor.getDbConn());
                    this.osmDBdialect.closeDatabase(accessor.getDbConn());
                }
                if (this.deleteOsmDB) {
                    this.osmDBdialect.removeDatabase(this.dbFile);
                }
                if (this.settings.indexMap || this.settings.indexRouting) {
                    this.setGeneralProgress(progress, "[90 / 100]");
                    if (this.settings.indexMap) {
                        progress.startTask(this.settings.getString("IndexCreator.INDEX_LO_LEVEL_WAYS"), this.indexMapCreator.getLowLevelWays());
                        this.indexMapCreator.processingLowLevelWays(progress);
                    }
                    if (this.settings.indexRouting) {
                        progress.startTask(this.settings.getString("IndexCreator.INDEX_LO_LEVEL_WAYS"), -1);
                        this.indexRouteCreator.processingLowLevelWays(progress);
                    }
                }
                if (this.settings.indexMap) {
                    this.setGeneralProgress(progress, "[90 / 100]");
                    progress.startTask(this.settings.getString("IndexCreator.PACK_RTREE_MAP"), -1);
                    this.indexMapCreator.packRtreeFiles(this.getRTreeMapIndexNonPackFileName(), this.getRTreeMapIndexPackFileName());
                }
                if (this.settings.indexRouting) {
                    this.indexRouteCreator.packRtreeFiles(this.getRTreeRouteIndexNonPackFileName(), this.getRTreeRouteIndexPackFileName());
                }
                if (this.settings.indexTransport) {
                    this.setGeneralProgress(progress, "[90 / 100]");
                    progress.startTask(this.settings.getString("IndexCreator.PACK_RTREE_TRANSP"), -1);
                    this.indexTransportCreator.packRTree(this.getRTreeTransportStopsFileName(), this.getRTreeTransportStopsPackFileName());
                }
            }
lbl77:
            // 5 sources

            if (this.settings.indexMap || this.settings.indexAddress || this.settings.indexTransport || this.settings.indexPOI || this.settings.indexRouting) {
                if (this.mapFile.exists()) {
                    this.mapFile.delete();
                }
                this.mapRAFile = new RandomAccessFile(this.mapFile, "rw");
                writer = new BinaryMapIndexWriter(this.mapRAFile, this.lastModifiedDate == null ? System.currentTimeMillis() : this.lastModifiedDate);
                if (this.settings.indexMap) {
                    this.setGeneralProgress(progress, "[95 of 100]");
                    progress.startTask("Writing map index to binary file...", -1);
                    this.indexMapCreator.writeBinaryMapIndex(writer, this.regionName);
                }
                if (this.settings.indexRouting) {
                    this.setGeneralProgress(progress, "[95 of 100]");
                    progress.startTask("Writing route index to binary file...", -1);
                    this.indexRouteCreator.writeBinaryRouteIndex(this.mapFile, writer, this.regionName, this.settings.generateLowLevel);
                }
                if (this.settings.indexAddress) {
                    this.setGeneralProgress(progress, "[95 of 100]");
                    progress.startTask("Writing address index to binary file...", -1);
                    this.indexAddressCreator.writeBinaryAddressIndex(writer, this.regionName, progress);
                }
                if (this.settings.indexPOI) {
                    this.setGeneralProgress(progress, "[95 of 100]");
                    progress.startTask("Writing poi index to binary file...", -1);
                    this.indexPoiCreator.writeBinaryPoiIndex(this.mapFile, writer, this.regionName, progress);
                }
                if (this.settings.indexTransport) {
                    this.setGeneralProgress(progress, "[95 of 100]");
                    progress.startTask("Writing transport index to binary file...", -1);
                    this.indexTransportCreator.writeBinaryTransportIndex(writer, this.regionName, this.mapConnection);
                }
                progress.finishTask();
                writer.close();
                this.mapRAFile.close();
                IndexCreator.log.info((Object)"Finish writing binary file");
            }
        }
        catch (RuntimeException e) {
            IndexCreator.log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            IndexCreator.log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            IndexCreator.log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
        catch (XmlPullParserException e) {
            IndexCreator.log.error((Object)"Log exception", (Throwable)e);
            throw e;
        }
        finally {
            try {
                this.indexPoiCreator.commitAndClosePoiFile(this.lastModifiedDate);
                if (IndexCreator.REMOVE_POI_DB) {
                    this.indexPoiCreator.removePoiFile();
                }
                this.indexRouteRelationCreatorV1.closeAllStatements();
                this.indexRouteRelationCreatorV2.closeAllStatements();
                this.indexAddressCreator.closeAllPreparedStatements();
                this.indexTransportCreator.commitAndCloseFiles(this.getRTreeTransportStopsFileName(), this.getRTreeTransportStopsPackFileName(), this.deleteDatabaseIndexes);
                this.indexMapCreator.commitAndCloseFiles(this.getRTreeMapIndexNonPackFileName(), this.getRTreeMapIndexPackFileName(), this.deleteDatabaseIndexes);
                this.indexRouteCreator.commitAndCloseFiles(this.getRTreeRouteIndexNonPackFileName(), this.getRTreeRouteIndexPackFileName(), this.deleteDatabaseIndexes);
                if (this.mapConnection != null) {
                    this.mapConnection.commit();
                    this.mapConnection.close();
                    this.mapConnection = null;
                    tempDBFile = new File(this.workingDir, this.getTempMapDBFileName());
                    if (this.mapIndexDBDialect.databaseFileExists(tempDBFile) && this.deleteDatabaseIndexes) {
                        this.mapIndexDBDialect.removeDatabase(tempDBFile);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return this.mapFile;
    }

    private void iterateMainEntities(OsmDbAccessor accessor, IProgress progress, final IndexCreationContext icc) throws SQLException, InterruptedException {
        this.setGeneralProgress(progress, "[50 / 100]");
        progress.startTask(this.settings.getString("IndexCreator.PROCESS_OSM_NODES"), accessor.getAllNodes());
        accessor.iterateOverEntities(progress, Entity.EntityType.NODE, new OsmDbAccessor.OsmDbVisitor(){

            @Override
            public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                IndexCreator.this.iterateMainEntity(e, ctx, icc);
            }
        });
        this.setGeneralProgress(progress, "[70 / 100]");
        progress.startTask(this.settings.getString("IndexCreator.PROCESS_OSM_WAYS"), accessor.getAllWays());
        accessor.iterateOverEntities(progress, Entity.EntityType.WAY, new OsmDbAccessor.OsmDbVisitor(){

            @Override
            public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                Way w = (Way)e;
                IndexCreator.this.propagateToNodes.calculateBorderPoints(w);
                IndexCreator.this.iterateMainEntity(e, ctx, icc);
            }
        });
        this.setGeneralProgress(progress, "[85 / 100]");
        progress.startTask(this.settings.getString("IndexCreator.PROCESS_OSM_REL"), accessor.getAllRelations());
        accessor.iterateOverEntities(progress, Entity.EntityType.RELATION, new OsmDbAccessor.OsmDbVisitor(){

            @Override
            public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                IndexCreator.this.iterateMainEntity(e, ctx, icc);
            }
        });
    }

    private void indexRelations(OsmDbAccessor accessor, IProgress progress, final IndexCreationContext icc) throws SQLException, InterruptedException {
        if (this.settings.indexAddress || this.settings.indexMap || this.settings.indexRouting || this.settings.indexPOI || this.settings.indexTransport) {
            this.setGeneralProgress(progress, "[30 / 100]");
            progress.startTask(this.settings.getString("IndexCreator.PREINDEX_BOUNDARIES_RELATIONS"), accessor.getAllRelations());
            accessor.iterateOverEntities(progress, Entity.EntityType.RELATION, new OsmDbAccessor.OsmDbVisitor(){

                @Override
                public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                    IndexCreator.this.calculateRegionTagAndTransliterate(e, icc);
                    if (IndexCreator.this.settings.indexAddress) {
                        IndexCreator.this.indexAddressCreator.indexBoundaries(e, ctx);
                    }
                    if (IndexCreator.this.settings.indexMap) {
                        if (!IndexCreator.this.settings.keepOnlyRouteRelationObjects) {
                            IndexCreator.this.indexMapCreator.indexMapRelationsAndMultiPolygons(e, ctx, icc);
                        } else {
                            IndexCreator.this.indexRouteRelationCreatorV1.iterateRelation(e, ctx, icc);
                        }
                        if (IndexCreator.this.settings.indexPOI && IndexCreator.this.settings.indexMap && IndexCreator.this.settings.indexRouteRelations) {
                            IndexCreator.this.indexRouteRelationCreatorV2.iterateRelation((Relation)e, ctx, icc);
                        }
                    }
                    if (IndexCreator.this.settings.indexRouting) {
                        IndexCreator.this.indexRouteCreator.indexRelations(e, ctx);
                        IndexCreator.this.indexRouteCreator.indexLowEmissionZones(e, ctx);
                    }
                    if (IndexCreator.this.settings.indexPOI) {
                        IndexCreator.this.indexPoiCreator.iterateRelation((Relation)e, ctx);
                    }
                    if (IndexCreator.this.settings.indexTransport) {
                        IndexCreator.this.indexTransportCreator.indexRelations((Relation)e, ctx);
                    }
                }
            });
            if (this.settings.indexMap) {
                this.indexMapCreator.createMapIndexTableIndexes(this.mapConnection);
            }
            if (this.settings.indexAddress || this.settings.indexRouting) {
                this.setGeneralProgress(progress, "[40 / 100]");
                progress.startTask(this.settings.getString("IndexCreator.PREINDEX_BOUNDARIES_WAYS"), accessor.getAllWays());
                accessor.iterateOverEntities(progress, Entity.EntityType.WAY_BOUNDARY, new OsmDbAccessor.OsmDbVisitor(){

                    @Override
                    public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                        if (IndexCreator.this.settings.indexAddress) {
                            IndexCreator.this.indexAddressCreator.indexBoundaries(e, ctx);
                        }
                        if (IndexCreator.this.settings.indexRouting) {
                            IndexCreator.this.indexRouteCreator.indexLowEmissionZones(e, ctx);
                        }
                    }
                });
            }
            if (this.settings.indexAddress) {
                this.setGeneralProgress(progress, "[42 / 100]");
                progress.startTask(this.settings.getString("IndexCreator.BIND_CITIES_AND_BOUNDARIES"), 100);
                this.indexAddressCreator.tryToAssignBoundaryToFreeCities(progress);
                this.setGeneralProgress(progress, "[45 / 100]");
                progress.startTask(this.settings.getString("IndexCreator.PREINDEX_ADRESS_MAP"), accessor.getAllRelations());
                accessor.iterateOverEntities(progress, Entity.EntityType.RELATION, new OsmDbAccessor.OsmDbVisitor(){

                    @Override
                    public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                        IndexCreator.this.indexAddressCreator.indexStreetRelation((Relation)e, ctx, icc);
                    }
                });
                this.indexAddressCreator.commitToPutAllCities();
            }
            if (this.settings.indexAddress && this.settings.indexPOI) {
                this.indexPoiCreator.storeCities(this.indexAddressCreator.getCityDataStorage());
            }
        }
    }

    private void writeAllCities(OsmDbAccessor accessor, IProgress progress) throws SQLException, InterruptedException {
        if (this.settings.indexAddress) {
            this.setGeneralProgress(progress, "[20 / 100]");
            progress.startTask(this.settings.getString("IndexCreator.INDEX_CITIES"), accessor.getAllNodes());
            this.indexAddressCreator.writeCitiesIntoDb();
        }
    }

    private void setGeneralProgress(IProgress progress, String genProgress) {
        progress.setGeneralProgress(genProgress);
    }

    public static void main(String[] args) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        long time = System.currentTimeMillis();
        String rootFolder = System.getProperty("maps.dir");
        IndexCreatorSettings settings = new IndexCreatorSettings();
        settings.indexAddress = true;
        settings.indexPOI = true;
        settings.srtmDataFolderUrl = null;
        IndexCreator creator = new IndexCreator(new File(rootFolder), settings);
        MapZooms zooms = MapZooms.getDefault();
        String file = rootFolder + "../temp/oakville.osm";
        int st = file.lastIndexOf(47);
        int e = file.indexOf(46, st);
        String name = file.substring(st, e);
        creator.setNodesDBFile(new File(rootFolder + name + ".tmp.odb"));
        MapPoiTypes.setDefault((MapPoiTypes)new MapPoiTypes(rootFolder + "../repos/resources/poi/poi_types.xml"));
        MapRenderingTypesEncoder rt = new MapRenderingTypesEncoder(rootFolder + "../repos/resources/obf_creation/rendering_types.xml", new File(file).getName());
        creator.generateIndexes(new File(file), new ConsoleProgressImplementation(1.0), null, zooms, rt, log);
        log.info((Object)("WHOLE GENERATION TIME :  " + (System.currentTimeMillis() - time)));
        log.info((Object)("COORDINATES_SIZE " + BinaryMapIndexWriter.COORDINATES_SIZE + " count " + BinaryMapIndexWriter.COORDINATES_COUNT));
        log.info((Object)("LABEL_COORDINATES_SIZE " + BinaryMapIndexWriter.LABEL_COORDINATES_SIZE));
        log.info((Object)("TYPES_SIZE " + BinaryMapIndexWriter.TYPES_SIZE));
        log.info((Object)("ID_SIZE " + BinaryMapIndexWriter.ID_SIZE));
        log.info((Object)("- COORD_TYPES_ID SIZE " + (BinaryMapIndexWriter.COORDINATES_SIZE + BinaryMapIndexWriter.TYPES_SIZE + BinaryMapIndexWriter.ID_SIZE)));
        log.info((Object)("- MAP_DATA_SIZE " + BinaryMapIndexWriter.MAP_DATA_SIZE));
        log.info((Object)("- STRING_TABLE_SIZE " + BinaryMapIndexWriter.STRING_TABLE_SIZE));
        log.info((Object)("-- MAP_DATA_AND_STRINGS SIZE " + (BinaryMapIndexWriter.MAP_DATA_SIZE + BinaryMapIndexWriter.STRING_TABLE_SIZE)));
    }

    public static void generateRegionsFile() throws IOException, SQLException, InterruptedException, XmlPullParserException {
        MapRenderingTypesEncoder rt = new MapRenderingTypesEncoder("regions");
        String file = "/home/victor/projects/osmand/repo/resources/osmand_regions.osm";
        String folder = "/home/victor/projects/osmand/repo/resources/countries-info/";
        IndexCreatorSettings settings = new IndexCreatorSettings();
        settings.indexMap = true;
        settings.indexAddress = false;
        settings.indexPOI = false;
        settings.indexTransport = false;
        settings.indexRouting = false;
        settings.zoomWaySmoothness = 1;
        IndexCreator creator = new IndexCreator(new File(folder), settings);
        creator.setMapFileName("regions.ocbf");
        MapZooms zooms = MapZooms.parseZooms((String)"5-6");
        int st = file.lastIndexOf(47);
        int e = file.indexOf(46, st);
        creator.setNodesDBFile(new File(folder + file.substring(st, e) + ".tmp.odb"));
        creator.generateIndexes(new File(file), new ConsoleProgressImplementation(1.0), null, zooms, rt, log);
    }
}

