/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.TagNode;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PlainTextConvertable;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import java.io.IOException;
import java.util.List;

public class PlainTextConverter
implements ITextConverter {
    private boolean renderLinks;

    public PlainTextConverter(boolean renderLinks) {
        this.renderLinks = renderLinks;
    }

    public PlainTextConverter() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodesToText(List<?> nodes, Appendable resultBuffer, IWikiModel model) throws IOException {
        assert (model != null);
        if (nodes != null && !nodes.isEmpty()) {
            try {
                int level = model.incrementRecursionLevel();
                if (level > 256) {
                    resultBuffer.append("Error - recursion limit exceeded rendering tags in PlainTextConverter#nodesToText().");
                    return;
                }
                for (Object item : nodes) {
                    if (item instanceof List) {
                        this.nodesToText((List)item, resultBuffer, model);
                        continue;
                    }
                    if (!(item instanceof PlainTextConvertable)) continue;
                    ((PlainTextConvertable)item).renderPlainText(this, resultBuffer, model);
                }
            }
            finally {
                model.decrementRecursionLevel();
            }
        }
    }

    @Override
    public boolean renderLinks() {
        return this.renderLinks;
    }

    @Override
    public void imageNodeToText(TagNode imageTagNode, ImageFormat imageFormat, Appendable resultBuffer, IWikiModel model) throws IOException {
    }
}

