/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.util;

import java.util.HashMap;
import java.util.Map;

public class WikiEntityUtil {
    private static Map<String, Entity> fHtmlToWiki = new HashMap<String, Entity>();
    private static Entity[] fIdToWiki = new Entity[65535];
    private static Map<String, Entity> fWikiToHtml = new HashMap<String, Entity>();

    private static void add(String wikiEnity, String htmlEntity, int id) {
        Entity entity = new Entity(wikiEnity, htmlEntity, id);
        fWikiToHtml.put(wikiEnity, entity);
        fHtmlToWiki.put(htmlEntity, entity);
        WikiEntityUtil.fIdToWiki[id] = entity;
    }

    public static int getHtmlCodeByHtmlEntity(String htmlEntity) {
        Entity entity = fHtmlToWiki.get(htmlEntity);
        return entity != null ? entity.fHtmlCode : 0;
    }

    public static int getHtmlCodeByWikiSymbol(String wikiEntity) {
        Entity entity = fWikiToHtml.get(wikiEntity);
        return entity != null ? entity.fHtmlCode : 0;
    }

    public static String getHtmlSymbol(char ch) {
        Entity entity = fIdToWiki[ch];
        return entity != null ? entity.fWikiSymbol : null;
    }

    public static String getHtmlSymbol(String wikiEntity) {
        Entity entity = fWikiToHtml.get(wikiEntity);
        return entity != null ? entity.fHtmlSymbol : null;
    }

    public static String getWikiSymbol(char ch) {
        Entity entity = fIdToWiki[ch];
        return entity != null ? entity.fWikiSymbol : null;
    }

    public static String getWikiSymbol(String htmlEntity) {
        Entity entity = fHtmlToWiki.get(htmlEntity);
        return entity != null ? entity.fHtmlSymbol : null;
    }

    static {
        WikiEntityUtil.add("<", "lt", 8249);
        WikiEntityUtil.add(">", "gt", 8250);
        WikiEntityUtil.add("&", "amp", 38);
        WikiEntityUtil.add("'", "rsquo", 8217);
        WikiEntityUtil.add("(tm)", "trade", 8482);
        WikiEntityUtil.add("(TM)", "trade", 8482);
        WikiEntityUtil.add("(No)", "8470", 8470);
        WikiEntityUtil.add(" -- ", "ndash", 8211);
        WikiEntityUtil.add("---", "mdash", 8212);
        WikiEntityUtil.add(" --- ", "mdash", 8212);
        WikiEntityUtil.add("...", "hellip", 8230);
        WikiEntityUtil.add("(*)", "bull", 8226);
        WikiEntityUtil.add("(R)", "reg", 174);
        WikiEntityUtil.add("(r)", "reg", 174);
        WikiEntityUtil.add("(o)", "deg", 176);
        WikiEntityUtil.add("(C)", "copy", 169);
        WikiEntityUtil.add("(p)", "para", 182);
        WikiEntityUtil.add("(P)", "para", 182);
        WikiEntityUtil.add("(s)", "sect", 167);
        WikiEntityUtil.add("()", "nbsp", 160);
        WikiEntityUtil.add("<<", "laquo", 171);
        WikiEntityUtil.add(">>", "raquo", 187);
        WikiEntityUtil.add("(c)", "cent", 162);
        WikiEntityUtil.add("(E)", "euro", 8364);
        WikiEntityUtil.add("(O)", "curren", 164);
        WikiEntityUtil.add("(L)", "pound", 163);
        WikiEntityUtil.add("(Y)", "yen", 165);
        WikiEntityUtil.add("(f)", "fnof", 402);
        WikiEntityUtil.add("+/-", "plusmn", 177);
        WikiEntityUtil.add("(S)", "sum", 8721);
        WikiEntityUtil.add("(/)", "divide", 247);
        WikiEntityUtil.add("(x)", "times", 215);
        WikiEntityUtil.add("(8)", "infin", 8734);
        WikiEntityUtil.add("(~)", "sim", 8764);
        WikiEntityUtil.add("!=", "ne", 8800);
        WikiEntityUtil.add("->", "rarr", 8594);
        WikiEntityUtil.add("-->", "rarr", 8594);
        WikiEntityUtil.add("--->", "rarr", 8594);
        WikiEntityUtil.add("<-", "larr", 8592);
        WikiEntityUtil.add("<--", "larr", 8592);
        WikiEntityUtil.add("<---", "larr", 8592);
        WikiEntityUtil.add("<->", "harr", 8596);
        WikiEntityUtil.add("<-->", "harr", 8596);
        WikiEntityUtil.add("<--->", "harr", 8596);
        WikiEntityUtil.add("=>", "rArr", 8658);
        WikiEntityUtil.add("==>", "rArr", 8658);
        WikiEntityUtil.add("===>", "rArr", 8658);
        WikiEntityUtil.add("<=", "lArr", 8658);
        WikiEntityUtil.add("<==", "lArr", 8658);
        WikiEntityUtil.add("<===", "lArr", 8658);
        WikiEntityUtil.add("<=>", "hArr", 8660);
        WikiEntityUtil.add("<==>", "hArr", 8660);
        WikiEntityUtil.add("<===>", "hArr", 8660);
        WikiEntityUtil.add("<=", "le", 8804);
        WikiEntityUtil.add(">=", "ge", 8805);
        WikiEntityUtil.add("!=", "ne", 8800);
        WikiEntityUtil.add("~=", "asymp", 8776);
    }

    private static class Entity {
        public final int fHtmlCode;
        public final String fHtmlSymbol;
        public final String fWikiSymbol;

        public Entity(String wikiSymbol, String htmlSymbol, int htmlCode) {
            this.fWikiSymbol = wikiSymbol;
            this.fHtmlSymbol = htmlSymbol;
            this.fHtmlCode = htmlCode;
        }
    }
}

