/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse;
import software.amazon.awssdk.services.batch.model.JobDefinition;

public class DescribeJobDefinitionsIterable
implements SdkIterable<DescribeJobDefinitionsResponse> {
    private final BatchClient client;
    private final DescribeJobDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeJobDefinitionsIterable(BatchClient client, DescribeJobDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeJobDefinitionsResponseFetcher();
    }

    public Iterator<DescribeJobDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobDefinition> jobDefinitions() {
        Function<DescribeJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitions() != null) {
                return response.jobDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeJobDefinitionsResponseFetcher
    implements SyncPageFetcher<DescribeJobDefinitionsResponse> {
        private DescribeJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeJobDefinitionsResponse nextPage(DescribeJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeJobDefinitionsIterable.this.client.describeJobDefinitions(DescribeJobDefinitionsIterable.this.firstRequest);
            }
            return DescribeJobDefinitionsIterable.this.client.describeJobDefinitions((DescribeJobDefinitionsRequest)((Object)DescribeJobDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

