/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.osmand.PlatformUtil;
import net.osmand.impl.FileProgressImplementation;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.travel.WikivoyageLangPreparation;
import net.osmand.wiki.WikiDatabasePreparation;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CommonsWikimediaPreparation {
    public static final String DATA_SOURCE = "commonswiki-latest-pages-articles.xml.gz";
    public static final String RESULT_SQLITE = "wikidata_commons_osm.sqlitedb";
    public static final String FILE_NAMESPACE = "6";
    public static final String FILE = "File:";
    private static final Log log = PlatformUtil.getLog(CommonsWikimediaPreparation.class);

    public static void main(String[] args) {
        String folder = "";
        String mode = "";
        String database = "";
        boolean recreateDb = false;
        for (String arg : args) {
            String val = arg.substring(arg.indexOf("=") + 1);
            if (arg.startsWith("--dir=")) {
                folder = val;
                continue;
            }
            if (arg.startsWith("--mode=")) {
                mode = val;
                continue;
            }
            if (arg.startsWith("--result_db=")) {
                database = val;
                continue;
            }
            if (!arg.startsWith("--recreate_db")) continue;
            recreateDb = true;
        }
        if (mode.isEmpty() || folder.isEmpty()) {
            throw new RuntimeException("Correct arguments weren't supplied");
        }
        String commonWikiArticles = folder + DATA_SOURCE;
        Object sqliteFileName = database.isEmpty() ? folder + RESULT_SQLITE : database;
        CommonsWikimediaPreparation p = new CommonsWikimediaPreparation();
        try {
            switch (mode) {
                case "parse-commonswiki-img-meta": {
                    p.parseCommonArticles(commonWikiArticles, (String)sqliteFileName, recreateDb);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown mode: " + mode);
                }
            }
        }
        catch (IOException | SQLException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error during parsing: " + e.getMessage(), e);
        }
    }

    private void parseCommonArticles(String articles, String sqliteFileName, boolean recreateDb) throws ParserConfigurationException, SAXException, IOException, SQLException {
        SAXParser sx = SAXParserFactory.newInstance().newSAXParser();
        FileProgressImplementation progress = new FileProgressImplementation("Read commonswiki articles file", new File(articles));
        InputStream streamFile = progress.openFileInputStream();
        InputSource is = CommonsWikimediaPreparation.getInputSource(streamFile);
        CommonsWikiHandler handler = new CommonsWikiHandler(sx, progress, new File(sqliteFileName), recreateDb);
        sx.parse(is, (DefaultHandler)handler);
        handler.finish();
    }

    private static InputSource getInputSource(InputStream streamFile) throws IOException {
        GZIPInputStream zis = new GZIPInputStream(streamFile);
        InputStreamReader reader = new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8);
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        return is;
    }

    private static class CommonsWikiHandler
    extends DefaultHandler {
        private final SAXParser saxParser;
        private DBDialect dialect = DBDialect.SQLITE;
        private Connection conn;
        private PreparedStatement prepContent;
        private int[] contentBatch = new int[]{0};
        private boolean page = false;
        private StringBuilder ctext = null;
        private final StringBuilder title = new StringBuilder();
        private final StringBuilder ns = new StringBuilder();
        private final StringBuilder id = new StringBuilder();
        private final FileProgressImplementation progress;
        public static final int BATCH_SIZE = 5000;
        private final StringBuilder textContent = new StringBuilder();

        CommonsWikiHandler(SAXParser saxParser, FileProgressImplementation progress, File sqliteFile, boolean recreateDb) throws SQLException {
            this.saxParser = saxParser;
            this.progress = progress;
            this.conn = this.dialect.getDatabaseConnection(sqliteFile.getAbsolutePath(), log);
            log.info((Object)"========= CREATE TABLE common_meta =========");
            try (Statement st = this.conn.createStatement();){
                if (recreateDb) {
                    log.info((Object)"========= DROP old TABLE common_meta =========");
                    st.execute("DROP TABLE IF EXISTS common_meta");
                }
                st.execute("CREATE TABLE IF NOT EXISTS common_meta(id long, name text, author text, date text, license text, description text)");
                st.execute("DELETE FROM common_meta");
            }
            this.prepContent = this.conn.prepareStatement("INSERT INTO common_meta(id, name, author,  date, license, description) VALUES (?, ?, ?, ?, ?, ?)");
        }

        public void finish() throws SQLException {
            log.info((Object)"========= DONE =========");
            log.info((Object)"Create indexes");
            try (Statement st = this.conn.createStatement();){
                st.execute("CREATE INDEX IF NOT EXISTS id_common_meta_index ON common_meta(id)");
                st.execute("CREATE INDEX IF NOT EXISTS name_common_meta_index ON common_meta(name)");
            }
            this.prepContent.executeBatch();
            if (!this.conn.getAutoCommit()) {
                this.conn.commit();
            }
            this.prepContent.close();
            this.conn.close();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (!this.page) {
                this.page = name.equals("page");
            } else {
                switch (name) {
                    case "title": {
                        this.title.setLength(0);
                        this.ctext = this.title;
                        break;
                    }
                    case "ns": {
                        this.ns.setLength(0);
                        this.ctext = this.ns;
                        break;
                    }
                    case "id": {
                        this.id.setLength(0);
                        this.ctext = this.id;
                        break;
                    }
                    case "text": {
                        this.textContent.setLength(0);
                        this.ctext = this.textContent;
                        break;
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.page && this.ctext != null) {
                this.ctext.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (this.page) {
                switch (name) {
                    case "page": {
                        this.page = false;
                        this.progress.update();
                        break;
                    }
                    case "title": 
                    case "ns": 
                    case "id": {
                        this.ctext = null;
                        break;
                    }
                    case "text": {
                        String nameSpace = this.ns.toString();
                        if (!CommonsWikimediaPreparation.FILE_NAMESPACE.equals(nameSpace)) break;
                        this.parseMeta(nameSpace);
                        break;
                    }
                }
            }
        }

        public void addBatch(PreparedStatement prep, int[] bt) throws SQLException {
            prep.addBatch();
            bt[0] = bt[0] + 1;
            int batch = bt[0];
            if (batch > 5000) {
                prep.executeBatch();
                bt[0] = 0;
            }
        }

        private void parseMeta(String nameSpace) {
            try {
                if (CommonsWikimediaPreparation.FILE_NAMESPACE.equals(nameSpace)) {
                    String imageTitle;
                    String string = imageTitle = this.title.toString().startsWith(CommonsWikimediaPreparation.FILE) ? this.title.substring(CommonsWikimediaPreparation.FILE.length()) : null;
                    if (imageTitle == null) {
                        return;
                    }
                    HashMap<String, String> meta = new HashMap<String, String>();
                    WikiDatabasePreparation.removeMacroBlocks(this.textContent, meta, new HashMap<WikivoyageLangPreparation.WikivoyageTemplates, List<String>>(), null, "en", imageTitle, null, true);
                    WikiDatabasePreparation.prepareMetaData(meta);
                    String author = meta.getOrDefault("author", "");
                    String license = meta.getOrDefault("license", "");
                    String description = meta.getOrDefault("description", "");
                    String date = meta.getOrDefault("date", "");
                    this.prepContent.setLong(1, Long.parseLong(this.id.toString()));
                    this.prepContent.setString(2, imageTitle.replace(" ", "_"));
                    this.prepContent.setString(3, author);
                    this.prepContent.setString(4, date);
                    this.prepContent.setString(5, license);
                    this.prepContent.setString(6, description);
                    this.addBatch(this.prepContent, this.contentBatch);
                }
            }
            catch (IOException | SQLException exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

