/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.tester;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osmand.MainUtilities;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.router.tester.RandomRouteEntry;
import net.osmand.router.tester.RandomRouteGenerator;
import net.osmand.router.tester.RandomRouteReport;
import net.osmand.router.tester.RandomRouteResult;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;

public class RandomRouteTester {
    private MainUtilities.CommandLineOpts opts;
    private String optMapsDir;
    private String optLibsDir;
    private String optObfPrefix;
    private String optHtmlReport;
    private String optHtmlDomain;
    private PrimaryRouting optPrimaryRouting;
    private long started;
    private File obfDirectory;
    private NativeLibrary nativeLibrary = null;
    private List<BinaryMapIndexReader> obfReaders = new ArrayList<BinaryMapIndexReader>();
    private HashMap<String, File> hhFiles = new HashMap();
    private RandomRouteGenerator generator;
    private GeneratorConfig config = new GeneratorConfig();
    private List<RandomRouteEntry> testList = new ArrayList<RandomRouteEntry>();
    private final Log LOG = PlatformUtil.getLog(RandomRouteTester.class);
    private final int EXIT_SUCCESS = 0;
    private final int EXIT_TEST_FAILED = 1;
    private final int EXIT_RED_LIMIT_REACHED = 2;

    public static void main(String[] args) throws Exception {
        RandomRouteTester test = new RandomRouteTester(args);
        test.applyCommandLineOpts();
        test.loadNativeLibrary();
        test.initObfReaders();
        test.generateRoutes();
        test.startSlowDown();
        test.collectRoutes();
        test.stopSlowDown();
        int exitCode = test.reportResult();
        System.exit(exitCode);
    }

    private RandomRouteTester(String[] args) {
        this.opts = new MainUtilities.CommandLineOpts(args);
        this.started = System.currentTimeMillis();
        this.generator = new RandomRouteGenerator(this.config);
    }

    private Boolean isFileWriteable(String name) {
        Path path = Paths.get(name, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isWritable(path)) {
            return true;
        }
        Path parent = path.normalize().toAbsolutePath().getParent();
        if (Files.exists(parent, new LinkOption[0]) && Files.isWritable(parent)) {
            return true;
        }
        return false;
    }

    private void applyCommandLineOpts() {
        this.optMapsDir = Objects.requireNonNullElse(this.opts.getOpt("--maps-dir"), "./");
        this.optObfPrefix = Objects.requireNonNullElse(this.opts.getOpt("--obf-prefix"), "");
        this.optHtmlReport = Objects.requireNonNullElse(this.opts.getOpt("--html-report"), "rr-report.html");
        this.optHtmlDomain = Objects.requireNonNullElse(this.opts.getOpt("--html-domain"), "test.osmand.net");
        this.optLibsDir = (String)((Object)Objects.requireNonNullElse(this.opts.getOpt("--libs-dir"), this.optMapsDir + "/../core-legacy/binaries"));
        if (!this.isFileWriteable(this.optHtmlReport).booleanValue()) {
            throw new IllegalStateException(this.optHtmlReport + " (html-report) file is not writable");
        }
        this.config.ITERATIONS = Integer.parseInt(Objects.requireNonNullElse(this.opts.getOpt("--iterations"), String.valueOf(this.config.ITERATIONS)));
        this.config.MIN_DISTANCE_KM = Integer.parseInt(Objects.requireNonNullElse(this.opts.getOpt("--min-dist"), String.valueOf(this.config.MIN_DISTANCE_KM)));
        this.config.MAX_DISTANCE_KM = Integer.parseInt(Objects.requireNonNullElse(this.opts.getOpt("--max-dist"), String.valueOf(this.config.MAX_DISTANCE_KM)));
        this.config.MAX_INTER_POINTS = Integer.parseInt(Objects.requireNonNullElse(this.opts.getOpt("--max-inter"), String.valueOf(this.config.MAX_INTER_POINTS)));
        this.config.MAX_SHIFT_ALL_POINTS_M = Integer.parseInt(Objects.requireNonNullElse(this.opts.getOpt("--max-shift"), String.valueOf(this.config.MAX_SHIFT_ALL_POINTS_M)));
        this.config.DEVIATION_RED = Double.parseDouble(Objects.requireNonNullElse(this.opts.getOpt("--red"), String.valueOf(this.config.DEVIATION_RED)));
        this.config.DEVIATION_YELLOW = Double.parseDouble(Objects.requireNonNullElse(this.opts.getOpt("--yellow"), String.valueOf(this.config.DEVIATION_YELLOW)));
        if (this.opts.getOpt("--profile") != null) {
            this.config.RANDOM_PROFILES = new String[]{this.opts.getOpt("--profile")};
        }
        if (this.opts.getStrings().size() > 0) {
            this.config.PREDEFINED_TESTS = this.opts.getStrings().toArray(new String[0]);
        }
        if (this.opts.getOpt("--primary") != null) {
            if ("brp-java".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.BRP_JAVA;
            } else if ("brp-cpp".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.BRP_CPP;
            } else if ("hh-java".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.HH_JAVA;
            } else if ("hh-cpp".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.HH_CPP;
            }
        }
        if (this.opts.getOpt("--car-2phase") != null) {
            this.config.CAR_2PHASE_MODE = true;
        }
        if (this.opts.getOpt("--no-conditionals") != null) {
            this.config.USE_TIME_CONDITIONAL_ROUTING = 0L;
        }
        if (this.opts.getOpt("--help") != null) {
            System.err.printf("%s\n", String.join((CharSequence)"\n", "", "Usage: random-route-tester [--options] [TEST_ROUTE(s)]", "", "[TEST_ROUTE] run specific test (url or query_string format)", "", "--maps-dir=/path/to/directory/with/*.obf (default ./)", "--obf-prefix=prefix to filter obf files (default all)", "--html-report=/path/to/report.html (rr-report.html)", "--html-domain=test.osmand.net (used in html-report)", "--libs-dir=/path/to/native/libs/dir (default auto)", "", "--iterations=N", "--min-dist=N km", "--max-dist=N km", "--max-shift=N meters", "--max-inter=N number", "--profile=profile,settings,key:value force one profile", "", "--primary=(brp-java|brp-cpp|hh-java|hh-cpp) compare others against this", "--avoid-brp-java avoid BinaryRoutePlanner (java)", "--avoid-brp-cpp avoid BinaryRoutePlanner (cpp)", "--avoid-hh-java avoid HHRoutePlanner (java)", "--avoid-hh-cpp avoid HHRoutePlanner (cpp)", "", "--car-2phase use COMPLEX mode for car (Android default)", "--no-conditionals disable *:conditional restrictions", "", "--yellow=N % yellow-color limit", "--red=N % red-color limit (affects exit code)", "", "--help show help", ""));
            System.exit(0);
        }
    }

    private int reportResult() throws IOException {
        long runTime = System.currentTimeMillis() - this.started;
        RandomRouteReport report = new RandomRouteReport(runTime, this.obfReaders.size(), this.testList.size(), this.config.DEVIATION_RED, this.config.DEVIATION_YELLOW, this.optHtmlDomain, this.config.CAR_2PHASE_MODE);
        for (int i = 0; i < this.testList.size(); ++i) {
            report.entryOpen(i + 1);
            RandomRouteEntry entry = this.testList.get(i);
            for (int j = 0; j < entry.results.size(); ++j) {
                RandomRouteResult primary = entry.results.get(0);
                RandomRouteResult result = entry.results.get(j);
                if (j == 0) {
                    report.resultPrimary(i + 1, primary);
                    continue;
                }
                report.resultCompare(i + 1, result, primary);
            }
            report.entryClose();
        }
        report.flush(this.optHtmlReport);
        if (report.isFailed()) {
            return 1;
        }
        if (report.isDeviated()) {
            return 2;
        }
        return 0;
    }

    private void initObfReaders() throws IOException {
        ArrayList<Object> obfFiles = new ArrayList<Object>();
        this.obfDirectory = new File(this.optMapsDir);
        if (this.obfDirectory.isDirectory()) {
            for (File f : Algorithms.getSortedFilesVersions((File)this.obfDirectory)) {
                if (!f.isFile() || !f.getName().endsWith(".obf") || !f.getName().startsWith(this.optObfPrefix)) continue;
                obfFiles.add(f);
            }
        } else {
            obfFiles.add(this.obfDirectory);
        }
        for (File file : obfFiles) {
            System.out.printf("Use OBF %s...\n", file.getName());
            Objects.requireNonNull(this.nativeLibrary).initMapFile(file.getAbsolutePath(), true);
            this.obfReaders.add(new BinaryMapIndexReader(new RandomAccessFile(file, "r"), file));
        }
        if (this.obfReaders.size() == 0) {
            throw new IllegalStateException("OBF files not initialized");
        }
    }

    private void generateRoutes() {
        this.testList = this.generator.generateTestList(this.obfReaders);
    }

    private void startSlowDown() {
        Runnable endless = () -> {
            while (this.config.OPTIONAL_SLOW_DOWN_THREADS > 0) {
                for (long i = 0L; i < 1000000000L; ++i) {
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        for (int i = 0; i < this.config.OPTIONAL_SLOW_DOWN_THREADS; ++i) {
            new Thread(endless).start();
        }
    }

    private void stopSlowDown() {
        this.config.OPTIONAL_SLOW_DOWN_THREADS = 0;
    }

    private void collectRoutes() {
        for (int i = 0; i < this.testList.size(); ++i) {
            RandomRouteEntry entry = this.testList.get(i);
            try {
                if (this.optPrimaryRouting != null) {
                    switch (this.optPrimaryRouting) {
                        case BRP_JAVA: {
                            this.opts.setOpt("--avoid-brp-java", "true");
                            entry.results.add(this.runBinaryRoutePlannerJava(entry));
                            break;
                        }
                        case BRP_CPP: {
                            this.opts.setOpt("--avoid-brp-cpp", "true");
                            entry.results.add(this.runBinaryRoutePlannerCpp(entry));
                            break;
                        }
                        case HH_JAVA: {
                            this.opts.setOpt("--avoid-hh-java", "true");
                            entry.results.add(this.runHHRoutePlannerJava(entry));
                            break;
                        }
                        case HH_CPP: {
                            this.opts.setOpt("--avoid-hh-cpp", "true");
                            entry.results.add(this.runHHRoutePlannerCpp(entry));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Wrong primary routing defined");
                        }
                    }
                }
                if (this.opts.getOpt("--avoid-brp-java") == null) {
                    entry.results.add(this.runBinaryRoutePlannerJava(entry));
                }
                if (this.opts.getOpt("--avoid-brp-cpp") == null) {
                    entry.results.add(this.runBinaryRoutePlannerCpp(entry));
                }
                if (this.opts.getOpt("--avoid-hh-java") == null) {
                    entry.results.add(this.runHHRoutePlannerJava(entry));
                }
                if (this.opts.getOpt("--avoid-hh-cpp") != null) continue;
                entry.results.add(this.runHHRoutePlannerCpp(entry));
                continue;
            }
            catch (IOException | InterruptedException | SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                System.err.println("---------------------------------------------------------------------------------");
                for (int j = 0; j < entry.results.size(); ++j) {
                    System.err.println(RandomRouteReport.resultPrimaryText(i + 1, entry.results.get(j)));
                }
                System.err.println("---------------------------------------------------------------------------------");
            }
        }
    }

    private RandomRouteResult runBinaryRoutePlannerJava(RandomRouteEntry entry) throws IOException, InterruptedException {
        return this.runBinaryRoutePlanner(entry, false);
    }

    private RandomRouteResult runBinaryRoutePlannerCpp(RandomRouteEntry entry) throws IOException, InterruptedException {
        return this.runBinaryRoutePlanner(entry, true);
    }

    private RandomRouteResult runBinaryRoutePlanner(RandomRouteEntry entry, boolean useNative) throws IOException, InterruptedException {
        RoutePlannerFrontEnd.RouteCalculationMode mode;
        long started = System.currentTimeMillis();
        int MEM_LIMIT = 4096;
        RoutePlannerFrontEnd fe = new RoutePlannerFrontEnd();
        fe.setHHRoutingConfig(null);
        RoutePlannerFrontEnd.CALCULATE_MISSING_MAPS = false;
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        RoutingConfiguration.RoutingMemoryLimits memoryLimits = new RoutingConfiguration.RoutingMemoryLimits(4096, 4096);
        RoutingConfiguration config = builder.build(entry.profile, memoryLimits, entry.mapParams());
        RoutePlannerFrontEnd.RouteCalculationMode routeCalculationMode = mode = this.config.CAR_2PHASE_MODE && "car".equals(entry.profile) ? RoutePlannerFrontEnd.RouteCalculationMode.COMPLEX : RoutePlannerFrontEnd.RouteCalculationMode.NORMAL;
        if (this.config.USE_TIME_CONDITIONAL_ROUTING == 1L) {
            config.routeCalculationTime = System.currentTimeMillis();
        } else if (this.config.USE_TIME_CONDITIONAL_ROUTING != 0L) {
            config.routeCalculationTime = this.config.USE_TIME_CONDITIONAL_ROUTING;
        }
        if (GeneratorConfig.ambiguousConditionalTags != null) {
            config.ambiguousConditionalTags = GeneratorConfig.ambiguousConditionalTags;
        }
        RoutingContext ctx = fe.buildRoutingContext(config, useNative ? this.nativeLibrary : null, this.obfReaders.toArray(new BinaryMapIndexReader[0]), mode);
        RouteResultPreparation.RouteCalcResult res = fe.searchRoute(ctx, entry.start, entry.finish, entry.via, null);
        List routeSegments = res != null ? res.getList() : new ArrayList();
        long runTime = System.currentTimeMillis() - started;
        return new RandomRouteResult(useNative ? "brp-cpp" : "brp-java", entry, runTime, ctx, routeSegments);
    }

    private RandomRouteResult runHHRoutePlannerJava(RandomRouteEntry entry) throws SQLException, IOException, InterruptedException {
        return this.runHHRoutePlanner(entry, false);
    }

    private RandomRouteResult runHHRoutePlannerCpp(RandomRouteEntry entry) throws SQLException, IOException, InterruptedException {
        return this.runHHRoutePlanner(entry, true);
    }

    private RandomRouteResult runHHRoutePlanner(RandomRouteEntry entry, boolean useNative) throws SQLException, IOException, InterruptedException {
        long started = System.currentTimeMillis();
        int MEM_LIMIT = 4096;
        HHRoutePlanner.DEBUG_VERBOSE_LEVEL = 1;
        HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL = 1;
        RouteResultPreparation.PRINT_TO_CONSOLE_ROUTE_INFORMATION = true;
        RoutePlannerFrontEnd fe = new RoutePlannerFrontEnd();
        RoutePlannerFrontEnd.CALCULATE_MISSING_MAPS = false;
        fe.setDefaultHHRoutingConfig();
        fe.setUseOnlyHHRouting(true);
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        RoutingConfiguration.RoutingMemoryLimits memoryLimits = new RoutingConfiguration.RoutingMemoryLimits(4096, 4096);
        RoutingConfiguration config = builder.build(entry.profile, memoryLimits, entry.mapParams());
        if (this.config.USE_TIME_CONDITIONAL_ROUTING == 1L) {
            config.routeCalculationTime = System.currentTimeMillis();
        } else if (this.config.USE_TIME_CONDITIONAL_ROUTING != 0L) {
            config.routeCalculationTime = this.config.USE_TIME_CONDITIONAL_ROUTING;
        }
        if (GeneratorConfig.ambiguousConditionalTags != null) {
            config.ambiguousConditionalTags = GeneratorConfig.ambiguousConditionalTags;
        }
        RoutingContext ctx = fe.buildRoutingContext(config, useNative ? this.nativeLibrary : null, this.obfReaders.toArray(new BinaryMapIndexReader[0]), RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
        fe.setHHRouteCpp(useNative);
        RouteResultPreparation.RouteCalcResult res = fe.searchRoute(ctx, entry.start, entry.finish, entry.via, null);
        List routeSegments = res != null ? res.getList() : new ArrayList();
        long runTime = System.currentTimeMillis() - started;
        return new RandomRouteResult(useNative ? "hh-cpp" : "hh-java", entry, runTime, ctx, routeSegments);
    }

    private void loadNativeLibrary() {
        String nativePath = this.getNativeLibPath();
        if (NativeLibrary.loadOldLib((String)nativePath)) {
            this.nativeLibrary = new NativeLibrary();
            return;
        }
        throw new IllegalStateException("Native library not loaded");
    }

    private String getNativeLibPath() {
        Path path = FileSystems.getDefault().getPath(this.optLibsDir, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            path = FileSystems.getDefault().getPath(this.optLibsDir.replaceFirst("../", "../../"), new String[0]);
        }
        if (Files.exists(path, new LinkOption[0])) {
            File nativeLibPath = path.normalize().toAbsolutePath().toFile();
            for (File f1 : Objects.requireNonNull(nativeLibPath.listFiles())) {
                if (!f1.isDirectory()) continue;
                for (File f2 : Objects.requireNonNull(f1.listFiles())) {
                    if (!f2.isDirectory()) continue;
                    File libDir = this.getLatestLib(f2.listFiles());
                    return libDir == null ? f2.getAbsolutePath() : libDir.getAbsolutePath();
                }
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                return nativeLibPath.getAbsolutePath();
            }
        }
        return null;
    }

    private File getLatestLib(File[] f3) {
        File libDir = null;
        for (File f4 : Objects.requireNonNull(f3)) {
            if (!f4.isDirectory() || !f4.getName().equals("Release") && !f4.getName().equals("Debug")) continue;
            if (libDir == null) {
                libDir = f4.getAbsoluteFile();
                continue;
            }
            if (libDir.lastModified() >= f4.lastModified()) continue;
            libDir = f4;
        }
        return libDir;
    }

    class GeneratorConfig {
        String[] PREDEFINED_TESTS = new String[0];
        int ITERATIONS = 10;
        int MAX_INTER_POINTS = 0;
        int MIN_DISTANCE_KM = 50;
        int MAX_DISTANCE_KM = 100;
        int MAX_SHIFT_ALL_POINTS_M = 500;
        int OPTIONAL_SLOW_DOWN_THREADS = 0;
        String[] RANDOM_PROFILES = new String[]{"car", "bicycle"};
        double DEVIATION_RED = 1.0;
        double DEVIATION_YELLOW = 0.1f;
        boolean CAR_2PHASE_MODE = false;
        long USE_TIME_CONDITIONAL_ROUTING = 1L;
        static final Map<String, String> ambiguousConditionalTags = null;

        GeneratorConfig() {
        }
    }

    private static enum PrimaryRouting {
        BRP_JAVA,
        BRP_CPP,
        HH_JAVA,
        HH_CPP;

    }
}

