/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.List;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;

public class WayChain {
    private List<Way> ways = new ArrayList<Way>(1);
    private List<Node> chainNodes;

    public WayChain(Way w) {
        this.ways.add(w);
    }

    public List<Way> getWays() {
        return this.ways;
    }

    public void append(Way w) {
        this.ways.add(w);
    }

    public void append(WayChain w) {
        this.ways.addAll(w.ways);
    }

    public void prepend(Way w) {
        this.ways.add(0, w);
    }

    public long getFistNode() {
        return this.ways.get(0).getFirstNodeId();
    }

    public long getLastNode() {
        return this.ways.get(this.ways.size() - 1).getLastNodeId();
    }

    public boolean isIncomplete() {
        for (int j = 0; j < this.ways.size(); ++j) {
            if (this.ways.get(j).getNodes().size() == this.ways.get(j).getNodeIds().size()) continue;
            return true;
        }
        return false;
    }

    public List<Node> getChainNodes() {
        if (this.chainNodes == null) {
            this.chainNodes = new ArrayList<Node>();
            for (int j = 0; j < this.ways.size(); ++j) {
                List ns = this.ways.get(j).getNodes();
                if (j == 0 && ns.get(0) != null) {
                    this.chainNodes.add((Node)ns.get(0));
                }
                for (int i = 1; i < ns.size(); ++i) {
                    if (ns.get(i) == null) continue;
                    this.chainNodes.add((Node)ns.get(i));
                }
            }
        }
        return this.chainNodes;
    }
}

