/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.osmand.binary.Abbreviations;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexHeightData;
import net.osmand.obf.preparation.IndexPoiCreator;
import net.osmand.obf.preparation.IndexRouteRelationCreator;
import net.osmand.obf.preparation.IndexVectorMapCreator;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.osmand.util.translit.ChineseTranslitHelper;
import net.osmand.util.translit.JapaneseTranslitHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexCreationContext {
    private static final Log log = LogFactory.getLog(IndexCreationContext.class);
    private static final String JAPAN = "japan";
    private static final String CHINA = "china";
    private static final double INFLATE_REGION_BBOX_KM = 20.0;
    public OsmandRegions allRegions;
    public boolean basemap;
    private boolean decryptAbbreviations = false;
    private boolean translitJapaneseNames = false;
    private boolean translitChineseNames = false;
    private IndexCreator indexCreator;
    private List<QuadRect> inflatedRegionQuads = null;

    IndexCreationContext(IndexCreator indexCreator, String regionName, boolean basemap) {
        this.indexCreator = indexCreator;
        this.allRegions = this.prepareRegions();
        this.basemap = basemap;
        if (regionName != null) {
            this.translitJapaneseNames = regionName.toLowerCase().startsWith(JAPAN);
            this.translitChineseNames = regionName.toLowerCase().startsWith(CHINA);
            this.decryptAbbreviations = IndexCreationContext.needDecryptAbbreviations(IndexCreationContext.getRegionLang(this.allRegions, regionName));
            WorldRegion region = this.allRegions.getRegionDataByDownloadName(regionName);
            if (region != null) {
                this.inflatedRegionQuads = region.getAllPolygonsBounds();
                double inflate = 0.17966223499820339;
                for (QuadRect rect : this.inflatedRegionQuads) {
                    MapUtils.inflateBBoxLatLon((QuadRect)rect, (double)inflate, (double)inflate);
                }
            }
        }
    }

    IndexPoiCreator getIndexPoiCreator() {
        return this.indexCreator.indexPoiCreator;
    }

    IndexRouteRelationCreator getIndexRouteRelationCreator() {
        return this.indexCreator.indexRouteRelationCreatorV2;
    }

    IndexVectorMapCreator getIndexMapCreator() {
        return this.indexCreator.indexMapCreator;
    }

    IndexHeightData getIndexHeightData() {
        return this.indexCreator.heightData;
    }

    @Nullable
    private OsmandRegions prepareRegions() {
        OsmandRegions or = new OsmandRegions();
        try {
            File loadedRegionsFile = this.refreshRegionsFileFromResources();
            or.prepareFile(loadedRegionsFile.getAbsolutePath());
            or.cacheAllCountries();
        }
        catch (IOException e) {
            log.error((Object)"Error preparing regions", (Throwable)e);
            return null;
        }
        return or;
    }

    private File refreshRegionsFileFromResources() throws IOException {
        String REGIONS_OCBF = "regions.ocbf";
        long pid = ProcessHandle.current().pid();
        long threadId = Thread.currentThread().getId();
        File regionsTmpFile = new File(String.format("%s.%d.%d.tmp", "regions.ocbf", pid, threadId));
        InputStream is = OsmandRegions.class.getResourceAsStream("regions.ocbf");
        FileOutputStream fos = new FileOutputStream(regionsTmpFile);
        Algorithms.streamCopy((InputStream)is, (OutputStream)fos);
        fos.close();
        is.close();
        File regionsFinalFile = new File("regions.ocbf");
        Files.move(regionsTmpFile.toPath(), regionsFinalFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        return regionsFinalFile;
    }

    private static String getRegionLang(OsmandRegions osmandRegions, String regionName) {
        if (osmandRegions == null) {
            return null;
        }
        WorldRegion wr = osmandRegions.getRegionDataByDownloadName(regionName);
        if (wr != null) {
            return wr.getParams().getRegionLang();
        }
        return null;
    }

    private static boolean needDecryptAbbreviations(String regionLang) {
        if (regionLang != null) {
            String[] langArr;
            for (String lang : langArr = regionLang.split(",")) {
                if (!lang.equals("en")) continue;
                return true;
            }
        }
        return false;
    }

    public void translitJapaneseNames(Entity e) {
        if (this.needTranslitName(e, e.getTags(), this.translitJapaneseNames, JAPAN)) {
            e.putTag(OSMSettings.OSMTagKey.NAME_EN.getValue(), JapaneseTranslitHelper.getEnglishTransliteration(e.getTag(OSMSettings.OSMTagKey.NAME.getValue())));
        }
    }

    public void translitChineseNames(Entity e) {
        if (this.needTranslitName(e, e.getTags(), this.translitChineseNames, CHINA)) {
            try {
                String pinyinNameTag = "name:zh_pinyin";
                if (e.getNameTags().containsKey(pinyinNameTag)) {
                    e.putTag(OSMSettings.OSMTagKey.NAME_EN.getValue(), (String)e.getNameTags().get(pinyinNameTag));
                } else {
                    e.putTag(OSMSettings.OSMTagKey.NAME_EN.getValue(), ChineseTranslitHelper.getPinyinTransliteration(e.getTag(OSMSettings.OSMTagKey.NAME.getValue())));
                }
            }
            catch (Throwable e1) {
                log.error((Object)e1.getMessage(), e1);
            }
        }
    }

    private boolean needTranslitName(Entity e, Map<String, String> etags, boolean translitByRegionName, String region) {
        if (!Algorithms.isEmpty((CharSequence)etags.get(OSMSettings.OSMTagKey.NAME_EN.getValue())) || Algorithms.isEmpty((CharSequence)etags.get(OSMSettings.OSMTagKey.NAME.getValue()))) {
            return false;
        }
        if (translitByRegionName) {
            return true;
        }
        if (!Algorithms.isEmpty((CharSequence)etags.get("osmand_region_name"))) {
            return etags.get("osmand_region_name").contains(region);
        }
        return false;
    }

    public String decryptAbbreviations(String name, LatLon loc, boolean addRegionTag) {
        boolean upd = false;
        if (this.decryptAbbreviations) {
            upd = true;
        } else if (addRegionTag && loc != null) {
            Set<String> dwNames = this.calcDownloadNames(null, false, this.allRegions, new QuadRect(loc.getLongitude(), loc.getLatitude(), loc.getLongitude(), loc.getLatitude()));
            for (String dwName : dwNames) {
                if (!IndexCreationContext.needDecryptAbbreviations(IndexCreationContext.getRegionLang(this.allRegions, dwName))) continue;
                upd = true;
                break;
            }
        }
        if (upd) {
            name = Abbreviations.replaceAll((String)name);
        }
        return name;
    }

    public Set<String> calcRegionTag(Entity entity, boolean add) {
        OsmandRegions or = this.allRegions;
        QuadRect qr = null;
        if (entity instanceof Relation) {
            LatLon l = ((Relation)entity).getLatLon();
            if (l != null) {
                double lat = l.getLatitude();
                double lon = l.getLongitude();
                qr = new QuadRect(lon, lat, lon, lat);
            }
        } else if (entity instanceof Way) {
            qr = ((Way)entity).getLatLonBBox();
        } else if (entity instanceof Node) {
            double lat = ((Node)entity).getLatitude();
            double lon = ((Node)entity).getLongitude();
            qr = new QuadRect(lon, lat, lon, lat);
        }
        return this.calcDownloadNames(entity, add, or, qr);
    }

    private Set<String> calcDownloadNames(Entity entity, boolean add, OsmandRegions or, QuadRect qr) {
        if (qr != null && or != null) {
            try {
                int lx = MapUtils.get31TileNumberX((double)qr.left);
                int rx = MapUtils.get31TileNumberX((double)qr.right);
                int by = MapUtils.get31TileNumberY((double)qr.bottom);
                int ty = MapUtils.get31TileNumberY((double)qr.top);
                List bbox = or.query(lx, rx, ty, by);
                TreeSet<String> lst = new TreeSet<String>();
                for (BinaryMapDataObject bo : bbox) {
                    String dw = or.getDownloadName(bo);
                    if (Algorithms.isEmpty((CharSequence)dw) || !or.isDownloadOfType(bo, "region_map")) continue;
                    lst.add(dw);
                }
                if (add && entity != null) {
                    entity.putTag("osmand_region_name", IndexCreationContext.serialize(lst));
                }
                return lst;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    private static String serialize(TreeSet<String> lst) {
        StringBuilder bld = new StringBuilder();
        for (String next : lst) {
            if (bld.length() > 0) {
                bld.append(",");
            }
            bld.append(next);
        }
        return bld.toString();
    }

    public boolean isInsideRegionBBox(Entity entity) {
        Way way;
        if (this.inflatedRegionQuads == null) {
            return true;
        }
        if (entity instanceof Node) {
            Node node = (Node)entity;
            double lon = node.getLongitude();
            double lat = node.getLatitude();
            for (QuadRect quad : this.inflatedRegionQuads) {
                if (!quad.contains(lon, lat, lon, lat)) continue;
                return true;
            }
            return false;
        }
        if (entity instanceof Way && (way = (Way)entity).getFirstNode() != null) {
            ArrayList<LatLon> latLons = new ArrayList<LatLon>();
            latLons.add(way.getFirstNode().getLatLon());
            latLons.add(way.getLastNode().getLatLon());
            if (way.getNodes().size() > 2) {
                latLons.add(((Node)way.getNodes().get(way.getNodes().size() / 2)).getLatLon());
            }
            for (LatLon l : latLons) {
                double lon = l.getLongitude();
                double lat = l.getLatitude();
                for (QuadRect quad : this.inflatedRegionQuads) {
                    if (!quad.contains(lon, lat, lon, lat)) continue;
                    return true;
                }
            }
            return false;
        }
        if (entity instanceof Relation) {
            Relation relation = (Relation)entity;
            for (Relation.RelationMember member : relation.getMembers()) {
                if (!this.isInsideRegionBBox(member.getEntity())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

