/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.osmand.Collator;
import net.osmand.IProgress;
import net.osmand.OsmAndCollator;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.CommonWords;
import net.osmand.binary.ObfConstants;
import net.osmand.data.Boundary;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.QuadRect;
import net.osmand.data.Street;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.CachedDBStreetDAO;
import net.osmand.obf.preparation.CityDataStorage;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.DBStreetDAO;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityParser;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.ArabicNormalizer;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexAddressCreator
extends AbstractIndexPartCreator {
    private static final Log log = LogFactory.getLog(IndexAddressCreator.class);
    private final Log logMapDataWarn;
    private PreparedStatement addressCityStat;
    private boolean loadInMemory = true;
    private List<Long> debugCityIds = new ArrayList<Long>();
    private List<Relation> postalCodeRelations = new ArrayList<Relation>();
    private Map<Entity, Boundary> postcodeBoundaries = new HashMap<Entity, Boundary>();
    private TLongHashSet visitedBoundaryWays = new TLongHashSet();
    private boolean normalizeStreets;
    private String[] normalizeDefaultSuffixes;
    private String[] normalizeSuffixes;
    private boolean DEBUG_FULL_NAMES = false;
    private static final String PLACE_ATTR = "place";
    private TreeSet<String> langAttributes = new TreeSet();
    public static final String ENTRANCE_BUILDING_DELIMITER = ", ";
    private static final int NO_BOUNDARY = 100;
    Connection mapConnection;
    DBStreetDAO streetDAO;
    private PreparedStatement postcodeSetStat;
    private IndexCreatorSettings settings;
    private CityDataStorage cityDataStorage;

    public IndexAddressCreator(Log logMapDataWarn, IndexCreatorSettings settings) {
        this.langAttributes.add(PLACE_ATTR);
        this.langAttributes.add("admin_level");
        this.logMapDataWarn = logMapDataWarn;
        this.settings = settings;
        this.streetDAO = this.loadInMemory ? new CachedDBStreetDAO() : new DBStreetDAO();
        this.cityDataStorage = new CityDataStorage();
    }

    public CityDataStorage getCityDataStorage() {
        return this.cityDataStorage;
    }

    public void registerCityNodes(Node n) {
        if (!Algorithms.isEmpty((CharSequence)n.getTag(OSMSettings.OSMTagKey.PLACE))) {
            City c = EntityParser.parseCity((Entity)n, null);
            this.regCity(c, (Entity)n);
        }
    }

    private City createMissingCity(Entity e, City.CityType t) throws SQLException {
        City c = EntityParser.parseCity((Entity)e, (City.CityType)t);
        if (this.debugCityIds.contains(c.getId())) {
            throw new IllegalStateException("Skip creating duplicate city already exists in \"city\" table \ninsert into city (id, latitude, longitude, name, name_en, city_type) values (" + c.getId() + ENTRANCE_BUILDING_DELIMITER + c.getLocation().getLatitude() + "," + c.getLocation().getLongitude() + ENTRANCE_BUILDING_DELIMITER + c.getName() + ENTRANCE_BUILDING_DELIMITER + Algorithms.encodeMap((Map)c.getNamesMap(true)) + ENTRANCE_BUILDING_DELIMITER + City.CityType.valueToString((City.CityType)c.getType()) + ")");
        }
        this.regCity(c, e);
        this.writeCity(c);
        this.commitWriteCity();
        return c;
    }

    private City regCity(City city, Entity e) {
        if (city == null || city.getLocation() == null) {
            return null;
        }
        LatLon l = city.getLocation();
        city.setNames(this.getOtherNames(e));
        if (!Algorithms.isEmpty((CharSequence)city.getName())) {
            this.cityDataStorage.registerObject(l.getLatitude(), l.getLongitude(), city, e);
            this.debugCityIds.add(city.getId());
        }
        return city;
    }

    public void indexBoundaries(Entity e, OsmDbAccessorContext ctx) throws SQLException {
        boolean boundaryValid;
        Boundary boundary = this.extractBoundary(e, false, ctx);
        boolean bl = boundaryValid = boundary != null && (!boundary.hasAdminLevel() || boundary.getAdminLevel() >= 4) && boundary.getCenterPoint() != null && !Algorithms.isEmpty((CharSequence)boundary.getName());
        if (boundaryValid) {
            String altBoundaryName;
            LatLon boundaryCenter = boundary.getCenterPoint();
            List<City> citiesToSearch = this.cityDataStorage.getClosestObjects(boundaryCenter.getLatitude(), boundaryCenter.getLongitude());
            City cityFound = null;
            String boundaryName = boundary.getName().toLowerCase();
            String string = altBoundaryName = Algorithms.isEmpty((CharSequence)boundary.getAltName()) ? "" : boundary.getAltName().toLowerCase();
            if (boundary.hasAdminCenterId()) {
                for (City c : citiesToSearch) {
                    if (c.getId().longValue() != boundary.getAdminCenterId() && c.getId().longValue() != boundary.getLabelId()) continue;
                    String cityLower = c.getName().toLowerCase();
                    if (!(this.nameContains(boundaryName, cityLower) || this.nameContains(altBoundaryName, cityLower) || this.nameContains(cityLower, boundaryName))) {
                        String msg = String.format("Ignore boundary '%s' (%d) admin center  for city '%s' name doesn't match", boundary.getName(), ObfConstants.getOsmIdFromMapObjectId((long)boundary.getBoundaryId()), c.getName());
                        if (this.logMapDataWarn != null) {
                            this.logMapDataWarn.info((Object)msg);
                            continue;
                        }
                        log.info((Object)msg);
                        continue;
                    }
                    boundary.setCityType(c.getType());
                    cityFound = c;
                    break;
                }
            }
            if (cityFound == null) {
                for (City c : citiesToSearch) {
                    if (!boundaryName.equalsIgnoreCase(c.getName()) && !altBoundaryName.equalsIgnoreCase(c.getName()) || !boundary.containsPoint(c.getLocation())) continue;
                    cityFound = c;
                    break;
                }
            }
            if (cityFound == null) {
                for (City c : citiesToSearch) {
                    String lower = c.getName().toLowerCase();
                    if (!this.nameContains(boundaryName, lower) && !this.nameContains(altBoundaryName, lower) || !boundary.containsPoint(c.getLocation())) continue;
                    cityFound = c;
                    break;
                }
            }
            if (cityFound == null && boundary.getCityType() != City.CityType.CITY && boundary.getCityType() != null) {
                if (e instanceof Relation) {
                    ctx.loadEntityRelation((Relation)e);
                }
                cityFound = this.createMissingCity(e, boundary.getCityType());
                boundary.setAdminCenterId(cityFound.getId());
                boundary.setLabelId(cityFound.getId());
            }
            if (cityFound != null) {
                this.putCityBoundary(boundary, cityFound);
                this.cityDataStorage.attachAllCitiesToBoundary(boundary);
            } else {
                this.logBoundaryChanged(boundary, null, 0, 100);
                this.cityDataStorage.addNotAssignedBoundary(boundary);
            }
        }
    }

    private boolean nameContains(String part, String fullString) {
        if (Algorithms.isEmpty((CharSequence)part)) {
            return false;
        }
        return part.equals(fullString) || part.startsWith(fullString + " ") || part.endsWith(" " + fullString) || part.contains(" " + fullString + " ");
    }

    public void tryToAssignBoundaryToFreeCities(IProgress progress) {
        progress.startWork(this.cityDataStorage.citiesSize());
        int smallestAdminLevel = 7;
        for (City c : this.cityDataStorage.getAllCities()) {
            progress.progress(1);
            Boundary cityB = this.cityDataStorage.getBoundaryByCity(c);
            if (cityB != null || c.getType() != City.CityType.CITY && c.getType() != City.CityType.TOWN) continue;
            LatLon location = c.getLocation();
            Boundary smallestBoundary = null;
            for (Boundary b : this.cityDataStorage.getNotAssignedBoundaries()) {
                if (b.getAdminLevel() < smallestAdminLevel || !b.containsPoint(location.getLatitude(), location.getLongitude())) continue;
                smallestAdminLevel = b.getAdminLevel();
                smallestBoundary = b;
            }
            if (smallestBoundary == null) continue;
            this.putCityBoundary(smallestBoundary, c);
            this.cityDataStorage.removeNotAssignedBoundary(smallestBoundary);
        }
    }

    private int extractBoundaryAdminLevel(Entity e) {
        int adminLevel = -1;
        try {
            String tag = e.getTag(OSMSettings.OSMTagKey.ADMIN_LEVEL);
            if (tag == null) {
                return adminLevel;
            }
            return Integer.parseInt(tag);
        }
        catch (NumberFormatException ex) {
            return adminLevel;
        }
    }

    private int getCityBoundaryImportance(Boundary b, City c) {
        boolean nameEq = b.getName().equalsIgnoreCase(c.getName());
        if (!Algorithms.isEmpty((CharSequence)b.getAltName()) && !nameEq) {
            nameEq = b.getAltName().equalsIgnoreCase(c.getName());
        }
        boolean cityBoundary = b.getCityType() != null;
        int adminLevelImportance = this.getAdminLevelImportance(b);
        if (nameEq) {
            if (cityBoundary) {
                return 0;
            }
            if (c.getId().longValue() == b.getAdminCenterId() || !b.hasAdminCenterId()) {
                return adminLevelImportance;
            }
            return 10 + adminLevelImportance;
        }
        if (c.getId().longValue() == b.getAdminCenterId()) {
            return 20 + adminLevelImportance;
        }
        return 30 + adminLevelImportance;
    }

    private int getAdminLevelImportance(Boundary b) {
        int adminLevelImportance = 5;
        if (b.hasAdminLevel()) {
            int adminLevel = b.getAdminLevel();
            adminLevelImportance = adminLevel == 8 ? 1 : (adminLevel == 7 ? 2 : (adminLevel == 6 ? 3 : (adminLevel == 9 ? 4 : (adminLevel == 10 ? 5 : 6))));
        }
        return adminLevelImportance;
    }

    private void putCityBoundary(Boundary boundary, City cityFound) {
        Boundary oldBoundary = this.cityDataStorage.getBoundaryByCity(cityFound);
        if (oldBoundary == null) {
            this.cityDataStorage.setCityBoundary(cityFound, boundary);
            this.logBoundaryChanged(boundary, cityFound, this.getCityBoundaryImportance(boundary, cityFound), 100);
        } else if (oldBoundary.getAdminLevel() == boundary.getAdminLevel() && oldBoundary != boundary && boundary.getName().equalsIgnoreCase(oldBoundary.getName())) {
            oldBoundary.mergeWith(boundary);
        } else {
            int old = this.getCityBoundaryImportance(oldBoundary, cityFound);
            int n = this.getCityBoundaryImportance(boundary, cityFound);
            if (n < old) {
                this.cityDataStorage.setCityBoundary(cityFound, boundary);
                this.logBoundaryChanged(boundary, cityFound, n, old);
            }
            this.cityDataStorage.addNotAssignedBoundary(oldBoundary);
        }
        QuadRect bbox = boundary.getMultipolygon().getLatLonBbox();
        cityFound.setBbox31(new int[]{MapUtils.get31TileNumberX((double)bbox.left), MapUtils.get31TileNumberY((double)bbox.top), MapUtils.get31TileNumberX((double)bbox.right), MapUtils.get31TileNumberY((double)bbox.bottom)});
    }

    private void logBoundaryChanged(Boundary boundary, City cityFound, int priority, int oldpriority) {
        Object s = String.format("boundary '%s' id %d - priority:%d", boundary.toString(), ObfConstants.getOsmIdFromMapObjectId((long)boundary.getBoundaryId()), priority);
        if (cityFound == null) {
            s = "No city for " + (String)s;
        } else {
            s = String.format("City '%s' (%d) link %s", cityFound.getName(), ObfConstants.getOsmObjectId((MapObject)cityFound), s);
            if (oldpriority != 100) {
                s = "REMAP " + (String)s + " old priority " + oldpriority;
            }
        }
        if (this.logMapDataWarn != null) {
            this.logMapDataWarn.info(s);
        } else {
            log.info(s);
        }
    }

    private Boundary extractBoundary(Entity e, boolean postalCode, OsmDbAccessorContext ctx) throws SQLException {
        if (e instanceof Node) {
            return null;
        }
        long centerId = 0L;
        long labelId = 0L;
        City.CityType ct = City.CityType.valueFromEntity((Entity)e);
        boolean administrative = "administrative".equals(e.getTag(OSMSettings.OSMTagKey.BOUNDARY));
        boolean census = "census".equals(e.getTag(OSMSettings.OSMTagKey.BOUNDARY));
        if (administrative || census || postalCode || ct != null) {
            if (e instanceof Way && this.visitedBoundaryWays.contains(e.getId())) {
                return null;
            }
            String bname = e.getTag(OSMSettings.OSMTagKey.NAME);
            MultipolygonBuilder m = new MultipolygonBuilder();
            if (e instanceof Relation) {
                Relation aRelation = (Relation)e;
                ctx.loadEntityRelation(aRelation);
                for (Relation.RelationMember es : aRelation.getMembers()) {
                    if (es.getEntity() instanceof Way) {
                        boolean inner = "inner".equals(es.getRole());
                        if (inner) {
                            m.addInnerWay((Way)es.getEntity());
                            continue;
                        }
                        String wName = es.getEntity().getTag(OSMSettings.OSMTagKey.NAME);
                        if (Algorithms.objectEquals((Object)wName, (Object)bname) || wName == null) {
                            this.visitedBoundaryWays.add(es.getEntity().getId());
                        }
                        m.addOuterWay((Way)es.getEntity());
                        continue;
                    }
                    if (es.getEntity() instanceof Node && ("admin_centre".equals(es.getRole()) || "admin_center".equals(es.getRole()))) {
                        centerId = ObfConstants.createMapObjectIdFromOsmAndEntity((Entity)es.getEntity());
                        continue;
                    }
                    if (!(es.getEntity() instanceof Node) || !"label".equals(es.getRole())) continue;
                    labelId = ObfConstants.createMapObjectIdFromOsmAndEntity((Entity)es.getEntity());
                }
            } else if (e instanceof Way) {
                m.addOuterWay((Way)e);
            }
            Boundary boundary = new Boundary(m);
            boundary.setName(bname);
            boundary.setAltName(e.getTag("short_name"));
            boundary.setAdminLevel(this.extractBoundaryAdminLevel(e));
            boundary.setBoundaryId(ObfConstants.createMapObjectIdFromOsmAndEntity((Entity)e));
            if (ct == null && census) {
                boundary.setCityType(City.CityType.CENSUS);
            } else {
                boundary.setCityType(ct);
            }
            if (labelId != 0L) {
                boundary.setLabelId(labelId);
            }
            if (centerId != 0L) {
                boundary.setAdminCenterId(centerId);
            }
            return boundary;
        }
        return null;
    }

    public void indexStreetRelation(Relation i, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        if ("street".equals(i.getTag(OSMSettings.OSMTagKey.TYPE)) || "associatedStreet".equals(i.getTag(OSMSettings.OSMTagKey.TYPE))) {
            Set<Long> idsOfStreet;
            LatLon l = null;
            String streetName = null;
            Set isInNames = null;
            ctx.loadEntityRelation(i);
            streetName = i.getTag(OSMSettings.OSMTagKey.NAME);
            Iterator it = i.getMemberEntities(null).iterator();
            while (l == null && it.hasNext()) {
                l = ((Entity)it.next()).getLatLon();
            }
            isInNames = i.getIsInNames();
            String postcode = i.getTag(OSMSettings.OSMTagKey.ADDR_POSTCODE);
            if (streetName == null) {
                List members = i.getMemberEntities("street");
                for (Entity street : members) {
                    String name = street.getTag(OSMSettings.OSMTagKey.NAME);
                    if (name == null) continue;
                    streetName = name;
                    l = street.getLatLon();
                    isInNames = street.getIsInNames();
                    break;
                }
            }
            if (streetName != null && !(idsOfStreet = this.getStreetInCity(isInNames, streetName, false, null, l, icc)).isEmpty()) {
                List houses = i.getMemberEntities("house");
                houses.addAll(i.getMemberEntities("address"));
                for (Entity house : houses) {
                    Building building;
                    Object hname = null;
                    String second = null;
                    if (this.settings.houseNumberPreferredOverName) {
                        hname = house.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NUMBER);
                        second = house.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NAME);
                    } else {
                        hname = house.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NAME);
                        second = house.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NUMBER);
                    }
                    if (hname == null) {
                        hname = second;
                        second = null;
                    }
                    if (hname == null) continue;
                    if (this.settings.houseNameAddAdditionalInfo && second != null) {
                        hname = (String)hname + " - [" + second + "]";
                    }
                    if (this.streetDAO.findBuilding(house)) continue;
                    if (house instanceof Relation) {
                        ctx.loadEntityRelation((Relation)house);
                    }
                    if ((building = EntityParser.parseBuilding((Entity)house)).getLocation() == null) {
                        log.warn((Object)("building with empty location! id: " + house.getId()));
                        continue;
                    }
                    building.setName((String)hname);
                    if (Algorithms.isEmpty((CharSequence)building.getPostcode())) {
                        building.setPostcode(postcode);
                    }
                    this.streetDAO.writeBuilding(idsOfStreet, building);
                }
            }
        }
    }

    public String normalizeStreetName(String name, LatLon location, IndexCreationContext icc) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        name = name.replace("\u2019", "'");
        name = icc.decryptAbbreviations(name, location, this.settings.addRegionTag);
        if (this.normalizeStreets) {
            int ind;
            String newName = name;
            boolean processed = newName.length() != name.length();
            for (String ch : this.normalizeDefaultSuffixes) {
                ind = this.checkSuffix(newName, ch);
                if (ind == -1) continue;
                newName = this.cutSuffix(newName, ind, ch.length());
                processed = true;
                break;
            }
            if (!processed) {
                for (String ch : this.normalizeSuffixes) {
                    ind = this.checkSuffix(newName, ch);
                    if (ind == -1) continue;
                    newName = this.putSuffixToEnd(newName, ind, ch.length());
                    processed = true;
                    break;
                }
            }
            if (processed) {
                return newName;
            }
        }
        return name;
    }

    private int checkSuffix(String name, String suffix) {
        int i = -1;
        boolean searchAgain = false;
        do {
            i = name.indexOf(suffix, i);
            searchAgain = false;
            if (i <= 0 || !Character.isLetterOrDigit(name.charAt(i - 1))) continue;
            ++i;
            searchAgain = true;
        } while (searchAgain);
        return i;
    }

    private String cutSuffix(String name, int ind, int suffixLength) {
        Object newName = name.substring(0, ind);
        if (name.length() > ind + suffixLength) {
            newName = (String)newName + name.substring(ind + suffixLength);
        }
        return ((String)newName).trim();
    }

    private String putSuffixToEnd(String name, int ind, int suffixLength) {
        Object newName;
        if (name.length() <= ind + suffixLength) {
            return name;
        }
        if (ind > 0) {
            newName = name.substring(0, ind);
            newName = (String)newName + name.substring(ind + suffixLength);
            newName = (String)newName + name.substring(ind - 1, ind + suffixLength);
        } else {
            newName = name.substring(suffixLength + 1) + name.charAt(suffixLength) + name.substring(0, suffixLength);
        }
        return ((String)newName).trim();
    }

    public Set<Long> getStreetInCity(Set<String> isInNames, String name, boolean place, Map<String, String> names, final LatLon location, IndexCreationContext icc) throws SQLException {
        if (location == null) {
            return Collections.emptySet();
        }
        name = this.normalizeStreetName(name, location, icc);
        LinkedHashSet<City> result = new LinkedHashSet<City>();
        List<City> nearestObjects = this.cityDataStorage.getClosestObjects(location.getLatitude(), location.getLongitude());
        for (City c : nearestObjects) {
            if (place && c.getName().equals(name)) {
                if (names == null) {
                    names = new HashMap<String, String>();
                }
                names.put("name:place", City.CityType.valueToString((City.CityType)c.getType()));
            }
            if (!c.getType().storedAsSeparateAdminEntity()) continue;
            Boundary boundary = this.cityDataStorage.getBoundaryByCity(c);
            if (!isInNames.contains(c.getName()) && (boundary == null || !boundary.containsPoint(location))) continue;
            result.add(c);
        }
        if (this.settings.indexByProximity) {
            City topAnyCity = null;
            double relAnyDistance = 0.0;
            ArrayList<City> allClosestCities = new ArrayList<City>();
            double threshold = 0.2;
            for (City c : nearestObjects) {
                if (!c.getType().storedAsSeparateAdminEntity()) continue;
                double relDist = this.relativeDistance(location, c);
                if (relDist < threshold) {
                    allClosestCities.add(c);
                }
                if (topAnyCity != null && !(relDist < relAnyDistance)) continue;
                relAnyDistance = relDist;
                topAnyCity = c;
            }
            if (result.isEmpty() && topAnyCity != null && relAnyDistance > threshold) {
                result.add(topAnyCity);
            } else {
                Collections.sort(allClosestCities, new Comparator<City>(){

                    @Override
                    public int compare(City c1, City c2) {
                        double r1 = IndexAddressCreator.this.relativeDistance(location, c1);
                        double r2 = IndexAddressCreator.this.relativeDistance(location, c2);
                        return Double.compare(r1, r2);
                    }
                });
                for (City c : allClosestCities) {
                    if (result.contains(c) || !result.isEmpty() && this.cityDataStorage.isCityHasBoundary(c)) continue;
                    result.add(c);
                }
            }
        }
        return this.registerStreetInCities(name, names, location, result);
    }

    private Set<Long> registerStreetInCities(String name, Map<String, String> names, LatLon location, Collection<City> result) throws SQLException {
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<Long> values = new TreeSet<Long>();
        for (City city : result) {
            Object nameInCity = name;
            if (nameInCity == null) {
                nameInCity = "<" + city.getName() + ">";
                names = new HashMap<String, String>();
                for (Map.Entry e : city.getNamesMap(true).entrySet()) {
                    names.put((String)e.getKey(), "<" + (String)e.getValue() + ">");
                }
                names.put("name:place", City.CityType.valueToString((City.CityType)city.getType()));
            }
            long streetId = this.getOrRegisterStreetIdForCity((String)nameInCity, names, location, city);
            values.add(streetId);
        }
        return values;
    }

    private long getOrRegisterStreetIdForCity(String name, Map<String, String> names, LatLon location, City city) throws SQLException {
        boolean place = names != null && names.containsKey("name:place");
        String cityPart = this.settings.indexByProximity && !place ? this.findCityPart(location, city) : city.getName();
        DBStreetDAO.SimpleStreet foundStreet = this.streetDAO.findStreet(name, city, cityPart);
        if (foundStreet == null) {
            if (cityPart == null) {
                cityPart = city.getName();
            }
            if (names != null) {
                this.langAttributes.addAll(names.keySet());
            }
            return this.streetDAO.insertStreet(name, names, location, city, cityPart);
        }
        if (names != null) {
            HashMap<String, String> addNames = null;
            for (String s : names.keySet()) {
                if (foundStreet.getLangs().contains(s + ";")) continue;
                if (addNames == null) {
                    addNames = new HashMap<String, String>();
                }
                addNames.put(s, names.get(s));
            }
            if (addNames != null) {
                foundStreet = this.streetDAO.updateStreetLangs(foundStreet, addNames);
            }
        }
        return foundStreet.getId();
    }

    private String findCityPart(LatLon location, City city) {
        String cityPart = city.getName();
        boolean found = false;
        Boundary cityBoundary = this.cityDataStorage.getBoundaryByCity(city);
        List<City> subcities = this.cityDataStorage.getCityListByBoundary(cityBoundary);
        subcities = subcities == null || subcities.isEmpty() ? this.cityDataStorage.getClosestObjects(location.getLatitude(), location.getLongitude()) : new ArrayList<City>(subcities);
        Collections.sort(subcities, new Comparator<City>(){

            public int order(City c) {
                if (c.getType() == City.CityType.SUBURB) {
                    return 0;
                }
                if (c.getType() == City.CityType.TOWN) {
                    return 1;
                }
                if (c.getType() == City.CityType.VILLAGE) {
                    return 2;
                }
                return 3;
            }

            @Override
            public int compare(City o1, City o2) {
                return Integer.compare(this.order(o1), this.order(o2));
            }
        });
        Iterator<City> it = subcities.iterator();
        while (it.hasNext()) {
            boolean boundaryPriority;
            City subpart = it.next();
            if (subpart == city) {
                it.remove();
                continue;
            }
            Boundary subBoundary = this.cityDataStorage.getBoundaryByCity(subpart);
            if (subBoundary == null) continue;
            boolean containsPoint = subBoundary.containsPoint(location);
            boolean bl = boundaryPriority = cityBoundary == null || !subBoundary.hasAdminLevel() || subBoundary.getAdminLevel() > cityBoundary.getAdminLevel();
            if (containsPoint && boundaryPriority) {
                cityPart = subpart.getName();
                found = true;
                break;
            }
            it.remove();
        }
        double dist = Double.MAX_VALUE;
        if (!found) {
            for (City subpart : subcities) {
                double actualDistance = MapUtils.getDistance((LatLon)location, (LatLon)subpart.getLocation());
                if (!(actualDistance < 1.5 * subpart.getType().getRadius()) || !(actualDistance < dist)) continue;
                cityPart = subpart.getName();
                dist = actualDistance;
                found = true;
            }
        }
        return cityPart;
    }

    private double relativeDistance(LatLon point, City c) {
        return MapUtils.getDistance((LatLon)c.getLocation(), (LatLon)point) / c.getType().getRadius();
    }

    public void iterateMainEntity(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        boolean exist;
        boolean emptyCityPlace;
        String street2;
        Building building;
        Set<Long> idsOfStreet;
        String interpolation = e.getTag(OSMSettings.OSMTagKey.ADDR_INTERPOLATION);
        String interpolationByHouseNumber = null;
        if (interpolation == null) {
            interpolationByHouseNumber = this.getInterpolationByHouseNumber(e);
        }
        if (e instanceof Way && (interpolation != null || interpolationByHouseNumber != null)) {
            Building.BuildingInterpolation type = null;
            int interpolationInterval = 0;
            try {
                type = Building.BuildingInterpolation.valueOf((String)interpolation.toUpperCase());
            }
            catch (RuntimeException ex) {
                try {
                    interpolationInterval = Integer.parseInt(interpolation);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (type != null || interpolationInterval > 0) {
                ArrayList<Node> nodesWithHno = new ArrayList<Node>();
                for (Node n : ((Way)e).getNodes()) {
                    if (n.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NUMBER) == null) continue;
                    String strt = n.getTag(OSMSettings.OSMTagKey.ADDR_STREET);
                    if (strt == null) {
                        strt = n.getTag(OSMSettings.OSMTagKey.ADDR_PLACE);
                    }
                    if (strt == null) continue;
                    nodesWithHno.add(n);
                }
                if (nodesWithHno.size() > 1) {
                    for (int i = 1; i < nodesWithHno.size(); ++i) {
                        Node first = (Node)nodesWithHno.get(i - 1);
                        Node second = (Node)nodesWithHno.get(i);
                        boolean exist2 = this.streetDAO.findBuilding((Entity)first);
                        if (exist2) {
                            this.streetDAO.removeBuilding((Entity)first);
                        }
                        LatLon l = e.getLatLon();
                        String strt = first.getTag(OSMSettings.OSMTagKey.ADDR_STREET);
                        boolean place = false;
                        if (strt == null) {
                            strt = first.getTag(OSMSettings.OSMTagKey.ADDR_PLACE);
                            place = true;
                        }
                        if ((idsOfStreet = this.getStreetInCity(first.getIsInNames(), strt, place, null, l, icc)).isEmpty()) continue;
                        building = EntityParser.parseBuilding((Entity)first);
                        building.setInterpolationInterval(interpolationInterval);
                        building.setInterpolationType(type);
                        building.setName(first.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NUMBER));
                        building.setName2(second.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NUMBER));
                        building.setLatLon2(second.getLatLon());
                        this.streetDAO.writeBuilding(idsOfStreet, building);
                    }
                }
            }
        }
        String houseName = e.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NAME);
        String houseNumber = this.normalizeHousenumber(e.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NUMBER));
        String streetOrPlace = null;
        boolean place = false;
        if ((houseNumber != null || houseName != null) && (streetOrPlace = e.getTag(OSMSettings.OSMTagKey.ADDR_STREET)) == null) {
            streetOrPlace = e.getTag(OSMSettings.OSMTagKey.ADDR_PLACE);
            place = true;
        }
        if (Algorithms.isEmpty((CharSequence)(street2 = e.getTag(OSMSettings.OSMTagKey.ADDR_STREET2)))) {
            street2 = e.getTag(OSMSettings.OSMTagKey.ADDR2_STREET);
        }
        String city = e.getTag(OSMSettings.OSMTagKey.ADDR_CITY);
        String suburb = e.getTag(OSMSettings.OSMTagKey.ADDR_SUBURB);
        boolean bl = emptyCityPlace = Algorithms.isEmpty((CharSequence)streetOrPlace) && Algorithms.isEmpty((CharSequence)city) && Algorithms.isEmpty((CharSequence)suburb);
        if (!(houseName == null && houseNumber == null || emptyCityPlace)) {
            boolean exist3;
            if (e instanceof Relation) {
                ctx.loadEntityRelation((Relation)e);
                List outs = ((Relation)e).getMemberEntities("outer");
                if (!outs.isEmpty()) {
                    e = (Entity)outs.iterator().next();
                }
            }
            boolean bl2 = exist3 = e instanceof Relation || this.streetDAO.findBuilding(e);
            if (!exist3) {
                LatLon l = e.getLatLon();
                idsOfStreet = this.getStreetInCity(e.getIsInNames(), streetOrPlace, place, null, l, icc);
                if (!idsOfStreet.isEmpty()) {
                    int i;
                    building = EntityParser.parseBuilding((Entity)e);
                    String hname = null;
                    String second = null;
                    if (this.settings.houseNumberPreferredOverName) {
                        hname = houseNumber;
                        second = houseName;
                    } else {
                        hname = houseName;
                        second = houseNumber;
                    }
                    if (hname == null) {
                        hname = second;
                        second = null;
                    }
                    Object additionalHname = "";
                    if (this.settings.houseNameAddAdditionalInfo && second != null) {
                        additionalHname = " - [" + second + "]";
                    }
                    if ((i = hname.indexOf(45)) != -1 && interpolation != null) {
                        building.setInterpolationInterval(1);
                        try {
                            building.setInterpolationType(Building.BuildingInterpolation.valueOf((String)interpolation.toUpperCase()));
                        }
                        catch (RuntimeException ex) {
                            try {
                                building.setInterpolationInterval(Integer.parseInt(interpolation));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        building.setName(hname.substring(0, i));
                        building.setName2(hname.substring(i + 1));
                    } else {
                        building.setName(hname + (String)additionalHname);
                    }
                    if (!Algorithms.isEmpty((CharSequence)street2)) {
                        String secondHno = e.getTag(OSMSettings.OSMTagKey.ADDR2_HOUSE_NUMBER);
                        Object firstNo = building.getName();
                        int secondNumberInd = hname.indexOf(47);
                        if (secondNumberInd != -1 && secondNumberInd < hname.length() - 1 && Algorithms.isEmpty((CharSequence)secondHno)) {
                            firstNo = hname.substring(0, secondNumberInd) + (String)additionalHname;
                            secondHno = hname.substring(secondNumberInd + 1);
                        }
                        if (secondHno != null) {
                            Building building2 = EntityParser.parseBuilding((Entity)e);
                            building2.setName(hname.substring(secondNumberInd + 1) + (String)additionalHname);
                            Set<Long> ids2OfStreet = this.getStreetInCity(e.getIsInNames(), street2, false, null, l, icc);
                            ids2OfStreet.removeAll(idsOfStreet);
                            if (!ids2OfStreet.isEmpty()) {
                                this.streetDAO.writeBuilding(ids2OfStreet, building2);
                                building.setName((String)firstNo);
                            }
                        }
                    }
                    this.streetDAO.writeBuilding(idsOfStreet, building);
                }
            }
        } else if (e instanceof Way && e.getTag(OSMSettings.OSMTagKey.HIGHWAY) != null && e.getTag(OSMSettings.OSMTagKey.NAME) != null && this.isStreetTag(e.getTag(OSMSettings.OSMTagKey.HIGHWAY)) && !"yes".equals(e.getTag(OSMSettings.OSMTagKey.AREA)) && !(exist = this.streetDAO.findStreetNode(e))) {
            LatLon l = e.getLatLon();
            idsOfStreet = this.getStreetInCity(e.getIsInNames(), e.getTag(OSMSettings.OSMTagKey.NAME), false, this.getOtherNames(e), l, icc);
            if (!idsOfStreet.isEmpty()) {
                this.streetDAO.writeStreetWayNodes(idsOfStreet, (Way)e);
            }
        }
        if (e.getTag(OSMSettings.OSMTagKey.POSTAL_CODE) != null) {
            if ("postal_code".equals(e.getTag(OSMSettings.OSMTagKey.BOUNDARY))) {
                Boundary boundary = this.extractBoundary(e, true, ctx);
                if (boundary != null) {
                    this.postcodeBoundaries.put(e, boundary);
                }
            } else if (e instanceof Relation) {
                ctx.loadEntityRelation((Relation)e);
                this.postalCodeRelations.add((Relation)e);
            }
        }
    }

    private String getInterpolationByHouseNumber(Entity e) {
        Matcher houseNumberWithDash;
        String number = e.getTag(OSMSettings.OSMTagKey.ADDR_HOUSE_NUMBER);
        if (number != null && (houseNumberWithDash = Pattern.compile("(\\d+)-(\\d+)").matcher(number)).matches()) {
            long firstNumber = Long.parseLong(houseNumberWithDash.group(1));
            long secondNumber = Long.parseLong(houseNumberWithDash.group(2));
            if (firstNumber % 2L == 0L && secondNumber % 2L == 0L) {
                return "even";
            }
            if (firstNumber % 2L != 0L && secondNumber % 2L != 0L) {
                return "odd";
            }
            return "all";
        }
        return null;
    }

    private String normalizeHousenumber(String hno) {
        if (hno != null) {
            if (((String)hno).toLowerCase().endsWith("bis")) {
                hno = ((String)hno).substring(0, ((String)hno).length() - "bis".length()).trim() + " bis";
            } else if (((String)hno).toLowerCase().endsWith("quater")) {
                hno = ((String)hno).substring(0, ((String)hno).length() - "quater".length()).trim() + " quater";
            } else if (((String)hno).toLowerCase().endsWith("ter")) {
                hno = ((String)hno).substring(0, ((String)hno).length() - "ter".length()).trim() + " ter";
            }
        }
        return hno;
    }

    public void cleanCityPart() throws SQLException {
        this.streetDAO.cleanCityPart();
    }

    private Map<String, String> getOtherNames(Entity e) {
        HashMap<String, String> m = null;
        List<String> languages = Arrays.asList(MapRenderingTypes.langs);
        for (String t : e.getTagKeySet()) {
            String prefix = null;
            if (t.startsWith("name:")) {
                String lang = t.substring(5);
                if (languages.contains(lang)) {
                    prefix = "name:";
                }
            } else if (t.startsWith("old_name")) {
                prefix = "";
            } else if (t.startsWith("alt_name")) {
                prefix = "";
            } else if (t.startsWith("loc_name")) {
                prefix = "";
            }
            if (prefix == null) continue;
            if (m == null) {
                m = new HashMap<String, String>();
            }
            m.put(t.substring(prefix.length()), e.getTag(t));
        }
        return m;
    }

    private boolean isStreetTag(String highwayValue) {
        return !"platform".equals(highwayValue) && !"cycleway".equals(highwayValue);
    }

    private void writeCity(City city) throws SQLException {
        this.addressCityStat.setLong(1, city.getId());
        this.addressCityStat.setDouble(2, city.getLocation().getLatitude());
        this.addressCityStat.setDouble(3, city.getLocation().getLongitude());
        this.addressCityStat.setString(4, city.getName());
        this.addressCityStat.setString(5, Algorithms.encodeMap((Map)city.getNamesMap(true)));
        this.addressCityStat.setString(6, City.CityType.valueToString((City.CityType)city.getType()));
        this.addBatch(this.addressCityStat);
        this.langAttributes.addAll(city.getNamesMap(false).keySet());
    }

    public void writeCitiesIntoDb() throws SQLException {
        for (City c : this.cityDataStorage.getAllCities()) {
            if (!c.getType().storedAsSeparateAdminEntity()) continue;
            this.writeCity(c);
        }
        this.commitWriteCity();
    }

    private void commitWriteCity() throws SQLException {
        if ((Integer)this.pStatements.get(this.addressCityStat) > 0) {
            this.addressCityStat.executeBatch();
            this.pStatements.put(this.addressCityStat, 0);
            this.mapConnection.commit();
        }
    }

    private void setPostcodeForBuilding(String postcode, long buildingId) throws SQLException {
        this.postcodeSetStat.setString(1, postcode);
        this.postcodeSetStat.setLong(2, buildingId);
        this.addBatch(this.postcodeSetStat);
    }

    private void processPostcodeRelations() throws SQLException {
        for (Relation r : this.postalCodeRelations) {
            for (Relation.RelationMember l : r.getMembers()) {
                if (l.getEntityId() == null) continue;
                this.setPostcodeForBuilding(r.getTag(OSMSettings.OSMTagKey.POSTAL_CODE), l.getEntityId().getId());
            }
        }
    }

    public void processPostcodes() throws SQLException {
        this.streetDAO.commit();
        this.pStatements.put(this.postcodeSetStat, 0);
        this.processPostcodeRelations();
        if ((Integer)this.pStatements.get(this.postcodeSetStat) > 0) {
            this.postcodeSetStat.executeBatch();
        }
        this.pStatements.remove(this.postcodeSetStat);
    }

    /*
     * WARNING - void declaration
     */
    public void writeBinaryAddressIndex(BinaryMapIndexWriter writer, String regionName, IProgress progress) throws IOException, SQLException {
        City city;
        void var17_20;
        this.processPostcodes();
        this.cleanCityPart();
        this.streetDAO.close();
        this.closePreparedStatements(this.addressCityStat);
        this.mapConnection.commit();
        this.createDatabaseIndexes(this.mapConnection);
        this.mapConnection.commit();
        TreeMap<String, City> postcodes = new TreeMap<String, City>();
        this.updatePostcodeBoundaries(progress, postcodes);
        this.mapConnection.commit();
        ArrayList<String> additionalTags = new ArrayList<String>();
        HashMap<String, Integer> tagRules = new HashMap<String, Integer>();
        int ind = 0;
        for (String lng : this.langAttributes) {
            additionalTags.add("name:" + lng);
            tagRules.put("name:" + lng, ind);
            ++ind;
        }
        writer.startWriteAddressIndex(regionName, additionalTags);
        Map<City.CityType, List<City>> cities = this.readCities(this.mapConnection);
        LinkedHashMap<String, List<City>> isInGroups = new LinkedHashMap<String, List<City>>();
        PreparedStatement streetstat = this.mapConnection.prepareStatement("SELECT A.id, A.name, A.name_en, A.latitude, A.longitude, B.id, B.name, B.name_en, B.latitude, B.longitude, B.postcode, A.cityPart,  B.name2, B.name_en2, B.lat2, B.lon2, B.interval, B.interpolateType, A.cityPart == C.name as MainTown FROM street A LEFT JOIN building B ON B.street = A.id JOIN city C ON A.city = C.id WHERE A.city = ? ORDER BY MainTown DESC, A.name ASC");
        PreparedStatement waynodesStat = this.mapConnection.prepareStatement("SELECT A.id, A.latitude, A.longitude FROM street_node A WHERE A.street = ? ");
        ArrayList<City> cityTowns = new ArrayList<City>();
        ArrayList<City> villages = new ArrayList<City>();
        for (City.CityType t : cities.keySet()) {
            if (t == City.CityType.CITY || t == City.CityType.TOWN) {
                cityTowns.addAll((Collection)cities.get(t));
            } else if (t.storedAsSeparateAdminEntity()) {
                villages.addAll((Collection)cities.get(t));
            }
            for (City city2 : cities.get(t)) {
                Set isIns = city2.getIsin();
                if (isIns == null) continue;
                for (String isIn : isIns) {
                    ArrayList<City> lst = (ArrayList<City>)isInGroups.get(isIn);
                    if (lst == null) {
                        lst = new ArrayList<City>();
                        isInGroups.put(isIn, lst);
                    }
                    lst.add(city2);
                }
            }
        }
        TreeMap namesIndex = new TreeMap(java.text.Collator.getInstance());
        progress.startTask(this.settings.getString("IndexCreator.SERIALIZING_ADDRESS"), cityTowns.size() + villages.size() / 100 + 1);
        this.writeCityBlockIndex(writer, BinaryMapAddressReaderAdapter.CityBlocks.CITY_TOWN_TYPE.index, streetstat, waynodesStat, isInGroups, cityTowns, postcodes, namesIndex, tagRules, progress);
        this.writeCityBlockIndex(writer, BinaryMapAddressReaderAdapter.CityBlocks.VILLAGES_TYPE.index, streetstat, waynodesStat, isInGroups, villages, postcodes, namesIndex, tagRules, progress);
        ArrayList<BinaryFileReference> refs = new ArrayList<BinaryFileReference>();
        writer.startCityBlockIndex(BinaryMapAddressReaderAdapter.CityBlocks.POSTCODES_TYPE.index);
        ArrayList posts = new ArrayList(postcodes.values());
        for (City s : posts) {
            refs.add(writer.writeCityHeader(s, -1, tagRules));
        }
        boolean bl = false;
        while (var17_20 < posts.size()) {
            City postCode = (City)posts.get((int)var17_20);
            Iterator<Object> ref = (BinaryFileReference)refs.get((int)var17_20);
            IndexAddressCreator.putNamedMapObject(namesIndex, (MapObject)postCode, ((BinaryFileReference)((Object)ref)).getStartPointer(), this.settings);
            ArrayList<Street> streets = new ArrayList<Street>(postCode.getStreets());
            Collections.sort(streets, new Comparator<Street>(){
                final Collator clt = OsmAndCollator.primaryCollator();

                @Override
                public int compare(Street o1, Street o2) {
                    return this.clt.compare(o1.getName(), o2.getName());
                }
            });
            writer.writeCityIndex(postCode, (List<Street>)streets, null, (BinaryFileReference)((Object)ref), (Map<String, Integer>)tagRules);
            ++var17_20;
        }
        writer.endCityBlockIndex();
        writer.startCityBlockIndex(BinaryMapAddressReaderAdapter.CityBlocks.BOUNDARY_TYPE.index);
        refs = new ArrayList();
        List<Boundary> list = this.cityDataStorage.getNotAssignedBoundaries();
        ArrayList<City> boundariesAsCities = new ArrayList<City>();
        for (Boundary b : list) {
            if (Algorithms.isEmpty((CharSequence)b.getName())) continue;
            city = new City(City.CityType.BOUNDARY);
            this.cityDataStorage.assignBbox(city, b);
            city.setId(Long.valueOf(b.getBoundaryId()));
            city.setLocation(b.getCenterPoint());
            city.setName(b.getName());
            if (b.hasAdminLevel()) {
                city.setName("admin_level", "" + b.getAdminLevel());
            }
            if (b.getCityType() != null) {
                city.setName(PLACE_ATTR, City.CityType.valueToString((City.CityType)b.getCityType()));
            }
            if (!Algorithms.isEmpty((CharSequence)b.getAltName())) {
                city.setEnName(b.getAltName());
            }
            boundariesAsCities.add(city);
        }
        for (City c : this.cityDataStorage.getAllCities()) {
            if (c.getType().storedAsSeparateAdminEntity() || c.getType() == City.CityType.POSTCODE) continue;
            city = new City(City.CityType.BOUNDARY);
            city.setBbox31(c.getBbox31());
            this.cityDataStorage.assignBbox(city);
            city.setId(c.getId());
            city.setLocation(c.getLocation());
            city.copyNames((MapObject)c);
            city.setName(c.getName());
            city.setName(PLACE_ATTR, City.CityType.valueToString((City.CityType)c.getType()));
            boundariesAsCities.add(city);
        }
        for (City c : boundariesAsCities) {
            refs.add(writer.writeCityHeader(c, c.getType().ordinal(), tagRules));
        }
        for (int i = 0; i < boundariesAsCities.size(); ++i) {
            Boundary b;
            b = (City)boundariesAsCities.get(i);
            BinaryFileReference ref = (BinaryFileReference)refs.get(i);
            IndexAddressCreator.putNamedMapObject(namesIndex, (MapObject)b, ref.getStartPointer(), this.settings);
            writer.writeCityIndex((City)b, Collections.emptyList(), null, ref, tagRules);
        }
        writer.endCityBlockIndex();
        progress.finishTask();
        writer.writeAddressNameIndex(namesIndex);
        writer.endWriteAddressIndex();
        writer.flush();
        streetstat.close();
        if (waynodesStat != null) {
            waynodesStat.close();
        }
    }

    private void updatePostcodeBoundaries(IProgress progress, Map<String, City> postcodes) throws SQLException {
        progress.startTask("Process postcode boundaries", this.postcodeBoundaries.size());
        Iterator<Map.Entry<Entity, Boundary>> it = this.postcodeBoundaries.entrySet().iterator();
        PreparedStatement ps = this.mapConnection.prepareStatement("SELECT postcode, latitude, longitude, id FROM building where latitude <= ? and latitude >= ? and longitude >= ? and longitude <= ? ");
        TLongObjectHashMap assignPostcodes = new TLongObjectHashMap();
        while (it.hasNext()) {
            Map.Entry<Entity, Boundary> e = it.next();
            String postcode = e.getKey().getTag(OSMSettings.OSMTagKey.POSTAL_CODE);
            Multipolygon mp = e.getValue().getMultipolygon();
            QuadRect bbox = mp.getLatLonBbox();
            if (bbox.width() > 0.0) {
                ps.setDouble(1, bbox.top);
                ps.setDouble(2, bbox.bottom);
                ps.setDouble(3, bbox.left);
                ps.setDouble(4, bbox.right);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String pst = rs.getString(1);
                    if (!Algorithms.isEmpty((CharSequence)pst) || !mp.containsPoint(rs.getDouble(2), rs.getDouble(3))) continue;
                    assignPostcodes.put(rs.getLong(4), (Object)postcode);
                }
            }
            progress.progress(1);
        }
        ps.close();
        ps = this.mapConnection.prepareStatement("UPDATE  building set postcode = ? where id = ? ");
        TLongObjectIterator its = assignPostcodes.iterator();
        int cnt = 0;
        while (its.hasNext()) {
            its.advance();
            ps.setString(1, (String)its.value());
            ps.setLong(2, its.key());
            ps.addBatch();
            if (cnt <= this.BATCH_SIZE) continue;
            ps.executeBatch();
            cnt = 0;
        }
        ps.executeBatch();
        ps.close();
    }

    public static void putNamedMapObject(Map<String, List<MapObject>> namesIndex, MapObject o, long fileOffset, IndexCreatorSettings settings) {
        String name = o.getName();
        IndexAddressCreator.parsePrefix(name, o, namesIndex, settings);
        for (String nm : o.getNamesMap(true).values()) {
            if (nm.equals(name)) continue;
            IndexAddressCreator.parsePrefix(nm, o, namesIndex, settings);
        }
        if (fileOffset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File offset > 2 GB.");
        }
        o.setFileOffset((long)((int)fileOffset));
    }

    private static String removeBraces(String localeName) {
        int i = localeName.indexOf(40);
        Object retName = localeName;
        if (i > -1) {
            retName = localeName.substring(0, i);
            int j = localeName.indexOf(41, i);
            if (j > -1) {
                retName = ((String)retName).trim() + " " + localeName.substring(j + 1).trim();
            }
        }
        return retName;
    }

    private static void parsePrefix(String name, MapObject data, Map<String, List<MapObject>> namesIndex, IndexCreatorSettings settings) {
        String arabic;
        name = Algorithms.normalizeSearchText((String)name);
        name = IndexAddressCreator.removeBraces(name);
        Set<String> splitNames = IndexAddressCreator.splitNames(name);
        if (ArabicNormalizer.isSpecialArabic((String)name) && (arabic = ArabicNormalizer.normalize((String)name)) != null && !arabic.equals(name)) {
            splitNames.addAll(Algorithms.splitByWordsLowercase((String)arabic));
        }
        ArrayList<String> namesToAdd = new ArrayList<String>(splitNames);
        int pos = 0;
        while (namesToAdd.size() > 1 && pos != -1) {
            int prioP = Integer.MAX_VALUE;
            pos = -1;
            for (int k = 0; k < namesToAdd.size(); ++k) {
                int prio = CommonWords.getCommon((String)((String)namesToAdd.get(k)));
                if (prio == -1 || prio >= prioP) continue;
                pos = k;
                prioP = prio;
            }
            if (pos == -1) continue;
            namesToAdd.remove(pos);
        }
        for (String substr : namesToAdd) {
            String val;
            List<MapObject> list;
            if (substr.length() > settings.charsToBuildAddressNameIndex) {
                substr = substr.substring(0, settings.charsToBuildAddressNameIndex);
            }
            if ((list = namesIndex.get(val = substr.toLowerCase())) == null) {
                list = new ArrayList<MapObject>();
                namesIndex.put(val, list);
            }
            if (list.contains(data)) continue;
            list.add(data);
        }
    }

    private static Set<String> splitNames(String name) {
        int prev = -1;
        HashSet<String> namesToAdd = new HashSet<String>();
        for (int i = 0; i <= name.length(); ++i) {
            boolean isHyphenNearNumber;
            boolean bl = isHyphenNearNumber = i != name.length() && name.charAt(i) == '-' && (i + 1 < name.length() && Character.isDigit(name.charAt(i + 1)) || i - 1 >= 0 && Character.isDigit(name.charAt(i - 1)));
            if (i == name.length() || !Character.isLetter(name.charAt(i)) && !Character.isDigit(name.charAt(i)) && name.charAt(i) != '\'' && !isHyphenNearNumber) {
                if (prev == -1) continue;
                String substr = name.substring(prev, i);
                namesToAdd.add(substr.toLowerCase());
                prev = -1;
                continue;
            }
            if (prev != -1) continue;
            prev = i;
        }
        return namesToAdd;
    }

    private void writeCityBlockIndex(BinaryMapIndexWriter writer, int type, PreparedStatement streetstat, PreparedStatement waynodesStat, Map<String, List<City>> isInGroups, List<City> cities, Map<String, City> postcodes, Map<String, List<MapObject>> namesIndex, Map<String, Integer> tagRules, IProgress progress) throws IOException, SQLException {
        ArrayList<BinaryFileReference> refs = new ArrayList<BinaryFileReference>();
        writer.startCityBlockIndex(type);
        for (City c : cities) {
            this.cityDataStorage.assignBbox(c);
            refs.add(writer.writeCityHeader(c, c.getType().ordinal(), tagRules));
        }
        for (int i = 0; i < cities.size(); ++i) {
            City city = cities.get(i);
            BinaryFileReference ref = (BinaryFileReference)refs.get(i);
            IndexAddressCreator.putNamedMapObject(namesIndex, (MapObject)city, ref.getStartPointer(), this.settings);
            if (type == BinaryMapAddressReaderAdapter.CityBlocks.CITY_TOWN_TYPE.index) {
                progress.progress(1);
            } else if ((cities.size() - i) % 100 == 0) {
                progress.progress(1);
            }
            LinkedHashMap<Street, List<Node>> streetNodes = new LinkedHashMap<Street, List<Node>>();
            Boundary boundary = this.cityDataStorage.getBoundaryByCity(city);
            ArrayList<City> listSuburbs = null;
            if (isInGroups != null && (boundary == null || boundary.getMultipolygon().hasOpenedPolygons()) && isInGroups.containsKey(city.getName().toLowerCase())) {
                List<City> suburbs = isInGroups.get(city.getName().toLowerCase());
                listSuburbs = new ArrayList<City>();
                for (City suburb : suburbs) {
                    if (suburb.getType() != City.CityType.SUBURB || city.getType() == City.CityType.SUBURB) continue;
                    listSuburbs.add(suburb);
                }
            }
            long time = System.currentTimeMillis();
            List<Street> streets = this.readStreetsBuildings(streetstat, city, waynodesStat, streetNodes, listSuburbs);
            long f = System.currentTimeMillis() - time;
            writer.writeCityIndex(city, streets, streetNodes, ref, tagRules);
            int bCount = 0;
            for (Street s : streets) {
                IndexAddressCreator.putNamedMapObject(namesIndex, (MapObject)s, s.getFileOffset(), this.settings);
                for (Building b : s.getBuildings()) {
                    City post;
                    Street newS;
                    ++bCount;
                    if (city.getPostcode() != null && b.getPostcode() == null) {
                        b.setPostcode(city.getPostcode());
                    }
                    if (b.getPostcode() == null) continue;
                    if (!postcodes.containsKey(b.getPostcode())) {
                        City p = City.createPostcode((String)b.getPostcode());
                        p.setLocation(b.getLocation().getLatitude(), b.getLocation().getLongitude());
                        postcodes.put(b.getPostcode(), p);
                    }
                    if ((newS = (post = postcodes.get(b.getPostcode())).getStreetByName(s.getName())) == null) {
                        newS = new Street(post);
                        newS.copyNames((MapObject)s);
                        newS.setLocation(s.getLocation().getLatitude(), s.getLocation().getLongitude());
                        newS.setId(s.getId());
                        post.registerStreet(newS);
                    }
                    newS.addBuildingCheckById(b);
                }
            }
            if (f <= 500L) continue;
            if (this.logMapDataWarn != null) {
                this.logMapDataWarn.info((Object)("! " + city.getName() + " ! " + f + " ms " + streets.size() + " streets " + bCount + " buildings"));
                continue;
            }
            log.info((Object)("! " + city.getName() + " ! " + f + " ms " + streets.size() + " streets " + bCount + " buildings"));
        }
        writer.endCityBlockIndex();
    }

    public void commitToPutAllCities() throws SQLException {
        this.streetDAO.commit();
    }

    public void createDatabaseIndexes(Connection mapConnection) throws SQLException {
        Statement stat = mapConnection.createStatement();
        stat.executeUpdate("create index city_ind on city (id, city_type)");
        stat.close();
        this.streetDAO.createIndexes(mapConnection);
    }

    public void createDatabaseStructure(Connection mapConnection, DBDialect dialect) throws SQLException {
        this.mapConnection = mapConnection;
        this.streetDAO.createDatabaseStructure(mapConnection, dialect);
        Statement stat = mapConnection.createStatement();
        stat.executeUpdate("create table city (id bigint primary key, latitude double, longitude double, name varchar(1024), name_en varchar(1024), city_type varchar(32))");
        stat.close();
        this.addressCityStat = mapConnection.prepareStatement("insert into city (id, latitude, longitude, name, name_en, city_type) values (?, ?, ?, ?, ?, ?)");
        this.postcodeSetStat = mapConnection.prepareStatement("UPDATE building SET postcode = ? WHERE id = ?");
        this.pStatements.put(this.addressCityStat, 0);
    }

    private List<Street> readStreetsBuildings(PreparedStatement streetBuildingsStat, City city, PreparedStatement waynodesStat, Map<Street, List<Node>> streetNodes, List<City> attachedSuburbs) throws SQLException {
        TLongObjectHashMap visitedStreets = new TLongObjectHashMap();
        TreeMap<String, List<Street>> uniqueNames = new TreeMap<String, List<Street>>((Comparator<String>)OsmAndCollator.primaryCollator());
        this.readStreetsAndBuildingsForCity(streetBuildingsStat, city, city, waynodesStat, streetNodes, (TLongObjectHashMap<Street>)visitedStreets, uniqueNames);
        if (attachedSuburbs != null) {
            for (City suburb : attachedSuburbs) {
                this.readStreetsAndBuildingsForCity(streetBuildingsStat, city, suburb, waynodesStat, streetNodes, (TLongObjectHashMap<Street>)visitedStreets, uniqueNames);
            }
        }
        this.mergeStreetsWithSameNames(streetNodes, uniqueNames);
        return new ArrayList<Street>(streetNodes.keySet());
    }

    private void mergeStreetsWithSameNames(Map<Street, List<Node>> streetNodes, Map<String, List<Street>> uniqueNames) {
        uniqueNames.keySet().stream().map(uniqueNames::get).filter(streets -> streets.size() > 1).forEach(streets -> this.mergeStreets((List<Street>)streets, streetNodes));
    }

    private void mergeStreets(List<Street> streets, Map<Street, List<Node>> streetNodes) {
        streets.sort(Collections.reverseOrder((s0, s1) -> Algorithms.compare((int)s0.getIntersectedStreets().size(), (int)s1.getIntersectedStreets().size())));
        streets.sort(Collections.reverseOrder((s0, s1) -> Algorithms.compare((int)s0.getBuildings().size(), (int)s1.getBuildings().size())));
        int i = 0;
        while (i < streets.size() - 1) {
            Street s = streets.get(i);
            boolean merged = false;
            int j = i + 1;
            while (j < streets.size()) {
                Street candidate = streets.get(j);
                if (this.getDistance(s, candidate, streetNodes) <= 900.0) {
                    merged = true;
                    s.mergeWith(candidate);
                    candidate.getCity().unregisterStreet(candidate);
                    List<Node> old = streetNodes.remove(candidate);
                    streetNodes.get(s).addAll(old);
                    streets.remove(j);
                    continue;
                }
                ++j;
            }
            if (merged) continue;
            ++i;
        }
    }

    private double getDistance(Street s, Street c, Map<Street, List<Node>> streetNodes) {
        List<Node> thisWayNodes = streetNodes.get(s);
        List<Node> oppositeStreetNodes = streetNodes.get(c);
        if (thisWayNodes.size() == 0) {
            thisWayNodes = Collections.singletonList(new Node(s.getLocation().getLatitude(), s.getLocation().getLongitude(), -1L));
        }
        if (oppositeStreetNodes.size() == 0) {
            oppositeStreetNodes = Collections.singletonList(new Node(c.getLocation().getLatitude(), c.getLocation().getLongitude(), -1L));
        }
        double md = Double.POSITIVE_INFINITY;
        for (Node n : thisWayNodes) {
            for (Node d : oppositeStreetNodes) {
                if (n == null || d == null) continue;
                md = Math.min(md, OsmMapUtils.getDistance((Node)n, (Node)d));
            }
        }
        return md;
    }

    private void readStreetsAndBuildingsForCity(PreparedStatement streetBuildingsStat, City mainCity, City city, PreparedStatement waynodesStat, Map<Street, List<Node>> streetNodes, TLongObjectHashMap<Street> visitedStreets, Map<String, List<Street>> uniqueNames) throws SQLException {
        streetBuildingsStat.setLong(1, city.getId());
        ResultSet set = streetBuildingsStat.executeQuery();
        while (set.next()) {
            long streetId = set.getLong(1);
            if (!visitedStreets.containsKey(streetId)) {
                Object cityPart;
                String streetName = set.getString(2);
                Map names = Algorithms.decodeMap((String)set.getString(3));
                double lat = set.getDouble(4);
                double lon = set.getDouble(5);
                List<Node> thisWayNodes = this.loadStreetNodes(streetId, waynodesStat);
                Street street = this.addStreetToUniqueNamesMap(uniqueNames, streetName, names, city);
                street.setLocation(lat, lon);
                street.setId(Long.valueOf(streetId));
                String district = set.getString(12);
                Object object = cityPart = district == null || district.equals(city.getName()) ? "" : " (" + district + ")";
                if (mainCity != city && ((String)cityPart).length() == 0) {
                    cityPart = " (" + city.getName() + ")";
                }
                street.setName(streetName + (String)cityPart);
                for (String lang : names.keySet()) {
                    street.setName(lang, (String)names.get(lang) + (String)cityPart);
                }
                streetNodes.put(street, thisWayNodes);
                city.registerStreet(street);
                visitedStreets.put(streetId, (Object)street);
            }
            if (set.getObject(6) == null) continue;
            Street s = (Street)visitedStreets.get(streetId);
            Building b = new Building();
            b.setId(Long.valueOf(set.getLong(6)));
            b.copyNames(set.getString(7), null, Algorithms.decodeMap((String)set.getString(8)));
            b.setLocation(set.getDouble(9), set.getDouble(10));
            b.setPostcode(set.getString(11));
            b.setName2(set.getString(13));
            b.setName2(set.getString(14));
            double lat2 = set.getDouble(15);
            double lon2 = set.getDouble(16);
            if (lat2 != 0.0 || lon2 != 0.0) {
                b.setLatLon2(new LatLon(lat2, lon2));
            }
            b.setInterpolationInterval(set.getInt(17));
            String type = set.getString(18);
            if (type != null) {
                b.setInterpolationType(Building.BuildingInterpolation.valueOf((String)type));
            }
            s.addBuildingCheckById(b);
        }
        set.close();
    }

    private Street addStreetToUniqueNamesMap(Map<String, List<Street>> uniqueNames, String currStrName, Map<String, String> names, City city) {
        String resStrName = currStrName;
        if (!uniqueNames.containsKey(currStrName)) {
            String foundStrName = this.findSameStrNameByUniqueNames(uniqueNames, names);
            if (foundStrName == null) {
                foundStrName = this.findSameStrNameByAllStrNames(uniqueNames, currStrName);
            }
            if (foundStrName != null) {
                resStrName = foundStrName;
            } else {
                uniqueNames.put(currStrName, new ArrayList());
            }
        }
        Street street = new Street(city);
        uniqueNames.get(resStrName).add(street);
        return street;
    }

    private String findSameStrNameByAllStrNames(Map<String, List<Street>> uniqueNames, String currentStreetName) {
        for (Map.Entry<String, List<Street>> uniqueName : uniqueNames.entrySet()) {
            for (Street uniqueStreet : uniqueName.getValue()) {
                if (this.findSameStreetName(uniqueStreet, currentStreetName) == null) continue;
                return uniqueName.getKey();
            }
        }
        return null;
    }

    private String findSameStreetName(Street uniqueStreet, String currentStreetName) {
        return this.getOtherNames(uniqueStreet).stream().filter(name -> name.equals(currentStreetName)).findFirst().orElse(null);
    }

    private String findSameStrNameByUniqueNames(Map<String, List<Street>> uniqueNames, Map<String, String> names) {
        List namesList = names.keySet().stream().filter(name -> !name.startsWith("old")).collect(Collectors.toList());
        return uniqueNames.keySet().stream().filter(namesList::contains).findFirst().orElse(null);
    }

    private List<String> getOtherNames(Street str) {
        return str.getNamesMap(true).entrySet().stream().filter(name -> !((String)name.getKey()).contains("old")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private List<Node> loadStreetNodes(long streetId, PreparedStatement waynodesStat) throws SQLException {
        ArrayList<Node> list = new ArrayList<Node>();
        waynodesStat.setLong(1, streetId);
        ResultSet rs = waynodesStat.executeQuery();
        while (rs.next()) {
            list.add(new Node(rs.getDouble(2), rs.getDouble(3), rs.getLong(1)));
        }
        rs.close();
        return list;
    }

    public Map<City.CityType, List<City>> readCities(Connection c) throws SQLException {
        LinkedHashMap<City.CityType, List<City>> cities = new LinkedHashMap<City.CityType, List<City>>();
        for (City.CityType t : City.CityType.values()) {
            cities.put(t, new ArrayList());
        }
        Statement stat = c.createStatement();
        ResultSet set = stat.executeQuery("select id, latitude, longitude , name , name_en , city_type from city");
        while (set.next()) {
            Boundary cityB;
            City.CityType type = City.CityType.valueFromString((String)set.getString(6));
            City city = new City(type);
            city.copyNames(set.getString(4), null, Algorithms.decodeMap((String)set.getString(5)));
            city.setLocation(set.getDouble(2), set.getDouble(3));
            city.setId(Long.valueOf(set.getLong(1)));
            ((List)cities.get(type)).add(city);
            if (!this.DEBUG_FULL_NAMES || (cityB = this.cityDataStorage.getBoundaryByCity(city)) == null) continue;
            city.setName(city.getName() + " " + cityB.getAdminLevel() + ":" + cityB.getName());
        }
        set.close();
        stat.close();
        Comparator<City> comparator = new Comparator<City>(){

            @Override
            public int compare(City o1, City o2) {
                return java.text.Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        };
        for (List t : cities.values()) {
            Collections.sort(t, comparator);
        }
        return cities;
    }
}

