/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.osm.OsmRouteType;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.primitives.Metadata;
import net.osmand.util.Algorithms;
import net.osmand.util.TransliterationHelper;

public class NetworkRouteSelector {
    public static final String ROUTE_KEY_VALUE_SEPARATOR = "__";
    public static final String NETWORK_ROUTE_TYPE = "type";

    public static List<RouteKey> getRouteKeys(RouteDataObject obj) {
        int i;
        TreeMap<String, String> tags = new TreeMap<String, String>();
        for (i = 0; obj.nameIds != null && i < obj.nameIds.length; ++i) {
            int nameId = obj.nameIds[i];
            String value = (String)obj.names.get(nameId);
            BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(nameId);
            if (rt == null) continue;
            tags.put(rt.getTag(), value);
        }
        for (i = 0; obj.types != null && i < obj.types.length; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(obj.types[i]);
            if (rt == null) continue;
            tags.put(rt.getTag(), rt.getValue());
        }
        return NetworkRouteSelector.getRouteKeys(tags);
    }

    public static List<RouteKey> getRouteKeys(BinaryMapDataObject bMdo) {
        int i;
        BinaryMapIndexReader.TagValuePair tp;
        TreeMap<String, String> tags = new TreeMap<String, String>();
        for (int i2 = 0; i2 < bMdo.getObjectNames().keys().length; ++i2) {
            int keyInd = bMdo.getObjectNames().keys()[i2];
            tp = bMdo.getMapIndex().decodeType(keyInd);
            String value = (String)bMdo.getObjectNames().get(keyInd);
            if (tp == null) continue;
            tags.put(tp.tag, value);
        }
        int[] tps = bMdo.getAdditionalTypes();
        for (i = 0; i < tps.length; ++i) {
            tp = bMdo.getMapIndex().decodeType(tps[i]);
            if (tp == null) continue;
            tags.put(tp.tag, tp.value);
        }
        tps = bMdo.getTypes();
        for (i = 0; i < tps.length; ++i) {
            tp = bMdo.getMapIndex().decodeType(tps[i]);
            if (tp == null) continue;
            tags.put(tp.tag, tp.value);
        }
        return NetworkRouteSelector.getRouteKeys(tags);
    }

    private static int getRouteQuantity(Map<String, String> tags, OsmRouteType rType) {
        int q = 0;
        for (String tag : tags.keySet()) {
            int num;
            if (!tag.startsWith(rType.getTagPrefix()) || (num = Algorithms.extractIntegerNumber(tag)) <= 0 || !tag.equals(rType.getTagPrefix() + num)) continue;
            q = Math.max(q, num);
        }
        return q;
    }

    public static List<RouteKey> getRouteKeys(Map<String, String> tags) {
        ArrayList<RouteKey> lst = new ArrayList<RouteKey>();
        for (OsmRouteType routeType : OsmRouteType.getAllValues()) {
            if (routeType.getRenderingPropertyAttr() == null) continue;
            int rq = NetworkRouteSelector.getRouteQuantity(tags, routeType);
            for (int routeIdx = 1; routeIdx <= rq; ++routeIdx) {
                String prefix = routeType.getTagPrefix() + routeIdx;
                RouteKey routeKey = new RouteKey(routeType);
                for (Map.Entry<String, String> e : tags.entrySet()) {
                    String tag = e.getKey();
                    if (!tag.startsWith(prefix) || tag.length() <= prefix.length()) continue;
                    String key = tag.substring(prefix.length() + 1);
                    routeKey.addTag(key, e.getValue());
                }
                lst.add(routeKey);
            }
        }
        return lst;
    }

    public static boolean containsUnsupportedRouteTags(Map<String, String> tags) {
        for (OsmRouteType routeType : OsmRouteType.getAllValues()) {
            if (routeType.getRenderingPropertyAttr() != null) continue;
            String routeName = "route_" + routeType.getName();
            String routeNameWithSuffixFirst = routeName + "_1";
            if (!tags.containsKey(routeName) && !tags.containsKey(routeNameWithSuffixFirst)) continue;
            return true;
        }
        return false;
    }

    public static class RouteKey {
        public final OsmRouteType type;
        public final Set<String> tags = new TreeSet<String>();
        private static final Map<String, String> SHIELD_TO_OSMC = Map.ofEntries(Map.entry("shield_bg", "osmc_background"), Map.entry("shield_fg", "osmc_foreground"), Map.entry("shield_fg_2", "osmc_foreground2"), Map.entry("shield_textcolor", "osmc_textcolor"), Map.entry("shield_text", "osmc_text"));

        public RouteKey(OsmRouteType routeType) {
            this.type = routeType;
        }

        public String getValue(String key) {
            key = NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR + (String)key + NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR;
            for (String tag : this.tags) {
                int i = tag.indexOf((String)key);
                if (i <= 0) continue;
                return tag.substring(i + ((String)key).length());
            }
            return "";
        }

        public String getKeyFromTag(String tag) {
            String prefix = "route_" + this.type.getName() + NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR;
            if (tag.startsWith(prefix) && tag.length() > prefix.length()) {
                int endIdx = tag.indexOf(NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR, prefix.length());
                return tag.substring(prefix.length(), endIdx != -1 ? endIdx : tag.length());
            }
            return "";
        }

        public void addTag(String key, String value) {
            value = Algorithms.isEmpty((CharSequence)value) ? "" : NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR + (String)value;
            this.tags.add("route_" + this.type.getName() + NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR + key + (String)value);
        }

        public String getRouteName() {
            return this.getRouteName(null);
        }

        public String getRouteName(String localeId) {
            return this.getRouteName(localeId, false);
        }

        public String getRouteName(String localeId, boolean transliteration) {
            String name;
            if (localeId != null && !(name = this.getValue("name:" + localeId)).isEmpty()) {
                return name;
            }
            name = this.getValue("name");
            if (!name.isEmpty()) {
                return transliteration ? TransliterationHelper.transliterate(name) : name;
            }
            name = this.getValue("ref");
            if (!name.isEmpty()) {
                return name;
            }
            name = this.getFromTo();
            if (!name.isEmpty()) {
                return name;
            }
            name = this.getRelationID();
            if (!name.isEmpty()) {
                return name;
            }
            return this.type.getName();
        }

        public String getRelationID() {
            return this.getValue("relation_id");
        }

        public String getNetwork() {
            return this.getValue("network");
        }

        public String getOperator() {
            return this.getValue("operator");
        }

        public String getSymbol() {
            return this.getValue("symbol");
        }

        public String getWebsite() {
            return this.getValue("website");
        }

        public String getWikipedia() {
            return this.getValue("wikipedia");
        }

        public String getRef() {
            return this.getValue("ref");
        }

        public String getFromTo() {
            String from = this.getValue("from");
            String to = this.getValue("to");
            if (!Algorithms.isEmpty(from) && !Algorithms.isEmpty(to)) {
                return from + " - " + to;
            }
            return "";
        }

        public static RouteKey fromGpxFile(GpxFile gpxFile) {
            OsmRouteType routeType;
            Map networkRouteKeyTags = gpxFile.getNetworkRouteKeyTags();
            String type = (String)networkRouteKeyTags.get(NetworkRouteSelector.NETWORK_ROUTE_TYPE);
            if (!Algorithms.isEmpty(type) && (routeType = OsmRouteType.getByTag(type)) != null) {
                RouteKey routeKey = new RouteKey(routeType);
                for (Map.Entry tag : networkRouteKeyTags.entrySet()) {
                    routeKey.addTag((String)tag.getKey(), (String)tag.getValue());
                }
                return routeKey;
            }
            Metadata metadata = gpxFile.getMetadata();
            LinkedHashMap<String, String> combinedExtensionsTags = new LinkedHashMap<String, String>();
            combinedExtensionsTags.putAll(metadata.getExtensionsToRead());
            combinedExtensionsTags.putAll(gpxFile.getExtensionsToRead());
            return RouteKey.fromShieldTags(combinedExtensionsTags);
        }

        public static RouteKey fromShieldTags(Map<String, String> shieldTags) {
            if (!shieldTags.isEmpty()) {
                for (Map.Entry<String, String> entry : SHIELD_TO_OSMC.entrySet()) {
                    String shield = entry.getKey();
                    String osmc = entry.getValue();
                    String value = shieldTags.get(shield);
                    if (value == null) continue;
                    shieldTags.put(osmc, value.replaceFirst("^osmc_", "").replaceFirst("_bg$", ""));
                }
                RouteKey tagsAsRouteKey = new RouteKey(OsmRouteType.UNKNOWN);
                shieldTags.forEach(tagsAsRouteKey::addTag);
                return tagsAsRouteKey;
            }
            return null;
        }

        public Map<String, String> tagsToGpx() {
            HashMap<String, String> networkRouteKey = new HashMap<String, String>();
            networkRouteKey.put(NetworkRouteSelector.NETWORK_ROUTE_TYPE, this.type.getName());
            for (String tag : this.tags) {
                String key = this.getKeyFromTag(tag);
                String value = this.getValue(key);
                if (Algorithms.isEmpty(value)) continue;
                networkRouteKey.put(key, value);
            }
            return networkRouteKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.tags.hashCode();
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RouteKey other = (RouteKey)obj;
            if (!this.tags.equals(other.tags)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "Route [type=" + String.valueOf(this.type) + ", set=" + String.valueOf(this.tags) + "]";
        }
    }

    public static class NetworkRouteSelectorFilter {
        public Set<RouteKey> keyFilter = null;
        public Set<OsmRouteType> typeFilter = null;

        public List<RouteKey> convert(BinaryMapDataObject obj) {
            return this.filterKeys(NetworkRouteSelector.getRouteKeys(obj));
        }

        public List<RouteKey> convert(RouteDataObject obj) {
            return this.filterKeys(NetworkRouteSelector.getRouteKeys(obj));
        }

        private List<RouteKey> filterKeys(List<RouteKey> keys) {
            if (this.keyFilter == null && this.typeFilter == null) {
                return keys;
            }
            Iterator<RouteKey> it = keys.iterator();
            while (it.hasNext()) {
                RouteKey key = it.next();
                if (this.keyFilter != null && !this.keyFilter.contains(key)) {
                    it.remove();
                    continue;
                }
                if (this.typeFilter == null || this.typeFilter.contains(key.type)) continue;
                it.remove();
            }
            return keys;
        }
    }
}

