/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.parameter;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.ArrayUtils;

public class InputStreamConverter
implements Converter {
    private static final Base64Encoder BASE64 = new Base64Encoder();

    public boolean canConvert(Class type) {
        return InputStream.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        int readSize;
        InputStream inpuStream = (InputStream)source;
        byte[] buffer = new byte[4096];
        do {
            try {
                readSize = inpuStream.read(buffer);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to read input stream", (Throwable)e);
            }
            if (readSize <= 0) continue;
            if (readSize == 4096) {
                writer.setValue(BASE64.encode(buffer));
                continue;
            }
            writer.setValue(BASE64.encode(ArrayUtils.subarray((byte[])buffer, (int)0, (int)readSize)));
        } while (readSize == 4096);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return new ByteArrayInputStream(BASE64.decode(reader.getValue()));
    }
}

