/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.confluence;

import java.util.ArrayDeque;
import java.util.Deque;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.InternalWikiScannerContext;
import org.xwiki.rendering.wikimodel.util.IListListener;
import org.xwiki.rendering.wikimodel.util.ListBuilder;
import org.xwiki.rendering.wikimodel.util.SectionBuilder;

public class ConfluenceInternalWikiScannerContext
extends InternalWikiScannerContext {
    private int fPreBlockType = 0;

    public ConfluenceInternalWikiScannerContext(SectionBuilder<WikiParameters> sectionBuilder, IWemListener listener) {
        super(sectionBuilder, listener);
    }

    @Override
    public void onTableCell(boolean head, WikiParameters params) {
        this.checkStyleOpened();
        this.checkListOpened();
        this.endTableCell();
        this.fTableHead = head;
        this.fTableCellParams = params != null ? params : WikiParameters.EMPTY;
    }

    @Override
    public void beginList() {
        if ((this.fBlockType & 8) != 8) {
            if (!this.isInTable()) {
                this.closeBlock();
            } else {
                this.checkStyleOpened();
                this.fPreBlockType = this.fBlockType;
            }
            if (this.fListParams == null) {
                this.fListParams = WikiParameters.EMPTY;
            }
            IListListener listener = new IListListener(){
                private Deque<WikiParameters> fListParamsStack = new ArrayDeque<WikiParameters>();

                @Override
                public void beginRow(char treeType, char rowType) {
                    if (rowType == ':') {
                        ConfluenceInternalWikiScannerContext.this.fBlockType = 56;
                        ConfluenceInternalWikiScannerContext.this.fListener.beginDefinitionDescription();
                    } else if (rowType == ';') {
                        ConfluenceInternalWikiScannerContext.this.fBlockType = 88;
                        ConfluenceInternalWikiScannerContext.this.fListener.beginDefinitionTerm();
                    } else {
                        ConfluenceInternalWikiScannerContext.this.fBlockType = 136;
                        ConfluenceInternalWikiScannerContext.this.fListener.beginListItem();
                    }
                    ConfluenceInternalWikiScannerContext.this.beginStyleContainer();
                }

                @Override
                public void beginTree(char type) {
                    this.fListParamsStack.push(ConfluenceInternalWikiScannerContext.this.fListParams);
                    ConfluenceInternalWikiScannerContext.this.closeFormat();
                    switch (type) {
                        case '#': {
                            ConfluenceInternalWikiScannerContext.this.fListener.beginList(ConfluenceInternalWikiScannerContext.this.fListParams, true);
                            ConfluenceInternalWikiScannerContext.this.fBlockType = 8;
                            break;
                        }
                        case 'd': {
                            ConfluenceInternalWikiScannerContext.this.fListener.beginDefinitionList(ConfluenceInternalWikiScannerContext.this.fListParams);
                            ConfluenceInternalWikiScannerContext.this.fBlockType = 24;
                            break;
                        }
                        default: {
                            ConfluenceInternalWikiScannerContext.this.fListener.beginList(ConfluenceInternalWikiScannerContext.this.fListParams, false);
                            ConfluenceInternalWikiScannerContext.this.fBlockType = 8;
                        }
                    }
                    ConfluenceInternalWikiScannerContext.this.fListParams = WikiParameters.EMPTY;
                }

                @Override
                public void endRow(char treeType, char rowType) {
                    ConfluenceInternalWikiScannerContext.this.closeFormat();
                    ConfluenceInternalWikiScannerContext.this.endStyleContainer();
                    if (rowType == ':') {
                        ConfluenceInternalWikiScannerContext.this.fListener.endDefinitionDescription();
                        ConfluenceInternalWikiScannerContext.this.fBlockType = 24;
                    } else if (rowType == ';') {
                        if ((ConfluenceInternalWikiScannerContext.this.fBlockType & 0x58) == 88) {
                            ConfluenceInternalWikiScannerContext.this.fListener.endDefinitionTerm();
                        } else {
                            ConfluenceInternalWikiScannerContext.this.fListener.endDefinitionDescription();
                        }
                        ConfluenceInternalWikiScannerContext.this.fBlockType = 24;
                    } else {
                        ConfluenceInternalWikiScannerContext.this.fListener.endListItem();
                        ConfluenceInternalWikiScannerContext.this.fBlockType = 8;
                    }
                }

                @Override
                public void endTree(char type) {
                    switch (type) {
                        case '#': {
                            ConfluenceInternalWikiScannerContext.this.fListener.endList(this.fListParamsStack.peek(), true);
                            ConfluenceInternalWikiScannerContext.this.fBlockType = 8;
                            break;
                        }
                        case 'd': {
                            ConfluenceInternalWikiScannerContext.this.fListener.endDefinitionList(this.fListParamsStack.peek());
                            ConfluenceInternalWikiScannerContext.this.fBlockType = 8;
                            break;
                        }
                        default: {
                            ConfluenceInternalWikiScannerContext.this.fListener.endList(this.fListParamsStack.peek(), false);
                            ConfluenceInternalWikiScannerContext.this.fBlockType = 8;
                        }
                    }
                    this.fListParamsStack.pop();
                }
            };
            this.fListBuilder = new ListBuilder(listener){

                @Override
                protected char getTreeType(char rowType) {
                    if (rowType == ';' || rowType == ':') {
                        return 'd';
                    }
                    return rowType;
                }
            };
            this.fBlockType = 8;
        }
    }

    @Override
    public void endList() {
        if ((this.fBlockType & 8) != 0) {
            this.fListBuilder.alignContext("");
            this.fListBuilder = null;
            this.fBlockType = this.fPreBlockType;
            this.fPreBlockType = 0;
        }
    }

    public boolean isExplicitInTable() {
        return super.isInTable() || (this.fPreBlockType & 0x800) == 2048 && (this.fBlockType & 8) == 8;
    }

    private void checkListOpened() {
        if (this.isExplicitInTable()) {
            this.endList();
        }
    }
}

