/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.PlatformUtil;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;

public class CommonWords {
    private static Map<String, Integer> commonWordsDictionary = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> frequentlyUsedWordsDictionary = new LinkedHashMap<String, Integer>();
    private static String NUMBER_WITH_LESS_THAN_2_LETTERS = "NUMBER_WITH_LESS_THAN_2_LETTERS";

    private static void addCommon(String string) {
        commonWordsDictionary.put(string, commonWordsDictionary.size());
    }

    private static void addFrequentlyUsed(String string) {
        frequentlyUsedWordsDictionary.put(string, frequentlyUsedWordsDictionary.size());
    }

    public static int getCommon(String name) {
        Integer i;
        if (Character.isDigit(name.charAt(0)) && CommonWords.letters(name) < 2) {
            name = NUMBER_WITH_LESS_THAN_2_LETTERS;
        }
        return (i = commonWordsDictionary.get(name)) == null ? -1 : i;
    }

    public static int getFrequentlyUsed(String name) {
        Integer i = frequentlyUsedWordsDictionary.get(name);
        return i == null ? -1 : i;
    }

    public static int getCommonSearch(String name) {
        Integer i;
        if (Character.isDigit(name.charAt(0)) && CommonWords.letters(name) < 2) {
            name = NUMBER_WITH_LESS_THAN_2_LETTERS;
        }
        if ((i = commonWordsDictionary.get(name)) == null) {
            int fq = CommonWords.getFrequentlyUsed(name);
            if (fq != -1) {
                return commonWordsDictionary.size() + fq;
            }
            return -1;
        }
        return i;
    }

    public static int getCommonGeocoding(String name) {
        Integer i = commonWordsDictionary.get(name);
        return i == null ? -1 : i;
    }

    private static int letters(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    private static void addRegionNames() {
        OsmandRegions osmandRegions = null;
        try {
            osmandRegions = PlatformUtil.getOsmandRegions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (osmandRegions != null) {
            HashSet<String> names = new HashSet<String>();
            CommonWords.parseRegionNames(osmandRegions.getWorldRegion(), names);
            for (String name : names) {
                CommonWords.addCommon(name);
                if (!name.contains(".")) continue;
                CommonWords.addCommon(name.replace(".", ""));
            }
        }
    }

    private static void parseRegionNames(WorldRegion region, Set<String> result) {
        List<WorldRegion> subregions = region.getSubregions();
        for (WorldRegion s : subregions) {
            String t = s.getRegionSearchText();
            if (t != null) {
                String[] ns;
                for (String n : ns = t.split(" ")) {
                    if (n.contains(";")) {
                        String[] ot;
                        for (String o : ot = n.split(";")) {
                            if (o.length() <= 1) continue;
                            result.add(o.toLowerCase());
                        }
                        continue;
                    }
                    if (n.length() <= 1) continue;
                    result.add(n.toLowerCase());
                }
            }
            CommonWords.parseRegionNames(s, result);
        }
    }

    static {
        CommonWords.addFrequentlyUsed("santa");
        CommonWords.addFrequentlyUsed("west");
        CommonWords.addFrequentlyUsed("east");
        CommonWords.addFrequentlyUsed("north");
        CommonWords.addFrequentlyUsed("northeast");
        CommonWords.addFrequentlyUsed("northwest");
        CommonWords.addFrequentlyUsed("southwest");
        CommonWords.addFrequentlyUsed("san");
        CommonWords.addFrequentlyUsed("southeast");
        CommonWords.addFrequentlyUsed("old");
        CommonWords.addFrequentlyUsed("main");
        CommonWords.addFrequentlyUsed("ridge");
        CommonWords.addFrequentlyUsed("jos\u00e9");
        CommonWords.addFrequentlyUsed("view");
        CommonWords.addFrequentlyUsed("range");
        CommonWords.addFrequentlyUsed("pine");
        CommonWords.addFrequentlyUsed("church");
        CommonWords.addFrequentlyUsed("mill");
        CommonWords.addFrequentlyUsed("green");
        CommonWords.addFrequentlyUsed("point");
        CommonWords.addFrequentlyUsed("cove");
        CommonWords.addFrequentlyUsed("gardens");
        CommonWords.addFrequentlyUsed("francisco");
        CommonWords.addFrequentlyUsed("mountain");
        CommonWords.addFrequentlyUsed("jean");
        CommonWords.addFrequentlyUsed("jo\u00e3o");
        CommonWords.addFrequentlyUsed("meadow");
        CommonWords.addFrequentlyUsed("farm");
        CommonWords.addFrequentlyUsed("juan");
        CommonWords.addFrequentlyUsed("bay");
        CommonWords.addFrequentlyUsed("run");
        CommonWords.addFrequentlyUsed("national");
        CommonWords.addFrequentlyUsed("cedar");
        CommonWords.addFrequentlyUsed("hollow");
        CommonWords.addFrequentlyUsed("new");
        CommonWords.addFrequentlyUsed("high");
        CommonWords.addFrequentlyUsed("maple");
        CommonWords.addFrequentlyUsed("antonio");
        CommonWords.addFrequentlyUsed("walk");
        CommonWords.addFrequentlyUsed("maria");
        CommonWords.addFrequentlyUsed("spring");
        CommonWords.addFrequentlyUsed("pedro");
        CommonWords.addFrequentlyUsed("vista");
        CommonWords.addFrequentlyUsed("grand");
        CommonWords.addFrequentlyUsed("giuseppe");
        CommonWords.addFrequentlyUsed("ant\u00f4nio");
        CommonWords.addFrequentlyUsed("saint");
        CommonWords.addFrequentlyUsed("development");
        CommonWords.addFrequentlyUsed("washington");
        CommonWords.addFrequentlyUsed("john");
        CommonWords.addFrequentlyUsed("white");
        CommonWords.addFrequentlyUsed("silva");
        CommonWords.addFrequentlyUsed("willow");
        CommonWords.addFrequentlyUsed("school");
        CommonWords.addFrequentlyUsed("giovanni");
        CommonWords.addFrequentlyUsed("canyon");
        CommonWords.addFrequentlyUsed("general");
        CommonWords.addFrequentlyUsed("charles");
        CommonWords.addFrequentlyUsed("king");
        CommonWords.addFrequentlyUsed("moulin");
        CommonWords.addFrequentlyUsed("monte");
        CommonWords.addFrequentlyUsed("wood");
        CommonWords.addFrequentlyUsed("glen");
        CommonWords.addFrequentlyUsed("rock");
        CommonWords.addFrequentlyUsed("elm");
        CommonWords.addFrequentlyUsed("center");
        CommonWords.addFrequentlyUsed("mount");
        CommonWords.addFrequentlyUsed("tree");
        CommonWords.addFrequentlyUsed("red");
        CommonWords.addFrequentlyUsed("central");
        CommonWords.addFrequentlyUsed("norte");
        CommonWords.addFrequentlyUsed("delle");
        CommonWords.addFrequentlyUsed("\u00e9glise");
        CommonWords.addFrequentlyUsed("carlos");
        CommonWords.addFrequentlyUsed("springs");
        CommonWords.addFrequentlyUsed("doutor");
        CommonWords.addFrequentlyUsed("grande");
        CommonWords.addFrequentlyUsed("martin");
        CommonWords.addFrequentlyUsed("station");
        CommonWords.addFrequentlyUsed("statale");
        CommonWords.addFrequentlyUsed("alte");
        CommonWords.addFrequentlyUsed("paul");
        CommonWords.addFrequentlyUsed("hills");
        CommonWords.addFrequentlyUsed("beach");
        CommonWords.addFrequentlyUsed("brook");
        CommonWords.addFrequentlyUsed("walnut");
        CommonWords.addFrequentlyUsed("gate");
        CommonWords.addFrequentlyUsed("oaks");
        CommonWords.addFrequentlyUsed("cross");
        CommonWords.addFrequentlyUsed("pierre");
        CommonWords.addFrequentlyUsed("rural");
        CommonWords.addFrequentlyUsed("service");
        CommonWords.addFrequentlyUsed("manuel");
        CommonWords.addFrequentlyUsed("country");
        CommonWords.addFrequentlyUsed("blue");
        CommonWords.addFrequentlyUsed("miguel");
        CommonWords.addFrequentlyUsed("branch");
        CommonWords.addFrequentlyUsed("cherry");
        CommonWords.addFrequentlyUsed("don");
        CommonWords.addFrequentlyUsed("lincoln");
        CommonWords.addFrequentlyUsed("orchard");
        CommonWords.addFrequentlyUsed("little");
        CommonWords.addFrequentlyUsed("memorial");
        CommonWords.addFrequentlyUsed("clos");
        CommonWords.addFrequentlyUsed("club");
        CommonWords.addFrequentlyUsed("bois");
        CommonWords.addFrequentlyUsed("james");
        CommonWords.addFrequentlyUsed("ranch");
        CommonWords.addFrequentlyUsed("louis");
        CommonWords.addFrequentlyUsed("sunset");
        CommonWords.addFrequentlyUsed("pond");
        CommonWords.addFrequentlyUsed("george");
        CommonWords.addFrequentlyUsed("g\u00e9n\u00e9ral");
        CommonWords.addFrequentlyUsed("costa");
        CommonWords.addFrequentlyUsed("santos");
        CommonWords.addFrequentlyUsed("victoria");
        CommonWords.addFrequentlyUsed("albert");
        CommonWords.addFrequentlyUsed("manor");
        CommonWords.addFrequentlyUsed("hall");
        CommonWords.addFrequentlyUsed("cemetery");
        CommonWords.addFrequentlyUsed("rose");
        CommonWords.addFrequentlyUsed("luis");
        CommonWords.addFrequentlyUsed("fox");
        CommonWords.addFrequentlyUsed("doctor");
        CommonWords.addFrequentlyUsed("long");
        CommonWords.addFrequentlyUsed("alameda");
        CommonWords.addFrequentlyUsed("smith");
        CommonWords.addFrequentlyUsed("padre");
        CommonWords.addFrequentlyUsed("woods");
        CommonWords.addFrequentlyUsed("villa");
        CommonWords.addFrequentlyUsed("lotissement");
        CommonWords.addFrequentlyUsed("indian");
        CommonWords.addFrequentlyUsed("pleasant");
        CommonWords.addFrequentlyUsed("jackson");
        CommonWords.addFrequentlyUsed("water");
        CommonWords.addFrequentlyUsed("wilson");
        CommonWords.addFrequentlyUsed("hickory");
        CommonWords.addFrequentlyUsed("deer");
        CommonWords.addFrequentlyUsed("birch");
        CommonWords.addFrequentlyUsed("chestnut");
        CommonWords.addFrequentlyUsed("eagle");
        CommonWords.addFrequentlyUsed("laurel");
        CommonWords.addFrequentlyUsed("heights");
        CommonWords.addFrequentlyUsed("jana");
        CommonWords.addFrequentlyUsed("shore");
        CommonWords.addFrequentlyUsed("highland");
        CommonWords.addFrequentlyUsed("roma");
        CommonWords.addFrequentlyUsed("oliveira");
        CommonWords.addFrequentlyUsed("garden");
        CommonWords.addFrequentlyUsed("ch\u00e2teau");
        CommonWords.addFrequentlyUsed("provincial");
        CommonWords.addFrequentlyUsed("thomas");
        CommonWords.addFrequentlyUsed("camp");
        CommonWords.addFrequentlyUsed("largo");
        CommonWords.addFrequentlyUsed("access");
        CommonWords.addFrequentlyUsed("georges");
        CommonWords.addFrequentlyUsed("college");
        CommonWords.addFrequentlyUsed("chapel");
        CommonWords.addFrequentlyUsed("house");
        CommonWords.addFrequentlyUsed("rosa");
        CommonWords.addFrequentlyUsed("johnson");
        CommonWords.addFrequentlyUsed("upper");
        CommonWords.addFrequentlyUsed("union");
        CommonWords.addFrequentlyUsed("crest");
        CommonWords.addFrequentlyUsed("gare");
        CommonWords.addFrequentlyUsed("market");
        CommonWords.addFrequentlyUsed("\u043b\u0435\u043d\u0438\u043d\u0430");
        CommonWords.addFrequentlyUsed("jefferson");
        CommonWords.addFrequentlyUsed("stone");
        CommonWords.addFrequentlyUsed("franklin");
        CommonWords.addFrequentlyUsed("r\u00e9sidence");
        CommonWords.addFrequentlyUsed("francesco");
        CommonWords.addFrequentlyUsed("railroad");
        CommonWords.addFrequentlyUsed("black");
        CommonWords.addFrequentlyUsed("fontaine");
        CommonWords.addFrequentlyUsed("silver");
        CommonWords.addFrequentlyUsed("lower");
        CommonWords.addFrequentlyUsed("mile");
        CommonWords.addFrequentlyUsed("henri");
        CommonWords.addFrequentlyUsed("big");
        CommonWords.addFrequentlyUsed("brown");
        CommonWords.addFrequentlyUsed("kennedy");
        CommonWords.addFrequentlyUsed("pereira");
        CommonWords.addFrequentlyUsed("airport");
        CommonWords.addFrequentlyUsed("spruce");
        CommonWords.addFrequentlyUsed("woodland");
        CommonWords.addFrequentlyUsed("robert");
        CommonWords.addFrequentlyUsed("victor");
        CommonWords.addFrequentlyUsed("manoel");
        CommonWords.addFrequentlyUsed("meadows");
        CommonWords.addFrequentlyUsed("vicente");
        CommonWords.addFrequentlyUsed("ash");
        CommonWords.addFrequentlyUsed("rise");
        CommonWords.addFrequentlyUsed("pike");
        CommonWords.addFrequentlyUsed("luigi");
        CommonWords.addFrequentlyUsed("sant");
        CommonWords.addFrequentlyUsed("santo");
        CommonWords.addFrequentlyUsed("western");
        CommonWords.addFrequentlyUsed("poplar");
        CommonWords.addFrequentlyUsed("\u0441\u043e\u0432\u0435\u0442\u0441\u043a\u0430\u044f");
        CommonWords.addFrequentlyUsed("croix");
        CommonWords.addFrequentlyUsed("real");
        CommonWords.addFrequentlyUsed("vittorio");
        CommonWords.addFrequentlyUsed("mews");
        CommonWords.addFrequentlyUsed("taylor");
        CommonWords.addFrequentlyUsed("davis");
        CommonWords.addFrequentlyUsed("jose");
        CommonWords.addFrequentlyUsed("frontage");
        CommonWords.addFrequentlyUsed("gaulle");
        CommonWords.addFrequentlyUsed("bank");
        CommonWords.addFrequentlyUsed("ferry");
        CommonWords.addFrequentlyUsed("nord");
        CommonWords.addFrequentlyUsed("holly");
        CommonWords.addFrequentlyUsed("castle");
        CommonWords.addFrequentlyUsed("sierra");
        CommonWords.addFrequentlyUsed("acceso");
        CommonWords.addFrequentlyUsed("royal");
        CommonWords.addFrequentlyUsed("pra\u00e7a");
        CommonWords.addFrequentlyUsed("williams");
        CommonWords.addFrequentlyUsed("souza");
        CommonWords.addFrequentlyUsed("madison");
        CommonWords.addFrequentlyUsed("joseph");
        CommonWords.addFrequentlyUsed("riverside");
        CommonWords.addFrequentlyUsed("adams");
        CommonWords.addFrequentlyUsed("nacional");
        CommonWords.addFrequentlyUsed("oude");
        CommonWords.addFrequentlyUsed("tee");
        CommonWords.addFrequentlyUsed("port");
        CommonWords.addFrequentlyUsed("private");
        CommonWords.addFrequentlyUsed("mayo");
        CommonWords.addFrequentlyUsed("carlo");
        CommonWords.addFrequentlyUsed("york");
        CommonWords.addFrequentlyUsed("ferreira");
        CommonWords.addFrequentlyUsed("giacomo");
        CommonWords.addFrequentlyUsed("parade");
        CommonWords.addFrequentlyUsed("field");
        CommonWords.addFrequentlyUsed("professor");
        CommonWords.addFrequentlyUsed("jones");
        CommonWords.addFrequentlyUsed("mar\u00eda");
        CommonWords.addFrequentlyUsed("lakeview");
        CommonWords.addFrequentlyUsed("great");
        CommonWords.addFrequentlyUsed("alves");
        CommonWords.addFrequentlyUsed("miller");
        CommonWords.addFrequentlyUsed("william");
        CommonWords.addFrequentlyUsed("henry");
        CommonWords.addFrequentlyUsed("coronel");
        CommonWords.addFrequentlyUsed("industrial");
        CommonWords.addFrequentlyUsed("mar\u00e9chal");
        CommonWords.addFrequentlyUsed("acres");
        CommonWords.addFrequentlyUsed("joaquim");
        CommonWords.addFrequentlyUsed("landing");
        CommonWords.addFrequentlyUsed("summit");
        CommonWords.addFrequentlyUsed("burgemeester");
        CommonWords.addFrequentlyUsed("magnolia");
        CommonWords.addFrequentlyUsed("trace");
        CommonWords.addFrequentlyUsed("presidente");
        CommonWords.addFrequentlyUsed("falls");
        CommonWords.addFrequentlyUsed("jules");
        CommonWords.addFrequentlyUsed("docteur");
        CommonWords.addFrequentlyUsed("pacific");
        CommonWords.addFrequentlyUsed("auzoa");
        CommonWords.addFrequentlyUsed("prairie");
        CommonWords.addFrequentlyUsed("luiz");
        CommonWords.addFrequentlyUsed("diagonal");
        CommonWords.addFrequentlyUsed("cypress");
        CommonWords.addFrequentlyUsed("mar");
        CommonWords.addFrequentlyUsed("harbor");
        CommonWords.addFrequentlyUsed("shady");
        CommonWords.addFrequentlyUsed("clark");
        CommonWords.addFrequentlyUsed("fort");
        CommonWords.addFrequentlyUsed("bluff");
        CommonWords.addFrequentlyUsed("grant");
        CommonWords.addFrequentlyUsed("fork");
        CommonWords.addFrequentlyUsed("fire");
        CommonWords.addFrequentlyUsed("petit");
        CommonWords.addFrequentlyUsed("sycamore");
        CommonWords.addFrequentlyUsed("nelson");
        CommonWords.addFrequentlyUsed("queen");
        CommonWords.addFrequentlyUsed("city");
        CommonWords.addFrequentlyUsed("vico");
        CommonWords.addFrequentlyUsed("j\u00f3zefa");
        CommonWords.addFrequentlyUsed("pietro");
        CommonWords.addFrequentlyUsed("bear");
        CommonWords.addFrequentlyUsed("lima");
        CommonWords.addFrequentlyUsed("\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f");
        CommonWords.addFrequentlyUsed("pablo");
        CommonWords.addFrequentlyUsed("golden");
        CommonWords.addFrequentlyUsed("mary");
        CommonWords.addFrequentlyUsed("hillside");
        CommonWords.addFrequentlyUsed("haven");
        CommonWords.addFrequentlyUsed("alberto");
        CommonWords.addFrequentlyUsed("lorong");
        CommonWords.addFrequentlyUsed("elizabeth");
        CommonWords.addFrequentlyUsed("kings");
        CommonWords.addFrequentlyUsed("dogwood");
        CommonWords.addFrequentlyUsed("scott");
        CommonWords.addFrequentlyUsed("beech");
        CommonWords.addFrequentlyUsed("lange");
        CommonWords.addFrequentlyUsed("andr\u00e9");
        CommonWords.addFrequentlyUsed("verde");
        CommonWords.addFrequentlyUsed("front");
        CommonWords.addFrequentlyUsed("obere");
        CommonWords.addFrequentlyUsed("hidden");
        CommonWords.addFrequentlyUsed("centre");
        CommonWords.addFrequentlyUsed("hamilton");
        CommonWords.addFrequentlyUsed("arthur");
        CommonWords.addFrequentlyUsed("parc");
        CommonWords.addFrequentlyUsed("quail");
        CommonWords.addFrequentlyUsed("julio");
        CommonWords.addFrequentlyUsed("jan");
        CommonWords.addFrequentlyUsed("bell");
        CommonWords.addFrequentlyUsed("sandy");
        CommonWords.addFrequentlyUsed("back");
        CommonWords.addFrequentlyUsed("sud");
        CommonWords.addFrequentlyUsed("paulo");
        CommonWords.addFrequentlyUsed("lago");
        CommonWords.addFrequentlyUsed("locust");
        CommonWords.addFrequentlyUsed("mart\u00edn");
        CommonWords.addFrequentlyUsed("gabriel");
        CommonWords.addFrequentlyUsed("chase");
        CommonWords.addFrequentlyUsed("palm");
        CommonWords.addFrequentlyUsed("liberty");
        CommonWords.addFrequentlyUsed("mairie");
        CommonWords.addFrequentlyUsed("jorge");
        CommonWords.addFrequentlyUsed("castro");
        CommonWords.addFrequentlyUsed("fernando");
        CommonWords.addFrequentlyUsed("alter");
        CommonWords.addFrequentlyUsed("salvador");
        CommonWords.addFrequentlyUsed("hillcrest");
        CommonWords.addFrequentlyUsed("cit\u00e9");
        CommonWords.addFrequentlyUsed("rodrigues");
        CommonWords.addFrequentlyUsed("prospect");
        CommonWords.addFrequentlyUsed("golf");
        CommonWords.addFrequentlyUsed("dom");
        CommonWords.addFrequentlyUsed("jacques");
        CommonWords.addFrequentlyUsed("berliner");
        CommonWords.addFrequentlyUsed("santiago");
        CommonWords.addFrequentlyUsed("transversal");
        CommonWords.addFrequentlyUsed("\u0441\u0430\u0434\u043e\u0432\u0430\u044f");
        CommonWords.addFrequentlyUsed("guglielmo");
        CommonWords.addFrequentlyUsed("pointe");
        CommonWords.addFrequentlyUsed("circuit");
        CommonWords.addFrequentlyUsed("rang");
        CommonWords.addFrequentlyUsed("fran\u00e7ois");
        CommonWords.addFrequentlyUsed("lewis");
        CommonWords.addFrequentlyUsed("railway");
        CommonWords.addFrequentlyUsed("allen");
        CommonWords.addFrequentlyUsed("grange");
        CommonWords.addFrequentlyUsed("ronda");
        CommonWords.addFrequentlyUsed("link");
        CommonWords.addFrequentlyUsed("harrison");
        CommonWords.addFrequentlyUsed("tower");
        CommonWords.addFrequentlyUsed("garibaldi");
        CommonWords.addFrequentlyUsed("novembre");
        CommonWords.addFrequentlyUsed("heritage");
        CommonWords.addFrequentlyUsed("anderson");
        CommonWords.addFrequentlyUsed("evergreen");
        CommonWords.addFrequentlyUsed("ribeiro");
        CommonWords.addFrequentlyUsed("ford");
        CommonWords.addFrequentlyUsed("linden");
        CommonWords.addFrequentlyUsed("short");
        CommonWords.addFrequentlyUsed("walker");
        CommonWords.addFrequentlyUsed("marie");
        CommonWords.addFrequentlyUsed("twin");
        CommonWords.addFrequentlyUsed("untere");
        CommonWords.addFrequentlyUsed("university");
        CommonWords.addFrequentlyUsed("douglas");
        CommonWords.addFrequentlyUsed("marconi");
        CommonWords.addFrequentlyUsed("martins");
        CommonWords.addFrequentlyUsed("windsor");
        CommonWords.addFrequentlyUsed("\u043c\u0438\u0440\u0430");
        CommonWords.addFrequentlyUsed("david");
        CommonWords.addFrequentlyUsed("middle");
        CommonWords.addFrequentlyUsed("fairview");
        CommonWords.addFrequentlyUsed("stanis\u0142awa");
        CommonWords.addFrequentlyUsed("timber");
        CommonWords.addFrequentlyUsed("thompson");
        CommonWords.addFrequentlyUsed("genera\u0142a");
        CommonWords.addFrequentlyUsed("virginia");
        CommonWords.addFrequentlyUsed("broad");
        CommonWords.addFrequentlyUsed("pasteur");
        CommonWords.addFrequentlyUsed("promenade");
        CommonWords.addFrequentlyUsed("hugo");
        CommonWords.addFrequentlyUsed("mont\u00e9e");
        CommonWords.addFrequentlyUsed("gomes");
        CommonWords.addFrequentlyUsed("warren");
        CommonWords.addFrequentlyUsed("luther");
        CommonWords.addFrequentlyUsed("columbia");
        CommonWords.addFrequentlyUsed("lakes");
        CommonWords.addFrequentlyUsed("campo");
        CommonWords.addFrequentlyUsed("puerto");
        CommonWords.addFrequentlyUsed("r\u00e9publique");
        CommonWords.addFrequentlyUsed("enrico");
        CommonWords.addFrequentlyUsed("champ");
        CommonWords.addFrequentlyUsed("lawrence");
        CommonWords.addFrequentlyUsed("monroe");
        CommonWords.addFrequentlyUsed("alessandro");
        CommonWords.addFrequentlyUsed("w\u0142adys\u0142awa");
        CommonWords.addFrequentlyUsed("pod");
        CommonWords.addFrequentlyUsed("campbell");
        CommonWords.addFrequentlyUsed("pinto");
        CommonWords.addFrequentlyUsed("\u0448\u043a\u043e\u043b\u044c\u043d\u0430\u044f");
        CommonWords.addFrequentlyUsed("estates");
        CommonWords.addFrequentlyUsed("howard");
        CommonWords.addFrequentlyUsed("orange");
        CommonWords.addFrequentlyUsed("croft");
        CommonWords.addFrequentlyUsed("star");
        CommonWords.addFrequentlyUsed("est");
        CommonWords.addFrequentlyUsed("triq");
        CommonWords.addFrequentlyUsed("beaver");
        CommonWords.addFrequentlyUsed("principale");
        CommonWords.addFrequentlyUsed("paz");
        CommonWords.addFrequentlyUsed("sol");
        CommonWords.addFrequentlyUsed("vieux");
        CommonWords.addFrequentlyUsed("southern");
        CommonWords.addFrequentlyUsed("greenway");
        CommonWords.addFrequentlyUsed("rocky");
        CommonWords.addFrequentlyUsed("roosevelt");
        CommonWords.addFrequentlyUsed("mai");
        CommonWords.addFrequentlyUsed("aspen");
        CommonWords.addFrequentlyUsed("russell");
        CommonWords.addFrequentlyUsed("pines");
        CommonWords.addFrequentlyUsed("concession");
        CommonWords.addFrequentlyUsed("wellington");
        CommonWords.addFrequentlyUsed("barrio");
        CommonWords.addFrequentlyUsed("neue");
        CommonWords.addFrequentlyUsed("post");
        CommonWords.addFrequentlyUsed("vale");
        CommonWords.addFrequentlyUsed("\u043c\u043e\u043b\u043e\u0434\u0451\u0436\u043d\u0430\u044f");
        CommonWords.addFrequentlyUsed("\u043e\u043a\u0442\u044f\u0431\u0440\u044c\u0441\u043a\u0430\u044f");
        CommonWords.addFrequentlyUsed("london");
        CommonWords.addFrequentlyUsed("four");
        CommonWords.addFrequentlyUsed("machado");
        CommonWords.addFrequentlyUsed("parque");
        CommonWords.addFrequentlyUsed("augusto");
        CommonWords.addFrequentlyUsed("carvalho");
        CommonWords.addFrequentlyUsed("markt");
        CommonWords.addFrequentlyUsed("division");
        CommonWords.addFrequentlyUsed("marina");
        CommonWords.addFrequentlyUsed("almeida");
        CommonWords.addFrequentlyUsed("horse");
        CommonWords.addFrequentlyUsed("berg");
        CommonWords.addFrequentlyUsed("mitchell");
        CommonWords.addFrequentlyUsed("pearl");
        CommonWords.addFrequentlyUsed("governador");
        CommonWords.addFrequentlyUsed("side");
        CommonWords.addFrequentlyUsed("robin");
        CommonWords.addFrequentlyUsed("iii");
        CommonWords.addFrequentlyUsed("vignes");
        CommonWords.addFrequentlyUsed("dale");
        CommonWords.addFrequentlyUsed("oriente");
        CommonWords.addFrequentlyUsed("coast");
        CommonWords.addFrequentlyUsed("baker");
        CommonWords.addFrequentlyUsed("ann");
        CommonWords.addFrequentlyUsed("europa");
        CommonWords.addFrequentlyUsed("maurice");
        CommonWords.addFrequentlyUsed("plac");
        CommonWords.addFrequentlyUsed("prince");
        CommonWords.addFrequentlyUsed("jardins");
        CommonWords.addFrequentlyUsed("ocean");
        CommonWords.addFrequentlyUsed("harris");
        CommonWords.addFrequentlyUsed("oxford");
        CommonWords.addFrequentlyUsed("kirchweg");
        CommonWords.addFrequentlyUsed("sunrise");
        CommonWords.addFrequentlyUsed("moore");
        CommonWords.addFrequentlyUsed("apple");
        CommonWords.addFrequentlyUsed("birkenweg");
        CommonWords.addFrequentlyUsed("flores");
        CommonWords.addFrequentlyUsed("marcel");
        CommonWords.addFrequentlyUsed("morgan");
        CommonWords.addFrequentlyUsed("ana");
        CommonWords.addFrequentlyUsed("cesare");
        CommonWords.addFrequentlyUsed("comunale");
        CommonWords.addFrequentlyUsed("m\u00e1rio");
        CommonWords.addFrequentlyUsed("olive");
        CommonWords.addFrequentlyUsed("ren\u00e9");
        CommonWords.addFrequentlyUsed("vine");
        CommonWords.addFrequentlyUsed("rafael");
        CommonWords.addFrequentlyUsed("champs");
        CommonWords.addFrequentlyUsed("nova");
        CommonWords.addFrequentlyUsed("brasil");
        CommonWords.addFrequentlyUsed("privada");
        CommonWords.addFrequentlyUsed("barbosa");
        CommonWords.addFrequentlyUsed("mare");
        CommonWords.addFrequentlyUsed("dias");
        CommonWords.addFrequentlyUsed("leclerc");
        CommonWords.addFrequentlyUsed("daniel");
        CommonWords.addFrequentlyUsed("dante");
        CommonWords.addFrequentlyUsed("parker");
        CommonWords.addFrequentlyUsed("francis");
        CommonWords.addFrequentlyUsed("pr\u00e9s");
        CommonWords.addFrequentlyUsed("knoll");
        CommonWords.addFrequentlyUsed("torre");
        CommonWords.addFrequentlyUsed("contrada");
        CommonWords.addFrequentlyUsed("localit\u00e0");
        CommonWords.addFrequentlyUsed("mesa");
        CommonWords.addFrequentlyUsed("stade");
        CommonWords.addFrequentlyUsed("hampton");
        CommonWords.addFrequentlyUsed("alfredo");
        CommonWords.addFrequentlyUsed("peak");
        CommonWords.addFrequentlyUsed("ross");
        CommonWords.addFrequentlyUsed("\u043b\u0435\u0441\u043d\u0430\u044f");
        CommonWords.addFrequentlyUsed("ivy");
        CommonWords.addFrequentlyUsed("filho");
        CommonWords.addFrequentlyUsed("mills");
        CommonWords.addFrequentlyUsed("major");
        CommonWords.addFrequentlyUsed("fratelli");
        CommonWords.addFrequentlyUsed("garc\u00eda");
        CommonWords.addFrequentlyUsed("wild");
        CommonWords.addFrequentlyUsed("gordon");
        CommonWords.addFrequentlyUsed("diego");
        CommonWords.addFrequentlyUsed("cerro");
        CommonWords.addFrequentlyUsed("cambridge");
        CommonWords.addFrequentlyUsed("alta");
        CommonWords.addFrequentlyUsed("home");
        CommonWords.addFrequentlyUsed("ram\u00f3n");
        CommonWords.addFrequentlyUsed("raymond");
        CommonWords.addFrequentlyUsed("juniper");
        CommonWords.addFrequentlyUsed("redwood");
        CommonWords.addFrequentlyUsed("crystal");
        CommonWords.addFrequentlyUsed("mulberry");
        CommonWords.addFrequentlyUsed("\u043d\u043e\u0432\u0430\u044f");
        CommonWords.addFrequentlyUsed("poniente");
        CommonWords.addFrequentlyUsed("alten");
        CommonWords.addFrequentlyUsed("\u0433\u0430\u0433\u0430\u0440\u0438\u043d\u0430");
        CommonWords.addFrequentlyUsed("bellevue");
        CommonWords.addFrequentlyUsed("veterans");
        CommonWords.addFrequentlyUsed("hope");
        CommonWords.addFrequentlyUsed("jaur\u00e8s");
        CommonWords.addFrequentlyUsed("summer");
        CommonWords.addFrequentlyUsed("bahnhof");
        CommonWords.addFrequentlyUsed("r-c");
        CommonWords.addFrequentlyUsed("oakwood");
        CommonWords.addFrequentlyUsed("richmond");
        CommonWords.addFrequentlyUsed("paris");
        CommonWords.addFrequentlyUsed("lorenzo");
        CommonWords.addFrequentlyUsed("hof");
        CommonWords.addFrequentlyUsed("mariano");
        CommonWords.addFrequentlyUsed("navajo");
        CommonWords.addFrequentlyUsed("\u043a\u043e\u043c\u0441\u043e\u043c\u043e\u043b\u044c\u0441\u043a\u0430\u044f");
        CommonWords.addFrequentlyUsed("kleine");
        CommonWords.addFrequentlyUsed("lodge");
        CommonWords.addFrequentlyUsed("torres");
        CommonWords.addFrequentlyUsed("le\u015bna");
        CommonWords.addFrequentlyUsed("cardinal");
        CommonWords.addFrequentlyUsed("marsh");
        CommonWords.addFrequentlyUsed("fern");
        CommonWords.addFrequentlyUsed("campos");
        CommonWords.addFrequentlyUsed("nationale");
        CommonWords.addFrequentlyUsed("berry");
        CommonWords.addFrequentlyUsed("commerce");
        CommonWords.addFrequentlyUsed("ignacio");
        CommonWords.addFrequentlyUsed("acesso");
        CommonWords.addFrequentlyUsed("madrid");
        CommonWords.addFrequentlyUsed("mission");
        CommonWords.addFrequentlyUsed("gang");
        CommonWords.addFrequentlyUsed("oeste");
        CommonWords.addFrequentlyUsed("cherokee");
        CommonWords.addFrequentlyUsed("paolo");
        CommonWords.addFrequentlyUsed("stewart");
        CommonWords.addFrequentlyUsed("cliff");
        CommonWords.addFrequentlyUsed("eduardo");
        CommonWords.addFrequentlyUsed("marshall");
        CommonWords.addFrequentlyUsed("dam");
        CommonWords.addFrequentlyUsed("pioneer");
        CommonWords.addFrequentlyUsed("alfred");
        CommonWords.addFrequentlyUsed("greenwood");
        CommonWords.addFrequentlyUsed("robinson");
        CommonWords.addFrequentlyUsed("acacias");
        CommonWords.addFrequentlyUsed("l\u00f3pez");
        CommonWords.addFrequentlyUsed("tadeusza");
        CommonWords.addFrequentlyUsed("leonardo");
        CommonWords.addFrequentlyUsed("hilltop");
        CommonWords.addFrequentlyUsed("diamond");
        CommonWords.addFrequentlyUsed("quarry");
        CommonWords.addFrequentlyUsed("het");
        CommonWords.addFrequentlyUsed("temple");
        CommonWords.addFrequentlyUsed("scenic");
        CommonWords.addFrequentlyUsed("alexander");
        CommonWords.addFrequentlyUsed("\u043f\u043e\u0431\u0435\u0434\u044b");
        CommonWords.addFrequentlyUsed("osiedle");
        CommonWords.addFrequentlyUsed("\u00e9coles");
        CommonWords.addFrequentlyUsed("cleveland");
        CommonWords.addFrequentlyUsed("lynn");
        CommonWords.addFrequentlyUsed("top");
        CommonWords.addFrequentlyUsed("mont");
        CommonWords.addFrequentlyUsed("polna");
        CommonWords.addFrequentlyUsed("leaf");
        CommonWords.addFrequentlyUsed("vieira");
        CommonWords.addFrequentlyUsed("cottonwood");
        CommonWords.addFrequentlyUsed("perry");
        CommonWords.addFrequentlyUsed("morris");
        CommonWords.addFrequentlyUsed("oberer");
        CommonWords.addFrequentlyUsed("domingo");
        CommonWords.addFrequentlyUsed("hawthorne");
        CommonWords.addFrequentlyUsed("autumn");
        CommonWords.addFrequentlyUsed("alto");
        CommonWords.addFrequentlyUsed("chapelle");
        CommonWords.addFrequentlyUsed("kelly");
        CommonWords.addFrequentlyUsed("sherwood");
        CommonWords.addFrequentlyUsed("garcia");
        CommonWords.addFrequentlyUsed("bruce");
        CommonWords.addFrequentlyUsed("cour");
        CommonWords.addFrequentlyUsed("petite");
        CommonWords.addFrequentlyUsed("gap");
        CommonWords.addFrequentlyUsed("sea");
        CommonWords.addFrequentlyUsed("\u00e9mile");
        CommonWords.addFrequentlyUsed("murray");
        CommonWords.addFrequentlyUsed("tangenziale");
        CommonWords.addFrequentlyUsed("m\u00fchlenweg");
        CommonWords.addFrequentlyUsed("gon\u00e7alves");
        CommonWords.addFrequentlyUsed("eastern");
        CommonWords.addFrequentlyUsed("belle");
        CommonWords.addFrequentlyUsed("northern");
        CommonWords.addFrequentlyUsed("xxiii");
        CommonWords.addFrequentlyUsed("vicinale");
        CommonWords.addFrequentlyUsed("hemlock");
        CommonWords.addFrequentlyUsed("hunter");
        CommonWords.addFrequentlyUsed("\u043b\u0435\u0442");
        CommonWords.addFrequentlyUsed("roberts");
        CommonWords.addFrequentlyUsed("heather");
        CommonWords.addFrequentlyUsed("bernardo");
        CommonWords.addFrequentlyUsed("verte");
        CommonWords.addFrequentlyUsed("arbor");
        CommonWords.addFrequentlyUsed("puits");
        CommonWords.addFrequentlyUsed("mine");
        CommonWords.addFrequentlyUsed("stefana");
        CommonWords.addFrequentlyUsed("g\u00fcterweg");
        CommonWords.addFrequentlyUsed("newton");
        CommonWords.addFrequentlyUsed("\u043a\u0438\u0440\u043e\u0432\u0430");
        CommonWords.addFrequentlyUsed("riverview");
        CommonWords.addFrequentlyUsed("clay");
        CommonWords.addFrequentlyUsed("sint");
        CommonWords.addFrequentlyUsed("aldo");
        CommonWords.addFrequentlyUsed("tilleuls");
        CommonWords.addFrequentlyUsed("claude");
        CommonWords.addFrequentlyUsed("kossuth");
        CommonWords.addFrequentlyUsed("edward");
        CommonWords.addFrequentlyUsed("communale");
        CommonWords.addFrequentlyUsed("fuente");
        CommonWords.addFrequentlyUsed("cooper");
        CommonWords.addFrequentlyUsed("trails");
        CommonWords.addFrequentlyUsed("nieuwe");
        CommonWords.addFrequentlyUsed("sebasti\u00e3o");
        CommonWords.addFrequentlyUsed("roberto");
        CommonWords.addFrequentlyUsed("overlook");
        CommonWords.addFrequentlyUsed("\u043f\u0435\u0440\u0432\u043e\u043c\u0430\u0439\u0441\u043a\u0430\u044f");
        CommonWords.addFrequentlyUsed("roger");
        CommonWords.addFrequentlyUsed("turner");
        CommonWords.addFrequentlyUsed("france");
        CommonWords.addFrequentlyUsed("mario");
        CommonWords.addFrequentlyUsed("iv");
        CommonWords.addFrequentlyUsed("sugar");
        CommonWords.addFrequentlyUsed("hudson");
        CommonWords.addFrequentlyUsed("lopes");
        CommonWords.addFrequentlyUsed("evans");
        CommonWords.addFrequentlyUsed("cottage");
        CommonWords.addFrequentlyUsed("raya");
        CommonWords.addFrequentlyUsed("branco");
        CommonWords.addFrequentlyUsed("vernon");
        CommonWords.addFrequentlyUsed("traverse");
        CommonWords.addFrequentlyUsed("emerald");
        CommonWords.addFrequentlyUsed("dove");
        CommonWords.addFrequentlyUsed("felipe");
        CommonWords.addFrequentlyUsed("wildwood");
        CommonWords.addFrequentlyUsed("moro");
        CommonWords.addFrequentlyUsed("marechal");
        CommonWords.addFrequentlyUsed("k\u00f6z");
        CommonWords.addFrequentlyUsed("marion");
        CommonWords.addFrequentlyUsed("marco");
        CommonWords.addFrequentlyUsed("l\u00e9on");
        CommonWords.addFrequentlyUsed("mt");
        CommonWords.addFrequentlyUsed("veneto");
        CommonWords.addFrequentlyUsed("mazzini");
        CommonWords.addFrequentlyUsed("plum");
        CommonWords.addFrequentlyUsed("boundary");
        CommonWords.addFrequentlyUsed("barros");
        CommonWords.addFrequentlyUsed("tour");
        CommonWords.addFrequentlyUsed("andrews");
        CommonWords.addFrequentlyUsed("wiesenweg");
        CommonWords.addFrequentlyUsed("maggio");
        CommonWords.addFrequentlyUsed("ricardo");
        CommonWords.addFrequentlyUsed("pennsylvania");
        CommonWords.addFrequentlyUsed("myrtle");
        CommonWords.addFrequentlyUsed("matteotti");
        CommonWords.addFrequentlyUsed("hinter");
        CommonWords.addFrequentlyUsed("\u043b\u0438\u043d\u0438\u044f");
        CommonWords.addFrequentlyUsed("ouest");
        CommonWords.addFrequentlyUsed("maja");
        CommonWords.addFrequentlyUsed("kent");
        CommonWords.addFrequentlyUsed("stanley");
        CommonWords.addFrequentlyUsed("jacob");
        CommonWords.addFrequentlyUsed("principal");
        CommonWords.addFrequentlyUsed("rogers");
        CommonWords.addFrequentlyUsed("homestead");
        CommonWords.addFrequentlyUsed("collins");
        CommonWords.addFrequentlyUsed("richard");
        CommonWords.addFrequentlyUsed("crown");
        CommonWords.addFrequentlyUsed("moss");
        CommonWords.addFrequentlyUsed("moreno");
        CommonWords.addFrequentlyUsed("garfield");
        CommonWords.addFrequentlyUsed("belmont");
        CommonWords.addFrequentlyUsed("rolling");
        CommonWords.addFrequentlyUsed("sportplatz");
        CommonWords.addFrequentlyUsed("c\u00f4te");
        CommonWords.addFrequentlyUsed("hospital");
        CommonWords.addFrequentlyUsed("sun");
        CommonWords.addFrequentlyUsed("\u0433\u043e\u0440\u044c\u043a\u043e\u0433\u043e");
        CommonWords.addFrequentlyUsed("flat");
        CommonWords.addFrequentlyUsed("colonial");
        CommonWords.addFrequentlyUsed("ramos");
        CommonWords.addFrequentlyUsed("lilas");
        CommonWords.addFrequentlyUsed("mason");
        CommonWords.addFrequentlyUsed("forge");
        CommonWords.addFrequentlyUsed("shadow");
        CommonWords.addFrequentlyUsed("gold");
        CommonWords.addFrequentlyUsed("rocha");
        CommonWords.addFrequentlyUsed("linda");
        CommonWords.addFrequentlyUsed("young");
        CommonWords.addFrequentlyUsed("estate");
        CommonWords.addFrequentlyUsed("martiri");
        CommonWords.addFrequentlyUsed("verdi");
        CommonWords.addFrequentlyUsed("augusta");
        CommonWords.addFrequentlyUsed("neuburger");
        CommonWords.addCommon("la");
        CommonWords.addCommon("via");
        CommonWords.addCommon("rua");
        CommonWords.addCommon("de");
        CommonWords.addCommon("du");
        CommonWords.addCommon("des");
        CommonWords.addCommon("del");
        CommonWords.addCommon("am");
        CommonWords.addCommon("da");
        CommonWords.addCommon("a");
        CommonWords.addCommon("der");
        CommonWords.addCommon("do");
        CommonWords.addCommon("los");
        CommonWords.addCommon("di");
        CommonWords.addCommon("im");
        CommonWords.addCommon("el");
        CommonWords.addCommon("e");
        CommonWords.addCommon("an");
        CommonWords.addCommon("g.");
        CommonWords.addCommon("rd");
        CommonWords.addCommon("dos");
        CommonWords.addCommon("dei");
        CommonWords.addCommon("b");
        CommonWords.addCommon("st");
        CommonWords.addCommon("the");
        CommonWords.addCommon("las");
        CommonWords.addCommon("f");
        CommonWords.addCommon("u");
        CommonWords.addCommon("jl.");
        CommonWords.addCommon("j");
        CommonWords.addCommon("sk");
        CommonWords.addCommon("w");
        CommonWords.addCommon("a.");
        CommonWords.addCommon("of");
        CommonWords.addCommon("k");
        CommonWords.addCommon("r");
        CommonWords.addCommon("h");
        CommonWords.addCommon("mc");
        CommonWords.addCommon("sw");
        CommonWords.addCommon("g");
        CommonWords.addCommon("v");
        CommonWords.addCommon("m");
        CommonWords.addCommon("c.");
        CommonWords.addCommon("r.");
        CommonWords.addCommon("ct");
        CommonWords.addCommon("e.");
        CommonWords.addCommon("dr.");
        CommonWords.addCommon("j.");
        CommonWords.addCommon("in");
        CommonWords.addCommon("al");
        CommonWords.addCommon("\u00fat");
        CommonWords.addCommon("per");
        CommonWords.addCommon("ne");
        CommonWords.addCommon("p");
        CommonWords.addCommon("et");
        CommonWords.addCommon("s.");
        CommonWords.addCommon("f.");
        CommonWords.addCommon("t");
        CommonWords.addCommon("fe");
        CommonWords.addCommon("\u00e0");
        CommonWords.addCommon("i");
        CommonWords.addCommon("c");
        CommonWords.addCommon("le");
        CommonWords.addCommon("s");
        CommonWords.addCommon("av.");
        CommonWords.addCommon("den");
        CommonWords.addCommon("dr");
        CommonWords.addCommon("y");
        CommonWords.addCommon("un");
        CommonWords.addCommon("nw");
        CommonWords.addCommon(NUMBER_WITH_LESS_THAN_2_LETTERS);
        CommonWords.addCommon("van");
        CommonWords.addCommon("road");
        CommonWords.addCommon("street");
        CommonWords.addCommon("sector");
        CommonWords.addCommon("drive");
        CommonWords.addCommon("avenue");
        CommonWords.addCommon("rue");
        CommonWords.addCommon("lane");
        CommonWords.addCommon("\u0443\u043b\u0438\u0446\u0430");
        CommonWords.addCommon("\u0441\u043f\u0443\u0441\u043a");
        CommonWords.addCommon("stra\u00dfe");
        CommonWords.addCommon("chemin");
        CommonWords.addCommon("way");
        CommonWords.addCommon("court");
        CommonWords.addCommon("calle");
        CommonWords.addCommon("place");
        CommonWords.addCommon("avenida");
        CommonWords.addCommon("boulevard");
        CommonWords.addCommon("county");
        CommonWords.addCommon("route");
        CommonWords.addCommon("trail");
        CommonWords.addCommon("circle");
        CommonWords.addCommon("close");
        CommonWords.addCommon("highway");
        CommonWords.addCommon("strada");
        CommonWords.addCommon("impasse");
        CommonWords.addCommon("utca");
        CommonWords.addCommon("creek");
        CommonWords.addCommon("carrer");
        CommonWords.addCommon("\u0432\u0443\u043b\u0438\u0446\u044f");
        CommonWords.addCommon("all\u00e9e");
        CommonWords.addCommon("weg");
        CommonWords.addCommon("\u043f\u043b\u043e\u0449\u0430\u0434\u044c");
        CommonWords.addCommon("\u0442\u0443\u043f\u0438\u043a");
        CommonWords.addCommon("terrace");
        CommonWords.addCommon("jalan");
        CommonWords.addCommon("parkway");
        CommonWords.addCommon("\u043f\u0435\u0440\u0435\u0443\u043b\u043e\u043a");
        CommonWords.addCommon("carretera");
        CommonWords.addCommon("valley");
        CommonWords.addCommon("camino");
        CommonWords.addCommon("viale");
        CommonWords.addCommon("loop");
        CommonWords.addCommon("bridge");
        CommonWords.addCommon("embankment");
        CommonWords.addCommon("township");
        CommonWords.addCommon("town");
        CommonWords.addCommon("village");
        CommonWords.addCommon("piazza");
        CommonWords.addCommon("della");
        CommonWords.addCommon("plaza");
        CommonWords.addCommon("pasaje");
        CommonWords.addCommon("expressway");
        CommonWords.addCommon("ruta");
        CommonWords.addCommon("square");
        CommonWords.addCommon("freeway");
        CommonWords.addCommon("line");
        CommonWords.addCommon("track");
        CommonWords.addCommon("zum");
        CommonWords.addCommon("rodovia");
        CommonWords.addCommon("sokak");
        CommonWords.addCommon("sur");
        CommonWords.addCommon("path");
        CommonWords.addCommon("das");
        CommonWords.addCommon("yolu");
        CommonWords.addCommon("\u043f\u0440\u043e\u0441\u043f\u0435\u043a\u0442");
        CommonWords.addCommon("auf");
        CommonWords.addCommon("alley");
        CommonWords.addCommon("s\u00e3o");
        CommonWords.addCommon("les");
        CommonWords.addCommon("paseo");
        CommonWords.addCommon("autostrada");
        CommonWords.addCommon("iela");
        CommonWords.addCommon("autov\u00eda");
        CommonWords.addCommon("d");
        CommonWords.addCommon("ulica");
        CommonWords.addCommon("na");
        CommonWords.addCommon("\u043f\u0440\u043e\u0435\u0437\u0434");
        CommonWords.addCommon("n");
        CommonWords.addCommon("\u0443\u043b.");
        CommonWords.addCommon("voie");
        CommonWords.addCommon("ring");
        CommonWords.addCommon("ruelle");
        CommonWords.addCommon("vicolo");
        CommonWords.addCommon("avinguda");
        CommonWords.addCommon("\u0448\u043e\u0441\u0441\u0435");
        CommonWords.addCommon("zur");
        CommonWords.addCommon("corso");
        CommonWords.addCommon("autopista");
        CommonWords.addCommon("\u043f\u0440\u043e\u0432\u0443\u043b\u043e\u043a");
        CommonWords.addCommon("broadway");
        CommonWords.addCommon("to");
        CommonWords.addCommon("passage");
        CommonWords.addCommon("sentier");
        CommonWords.addCommon("aleja");
        CommonWords.addCommon("dem");
        CommonWords.addCommon("valle");
        CommonWords.addCommon("cruz");
        CommonWords.addCommon("bypass");
        CommonWords.addCommon("r\u00faa");
        CommonWords.addCommon("crest");
        CommonWords.addCommon("ave");
        CommonWords.addCommon("turnpike");
        CommonWords.addCommon("autoroute");
        CommonWords.addCommon("crossing");
        CommonWords.addCommon("cam\u00ed");
        CommonWords.addCommon("bend");
        CommonWords.addCommon("end");
        CommonWords.addCommon("caddesi");
        CommonWords.addCommon("bis");
        CommonWords.addCommon("\u10e5\u10e3\u10e9\u10d0");
        CommonWords.addCommon("kalea");
        CommonWords.addCommon("pass");
        CommonWords.addCommon("ponte");
        CommonWords.addCommon("cruce");
        CommonWords.addCommon("se");
        CommonWords.addCommon("au");
        CommonWords.addCommon("allee");
        CommonWords.addCommon("autobahn");
        CommonWords.addCommon("v\u00e4g");
        CommonWords.addCommon("sentiero");
        CommonWords.addCommon("pla\u00e7a");
        CommonWords.addCommon("o");
        CommonWords.addCommon("vej");
        CommonWords.addCommon("aux");
        CommonWords.addCommon("spur");
        CommonWords.addCommon("ringstra\u00dfe");
        CommonWords.addCommon("lindenstra\u00dfe");
        CommonWords.addCommon("kirchstra\u00dfe");
        CommonWords.addCommon("bergstra\u00dfe");
        CommonWords.addCommon("m\u00fchlenstra\u00dfe");
        CommonWords.addCommon("industriestra\u00dfe");
        CommonWords.addCommon("schillerstra\u00dfe");
        CommonWords.addCommon("talstra\u00dfe");
        CommonWords.addCommon("gartenstra\u00dfe");
        CommonWords.addCommon("prospect");
        CommonWords.addCommon("m.");
        CommonWords.addCommon("chaussee");
        CommonWords.addCommon("row");
        CommonWords.addCommon("link");
        CommonWords.addCommon("traves\u00eda");
        CommonWords.addCommon("degli");
        CommonWords.addCommon("piazzale");
        CommonWords.addCommon("vei");
        CommonWords.addCommon("waldstra\u00dfe");
        CommonWords.addCommon("promenade");
        CommonWords.addCommon("puente");
        CommonWords.addCommon("rond-point");
        CommonWords.addCommon("v\u00eda");
        CommonWords.addCommon("pod");
        CommonWords.addCommon("triq");
        CommonWords.addCommon("hwy");
        CommonWords.addCommon("\u03bf\u03b4\u03cc\u03c2");
        CommonWords.addCommon("dels");
        CommonWords.addCommon("and");
        CommonWords.addCommon("pr\u00e9");
        CommonWords.addCommon("plac");
        CommonWords.addCommon("fairway");
        CommonWords.addCommon("\u043d\u0430\u0431\u0435\u0440\u0435\u0436\u043d\u0430\u044f");
        CommonWords.addCommon("chauss\u00e9e");
        CommonWords.addCommon("n\u00e1m\u011bst\u00ed");
        CommonWords.addCommon("t\u00e9r");
        CommonWords.addCommon("roundabout");
        CommonWords.addCommon("lakeshore");
        CommonWords.addCommon("lakeside");
        CommonWords.addCommon("alle");
        CommonWords.addCommon("gasse");
        CommonWords.addCommon("str.");
        CommonWords.addCommon("ville");
        CommonWords.addCommon("beco");
        CommonWords.addCommon("platz");
        CommonWords.addCommon("sideroad");
        CommonWords.addCommon("pista");
        CommonWords.addCommon("\u0430\u043b\u043b\u0435\u044f");
        CommonWords.addCommon("\u0431\u0443\u043b\u044c\u0432\u0430\u0440");
        CommonWords.addCommon("\u0433\u043e\u0440\u043e\u0434");
        CommonWords.addCommon("\u0433\u043e\u0440\u043e\u0434\u043e\u043a");
        CommonWords.addCommon("\u0434\u0435\u0440\u0435\u0432\u043d\u044f");
        CommonWords.addCommon("\u0434\u0435\u0440.");
        CommonWords.addCommon("\u043f\u043e\u0441.");
        CommonWords.addCommon("\u0434\u043e\u0440\u043e\u0433\u0430");
        CommonWords.addCommon("\u0434\u043e\u0440\u043e\u0436\u043a\u0430");
        CommonWords.addCommon("\u043a\u043e\u043b\u044c\u0446\u043e");
        CommonWords.addCommon("\u043c\u043e\u0441\u0442");
        CommonWords.addCommon("\u043e\u0441\u0442\u0440\u043e\u0432");
        CommonWords.addCommon("\u043e\u0441\u0442\u0440\u043e\u0432\u043e\u043a");
        CommonWords.addCommon("\u043f\u043e\u0441\u0435\u043b\u043e\u043a");
        CommonWords.addCommon("\u043f\u043e\u0441\u0451\u043b\u043e\u043a");
        CommonWords.addCommon("\u043f\u0443\u0442\u0435\u043f\u0440\u043e\u0432\u043e\u0434");
        CommonWords.addCommon("\u0441\u043b\u043e\u0431\u043e\u0434\u0430");
        CommonWords.addCommon("\u0441\u0442\u0430\u043d\u0446\u0438\u044f");
        CommonWords.addCommon("\u0442\u043e\u043d\u043d\u0435\u043b\u044c");
        CommonWords.addCommon("\u0442\u0440\u0430\u043a\u0442");
        CommonWords.addCommon("island");
        CommonWords.addCommon("islet");
        CommonWords.addCommon("tunnel");
        CommonWords.addCommon("stadt");
        CommonWords.addCommon("br\u00fccke");
        CommonWords.addCommon("damm");
        CommonWords.addCommon("insel");
        CommonWords.addCommon("dorf");
        CommonWords.addCommon("bereich");
        CommonWords.addCommon("\u00fcberf\u00fchrung");
        CommonWords.addCommon("bulevar");
        CommonWords.addCommon("ciudad");
        CommonWords.addCommon("pueblo");
        CommonWords.addCommon("anillo");
        CommonWords.addCommon("muelle");
        CommonWords.addCommon("isla");
        CommonWords.addCommon("islote");
        CommonWords.addCommon("carril");
        CommonWords.addCommon("viaje");
        CommonWords.addCommon("citt\u00e0");
        CommonWords.addCommon("paese");
        CommonWords.addCommon("villaggio");
        CommonWords.addCommon("banchina");
        CommonWords.addCommon("isola");
        CommonWords.addCommon("isolotto");
        CommonWords.addCommon("corsia");
        CommonWords.addCommon("viaggio");
        CommonWords.addCommon("canale");
        CommonWords.addCommon("pont");
        CommonWords.addCommon("quai");
        CommonWords.addCommon("\u00eele");
        CommonWords.addCommon("\u00eelot");
        CommonWords.addCommon("voyage");
        CommonWords.addCommon("descente");
        CommonWords.addCommon("straat");
        CommonWords.addCommon("stad");
        CommonWords.addCommon("dorp");
        CommonWords.addCommon("brug");
        CommonWords.addCommon("kade");
        CommonWords.addCommon("eiland");
        CommonWords.addCommon("eilandje");
        CommonWords.addCommon("laan");
        CommonWords.addCommon("plein");
        CommonWords.addCommon("reizen");
        CommonWords.addCommon("afkomst");
        CommonWords.addCommon("kanaal");
        CommonWords.addCommon("doodlopende");
        CommonWords.addCommon("strad\u0103");
        CommonWords.addCommon("rutier");
        CommonWords.addCommon("alee");
        CommonWords.addCommon("municipiu");
        CommonWords.addCommon("oras");
        CommonWords.addCommon("drumuri");
        CommonWords.addCommon("poduri");
        CommonWords.addCommon("cheu");
        CommonWords.addCommon("insula");
        CommonWords.addCommon("ostrov");
        CommonWords.addCommon("sat");
        CommonWords.addCommon("c\u0103l\u0103torie");
        CommonWords.addCommon("cobor\u00e2re");
        CommonWords.addCommon("statie");
        CommonWords.addCommon("tunel");
        CommonWords.addCommon("fund\u0103tur\u0103");
        CommonWords.addCommon("ulice");
        CommonWords.addCommon("silnice");
        CommonWords.addCommon("bulv\u00e1r");
        CommonWords.addCommon("m\u011bsto");
        CommonWords.addCommon("obec");
        CommonWords.addCommon("most");
        CommonWords.addCommon("n\u00e1b\u0159e\u017e\u00ed");
        CommonWords.addCommon("ostrova");
        CommonWords.addCommon("ostr\u016fvek");
        CommonWords.addCommon("vesnice");
        CommonWords.addCommon("jezdit");
        CommonWords.addCommon("sestup");
        CommonWords.addCommon("n\u00e1dra\u017e\u00ed");
        CommonWords.addCommon("kan\u00e1l");
        CommonWords.addCommon("uli\u010dka");
        CommonWords.addCommon("gata");
        CommonWords.addCommon("by");
        CommonWords.addCommon("bro");
        CommonWords.addCommon("kaj");
        CommonWords.addCommon("\u00f6");
        CommonWords.addCommon("holme");
        CommonWords.addCommon("fyrkant");
        CommonWords.addCommon("resa");
        CommonWords.addCommon("h\u00e4rkomst");
        CommonWords.addCommon("kanal");
        CommonWords.addCommon("\u00e5terv\u00e4ndsgr\u00e4nd");
        CommonWords.addCommon("cesty");
        CommonWords.addCommon("ostrov\u010dek");
        CommonWords.addCommon("n\u00e1mestie");
        CommonWords.addCommon("dediny");
        CommonWords.addCommon("jazdi\u0165");
        CommonWords.addCommon("zostup");
        CommonWords.addCommon("stanice");
        CommonWords.addCommon("cesta");
        CommonWords.addCommon("pot");
        CommonWords.addCommon("mesto");
        CommonWords.addCommon("kraj");
        CommonWords.addCommon("vas");
        CommonWords.addCommon("pomol");
        CommonWords.addCommon("otok");
        CommonWords.addCommon("oto\u010dek");
        CommonWords.addCommon("trg");
        CommonWords.addCommon("potovanje");
        CommonWords.addCommon("spust");
        CommonWords.addCommon("postaja");
        CommonWords.addCommon("predor");
        CommonWords.addCommon("\u0432\u0443\u043b\u0456\u0446\u0430");
        CommonWords.addCommon("\u0448\u0430\u0448\u0430");
        CommonWords.addCommon("\u0430\u043b\u0435\u044f");
        CommonWords.addCommon("\u0433\u043e\u0440\u0430\u0434");
        CommonWords.addCommon("\u043c\u044f\u0441\u0442\u044d\u0447\u043a\u0430");
        CommonWords.addCommon("\u0432\u0451\u0441\u043a\u0430");
        CommonWords.addCommon("\u0434\u0430\u0440\u043e\u0433\u0430");
        CommonWords.addCommon("\u043d\u0430\u0431\u044f\u0440\u044d\u0436\u043d\u0430\u044f");
        CommonWords.addCommon("\u0432\u043e\u0441\u0442\u0440\u0430\u045e");
        CommonWords.addCommon("\u0430\u0441\u0442\u0440\u0430\u0432\u043e\u043a");
        CommonWords.addCommon("\u0437\u0430\u0432\u0443\u043b\u0430\u043a");
        CommonWords.addCommon("\u043f\u043b\u043e\u0448\u0447\u0430");
        CommonWords.addCommon("\u043f\u0430\u0441\u0451\u043b\u0430\u043a");
        CommonWords.addCommon("\u043f\u0440\u0430\u0435\u0437\u0434");
        CommonWords.addCommon("\u043f\u0440\u0430\u0441\u043f\u0435\u043a\u0442");
        CommonWords.addCommon("\u0441\u0442\u0430\u043d\u0446\u044b\u044f");
        CommonWords.addCommon("\u0442\u0443\u043d\u044d\u043b\u044c");
        CommonWords.addCommon("\u0442\u0443\u043f\u0456\u043a");
        CommonWords.addCommon("\u0627\u0641\u064a.");
        CommonWords.addCommon("\u0625\u0644\u0649");
        CommonWords.addCommon("\u062a\u0633\u0648\u064a\u0629");
        CommonWords.addCommon("\u062c\u0627\u062f\u0629");
        CommonWords.addCommon("\u062c\u0632\u064a\u0631\u0629");
        CommonWords.addCommon("\u062c\u0633\u0631");
        CommonWords.addCommon("\u0632\u0642\u0627\u0642");
        CommonWords.addCommon("\u0634\u0627\u0631\u0639");
        CommonWords.addCommon("\u0637\u0631\u064a\u0642");
        CommonWords.addCommon("\u0642\u0631\u064a\u0629");
        CommonWords.addCommon("\u0645\u0623\u0632\u0642");
        CommonWords.addCommon("\u0645\u062d\u0637\u0629");
        CommonWords.addCommon("\u0645\u062f\u064a\u0646\u0629");
        CommonWords.addCommon("\u0645\u0631\u0648\u0631");
        CommonWords.addCommon("\u0645\u0633\u0627\u0631");
        CommonWords.addCommon("\u0645\u0645\u0631");
        CommonWords.addCommon("\u0645\u0646\u0637\u0642\u0629");
        CommonWords.addCommon("\u0646\u0641\u0642");
        CommonWords.addCommon("\u043f\u044a\u0442");
        CommonWords.addCommon("\u0431\u0443\u043b\u0435\u0432\u0430\u0440\u0434");
        CommonWords.addCommon("\u0433\u0440\u0430\u0434");
        CommonWords.addCommon("\u0441\u0435\u043b\u043e");
        CommonWords.addCommon("\u043a\u0435\u0439");
        CommonWords.addCommon("\u043e\u0441\u0442\u0440\u043e\u0432\u0447\u0435");
        CommonWords.addCommon("\u043f\u043b\u0430\u0442\u043d\u043e");
        CommonWords.addCommon("\u043a\u0432\u0430\u0434\u0440\u0430\u0442");
        CommonWords.addCommon("\u043f\u044a\u0442\u0443\u0432\u0430\u043d\u0435");
        CommonWords.addCommon("\u043f\u0440\u043e\u0438\u0437\u0445\u043e\u0434");
        CommonWords.addCommon("\u0433\u0430\u0440\u0430");
        CommonWords.addCommon("\u0442\u0443\u043d\u0435\u043b");
        CommonWords.addCommon("\u043a\u0430\u043d\u0430\u043b");
        CommonWords.addCommon("k\u00f6r\u00fat");
        CommonWords.addCommon("h\u00edd");
        CommonWords.addCommon("rakpart");
        CommonWords.addCommon("\u00e1llom\u00e1s");
        CommonWords.addCommon("alag\u00fat");
        CommonWords.addCommon("\u0111\u01b0\u1eddng");
        CommonWords.addCommon("\u0111\u1ea1i");
        CommonWords.addCommon("l\u00e0ng");
        CommonWords.addCommon("c\u1ea7u");
        CommonWords.addCommon("\u0111\u1ea3o");
        CommonWords.addCommon("ph\u1ed1");
        CommonWords.addCommon("g\u1ed1c");
        CommonWords.addCommon("k\u00eanh");
        CommonWords.addCommon("\u03b4\u03c1\u03cc\u03bc\u03bf");
        CommonWords.addCommon("\u03bb\u03b5\u03c9\u03c6\u03cc\u03c1\u03bf\u03c2");
        CommonWords.addCommon("\u03c0\u03cc\u03bb\u03b7");
        CommonWords.addCommon("\u03ba\u03c9\u03bc\u03cc\u03c0\u03bf\u03bb\u03b7");
        CommonWords.addCommon("\u03c7\u03c9\u03c1\u03b9\u03cc");
        CommonWords.addCommon("\u03b4\u03c1\u03cc\u03bc\u03bf\u03c2");
        CommonWords.addCommon("\u03b3\u03ad\u03c6\u03c5\u03c1\u03b1");
        CommonWords.addCommon("\u03b1\u03c0\u03bf\u03b2\u03ac\u03b8\u03c1\u03b1");
        CommonWords.addCommon("\u03bd\u03b7\u03c3\u03af");
        CommonWords.addCommon("\u03bd\u03b7\u03c3\u03af\u03b4\u03b1");
        CommonWords.addCommon("\u03bb\u03c9\u03c1\u03af\u03b4\u03b1");
        CommonWords.addCommon("\u03c0\u03bb\u03b1\u03c4\u03b5\u03af\u03b1");
        CommonWords.addCommon("\u03c7\u03c9\u03c1\u03b9\u03cc");
        CommonWords.addCommon("\u03c4\u03b1\u03be\u03af\u03b4\u03b9\u03b1");
        CommonWords.addCommon("\u00f8");
        CommonWords.addCommon("bane");
        CommonWords.addCommon("villages");
        CommonWords.addCommon("stravenue");
        CommonWords.addCommon("forge");
        CommonWords.addCommon("loops");
        CommonWords.addCommon("crossroad");
        CommonWords.addCommon("ridges");
        CommonWords.addCommon("motorway");
        CommonWords.addCommon("squares");
        CommonWords.addCommon("ways");
        CommonWords.addCommon("junctions");
        CommonWords.addCommon("drives");
        CommonWords.addCommon("throughway");
        CommonWords.addCommon("trafficway");
        CommonWords.addCommon("plaine");
        CommonWords.addRegionNames();
    }
}

