/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.osmand.Collator;
import net.osmand.CollatorStringMatcher;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class BinaryMapPoiReaderAdapter {
    private static final Log LOG = PlatformUtil.getLog(BinaryMapPoiReaderAdapter.class);
    public static final int SHIFT_BITS_CATEGORY = 7;
    private static final int CATEGORY_MASK = 127;
    private static final int ZOOM_TO_SKIP_FILTER_READ = 6;
    private static final int ZOOM_TO_SKIP_FILTER = 3;
    private static final int BUCKET_SEARCH_BY_NAME = 15;
    private static final int BASE_POI_SHIFT = 7;
    private static final int FINAL_POI_SHIFT = 5;
    private static final int BASE_POI_ZOOM = 24;
    private static final int FINAL_POI_ZOOM = 26;
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;
    private MapPoiTypes poiTypes;

    protected BinaryMapPoiReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
        this.poiTypes = MapPoiTypes.getDefault();
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private long readInt() throws IOException {
        return this.map.readInt();
    }

    private void readPoiBoundariesIndex(PoiRegion region) throws IOException {
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    region.left31 = this.codedIS.readUInt32();
                    continue block7;
                }
                case 2: {
                    region.right31 = this.codedIS.readUInt32();
                    continue block7;
                }
                case 3: {
                    region.top31 = this.codedIS.readUInt32();
                    continue block7;
                }
                case 4: {
                    region.bottom31 = this.codedIS.readUInt32();
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void readPoiIndex(PoiRegion region, boolean readCategories) throws IOException {
        block8: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    region.name = this.codedIS.readString();
                    continue block8;
                }
                case 2: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readPoiBoundariesIndex(region);
                    this.codedIS.popLimit(oldLimit);
                    continue block8;
                }
                case 3: {
                    if (!readCategories) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return;
                    }
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readCategory(region);
                    this.codedIS.popLimit(oldLimit);
                    continue block8;
                }
                case 5: {
                    if (!readCategories) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return;
                    }
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readSubtypes(region);
                    this.codedIS.popLimit(oldLimit);
                    continue block8;
                }
                case 6: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readCategory(PoiRegion region) throws IOException {
        block5: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    String cat = this.codedIS.readString().intern();
                    region.categories.add(cat);
                    region.categoriesType.add(this.poiTypes.getPoiCategoryByName(cat.toLowerCase(), true));
                    region.subcategories.add(new ArrayList());
                    continue block5;
                }
                case 3: {
                    region.subcategories.get(region.subcategories.size() - 1).add(this.codedIS.readString().intern());
                    continue block5;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readSubtypes(PoiRegion region) throws IOException {
        block10: while (true) {
            int outT = this.codedIS.readTag();
            int outTag = WireFormat.getTagFieldNumber(outT);
            switch (outTag) {
                case 0: {
                    return;
                }
                case 4: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    PoiSubType st = new PoiSubType();
                    block11: while (true) {
                        int inT = this.codedIS.readTag();
                        int inTag = WireFormat.getTagFieldNumber(inT);
                        switch (inTag) {
                            case 0: {
                                break block11;
                            }
                            case 1: {
                                st.name = this.codedIS.readString().intern();
                                continue block11;
                            }
                            case 8: {
                                if (st.possibleValues == null) {
                                    st.possibleValues = new ArrayList<String>();
                                }
                                st.possibleValues.add(this.codedIS.readString().intern());
                                continue block11;
                            }
                            case 3: {
                                st.text = this.codedIS.readBool();
                                continue block11;
                            }
                            default: {
                                this.skipUnknownField(inT);
                                continue block11;
                            }
                        }
                        break;
                    }
                    region.subTypes.add(st);
                    if (this.poiTypes.topIndexPoiAdditional.containsKey(st.name)) {
                        region.topIndexSubTypes.add(st);
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block10;
                }
            }
            this.skipUnknownField(outT);
        }
    }

    public void initCategories(PoiRegion region) throws IOException {
        if (region.categories.isEmpty()) {
            this.codedIS.seek(region.filePointer);
            long oldLimit = this.codedIS.pushLimitLong(region.length);
            this.readPoiIndex(region, true);
            this.codedIS.popLimit(oldLimit);
        }
    }

    private String normalizeSearchPoiByNameQuery(String query) {
        return query.replace("\"", "").toLowerCase();
    }

    protected void searchPoiByName(PoiRegion region, BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        TIntLongHashMap offsets = new TIntLongHashMap();
        String query = this.normalizeSearchPoiByNameQuery(req.nameQuery);
        CollatorStringMatcher matcher = new CollatorStringMatcher(query, req.matcherMode);
        long indexOffset = this.codedIS.getTotalBytesRead();
        TIntLongHashMap offsetsMap = new TIntLongHashMap();
        ArrayList<Integer> nameIndexCoordinates = new ArrayList<Integer>();
        QuadTree<Void> nameIndexTree = null;
        block6: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    long length = this.readInt();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    offsets = this.readPoiNameIndex(matcher.getCollator(), query, req, region, nameIndexCoordinates);
                    this.codedIS.popLimit(oldLimit);
                    continue block6;
                }
                case 6: {
                    long length = this.readInt();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    if (nameIndexCoordinates.size() > 0 && nameIndexTree == null) {
                        nameIndexTree = new QuadTree<Void>(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 8, 0.55f);
                        for (int i = 0; i < nameIndexCoordinates.size(); i += 2) {
                            int x = (Integer)nameIndexCoordinates.get(i);
                            int y = (Integer)nameIndexCoordinates.get(i + 1);
                            nameIndexTree.insert(null, new QuadRect(x, y, x, y));
                        }
                    }
                    BinaryMapIndexReader.SearchPoiTypeFilter filter = req.poiTypeFilter;
                    req.poiTypeFilter = null;
                    this.readBoxField(0, 0, 0, 0, 0, 0, 0, offsetsMap, null, req, region, nameIndexTree);
                    req.poiTypeFilter = filter;
                    this.codedIS.popLimit(oldLimit);
                    continue block6;
                }
                case 9: {
                    Object[] offKeys = new Integer[offsets.size()];
                    if (offsets.size() > 0) {
                        int[] keys = offsets.keys();
                        for (int i = 0; i < keys.length; ++i) {
                            offKeys[i] = keys[i];
                        }
                        final TIntLongHashMap foffsets = offsets;
                        Arrays.sort(offKeys, new Comparator<Integer>(){

                            @Override
                            public int compare(Integer object1, Integer object2) {
                                return Double.compare(foffsets.get(object1.intValue()), foffsets.get(object2.intValue()));
                            }
                        });
                        int p = 45;
                        if (p < offKeys.length) {
                            int i = p + 15;
                            while (true) {
                                if (i > offKeys.length) {
                                    Arrays.sort(offKeys, p, offKeys.length);
                                    break;
                                }
                                Arrays.sort(offKeys, p, i);
                                p = i;
                                i += 15;
                            }
                        }
                    }
                    for (int j = 0; j < offKeys.length; ++j) {
                        this.codedIS.seek((long)offKeys[j].intValue() + indexOffset);
                        long len = this.readInt();
                        long oldLim = this.codedIS.pushLimitLong(len);
                        this.readPoiData(matcher, req, region);
                        this.codedIS.popLimit(oldLim);
                        if (!req.isCancelled() && !req.limitExceeded()) continue;
                        return;
                    }
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private TIntLongHashMap readPoiNameIndex(Collator instance, String query, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, List<Integer> nameIndexCoordinates) throws IOException {
        TIntLongHashMap offsets = new TIntLongHashMap();
        ArrayList<TIntArrayList> listOffsets = null;
        ArrayList<TIntLongHashMap> listOfSepOffsets = new ArrayList<TIntLongHashMap>();
        long offset = 0L;
        block5: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return offsets;
                }
                case 3: {
                    long length = this.readInt();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    offset = this.codedIS.getTotalBytesRead();
                    List<String> queries = Algorithms.splitByWordsLowercase(query);
                    TIntArrayList charsList = new TIntArrayList(queries.size());
                    listOffsets = new ArrayList<TIntArrayList>(queries.size());
                    while (listOffsets.size() < queries.size()) {
                        charsList.add(0);
                        listOffsets.add(new TIntArrayList());
                    }
                    this.map.readIndexedStringTable(instance, queries, "", listOffsets, charsList);
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 5: {
                    if (listOffsets != null) {
                        for (TIntArrayList dataOffsets : listOffsets) {
                            TIntLongHashMap offsetMap = new TIntLongHashMap();
                            listOfSepOffsets.add(offsetMap);
                            dataOffsets.sort();
                            for (int i = 0; i < dataOffsets.size(); ++i) {
                                this.codedIS.seek((long)dataOffsets.get(i) + offset);
                                int len = this.codedIS.readRawVarint32();
                                long oldLim = this.codedIS.pushLimitLong(len);
                                this.readPoiNameIndexData(offsetMap, req, region, nameIndexCoordinates);
                                this.codedIS.popLimit(oldLim);
                                if (!req.isCancelled()) continue;
                                this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                                return offsets;
                            }
                        }
                    }
                    if (listOfSepOffsets.size() > 0) {
                        if (req.matcherMode == CollatorStringMatcher.StringMatcherMode.MULTISEARCH) {
                            for (TIntLongHashMap m : listOfSepOffsets) {
                                offsets.putAll((TIntLongMap)m);
                            }
                        } else {
                            offsets.putAll((TIntLongMap)listOfSepOffsets.get(0));
                            for (int j = 1; j < listOfSepOffsets.size(); ++j) {
                                TIntLongHashMap mp = (TIntLongHashMap)listOfSepOffsets.get(j);
                                for (int chKey : offsets.keys()) {
                                    if (mp.containsKey(chKey)) continue;
                                    offsets.remove(chKey);
                                }
                            }
                        }
                    }
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return offsets;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readPoiNameIndexData(TIntLongHashMap offsets, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, List<Integer> nameIndexCoordinates) throws IOException {
        block4: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    int len = this.codedIS.readRawVarint32();
                    long oldLim = this.codedIS.pushLimitLong(len);
                    this.readPoiNameIndexDataAtom(offsets, req, region, nameIndexCoordinates);
                    this.codedIS.popLimit(oldLim);
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readPoiNameIndexDataAtom(TIntLongHashMap offsets, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, List<Integer> nameIndexCoordinates) throws IOException {
        int x = 0;
        int y = 0;
        int zoom = 15;
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    x = this.codedIS.readUInt32();
                    continue block7;
                }
                case 4: {
                    y = this.codedIS.readUInt32();
                    continue block7;
                }
                case 2: {
                    zoom = this.codedIS.readUInt32();
                    continue block7;
                }
                case 14: {
                    int x31 = x << 31 - zoom;
                    int y31 = y << 31 - zoom;
                    int x31r = x + 1 << 31 - zoom;
                    int y31b = y + 1 << 31 - zoom;
                    long l = this.readInt();
                    if (l > Integer.MAX_VALUE) {
                        throw new IllegalStateException();
                    }
                    int shift = (int)l;
                    QuadRect r = new QuadRect(x31, y31, x31r, y31b);
                    if (req.contains(x31, y31, x31, y31) || r.contains(req.x, req.y, req.x, req.y)) {
                        long d = Math.abs(req.x - x31) + Math.abs(req.y - y31);
                        offsets.put(shift, d);
                    }
                    ArrayList bboxResult = new ArrayList();
                    region.bboxIndexCache.queryInBox(new QuadRect(x31, y31, x31, y31), bboxResult);
                    if (bboxResult.size() != 0) continue block7;
                    nameIndexCoordinates.add(x31);
                    nameIndexCoordinates.add(y31);
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void searchPoiIndex(int left31, int right31, int top31, int bottom31, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region) throws IOException {
        long indexOffset = this.codedIS.getTotalBytesRead();
        long time = System.currentTimeMillis();
        TLongHashSet skipTiles = null;
        if (req.zoom >= 0 && req.zoom < 16) {
            skipTiles = new TLongHashSet();
        }
        TIntLongHashMap offsetsMap = new TIntLongHashMap();
        block5: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 6: {
                    long length = this.readInt();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readBoxField(left31, right31, top31, bottom31, 0, 0, 0, offsetsMap, skipTiles, req, region, null);
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 9: {
                    int[] offsets = offsetsMap.keys();
                    Arrays.sort(offsets);
                    if (skipTiles != null) {
                        skipTiles.clear();
                    }
                    for (int j = 0; j < offsets.length; ++j) {
                        long dy;
                        int dzoom;
                        long dx;
                        long skipVal = offsetsMap.get(offsets[j]);
                        if (skipTiles != null && skipVal != -1L && (skipVal = (dx = skipVal >> 6) >> (dzoom = 3) << 3 | (dy = skipVal - (dx << 6)) >> dzoom) != -1L && skipTiles.contains(skipVal)) continue;
                        this.codedIS.seek((long)offsets[j] + indexOffset);
                        long len = this.readInt();
                        long oldLim = this.codedIS.pushLimitLong(len);
                        boolean read = this.readPoiData(left31, right31, top31, bottom31, req, region, skipTiles, req.zoom == -1 ? 31 : req.zoom + 3);
                        if (read && skipVal != -1L && skipTiles != null) {
                            skipTiles.add(skipVal);
                        }
                        this.codedIS.popLimit(oldLim);
                        if (!req.isCancelled()) continue;
                        return;
                    }
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private void readPoiData(CollatorStringMatcher matcher, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region) throws IOException {
        int x = 0;
        int y = 0;
        int zoom = 0;
        block7: while (!req.isCancelled() && !req.limitExceeded()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 2: {
                    x = this.codedIS.readUInt32();
                    break;
                }
                case 1: {
                    zoom = this.codedIS.readUInt32();
                    break;
                }
                case 3: {
                    y = this.codedIS.readUInt32();
                    break;
                }
                case 5: {
                    boolean matches;
                    int len = this.codedIS.readRawVarint32();
                    long oldLim = this.codedIS.pushLimitLong(len);
                    Amenity am = this.readPoiPoint(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, x, y, zoom, req, region, false);
                    this.codedIS.popLimit(oldLim);
                    if (am == null) continue block7;
                    boolean bl = matches = matcher.matches(am.getName().toLowerCase()) || matcher.matches(am.getEnName(true).toLowerCase());
                    if (!matches) {
                        String s;
                        Iterator<String> iterator = am.getOtherNames().iterator();
                        while (iterator.hasNext() && !(matches = matcher.matches((s = iterator.next()).toLowerCase()))) {
                        }
                        if (!matches) {
                            String key;
                            iterator = am.getAdditionalInfoKeys().iterator();
                            while (!(!iterator.hasNext() || ((key = iterator.next()).contains("_name") || key.equals("brand") || key.contains("wikidata") || key.equals("route_id") || key.equals("route_members_ids")) && (matches = matcher.matches(am.getAdditionalInfo(key))))) {
                            }
                        }
                    }
                    if (!matches) continue block7;
                    req.collectRawData(am);
                    req.publish(am);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return;
    }

    private boolean readPoiData(int left31, int right31, int top31, int bottom31, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, TLongHashSet toSkip, int zSkip) throws IOException {
        int x = 0;
        int y = 0;
        int zoom = 0;
        boolean read = false;
        block7: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return read;
                }
                case 2: {
                    x = this.codedIS.readUInt32();
                    break;
                }
                case 1: {
                    zoom = this.codedIS.readUInt32();
                    break;
                }
                case 3: {
                    y = this.codedIS.readUInt32();
                    break;
                }
                case 5: {
                    int len = this.codedIS.readRawVarint32();
                    long oldLim = this.codedIS.pushLimitLong(len);
                    Amenity am = this.readPoiPoint(left31, right31, top31, bottom31, x, y, zoom, req, region, true);
                    this.codedIS.popLimit(oldLim);
                    if (am == null) continue block7;
                    if (toSkip != null) {
                        int yp;
                        int xp = (int)MapUtils.getTileNumberX(zSkip, am.getLocation().getLongitude());
                        long valSkip = (long)xp << zSkip | (long)(yp = (int)MapUtils.getTileNumberY(zSkip, am.getLocation().getLatitude()));
                        if (!toSkip.contains(valSkip)) {
                            req.collectRawData(am);
                            boolean publish = req.publish(am);
                            if (!publish) continue block7;
                            read = true;
                            toSkip.add(valSkip);
                            break;
                        }
                        if (zSkip > zoom) continue block7;
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return read;
                    }
                    req.collectRawData(am);
                    if (!req.publish(am)) continue block7;
                    read = true;
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return read;
    }

    private Amenity.AmenityRoutePoint dist(LatLon l, List<Location> locations, double radius) {
        float dist = (float)(radius + 0.1);
        Amenity.AmenityRoutePoint arp = null;
        for (int i = 1; i < locations.size(); i += 2) {
            float d = (float)MapUtils.getOrthogonalDistance(l.getLatitude(), l.getLongitude(), locations.get(i - 1).getLatitude(), locations.get(i - 1).getLongitude(), locations.get(i).getLatitude(), locations.get(i).getLongitude());
            if (!(d < dist)) continue;
            arp = new Amenity.AmenityRoutePoint();
            dist = d;
            arp.deviateDistance = dist;
            arp.pointA = locations.get(i - 1);
            arp.pointB = locations.get(i);
        }
        if (arp != null && arp.deviateDistance != 0.0 && arp.pointA != null && arp.pointB != null) {
            arp.deviationDirectionRight = MapUtils.rightSide(l.getLatitude(), l.getLongitude(), arp.pointA.getLatitude(), arp.pointA.getLongitude(), arp.pointB.getLatitude(), arp.pointB.getLongitude());
        }
        return arp;
    }

    private Amenity readPoiPoint(int left31, int right31, int top31, int bottom31, int px, int py, int zoom, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, boolean checkBounds) throws IOException {
        MapObject am = null;
        int x = 0;
        int y = 0;
        int precisionXY = 0;
        boolean hasLocation = false;
        StringBuilder retValue = new StringBuilder();
        PoiCategory amenityType = null;
        LinkedList<String> textTags = null;
        boolean hasSubcategoriesField = false;
        boolean topIndexAdditonalFound = false;
        HashMap<String, PoiCategory> otherSubTypes = new HashMap<String, PoiCategory>();
        block18: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            if (amenityType == null && (tag > 4 || tag == 0)) {
                this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                return null;
            }
            if (!(req.poiAdditionalFilter == null || tag <= 5 && tag != 0 || hasSubcategoriesField && topIndexAdditonalFound)) {
                this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                return null;
            }
            switch (tag) {
                case 0: {
                    ++req.numberOfAcceptedObjects;
                    if (hasLocation) {
                        if (precisionXY != 0) {
                            int[] xy = MapUtils.calculateFinalXYFromBaseAndPrecisionXY(24, 26, precisionXY, x >> 7, y >> 7, true);
                            int n = xy[0] << 5;
                            int y31 = xy[1] << 5;
                            am.setLocation(MapUtils.get31LatitudeY(y31), MapUtils.get31LongitudeX(n));
                        } else {
                            am.setLocation(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
                        }
                    } else {
                        return null;
                    }
                    if (req.radius > 0.0) {
                        LatLon loc = am.getLocation();
                        List list = (List)req.tiles.get(req.getTileHashOnPath(loc.getLatitude(), loc.getLongitude()));
                        if (list == null) {
                            return null;
                        }
                        Amenity.AmenityRoutePoint arp = this.dist(am.getLocation(), list, req.radius);
                        if (arp == null) {
                            return null;
                        }
                        ((Amenity)am).setRoutePoint(arp);
                    }
                    if (req.poiTypeFilter != null) {
                        for (Map.Entry entry : otherSubTypes.entrySet()) {
                            PoiCategory cat = (PoiCategory)entry.getValue();
                            if (((Amenity)am).getType() != cat) continue;
                            String sub = (String)entry.getKey();
                            ((Amenity)am).setSubType(((Amenity)am).getSubType() + ";" + sub);
                        }
                    }
                    ((Amenity)am).setRegionName(region.getName());
                    return am;
                }
                case 2: {
                    x = this.codedIS.readSInt32() + (px << 24 - zoom) << 7;
                    continue block18;
                }
                case 3: {
                    y = this.codedIS.readSInt32() + (py << 24 - zoom) << 7;
                    ++req.numberOfVisitedObjects;
                    if (checkBounds && (left31 > x || right31 < x || top31 > y || bottom31 < y)) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return null;
                    }
                    am = new Amenity();
                    hasLocation = true;
                    continue block18;
                }
                case 5: {
                    int subtypev = this.codedIS.readUInt32();
                    retValue.setLength(0);
                    hasSubcategoriesField = true;
                    PoiSubType poiSubType = region.getSubtypeFromId(subtypev, retValue);
                    boolean topIndex = region.topIndexSubTypes.contains(poiSubType);
                    if (req.poiAdditionalFilter != null && poiSubType != null && req.poiAdditionalFilter.accept(poiSubType, retValue.toString())) {
                        topIndexAdditonalFound = true;
                    }
                    if (poiSubType == null || topIndex) continue block18;
                    ((Amenity)am).setAdditionalInfo(poiSubType.name, retValue.toString());
                    continue block18;
                }
                case 14: {
                    int texttypev = this.codedIS.readUInt32();
                    retValue.setLength(0);
                    PoiSubType textt = region.getSubtypeFromId(texttypev, retValue);
                    if (textt == null || !textt.text) continue block18;
                    if (textTags == null) {
                        textTags = new LinkedList<String>();
                    }
                    textTags.add(textt.name);
                    continue block18;
                }
                case 15: {
                    String str = this.codedIS.readString();
                    if (textTags == null || textTags.isEmpty()) continue block18;
                    ((Amenity)am).setAdditionalInfo((String)textTags.poll(), str);
                    continue block18;
                }
                case 4: {
                    boolean isForbidden;
                    int cat = this.codedIS.readUInt32();
                    int subcatId = cat >> 7;
                    int catId = cat & 0x7F;
                    PoiCategory type = this.poiTypes.getOtherPoiCategory();
                    String subtype = "";
                    if (catId < region.categoriesType.size()) {
                        type = region.categoriesType.get(catId);
                        List<String> subcats = region.subcategories.get(catId);
                        if (subcatId < subcats.size()) {
                            subtype = subcats.get(subcatId);
                        }
                    }
                    if (!(isForbidden = this.poiTypes.isTypeForbidden(subtype = this.poiTypes.replaceDeprecatedSubtype(type, subtype))) && (req.poiTypeFilter == null || req.poiTypeFilter.accept(type, subtype))) {
                        if (amenityType == null) {
                            amenityType = type;
                            ((Amenity)am).setSubType(subtype);
                            ((Amenity)am).setType(amenityType);
                            continue block18;
                        }
                        ((Amenity)am).setSubType(((Amenity)am).getSubType() + ";" + subtype);
                        continue block18;
                    }
                    otherSubTypes.put(subtype, type);
                    continue block18;
                }
                case 8: {
                    am.setId(this.codedIS.readUInt64());
                    continue block18;
                }
                case 6: {
                    am.setName(this.codedIS.readString());
                    continue block18;
                }
                case 7: {
                    am.setEnName(this.codedIS.readString());
                    continue block18;
                }
                case 10: {
                    ((Amenity)am).setOpeningHours(this.codedIS.readString());
                    continue block18;
                }
                case 11: {
                    ((Amenity)am).setSite(this.codedIS.readString());
                    continue block18;
                }
                case 12: {
                    ((Amenity)am).setPhone(this.codedIS.readString());
                    continue block18;
                }
                case 13: {
                    ((Amenity)am).setDescription(this.codedIS.readString());
                    continue block18;
                }
                case 16: {
                    if (!hasLocation) continue block18;
                    precisionXY = this.codedIS.readInt32();
                    continue block18;
                }
                case 17: {
                    PoiRegion.MAP_HAS_TAG_GROUPS = true;
                    long sz = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(sz);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        int tagGroupId = this.codedIS.readUInt32();
                        List<BinaryMapIndexReader.TagValuePair> list = region.getTagValues(tagGroupId);
                        if (list.size() <= 0) continue;
                        ((Amenity)am).addTagGroup(tagGroupId, list);
                    }
                    this.codedIS.popLimit(old);
                    continue block18;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private boolean checkCategories(BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region) throws IOException {
        block5: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return false;
                }
                case 5: {
                    int subcat = this.codedIS.readUInt32();
                    StringBuilder subType = new StringBuilder();
                    PoiSubType poiSubType = region.getSubtypeFromId(subcat, subType);
                    String val = subType.toString();
                    if (poiSubType == null || val.isEmpty() || req.poiAdditionalFilter == null || !req.poiAdditionalFilter.accept(poiSubType, val)) continue block5;
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return true;
                }
                case 3: {
                    PoiCategory type = this.poiTypes.getOtherPoiCategory();
                    String subtype = "";
                    int cat = this.codedIS.readUInt32();
                    int subcatId = cat >> 7;
                    int catId = cat & 0x7F;
                    if (catId < region.categoriesType.size()) {
                        type = region.categoriesType.get(catId);
                        List<String> subcats = region.subcategories.get(catId);
                        if (subcatId < subcats.size()) {
                            subtype = subcats.get(subcatId);
                        }
                    }
                    subtype = this.poiTypes.replaceDeprecatedSubtype(type, subtype);
                    if (req.poiTypeFilter == null || !req.poiTypeFilter.accept(type, subtype)) continue block5;
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return true;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private boolean readBoxField(int left31, int right31, int top31, int bottom31, int px, int py, int pzoom, TIntLongHashMap offsetsMap, TLongHashSet skipTiles, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, QuadTree<Void> nameIndexTree) throws IOException {
        ++req.numberOfReadSubtrees;
        int zoomToSkip = req.zoom == -1 ? 31 : req.zoom + 6;
        boolean checkBox = true;
        boolean existsCategories = false;
        int zoom = pzoom;
        int dy = py;
        int dx = px;
        block10: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return existsCategories;
                }
                case 1: {
                    zoom = this.codedIS.readUInt32() + pzoom;
                    break;
                }
                case 2: {
                    dx = this.codedIS.readSInt32();
                    break;
                }
                case 3: {
                    dy = this.codedIS.readSInt32();
                    break;
                }
                case 4: {
                    if (req.poiTypeFilter == null) {
                        this.skipUnknownField(t);
                        break;
                    }
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    boolean check = this.checkCategories(req, region);
                    this.codedIS.popLimit(oldLimit);
                    if (!check) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return false;
                    }
                    existsCategories = true;
                    break;
                }
                case 8: {
                    PoiRegion.MAP_HAS_TAG_GROUPS = true;
                    int tagGroupLength = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(tagGroupLength);
                    this.readTagGroups(region.tagGroups, req);
                    this.codedIS.popLimit(old);
                    break;
                }
                case 10: {
                    long val;
                    int x = dx + (px << zoom - pzoom);
                    int y = dy + (py << zoom - pzoom);
                    if (checkBox) {
                        int xL = x << 31 - zoom;
                        int xR = (x + 1 << 31 - zoom) - 1;
                        int yT = y << 31 - zoom;
                        int yB = (y + 1 << 31 - zoom) - 1;
                        boolean intersectWithNameIndex = false;
                        QuadRect rect = new QuadRect(xL, yT, xR, yB);
                        if (PoiRegion.MAP_HAS_TAG_GROUPS && nameIndexTree != null) {
                            ArrayList resCache = new ArrayList();
                            region.bboxIndexCache.queryInBox(rect, resCache);
                            if (resCache.size() == 0) {
                                ArrayList res = new ArrayList();
                                nameIndexTree.queryInBox(rect, res);
                                boolean bl = intersectWithNameIndex = res.size() > 0;
                            }
                        }
                        if (!(left31 <= xR && xL <= right31 && bottom31 >= yT && yB >= top31 || intersectWithNameIndex)) {
                            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                            return false;
                        }
                        ++req.numberOfAcceptedSubtrees;
                        checkBox = false;
                        region.bboxIndexCache.insert(null, rect);
                    }
                    long length = this.readInt();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    boolean exists = this.readBoxField(left31, right31, top31, bottom31, x, y, zoom, offsetsMap, skipTiles, req, region, nameIndexTree);
                    this.codedIS.popLimit(oldLimit);
                    if (skipTiles == null || zoom < zoomToSkip || !exists || !skipTiles.contains(val = (long)x >> zoom - zoomToSkip << zoomToSkip | (long)y >> zoom - zoomToSkip)) continue block10;
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return true;
                }
                case 14: {
                    long l;
                    int x = dx + (px << zoom - pzoom);
                    int y = dy + (py << zoom - pzoom);
                    boolean read = true;
                    if (req.tiles != null) {
                        long zx = x << 16 - zoom;
                        long zy = y << 16 - zoom;
                        read = req.tiles.contains((zx << 16) + zy);
                    }
                    if ((l = this.readInt()) > Integer.MAX_VALUE) {
                        throw new IllegalStateException();
                    }
                    int offset = (int)l;
                    if (!read) continue block10;
                    if (skipTiles != null && zoom >= zoomToSkip) {
                        long valSkip = (long)x >> zoom - zoomToSkip << zoomToSkip | (long)y >> zoom - zoomToSkip;
                        offsetsMap.put(offset, valSkip);
                        skipTiles.add(valSkip);
                        break;
                    }
                    offsetsMap.put(offset, -1L);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return false;
    }

    private void readTagGroups(Map<Integer, List<BinaryMapIndexReader.TagValuePair>> tagGroups, BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        block4: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 5: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readTagGroup(tagGroups, req);
                    this.codedIS.popLimit(oldLimit);
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private void readTagGroup(Map<Integer, List<BinaryMapIndexReader.TagValuePair>> tagGroups, BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        ArrayList<String> tagValues = new ArrayList<String>();
        int id = -1;
        block5: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (id > 0 && tagValues.size() > 1 && tagValues.size() % 2 == 0) {
                        ArrayList<BinaryMapIndexReader.TagValuePair> tagValuePairs = new ArrayList<BinaryMapIndexReader.TagValuePair>();
                        for (int i = 0; i < tagValues.size(); i += 2) {
                            tagValuePairs.add(new BinaryMapIndexReader.TagValuePair((String)tagValues.get(i), (String)tagValues.get(i + 1), -1));
                        }
                        tagGroups.put(id, tagValuePairs);
                    }
                    return;
                }
                case 1: {
                    id = this.codedIS.readUInt32();
                    continue block5;
                }
                case 5: {
                    tagValues.add(this.codedIS.readString().intern());
                    continue block5;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    public static class PoiRegion
    extends BinaryIndexPart {
        List<String> categories = new ArrayList<String>();
        List<PoiCategory> categoriesType = new ArrayList<PoiCategory>();
        List<List<String>> subcategories = new ArrayList<List<String>>();
        List<PoiSubType> subTypes = new ArrayList<PoiSubType>();
        List<PoiSubType> topIndexSubTypes = new ArrayList<PoiSubType>();
        Map<Integer, List<BinaryMapIndexReader.TagValuePair>> tagGroups = new HashMap<Integer, List<BinaryMapIndexReader.TagValuePair>>();
        QuadTree<Void> bboxIndexCache = new QuadTree(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 8, 0.55f);
        static boolean MAP_HAS_TAG_GROUPS = false;
        int left31;
        int right31;
        int top31;
        int bottom31;

        public int getLeft31() {
            return this.left31;
        }

        public int getRight31() {
            return this.right31;
        }

        public int getTop31() {
            return this.top31;
        }

        public int getBottom31() {
            return this.bottom31;
        }

        @Override
        public String getPartName() {
            return "POI";
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public List<List<String>> getSubcategories() {
            return this.subcategories;
        }

        public List<PoiSubType> getSubTypes() {
            return this.subTypes;
        }

        public List<PoiSubType> getTopIndexSubTypes() {
            return this.topIndexSubTypes;
        }

        @Override
        public int getFieldNumber() {
            return 8;
        }

        public PoiSubType getSubtypeFromId(int id, StringBuilder returnValue) {
            int sl;
            int tl;
            if (id % 2 == 0) {
                tl = id >> 1 & 0x1F;
                sl = id >> 6;
            } else {
                tl = id >> 1 & Short.MAX_VALUE;
                sl = id >> 16;
            }
            if (this.subTypes.size() > tl) {
                PoiSubType st = this.subTypes.get(tl);
                if (st.text) {
                    return st;
                }
                if (st.possibleValues != null && st.possibleValues.size() > sl) {
                    returnValue.append(st.possibleValues.get(sl));
                    return st;
                }
            }
            return null;
        }

        public List<BinaryMapIndexReader.TagValuePair> getTagValues(int id) {
            return this.tagGroups.getOrDefault(id, new ArrayList());
        }
    }

    public static class PoiSubType {
        public boolean text;
        public String name;
        public List<String> possibleValues = null;
    }
}

