/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.osmand.PlatformUtil;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.wiki.WikiDatabasePreparation;
import org.apache.commons.logging.Log;

public class WikiDatabaseUpdater {
    private static final Log log = PlatformUtil.getLog(WikiDatabasePreparation.class);
    private final String WIKIDATA_URL = "https://dumps.wikimedia.org/wikidatawiki/latest/";
    private List<String> downloadedPages = new ArrayList<String>();
    private long maxQId = 0L;
    private final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";

    public WikiDatabaseUpdater(File db) {
        try {
            this.maxQId = this.getMaxQIdFromDb(db);
            long maxId = this.getMaxId();
            Pattern pattern = Pattern.compile("wikidatawiki-latest-pages-articles\\d+\\.xml.+bz2\"");
            List<Page> pages = this.readUrl(pattern);
            List<Page> updateList = new ArrayList<Page>();
            for (Page p : pages) {
                if (maxId >= p.max && maxId >= p.min) continue;
                updateList.add(p);
            }
            updateList = this.getWithoutRepeats(updateList);
            String folder = db.getParent();
            this.downloadPages(folder, updateList);
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long getMaxQId() {
        return this.maxQId;
    }

    public List<String> getDownloadedPages() {
        return this.downloadedPages;
    }

    private List<Page> getWithoutRepeats(List<Page> updateList) {
        ArrayList<Long> min = new ArrayList<Long>();
        long repeatedMin = 0L;
        for (Page p : updateList) {
            if (min.contains(p.min)) {
                repeatedMin = p.min;
                break;
            }
            min.add(p.min);
        }
        if (repeatedMin > 0L) {
            ArrayList<Page> res = new ArrayList<Page>();
            long max = 0L;
            for (Page p : updateList) {
                if (p.min != repeatedMin) {
                    res.add(p);
                    continue;
                }
                max = Math.max(max, p.max);
            }
            for (Page p : updateList) {
                if (p.max != max) continue;
                res.add(p);
                break;
            }
            return res;
        }
        return updateList;
    }

    private void downloadPages(String folder, List<Page> updateList) throws IOException {
        for (Page p : updateList) {
            Object line;
            Object gzFile = p.url.replace(".bz2", ".gz");
            File gz = new File((String)(gzFile = folder + "/" + (String)gzFile));
            if (gz.exists()) {
                System.out.println((String)gzFile + " already downloaded");
                this.downloadedPages.add((String)gzFile);
                continue;
            }
            String cmd = "curl -A \"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11\" https://dumps.wikimedia.org/wikidatawiki/latest/" + p.url + " | bzcat | gzip -1 ";
            System.out.println("Download https://dumps.wikimedia.org/wikidatawiki/latest/" + p.url);
            System.out.println(cmd);
            Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmd});
            BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(process.getInputStream())));
            GZIPOutputStream gzout = new GZIPOutputStream(new FileOutputStream((String)gzFile));
            while ((line = reader.readLine()) != null) {
                line = (String)line + System.lineSeparator();
                gzout.write(((String)line).getBytes(StandardCharsets.UTF_8));
            }
            gzout.close();
            System.out.println((String)gzFile + " downloading is finished");
            this.downloadedPages.add((String)gzFile);
        }
    }

    public void removeDownloadedPages() {
        for (String s : this.downloadedPages) {
            File f = new File(s);
            if (!f.exists()) continue;
            f.delete();
        }
    }

    private List<Page> readUrl(Pattern pattern) throws IOException {
        String line;
        URLConnection connection = new URL("https://dumps.wikimedia.org/wikidatawiki/latest/").openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        connection.connect();
        BufferedReader r = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
        ArrayList<Page> result = new ArrayList<Page>();
        while ((line = r.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String data = line.replace("<a href=\"", "").replaceAll("\">.+$", "");
            String p = data.replaceAll(".+xml-", "").replaceAll("\\.bz2", "");
            String[] pages = p.split("p");
            Page page = new Page();
            page.min = Integer.parseInt(pages[1]);
            page.max = Integer.parseInt(pages[2]);
            page.url = data;
            result.add(page);
        }
        if (result.size() == 0) {
            throw new RuntimeException("Could not download list from https://dumps.wikimedia.org/wikidatawiki/latest/");
        }
        return result;
    }

    private long getMaxQIdFromDb(File wikidataSqlite) throws SQLException {
        DBDialect dialect = DBDialect.SQLITE;
        Connection conn = dialect.getDatabaseConnection(wikidataSqlite.getAbsolutePath(), log);
        ResultSet rs = conn.createStatement().executeQuery("SELECT max(id) FROM wiki_coords");
        long maxQId = 0L;
        if (rs.next()) {
            maxQId = rs.getLong(1);
        }
        if ((rs = conn.createStatement().executeQuery("SELECT max(id) FROM wikidata_properties")).next()) {
            maxQId = Math.max(rs.getLong(1), maxQId);
        }
        conn.close();
        if (maxQId == 0L) {
            throw new RuntimeException("Could not get max QiD from " + wikidataSqlite.getAbsolutePath());
        }
        return maxQId;
    }

    private long getMaxId() throws IOException {
        JsonNode jsonPageId;
        ObjectMapper mapper = new ObjectMapper();
        String s = "https://www.wikidata.org/wiki/Special:EntityData/Q" + this.maxQId + ".json";
        URL url = new URL(s);
        JsonNode json = mapper.readTree(url);
        if (json != null && (jsonPageId = json.findValue("pageid")) != null) {
            return jsonPageId.asLong();
        }
        throw new RuntimeException("Could not get max id for updating from " + s);
    }

    private class Page {
        long min;
        long max;
        String url;

        private Page() {
        }
    }
}

