/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.Collator;
import net.osmand.OsmAndCollator;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.json.JSONObject;

public class BinaryComparator {
    public static final int BUFFER_SIZE = 0x100000;
    private static double CITY_SIMILARITY_DISTANCE = 5500.0;
    private static double CITY_SIMILARITY_DISTANCE_POSSIBLE = 25500.0;
    private static final Log log = PlatformUtil.getLog(BinaryComparator.class);
    private static Set<Integer> COMPARE_SET = new HashSet<Integer>();
    private static final int CITY_COMPARE = 11;
    private static final int CITY_NAME_COMPARE = 12;
    private static final int STREET_COMPARE = 21;
    private static final int STREET_NAME_COMPARE = 22;
    private static final int BUILDINGS_COMPARE = 31;
    private static final int INTERSECTIONS_COMPARE = 41;
    private static final int POI_COMPARE = 51;
    private static final int POI_DETAILS = 55;
    private static final int COMPARE_UNIQUE_1 = 91;
    private static final int COMPARE_UNIQUE_2 = 92;
    private static final Integer[] ADDRESS_COMPARE = new Integer[]{11, 12, 21, 22, 31, 41};
    private static final Map<String, Integer> COMPARE_ARGS = new HashMap<String, Integer>();
    private static final String[] fileNameByNumber;
    private int ELEM_ID = -1;
    private FileOutputStream fosm = null;
    public static final String helpMessage = "[--cities] [--city-names] [--streets] [--street-names] [--buildings] [--intersections] [--poi] [--poi-details] [--osm=file_path] [--add] [--rm] <first> <second>: compare <first> and <second> (map & routing data is not supported)";

    public static void main(String[] args) throws IOException {
        BinaryComparator in = new BinaryComparator();
        if (args.length == 1 && "test".equals(args[0])) {
            in.compare(new String[]{System.getProperty("maps.dir") + "Andorra_europe_2.obf", System.getProperty("maps.dir") + "Andorra_europe.obf", "--poi", "--poi-details", "--unique-1", "--unique-2"});
        } else {
            in.compare(args);
        }
    }

    private void compare(String[] argArr) throws IOException {
        if (argArr == null || argArr.length < 2) {
            System.out.println(helpMessage);
            System.exit(1);
        }
        ArrayList<BinaryMapIndexReader> indexes = new ArrayList<BinaryMapIndexReader>();
        ArrayList<RandomAccessFile> rafs = new ArrayList<RandomAccessFile>();
        for (int i = 0; i < argArr.length; ++i) {
            String arg = argArr[i];
            if (arg.startsWith("--osm=")) {
                this.fosm = new FileOutputStream(arg.substring("--osm=".length()));
                continue;
            }
            if (arg.startsWith("--")) {
                if (COMPARE_ARGS.containsKey(arg)) {
                    COMPARE_SET.add(COMPARE_ARGS.get(arg));
                    continue;
                }
                System.out.print("Error: unknown argument");
                System.out.println(helpMessage);
                System.exit(1);
                continue;
            }
            RandomAccessFile raf = new RandomAccessFile(arg, "r");
            BinaryMapIndexReader reader = new BinaryMapIndexReader(raf, new File(arg));
            indexes.add(reader);
            rafs.add(raf);
        }
        if (COMPARE_SET.isEmpty()) {
            COMPARE_SET.addAll(COMPARE_ARGS.values());
        }
        if (this.isOsmOutput()) {
            this.fosm.write("<?xml version='1.0' encoding='utf-8'?>\n".getBytes());
            this.fosm.write("<osm version='0.6'>\n".getBytes());
        }
        HashSet<Integer> addressCompareSet = new HashSet<Integer>(COMPARE_SET);
        addressCompareSet.retainAll(Arrays.asList(ADDRESS_COMPARE));
        if (!addressCompareSet.isEmpty()) {
            this.compareAddress((BinaryMapIndexReader)indexes.get(0), (BinaryMapIndexReader)indexes.get(1));
        }
        if (COMPARE_SET.contains(51) || COMPARE_SET.contains(55)) {
            this.comparePoi((BinaryMapIndexReader)indexes.get(0), (BinaryMapIndexReader)indexes.get(1));
        }
        if (this.isOsmOutput()) {
            this.fosm.write("</osm>".getBytes());
            this.fosm.close();
        }
    }

    private List<Amenity> loadAmenities(BinaryMapIndexReader index) throws IOException {
        ArrayList<Amenity> amenities = new ArrayList<Amenity>(index.searchPoi(BinaryMapIndexReader.buildSearchPoiRequest((int)0, (int)Integer.MAX_VALUE, (int)0, (int)Integer.MAX_VALUE, (int)-1, (BinaryMapIndexReader.SearchPoiTypeFilter)BinaryMapIndexReader.ACCEPT_ALL_POI_TYPE_FILTER, null)));
        Collections.sort(amenities, this.getNaturalOrder());
        log.info((Object)("Read " + amenities.size() + " amenities from " + String.valueOf(index.getFile())));
        return amenities;
    }

    private Comparator<Amenity> getNaturalOrder() {
        return new Comparator<Amenity>(){

            @Override
            public int compare(Amenity o1, Amenity o2) {
                int c;
                if (o1 == null || o2 == null) {
                    return o1 == o2 ? 0 : (o1 == null ? 1 : -1);
                }
                if (o1.getId() < 0L || o2.getId() < 0L) {
                    if (o1.getId() > 0L) {
                        return 1;
                    }
                    if (o2.getId() > 0L) {
                        return -1;
                    }
                    long h1 = BinaryComparator.latlon(o1);
                    long h2 = BinaryComparator.latlon(o2);
                    c = Algorithms.compare((long)h1, (long)h2);
                } else {
                    c = Algorithms.compare((long)o1.getId(), (long)o2.getId());
                }
                if (c == 0) {
                    int l = Algorithms.compare((int)o1.getType().ordinal(), (int)o2.getType().ordinal());
                    if (l == 0) {
                        return o1.getSubType().compareTo(o2.getSubType());
                    }
                    return l;
                }
                return c;
            }
        };
    }

    public static long latlon(Amenity amenity) {
        LatLon loc = amenity.getLocation();
        return (long)MapUtils.getTileNumberX((float)21.0f, (double)loc.getLongitude()) << 31 | (long)MapUtils.getTileNumberY((float)21.0f, (double)loc.getLatitude());
    }

    private void comparePoiDetails(Amenity a0, Amenity a1) throws IOException {
        if (!Algorithms.objectEquals((Object)a0.getSubType(), (Object)a1.getSubType())) {
            this.printMapObject(55, (MapObject)a0, "Amenity subtypes are not equal " + a0.getSubType() + " <> " + a1.getSubType());
        }
        if (!Algorithms.objectEquals((Object)a0.getAdditionalInfoKeys(), (Object)a1.getAdditionalInfoKeys())) {
            this.printMapObject(55, (MapObject)a0, "Amenity info key is not equal " + String.valueOf(a0.getAdditionalInfoKeys()) + " <> " + String.valueOf(a1.getAdditionalInfoKeys()));
        }
        if (!Algorithms.objectEquals(new TreeSet(a0.getAdditionalInfoValues(false)), new TreeSet(a1.getAdditionalInfoValues(false)))) {
            this.printMapObject(55, (MapObject)a0, "Amenity info is not equal " + String.valueOf(a0.getAdditionalInfoValues(false)) + " <> " + String.valueOf(a1.getAdditionalInfoValues(false)));
        }
        if (!Algorithms.objectEquals((Object)a0.getNamesMap(true), (Object)a1.getNamesMap(true))) {
            this.printMapObject(55, (MapObject)a0, "Amenity name is not equal " + String.valueOf(a0.getNamesMap(true)) + " <> " + String.valueOf(a1.getNamesMap(true)));
        }
        if (MapUtils.getDistance((LatLon)a0.getLocation(), (LatLon)a1.getLocation()) > 50.0) {
            this.printMapObject(55, (MapObject)a0, "Amenitis are too far" + String.valueOf(a0.getLocation()) + " <> " + String.valueOf(a1.getLocation()) + " " + MapUtils.getDistance((LatLon)a0.getLocation(), (LatLon)a1.getLocation()));
        }
    }

    private void comparePoi(BinaryMapIndexReader i0, BinaryMapIndexReader i1) throws IOException {
        List<Amenity> amenities0 = this.loadAmenities(i0);
        List<Amenity> amenities1 = this.loadAmenities(i1);
        int i = 0;
        int j = 0;
        int[] uniqueCount = new int[]{0, 0};
        Comparator<Amenity> c = this.getNaturalOrder();
        Amenity a0 = this.get(amenities0, 0);
        Amenity a1 = this.get(amenities1, 0);
        while (i < amenities0.size() || j < amenities1.size()) {
            int cmp = c.compare(a0, a1);
            if (cmp < 0) {
                if (COMPARE_SET.contains(91) && COMPARE_SET.contains(51)) {
                    uniqueCount[0] = uniqueCount[0] + 1;
                    this.printAmenity(a0, 0);
                }
                a0 = this.get(amenities0, ++i);
                continue;
            }
            if (cmp > 0) {
                if (COMPARE_SET.contains(92) && COMPARE_SET.contains(51)) {
                    uniqueCount[1] = uniqueCount[1] + 1;
                    this.printAmenity(a1, 1);
                }
                a1 = this.get(amenities1, ++j);
                continue;
            }
            if (COMPARE_SET.contains(55) && a0 != null && a1 != null) {
                this.comparePoiDetails(a0, a1);
            }
            a0 = this.get(amenities0, ++i);
            a1 = this.get(amenities1, ++j);
        }
        for (int compareUnique : Arrays.asList(91, 92)) {
            if (!COMPARE_SET.contains(compareUnique)) continue;
            int uniqueToFile = compareUnique - 91;
            log.info((Object)("Amenities present only in " + fileNameByNumber[uniqueToFile] + ": " + uniqueCount[uniqueToFile]));
        }
    }

    private void compareAddress(BinaryMapIndexReader i0, BinaryMapIndexReader i1) throws IOException {
        for (BinaryMapAddressReaderAdapter.CityBlocks cityType : BinaryMapAddressReaderAdapter.CityBlocks.values()) {
            if (!cityType.cityGroupType) continue;
            List ct0 = i0.getCities(null, cityType);
            List ct1 = i1.getCities(null, cityType);
            Comparator<City> c = this.comparator();
            Collections.sort(ct0, c);
            Collections.sort(ct1, c);
            int i = 0;
            int j = 0;
            this.printComment("CITY TYPE: " + String.valueOf(cityType));
            while (i < ct0.size() || j < ct1.size()) {
                City c1;
                City c0 = (City)this.get(ct0, i);
                int cmp = c.compare(c0, c1 = (City)this.get(ct1, j));
                if (cmp < 0) {
                    while (c.compare(c0, c1) < 0) {
                        if (COMPARE_SET.contains(11) && COMPARE_SET.contains(91)) {
                            City ps = this.searchSimilarCities(c0, ct1, j);
                            if (ps != null) {
                                int distance = (int)MapUtils.getDistance((LatLon)c0.getLocation(), (LatLon)ps.getLocation());
                                this.printMapObject(11, (MapObject)c0, "(1). Extra city in 1st file: " + String.valueOf(c0) + "( " + distance + " m ) possible duplicate " + String.valueOf(ps));
                            } else {
                                this.printMapObject(11, (MapObject)c0, "(1)! Extra city in 1st file: " + String.valueOf(c0));
                            }
                        }
                        c0 = (City)this.get(ct0, ++i);
                    }
                    continue;
                }
                if (cmp > 0) {
                    while (c.compare(c0, c1) > 0) {
                        if (COMPARE_SET.contains(11) && COMPARE_SET.contains(92)) {
                            City ps = this.searchSimilarCities(c1, ct0, i);
                            if (ps != null) {
                                int distance = (int)MapUtils.getDistance((LatLon)c1.getLocation(), (LatLon)ps.getLocation());
                                this.printMapObject(11, (MapObject)c1, "(1). Extra city in 2nd file: " + String.valueOf(c1) + "( " + distance + " m ) possible duplicate " + String.valueOf(ps));
                            } else {
                                this.printMapObject(11, (MapObject)c1, "(1)! Extra city in 2nd file: " + String.valueOf(c0));
                            }
                        }
                        c1 = (City)this.get(ct1, ++j);
                    }
                    continue;
                }
                ++i;
                ++j;
                i0.preloadStreets(c0, null, null);
                i1.preloadStreets(c1, null, null);
                if (COMPARE_SET.contains(12) && !c0.getNamesMap(true).equals(c1.getNamesMap(true))) {
                    this.printComment("(1). City all names are not same : " + String.valueOf(c1) + " " + String.valueOf(new JSONObject(c0.getNamesMap(true))) + " != " + String.valueOf(new JSONObject(c1.getNamesMap(true))));
                }
                if (c0.getStreets().size() != c1.getStreets().size()) {
                    if (!COMPARE_SET.contains(21)) continue;
                    if (!this.isOsmOutput()) {
                        this.printComment("(2). City streets " + String.valueOf(c1) + ":  " + c0.getStreets().size() + " <> " + c1.getStreets().size());
                    }
                    ArrayList<String> s0 = new ArrayList<String>();
                    ArrayList<String> s1 = new ArrayList<String>();
                    for (Street s : c0.getStreets()) {
                        if (c1.getStreetByName(s.getName()) != null) continue;
                        s0.add(s.getName());
                        if (!this.isOsmOutput()) continue;
                        this.printMapObject(21, (MapObject)s, "(2) Street " + String.valueOf(s) + "is not present in 2nd file");
                    }
                    for (Street s : c1.getStreets()) {
                        if (c0.getStreetByName(s.getName()) != null) continue;
                        if (this.isOsmOutput()) {
                            this.printMapObject(21, (MapObject)s, "(2) Street " + String.valueOf(s) + " is not present in 1st file");
                        }
                        s1.add(s.getName());
                    }
                    if (s0.isEmpty() && s1.isEmpty()) {
                        this.printMapObject(21, (MapObject)c0, "(2) Number of streets with same name is not equal" + String.valueOf(c0.getStreets()));
                        continue;
                    }
                    this.printComment("(2).. " + String.valueOf(s0) + "<>" + String.valueOf(s1));
                    continue;
                }
                for (int ij = 0; ij < c1.getStreets().size(); ++ij) {
                    Street s0 = (Street)c0.getStreets().get(ij);
                    Street s1 = (Street)c1.getStreets().get(ij);
                    if (!s0.getNamesMap(true).equals(s1.getNamesMap(true)) && COMPARE_SET.contains(22)) {
                        this.printMapObject(22, (MapObject)s0, "(2)- Street all names are not same : " + String.valueOf(c1) + " " + String.valueOf(s0.getNamesMap(true)) + " <> " + String.valueOf(s1.getNamesMap(true)));
                    }
                    if (s0.getName().equals(s1.getName())) {
                        int it;
                        i0.preloadBuildings(s0, null, null);
                        i1.preloadBuildings(s1, null, null);
                        if (COMPARE_SET.contains(31)) {
                            if (s0.getBuildings().size() != s1.getBuildings().size()) {
                                this.printMapObject(31, (MapObject)s0, "(3). Buildings size: " + s0.getBuildings().size() + "<>" + s1.getBuildings().size() + " " + String.valueOf(c0) + ", " + String.valueOf(s0));
                            } else {
                                for (it = 0; it < s0.getBuildings().size(); ++it) {
                                    Building b0 = (Building)s0.getBuildings().get(it);
                                    Building b1 = (Building)s1.getBuildings().get(it);
                                    if (!b0.getName().equals(b1.getName())) {
                                        this.printMapObject(31, (MapObject)b0, "(4). Buildings name: " + b0.getName() + "<>" + b1.getName() + " " + String.valueOf(c0) + ", " + String.valueOf(s0));
                                    }
                                    if (Algorithms.objectEquals((Object)b0.getPostcode(), (Object)b1.getPostcode())) continue;
                                    this.printMapObject(31, (MapObject)b0, "(4). Buildings postcode: " + b0.getPostcode() + "<>" + b1.getPostcode() + " " + String.valueOf(c0) + ", " + String.valueOf(s0));
                                }
                            }
                        }
                        if (!COMPARE_SET.contains(41)) continue;
                        if (s0.getIntersectedStreets().size() != s1.getIntersectedStreets().size()) {
                            this.printMapObject(41, (MapObject)s0, "(5). Intersections size: " + s0.getIntersectedStreets().size() + "<>" + s1.getIntersectedStreets().size() + " " + String.valueOf(c0) + ", " + String.valueOf(s0));
                            continue;
                        }
                        Collections.sort(s0.getIntersectedStreets(), MapObject.BY_NAME_COMPARATOR);
                        Collections.sort(s1.getIntersectedStreets(), MapObject.BY_NAME_COMPARATOR);
                        for (it = 0; it < s0.getIntersectedStreets().size(); ++it) {
                            Street st0 = (Street)s0.getIntersectedStreets().get(it);
                            Street st1 = (Street)s1.getIntersectedStreets().get(it);
                            if (!st0.getName().equals(st1.getName())) {
                                this.printMapObject(41, (MapObject)st0, "(5). Intersections names <> : " + String.valueOf(st0) + "<>" + String.valueOf(st1) + " " + String.valueOf(c0) + ", " + String.valueOf(s0) + " ");
                            }
                            if (!(MapUtils.getDistance((LatLon)st0.getLocation(), (LatLon)st1.getLocation()) > 1500.0)) continue;
                            this.printMapObject(41, (MapObject)st0, "(5). Intersections location <> : " + String.valueOf(st0) + "<>" + String.valueOf(st1) + " " + String.valueOf(c0) + ", " + String.valueOf(s0) + " ");
                        }
                        continue;
                    }
                    if (!COMPARE_SET.contains(22)) continue;
                    this.printMapObject(22, (MapObject)s0, "(3)? Street name order: " + String.valueOf(s0) + "!=" + String.valueOf(s1) + " " + String.valueOf(c0));
                }
            }
        }
    }

    private void printMapObject(int type, MapObject obj, String msg) throws IOException {
        if (!this.isOsmOutput()) {
            System.out.println(msg);
        } else {
            this.fosm.write(("  <node lat='" + obj.getLocation().getLatitude() + "' lon='" + obj.getLocation().getLongitude() + "'  id='" + this.ELEM_ID-- + "'>\n").getBytes());
            this.fosm.write(("  <tag k='comment' v='" + msg.replace('\'', '_').replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;") + "'/>\n").getBytes());
            this.fosm.write(("  <tag k='name' v='" + type + "'/>\n").getBytes());
            this.fosm.write("  </node>\n".getBytes());
        }
    }

    private void printAmenity(Amenity amenity, int uniqueToFile) throws IOException {
        this.printMapObject(51, (MapObject)amenity, "Amenity exist only in " + fileNameByNumber[uniqueToFile] + ": " + amenity.toString());
    }

    private boolean isOsmOutput() {
        return this.fosm != null;
    }

    private void printComment(String string) throws IOException {
        if (!this.isOsmOutput()) {
            System.out.println(string);
        } else {
            this.fosm.write(("<!-- " + string + "-->\n").getBytes());
        }
    }

    private City searchSimilarCities(City city, List<City> search, int j) {
        City ps;
        int t;
        Collator collator = OsmAndCollator.primaryCollator();
        boolean offByOneError = false;
        for (t = Math.min(j, search.size() - 1); t >= 0; --t) {
            ps = search.get(t);
            if (collator.compare(this.strip(city.getName()), this.strip(ps.getName())) != 0) {
                if (offByOneError) break;
                offByOneError = true;
                continue;
            }
            if (!(MapUtils.getDistance((LatLon)city.getLocation(), (LatLon)ps.getLocation()) < CITY_SIMILARITY_DISTANCE_POSSIBLE)) continue;
            return ps;
        }
        offByOneError = false;
        for (t = j; t < search.size(); ++t) {
            ps = search.get(t);
            if (collator.compare(this.strip(city.getName()), this.strip(ps.getName())) != 0) {
                if (offByOneError) break;
                offByOneError = true;
                continue;
            }
            if (!(MapUtils.getDistance((LatLon)city.getLocation(), (LatLon)ps.getLocation()) < CITY_SIMILARITY_DISTANCE_POSSIBLE)) continue;
            return ps;
        }
        return null;
    }

    private <T> T get(List<T> list, int i) {
        return i >= list.size() ? null : (T)list.get(i);
    }

    private String strip(String name) {
        return name.indexOf(40) != -1 ? name.substring(0, name.indexOf(40)).trim() : name;
    }

    private Comparator<City> comparator() {
        return new Comparator<City>(){
            Collator collator = OsmAndCollator.primaryCollator();

            @Override
            public int compare(City o1, City o2) {
                if (o1 == null || o2 == null) {
                    return o1 == o2 ? 0 : (o1 == null ? 1 : -1);
                }
                int c = this.collator.compare(BinaryComparator.this.strip(o1.getName()), BinaryComparator.this.strip(o2.getName()));
                if (c == 0) {
                    if (MapUtils.getDistance((LatLon)o1.getLocation(), (LatLon)o2.getLocation()) < CITY_SIMILARITY_DISTANCE) {
                        return 0;
                    }
                    c = Double.compare(MapUtils.getDistance((LatLon)o1.getLocation(), (double)0.0, (double)0.0), MapUtils.getDistance((LatLon)o2.getLocation(), (double)0.0, (double)0.0));
                }
                return c;
            }
        };
    }

    static {
        COMPARE_ARGS.put("--cities", 11);
        COMPARE_ARGS.put("--city-names", 12);
        COMPARE_ARGS.put("--streets", 21);
        COMPARE_ARGS.put("--street-names", 22);
        COMPARE_ARGS.put("--buildings", 31);
        COMPARE_ARGS.put("--intersections", 41);
        COMPARE_ARGS.put("--poi", 51);
        COMPARE_ARGS.put("--poi-details", 55);
        COMPARE_ARGS.put("--unique-1", 91);
        COMPARE_ARGS.put("--unique-2", 92);
        fileNameByNumber = new String[]{"first file", "second file"};
    }
}

