/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.impl;

import java.text.MessageFormat;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;

public class ConsoleProgressImplementation
implements IProgress {
    public static double deltaPercentsToPrint = 3.5;
    public static long deltaTimeToPrint = 1000L;
    public static long deltaTimeToPrintMax = 120000L;
    private static Log log = PlatformUtil.getLog(ConsoleProgressImplementation.class);
    protected String currentTask;
    protected long work;
    protected long currentDone;
    protected double delta;
    protected long previousTaskStarted = 0L;
    protected long lastTimePrinted = 0L;
    double lastPercentPrint = 0.0;

    public ConsoleProgressImplementation() {
        this.delta = deltaPercentsToPrint;
    }

    public ConsoleProgressImplementation(double deltaToPrint) {
        this.delta = deltaToPrint;
    }

    public ConsoleProgressImplementation(double deltaToPrint, int deltaTime) {
        this.delta = deltaToPrint;
        deltaToPrint = deltaTime;
    }

    public void finishTask() {
        this.print("Task " + this.currentTask + " is finished ");
        this.currentTask = null;
    }

    public boolean isIndeterminate() {
        return this.work == -1L;
    }

    public void progress(int deltaWork) {
        this.currentDone += (long)deltaWork;
        this.printIfNeeded();
    }

    protected void printIfNeeded() {
        long now = System.currentTimeMillis();
        if (this.getCurrentPercent() - this.lastPercentPrint >= this.delta || now - this.lastTimePrinted > deltaTimeToPrintMax) {
            this.lastPercentPrint = this.getCurrentPercent();
            if (now - this.lastTimePrinted >= deltaTimeToPrint) {
                this.print(this.getPrintMessage());
                this.lastTimePrinted = now;
            }
        }
    }

    private void print(String printMessage) {
        log.info((Object)printMessage);
    }

    private void printDebug(String string) {
        log.debug((Object)string);
    }

    protected String getPrintMessage() {
        return MessageFormat.format("Done {0} %.", this.getCurrentPercent());
    }

    public double getCurrentPercent() {
        return (double)this.currentDone * 100.0 / (double)this.work;
    }

    public void remaining(int remainingWork) {
        this.currentDone = this.work - (long)remainingWork;
        this.printIfNeeded();
    }

    public void remainingLong(long remainingWork) {
        this.currentDone = this.work - remainingWork;
        this.printIfNeeded();
    }

    public void startTask(String taskName, int work) {
        this.startTaskLong(taskName, work);
    }

    public void startTaskLong(String taskName, long work) {
        if (!Algorithms.objectEquals((Object)this.currentTask, (Object)taskName)) {
            this.currentTask = taskName;
            this.printDebug("Memory before task exec: " + Runtime.getRuntime().totalMemory() + " free : " + Runtime.getRuntime().freeMemory());
            if (this.previousTaskStarted == 0L) {
                this.print(taskName + " started - " + work);
            } else {
                this.print(taskName + " started after " + (System.currentTimeMillis() - this.previousTaskStarted) + " ms - " + work);
            }
            this.previousTaskStarted = System.currentTimeMillis();
        }
        this.startWorkLong(work);
    }

    public void startWork(int work) {
        this.startWorkLong(work);
    }

    private void startWorkLong(long work) {
        if (this.work != work) {
            this.work = work;
            this.print("Task " + this.currentTask + ": work total has changed to " + work);
        }
        this.currentDone = 0L;
        this.lastPercentPrint = 0.0;
    }

    public boolean isInterrupted() {
        return false;
    }

    public void setGeneralProgress(String genProgress) {
    }
}

