/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.model.JobSummary;
import software.amazon.awssdk.services.batch.model.ListJobsRequest;
import software.amazon.awssdk.services.batch.model.ListJobsResponse;

public class ListJobsIterable
implements SdkIterable<ListJobsResponse> {
    private final BatchClient client;
    private final ListJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobsIterable(BatchClient client, ListJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public Iterator<ListJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobSummary> jobSummaryList() {
        Function<ListJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaryList() != null) {
                return response.jobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobsResponseFetcher
    implements SyncPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobsResponse nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsIterable.this.client.listJobs(ListJobsIterable.this.firstRequest);
            }
            return ListJobsIterable.this.client.listJobs((ListJobsRequest)((Object)ListJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

