/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.osmand.util.Algorithms;

public class TurnType {
    public static final int C = 1;
    public static final int TL = 2;
    public static final int TSLL = 3;
    public static final int TSHL = 4;
    public static final int TR = 5;
    public static final int TSLR = 6;
    public static final int TSHR = 7;
    public static final int KL = 8;
    public static final int KR = 9;
    public static final int TU = 10;
    public static final int TRU = 11;
    public static final int OFFR = 12;
    public static final int RNDB = 13;
    public static final int RNLB = 14;
    private static final int[] TURNS_ORDER = new int[]{10, 4, 2, 3, 1, 6, 5, 7, 11};
    private final int value;
    private int exitOut;
    private float turnAngle;
    private boolean skipToSpeak;
    private int[] lanes;
    private boolean possiblyLeftTurn;
    private boolean possiblyRightTurn;
    private List<Float> otherTurnAngles;

    public static TurnType straight() {
        return TurnType.valueOf(1, false);
    }

    public int getActiveCommonLaneTurn() {
        if (this.lanes == null || this.lanes.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.lanes.length; ++i) {
            if (this.lanes[i] % 2 != 1) continue;
            return TurnType.getPrimaryTurn(this.lanes[i]);
        }
        return -1;
    }

    public String toXmlString() {
        switch (this.value) {
            case 1: {
                return "C";
            }
            case 2: {
                return "TL";
            }
            case 3: {
                return "TSLL";
            }
            case 4: {
                return "TSHL";
            }
            case 5: {
                return "TR";
            }
            case 6: {
                return "TSLR";
            }
            case 7: {
                return "TSHR";
            }
            case 8: {
                return "KL";
            }
            case 9: {
                return "KR";
            }
            case 10: {
                return "TU";
            }
            case 11: {
                return "TRU";
            }
            case 12: {
                return "OFFR";
            }
            case 13: {
                return "RNDB" + this.exitOut;
            }
            case 14: {
                return "RNLB" + this.exitOut;
            }
        }
        return "C";
    }

    public static TurnType fromString(String s, boolean leftSide) {
        TurnType t = null;
        if ("C".equals(s)) {
            t = TurnType.valueOf(1, leftSide);
        } else if ("TL".equals(s)) {
            t = TurnType.valueOf(2, leftSide);
        } else if ("TSLL".equals(s)) {
            t = TurnType.valueOf(3, leftSide);
        } else if ("TSHL".equals(s)) {
            t = TurnType.valueOf(4, leftSide);
        } else if ("TR".equals(s)) {
            t = TurnType.valueOf(5, leftSide);
        } else if ("TSLR".equals(s)) {
            t = TurnType.valueOf(6, leftSide);
        } else if ("TSHR".equals(s)) {
            t = TurnType.valueOf(7, leftSide);
        } else if ("KL".equals(s)) {
            t = TurnType.valueOf(8, leftSide);
        } else if ("KR".equals(s)) {
            t = TurnType.valueOf(9, leftSide);
        } else if ("TU".equals(s)) {
            t = TurnType.valueOf(10, leftSide);
        } else if ("TRU".equals(s)) {
            t = TurnType.valueOf(11, leftSide);
        } else if ("OFFR".equals(s)) {
            t = TurnType.valueOf(12, leftSide);
        } else if (s != null && (s.startsWith("EXIT") || s.startsWith("RNDB") || s.startsWith("RNLB"))) {
            try {
                int type = s.contains("RNLB") ? 14 : 13;
                t = TurnType.getExitTurn(type, Integer.parseInt(s.substring(4)), 0.0f, leftSide);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (t == null) {
            t = TurnType.straight();
        }
        return t;
    }

    public static TurnType valueOf(int vs, boolean leftSide) {
        if (vs == 10 && leftSide) {
            vs = 11;
        } else if (vs == 13 && leftSide) {
            vs = 14;
        }
        return new TurnType(vs);
    }

    public TurnType(int value, int exitOut, float turnAngle, boolean skipToSpeak, int[] lanes, boolean possiblyLeftTurn, boolean possiblyRightTurn) {
        this.value = value;
        this.exitOut = exitOut;
        this.turnAngle = turnAngle;
        this.skipToSpeak = skipToSpeak;
        this.lanes = lanes;
        this.possiblyLeftTurn = possiblyLeftTurn;
        this.possiblyRightTurn = possiblyRightTurn;
    }

    public static TurnType getExitTurn(int out, float angle, boolean leftSide) {
        TurnType r = TurnType.valueOf(13, leftSide);
        r.exitOut = out;
        r.setTurnAngle(angle);
        return r;
    }

    private static TurnType getExitTurn(int type, int out, float angle, boolean leftSide) {
        if (type != 13 && type != 14) {
            return TurnType.getExitTurn(out, angle, leftSide);
        }
        TurnType r = TurnType.valueOf(type, leftSide);
        r.exitOut = out;
        r.setTurnAngle(angle);
        return r;
    }

    private TurnType(int vl) {
        this.value = vl;
    }

    public float getTurnAngle() {
        return this.turnAngle;
    }

    public boolean isLeftSide() {
        return this.value == 14 || this.value == 11;
    }

    public void setExitOut(int exitOut) {
        this.exitOut = exitOut;
    }

    public void setTurnAngle(float turnAngle) {
        this.turnAngle = turnAngle;
    }

    public int getValue() {
        return this.value;
    }

    public int getExitOut() {
        return this.exitOut;
    }

    public boolean isRoundAbout() {
        return this.value == 13 || this.value == 14;
    }

    public void setLanes(int[] lanes) {
        this.lanes = lanes;
    }

    public static void setPrimaryTurnAndReset(int[] lanes, int lane, int turnType) {
        lanes[lane] = turnType << 1;
    }

    public static int getPrimaryTurn(int laneValue) {
        return laneValue >> 1 & 0xF;
    }

    public static void setSecondaryTurn(int[] lanes, int lane, int turnType) {
        int n = lane;
        lanes[n] = lanes[n] & 0xFFFFFE1F;
        int n2 = lane;
        lanes[n2] = lanes[n2] | turnType << 5;
    }

    public static void setPrimaryTurn(int[] lanes, int lane, int turnType) {
        int n = lane;
        lanes[n] = lanes[n] & 0xFFFFFFE1;
        int n2 = lane;
        lanes[n2] = lanes[n2] | turnType << 1;
    }

    public static int getSecondaryTurn(int laneValue) {
        return laneValue >> 5 & 0x1F;
    }

    public static void setPrimaryTurnShiftOthers(int[] lanes, int lane, int turnType) {
        int pt = TurnType.getPrimaryTurn(lanes[lane]);
        int st = TurnType.getSecondaryTurn(lanes[lane]);
        TurnType.setPrimaryTurnAndReset(lanes, lane, turnType);
        TurnType.setSecondaryTurn(lanes, lane, pt);
        TurnType.setTertiaryTurn(lanes, lane, st);
    }

    public static void setSecondaryToPrimary(int[] lanes, int lane) {
        int st = TurnType.getSecondaryTurn(lanes[lane]);
        int pt = TurnType.getPrimaryTurn(lanes[lane]);
        TurnType.setPrimaryTurn(lanes, lane, st);
        TurnType.setSecondaryTurn(lanes, lane, pt);
    }

    public static void setTertiaryToPrimary(int[] lanes, int lane) {
        int st = TurnType.getSecondaryTurn(lanes[lane]);
        int pt = TurnType.getPrimaryTurn(lanes[lane]);
        int tt = TurnType.getTertiaryTurn(lanes[lane]);
        TurnType.setPrimaryTurn(lanes, lane, tt);
        TurnType.setSecondaryTurn(lanes, lane, pt);
        TurnType.setTertiaryTurn(lanes, lane, st);
    }

    public static void setTertiaryTurn(int[] lanes, int lane, int turnType) {
        int n = lane;
        lanes[n] = lanes[n] & 0xFFFFC3FF;
        int n2 = lane;
        lanes[n2] = lanes[n2] | turnType << 10;
    }

    public static int getTertiaryTurn(int laneValue) {
        return laneValue >> 10;
    }

    public static String lanesToString(int[] lns) {
        StringBuilder s = new StringBuilder();
        for (int h = 0; h < lns.length; ++h) {
            int tt;
            int pt;
            if (h > 0) {
                s.append("|");
            }
            if (lns[h] % 2 == 1) {
                s.append("+");
            }
            if ((pt = TurnType.getPrimaryTurn(lns[h])) == 0) {
                pt = 1;
            }
            s.append(TurnType.valueOf(pt, false).toXmlString());
            int st = TurnType.getSecondaryTurn(lns[h]);
            if (st != 0) {
                s.append(",").append(TurnType.valueOf(st, false).toXmlString());
            }
            if ((tt = TurnType.getTertiaryTurn(lns[h])) == 0) continue;
            s.append(",").append(TurnType.valueOf(tt, false).toXmlString());
        }
        return s.toString();
    }

    public int countTurnTypeDirections(int type, boolean onlyActive) {
        if (this.lanes == null) {
            return 0;
        }
        int cnt = 0;
        for (int h = 0; h < this.lanes.length; ++h) {
            int tertiary;
            boolean active;
            boolean bl = active = this.lanes[h] % 2 == 1;
            if (onlyActive && !active) continue;
            int primary = TurnType.getPrimaryTurn(this.lanes[h]);
            if (primary == 0) {
                primary = 1;
            }
            if (primary == type) {
                ++cnt;
            }
            if (onlyActive) continue;
            int secondary = TurnType.getSecondaryTurn(this.lanes[h]);
            if (secondary == type) {
                ++cnt;
            }
            if ((tertiary = TurnType.getTertiaryTurn(this.lanes[h])) != type) continue;
            ++cnt;
        }
        return cnt;
    }

    public int countDirections() {
        HashSet<Integer> directions = new HashSet<Integer>();
        for (int h = 0; h < this.lanes.length; ++h) {
            int tertiary;
            int primary = TurnType.getPrimaryTurn(this.lanes[h]);
            if (primary == 0) {
                primary = 1;
            }
            directions.add(primary);
            int secondary = TurnType.getSecondaryTurn(this.lanes[h]);
            if (secondary > 0) {
                directions.add(secondary);
            }
            if ((tertiary = TurnType.getTertiaryTurn(this.lanes[h])) <= 0) continue;
            directions.add(tertiary);
        }
        return directions.size();
    }

    public static int[] lanesFromString(String lanesString) {
        if (Algorithms.isEmpty(lanesString)) {
            return null;
        }
        String[] lanesArr = lanesString.split("\\|");
        int[] lanes = new int[lanesArr.length];
        for (int l = 0; l < lanesArr.length; ++l) {
            String lane = lanesArr[l];
            String[] turns = lane.split(",");
            TurnType primaryTurn = null;
            TurnType secondaryTurn = null;
            TurnType tertiaryTurn = null;
            boolean plus = false;
            for (int i = 0; i < turns.length; ++i) {
                String turn = turns[i];
                if (i == 0) {
                    boolean bl = plus = turn.length() > 0 && turn.charAt(0) == '+';
                    if (plus) {
                        turn = turn.substring(1);
                    }
                    primaryTurn = TurnType.fromString(turn, false);
                    continue;
                }
                if (i == 1) {
                    secondaryTurn = TurnType.fromString(turn, false);
                    continue;
                }
                if (i != 2) continue;
                tertiaryTurn = TurnType.fromString(turn, false);
            }
            TurnType.setPrimaryTurnAndReset(lanes, l, primaryTurn.value);
            if (secondaryTurn != null) {
                TurnType.setSecondaryTurn(lanes, l, secondaryTurn.value);
            }
            if (tertiaryTurn != null) {
                TurnType.setTertiaryTurn(lanes, l, tertiaryTurn.value);
            }
            if (!plus) continue;
            int n = l;
            lanes[n] = lanes[n] | 1;
        }
        return lanes;
    }

    public int[] getLanes() {
        return this.lanes;
    }

    public void setPossibleLeftTurn(boolean possiblyLeftTurn) {
        this.possiblyLeftTurn = possiblyLeftTurn;
    }

    public void setPossibleRightTurn(boolean possiblyRightTurn) {
        this.possiblyRightTurn = possiblyRightTurn;
    }

    public boolean isPossibleLeftTurn() {
        return this.possiblyLeftTurn;
    }

    public boolean isPossibleRightTurn() {
        return this.possiblyRightTurn;
    }

    public boolean keepLeft() {
        return this.value == 8;
    }

    public boolean keepRight() {
        return this.value == 9;
    }

    public boolean goAhead() {
        return this.value == 1;
    }

    public boolean isSkipToSpeak() {
        return this.skipToSpeak;
    }

    public void setSkipToSpeak(boolean skipToSpeak) {
        this.skipToSpeak = skipToSpeak;
    }

    public String toString() {
        Object vl = null;
        if (this.isRoundAbout()) {
            vl = "Take " + this.getExitOut() + " exit";
        } else if (this.value == 1) {
            vl = "Go ahead";
        } else if (this.value == 3) {
            vl = "Turn slightly left";
        } else if (this.value == 2) {
            vl = "Turn left";
        } else if (this.value == 4) {
            vl = "Turn sharply left";
        } else if (this.value == 6) {
            vl = "Turn slightly right";
        } else if (this.value == 5) {
            vl = "Turn right";
        } else if (this.value == 7) {
            vl = "Turn sharply right";
        } else if (this.value == 10) {
            vl = "Make uturn";
        } else if (this.value == 11) {
            vl = "Make uturn";
        } else if (this.value == 8) {
            vl = "Keep left";
        } else if (this.value == 9) {
            vl = "Keep right";
        } else if (this.value == 12) {
            vl = "Off route";
        }
        if (vl != null) {
            if (this.lanes != null && this.lanes.length > 0) {
                vl = (String)vl + " (" + TurnType.lanesToString(this.lanes) + ")";
            }
            return vl;
        }
        return super.toString();
    }

    public static boolean isLeftTurn(int type) {
        return type == 2 || type == 4 || type == 3 || type == 10 || type == 8;
    }

    public static boolean isLeftTurnNoUTurn(int type) {
        return type == 2 || type == 4 || type == 3 || type == 8;
    }

    public static boolean isRightTurn(int type) {
        return type == 5 || type == 7 || type == 6 || type == 11 || type == 9;
    }

    public static boolean isRightTurnNoUTurn(int type) {
        return type == 5 || type == 7 || type == 6 || type == 9;
    }

    public static boolean isSlightTurn(int type) {
        return type == 3 || type == 6 || type == 1 || type == 8 || type == 9;
    }

    public static boolean isKeepDirectionTurn(int type) {
        return type == 1 || type == 8 || type == 9;
    }

    public static boolean isSharpOrReverse(int type) {
        return type == 4 || type == 7 || type == 10 || type == 11;
    }

    public static boolean isSharpLeftOrUTurn(int type) {
        return type == 4 || type == 10;
    }

    public static boolean isSharpRightOrUTurn(int type) {
        return type == 7 || type == 11 || type == 10;
    }

    public static boolean hasAnySlightTurnLane(int type) {
        return TurnType.isSlightTurn(TurnType.getPrimaryTurn(type)) || TurnType.isSlightTurn(TurnType.getSecondaryTurn(type)) || TurnType.isSlightTurn(TurnType.getTertiaryTurn(type));
    }

    public static boolean hasAnyTurnLane(int type, int turn) {
        return TurnType.getPrimaryTurn(type) == turn || TurnType.getSecondaryTurn(type) == turn || TurnType.getTertiaryTurn(type) == turn;
    }

    public static void collectTurnTypes(int lane, LinkedHashSet<Integer> set) {
        int pt = TurnType.getPrimaryTurn(lane);
        if (pt != 0) {
            set.add(pt);
        }
        if ((pt = TurnType.getSecondaryTurn(lane)) != 0) {
            set.add(pt);
        }
        if ((pt = TurnType.getTertiaryTurn(lane)) != 0) {
            set.add(pt);
        }
    }

    public static int orderFromLeftToRight(int type) {
        switch (type) {
            case 10: {
                return -5;
            }
            case 4: {
                return -4;
            }
            case 2: {
                return -3;
            }
            case 3: {
                return -2;
            }
            case 8: {
                return -1;
            }
            case 11: {
                return 5;
            }
            case 7: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 9: {
                return 1;
            }
        }
        return 0;
    }

    public static int convertType(String lane) {
        int turn = lane.equals("merge_to_left") ? 1 : (lane.equals("merge_to_right") ? 1 : (lane.equals("none") || lane.equals("through") ? 1 : (lane.equals("slight_right") ? 6 : (lane.equals("slight_left") ? 3 : (lane.equals("right") ? 5 : (lane.equals("left") ? 2 : (lane.equals("sharp_right") ? 7 : (lane.equals("sharp_left") ? 4 : (lane.equals("reverse") ? 10 : 1)))))))));
        return turn;
    }

    public static int getPrev(int turn) {
        for (int i = TURNS_ORDER.length - 1; i >= 0; --i) {
            int t = TURNS_ORDER[i];
            if (t != turn || i <= 0) continue;
            return TURNS_ORDER[i - 1];
        }
        return turn;
    }

    public static int getNext(int turn) {
        for (int i = 0; i < TURNS_ORDER.length; ++i) {
            int t = TURNS_ORDER[i];
            if (t != turn || i + 1 >= TURNS_ORDER.length) continue;
            return TURNS_ORDER[i + 1];
        }
        return turn;
    }

    public List<Float> getOtherTurnAngles() {
        return this.otherTurnAngles;
    }

    public void setOtherTurnAngles(List<Float> turnAngles) {
        this.otherTurnAngles = turnAngles;
    }
}

