/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import net.osmand.util.CollectionUtils;

public class PointAttributes {
    public static final String SENSOR_TAG_HEART_RATE = "gpxtpx:hr";
    public static final String SENSOR_TAG_SPEED = "osmand:speed_sensor";
    public static final String SENSOR_TAG_CADENCE = "gpxtpx:cad";
    public static final String SENSOR_TAG_BIKE_POWER = "gpxtpx:power";
    public static final String SENSOR_TAG_TEMPERATURE = "temp_sensor";
    public static final String SENSOR_TAG_TEMPERATURE_W = "gpxtpx:wtemp";
    public static final String SENSOR_TAG_TEMPERATURE_A = "gpxtpx:atemp";
    public static final String SENSOR_TAG_DISTANCE = "osmand:bike_distance_sensor";
    public static final String DEV_RAW_ZOOM = "raw_zoom";
    public static final String DEV_ANIMATED_ZOOM = "animated_zoom";
    public static final String DEV_INTERPOLATION_OFFSET_N = "offset";
    public float distance;
    public final float timeDiff;
    public final boolean firstPoint;
    public final boolean lastPoint;
    public float speed;
    public float elevation;
    public float heartRate;
    public float sensorSpeed;
    public float bikeCadence;
    public float bikePower;
    public float waterTemperature;
    public float airTemperature;
    public float rawZoom;
    public float animatedZoom;
    public float interpolationOffsetN;

    public PointAttributes(float distance, float timeDiff, boolean firstPoint, boolean lastPoint) {
        this.distance = distance;
        this.timeDiff = timeDiff;
        this.firstPoint = firstPoint;
        this.lastPoint = lastPoint;
    }

    public Float getAttributeValue(String tag) {
        switch (tag) {
            case "speed": {
                return Float.valueOf(this.speed);
            }
            case "ele": {
                return Float.valueOf(this.elevation);
            }
            case "gpxtpx:hr": {
                return Float.valueOf(this.heartRate);
            }
            case "osmand:speed_sensor": {
                return Float.valueOf(this.sensorSpeed);
            }
            case "gpxtpx:cad": {
                return Float.valueOf(this.bikeCadence);
            }
            case "gpxtpx:power": {
                return Float.valueOf(this.bikePower);
            }
            case "temp_sensor": {
                return Float.valueOf(this.getTemperature());
            }
            case "gpxtpx:wtemp": {
                return Float.valueOf(this.waterTemperature);
            }
            case "gpxtpx:atemp": {
                return Float.valueOf(this.airTemperature);
            }
            case "raw_zoom": {
                return Float.valueOf(this.rawZoom);
            }
            case "animated_zoom": {
                return Float.valueOf(this.animatedZoom);
            }
            case "offset": {
                return Float.valueOf(this.interpolationOffsetN);
            }
        }
        return null;
    }

    public void setAttributeValue(String tag, float value) {
        switch (tag) {
            case "speed": {
                this.speed = value;
                break;
            }
            case "ele": {
                this.elevation = value;
                break;
            }
            case "gpxtpx:hr": {
                this.heartRate = value;
                break;
            }
            case "osmand:speed_sensor": {
                this.sensorSpeed = value;
                break;
            }
            case "gpxtpx:cad": {
                this.bikeCadence = value;
                break;
            }
            case "gpxtpx:power": {
                this.bikePower = value;
                break;
            }
            case "gpxtpx:wtemp": {
                this.waterTemperature = value;
                break;
            }
            case "gpxtpx:atemp": {
                this.airTemperature = value;
                break;
            }
            case "raw_zoom": {
                this.rawZoom = value;
                break;
            }
            case "animated_zoom": {
                this.animatedZoom = value;
                break;
            }
            case "offset": {
                this.interpolationOffsetN = value;
            }
        }
    }

    public float getTemperature() {
        if (!Float.isNaN(this.airTemperature)) {
            return !Float.isNaN(this.waterTemperature) ? Math.max(this.waterTemperature, this.airTemperature) : this.airTemperature;
        }
        return this.waterTemperature;
    }

    public boolean hasValidValue(String tag) {
        float value = this.getAttributeValue(tag).floatValue();
        if (CollectionUtils.equalsToAny(tag, SENSOR_TAG_TEMPERATURE, SENSOR_TAG_TEMPERATURE_W, SENSOR_TAG_TEMPERATURE_A, "ele")) {
            return !Float.isNaN(value);
        }
        return value > 0.0f;
    }
}

