/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.map;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import net.osmand.Collator;
import net.osmand.OsmAndCollator;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.map.WorldRegion;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class OsmandRegions {
    public static final String MAP_TYPE = "region_map";
    public static final String ROADS_TYPE = "region_roads";
    public static final String MAP_JOIN_TYPE = "region_join_map";
    public static final String ROADS_JOIN_TYPE = "region_join_roads";
    public static final String FIELD_DOWNLOAD_NAME = "download_name";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NAME_EN = "name:en";
    public static final String FIELD_REGION_PARENT_NAME = "region_parent_name";
    public static final String FIELD_REGION_FULL_NAME = "region_full_name";
    public static final String FIELD_LANG = "region_lang";
    public static final String FIELD_METRIC = "region_metric";
    public static final String FIELD_ROAD_SIGNS = "region_road_signs";
    public static final String FIELD_LEFT_HAND_DRIVING = "region_left_hand_navigation";
    public static final String FIELD_WIKI_LINK = "region_wiki_link";
    public static final String FIELD_POPULATION = "region_population";
    public static final String LOCALE_NAME_DEFAULT_FORMAT = "%1$s %2$s";
    public static final String LOCALE_NAME_REVERSED_FORMAT = "%2$s, %1$s";
    private BinaryMapIndexReader reader;
    private String locale = "en";
    private String locale2 = null;
    private static final Log LOG = PlatformUtil.getLog(OsmandRegions.class);
    WorldRegion worldRegion = new WorldRegion("world");
    Map<String, WorldRegion> fullNamesToRegionData = new HashMap<String, WorldRegion>();
    Map<String, String> downloadNamesToFullNames = new HashMap<String, String>();
    Map<String, LinkedList<BinaryMapDataObject>> countriesByDownloadName = new HashMap<String, LinkedList<BinaryMapDataObject>>();
    QuadTree<String> quadTree;
    MapIndexFields mapIndexFields;
    RegionTranslation translator;

    public void setTranslator(RegionTranslation translator) {
        this.translator = translator;
    }

    public BinaryMapIndexReader prepareFile() throws IOException {
        File regions = new File("regions.ocbf");
        InputStream is = OsmandRegions.class.getResourceAsStream("regions.ocbf");
        FileOutputStream fous = new FileOutputStream(regions);
        Algorithms.streamCopy(is, fous);
        fous.close();
        return this.prepareFile(regions.getAbsolutePath());
    }

    public BinaryMapIndexReader prepareFile(String fileName) throws IOException {
        this.reader = new BinaryMapIndexReader(new RandomAccessFile(fileName, "r"), new File(fileName));
        final LinkedHashMap parentRelations = new LinkedHashMap();
        final HashMap unattachedBoundaryMapObjectsByRegions = new HashMap();
        ResultMatcher<BinaryMapDataObject> resultMatcher = new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                int[] types;
                OsmandRegions.this.initTypes(object);
                boolean boundary = false;
                for (int type : types = object.getTypes()) {
                    BinaryMapIndexReader.TagValuePair tp = object.getMapIndex().decodeType(type);
                    if (!"boundary".equals(tp.value)) continue;
                    boundary = true;
                    break;
                }
                if (boundary) {
                    String fullRegionName = OsmandRegions.this.getFullName(object);
                    WorldRegion region = OsmandRegions.this.fullNamesToRegionData.get(fullRegionName);
                    if (region != null) {
                        OsmandRegions.this.addPolygonToRegionIfValid(object, region);
                    } else {
                        ArrayList<BinaryMapDataObject> unattachedMapObjects = (ArrayList<BinaryMapDataObject>)unattachedBoundaryMapObjectsByRegions.get(fullRegionName);
                        if (unattachedMapObjects == null) {
                            unattachedMapObjects = new ArrayList<BinaryMapDataObject>();
                            unattachedBoundaryMapObjectsByRegions.put(fullRegionName, unattachedMapObjects);
                        }
                        unattachedMapObjects.add(object);
                    }
                    return false;
                }
                WorldRegion region = OsmandRegions.this.initRegionData(parentRelations, object);
                if (region == null) {
                    return false;
                }
                List unattachedMapObjects = (List)unattachedBoundaryMapObjectsByRegions.get(region.regionFullName);
                if (unattachedMapObjects != null) {
                    for (BinaryMapDataObject mapObject : unattachedMapObjects) {
                        OsmandRegions.this.addPolygonToRegionIfValid(mapObject, region);
                    }
                    unattachedBoundaryMapObjectsByRegions.remove(region.regionFullName);
                }
                if (region.regionDownloadName != null) {
                    OsmandRegions.this.downloadNamesToFullNames.put(region.regionDownloadName, region.regionFullName);
                }
                OsmandRegions.this.fullNamesToRegionData.put(region.regionFullName, region);
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        this.iterateOverAllObjects(resultMatcher);
        for (Map.Entry e : parentRelations.entrySet()) {
            String fullName = (String)e.getKey();
            String parentFullName = (String)e.getValue();
            WorldRegion rd = this.fullNamesToRegionData.get(fullName);
            WorldRegion parent = this.fullNamesToRegionData.get(parentFullName);
            if (parent == null || rd == null) continue;
            parent.addSubregion(rd);
        }
        this.structureWorldRegions(new ArrayList<WorldRegion>(this.fullNamesToRegionData.values()));
        return this.reader;
    }

    public boolean containsCountry(String name) {
        return this.countriesByDownloadName.containsKey(name);
    }

    public String getLocaleName(String downloadName, boolean includingParent) {
        return this.getLocaleName(downloadName, includingParent, false);
    }

    public String getLocaleName(String downloadName, boolean includingParent, boolean reversed) {
        return this.getLocaleName(downloadName, includingParent, null, reversed);
    }

    public String getLocaleName(String downloadName, boolean includingParent, WorldRegion baseParentRegion, boolean reversed) {
        String divider = reversed ? ", " : " ";
        return this.getLocaleName(downloadName, divider, includingParent, baseParentRegion, reversed);
    }

    public String getLocaleName(String downloadName, String divider, boolean includingParent, boolean reversed) {
        return this.getLocaleName(downloadName, divider, includingParent, null, reversed);
    }

    public String getLocaleName(String downloadName, String divider, boolean includingParent, WorldRegion baseParentRegion, boolean reversed) {
        String lc = downloadName.toLowerCase();
        if (this.downloadNamesToFullNames.containsKey(lc)) {
            String fullName = this.downloadNamesToFullNames.get(lc);
            return this.getLocaleNameByFullName(fullName, divider, includingParent, baseParentRegion, reversed);
        }
        return downloadName.replace('_', ' ');
    }

    public String getLocaleNameByFullName(String fullName, String divider, boolean includingParent, boolean reversed) {
        return this.getLocaleNameByFullName(fullName, divider, includingParent, null, reversed);
    }

    public String getLocaleNameByFullName(String fullName, String divider, boolean includingParent, WorldRegion baseParentRegion, boolean reversed) {
        WorldRegion region = this.fullNamesToRegionData.get(fullName);
        if (region == null) {
            return fullName.replace('_', ' ');
        }
        String regionName = region.getLocaleName();
        if (includingParent && region.getSuperregion() != null) {
            List<WorldRegion> superRegions;
            WorldRegion parent = region.getSuperregion();
            WorldRegion parentParent = parent.getSuperregion();
            if (parentParent != null) {
                String parentParentId = parentParent.getRegionId();
                if ("world".equals(parentParentId) && !parent.getRegionId().equals("russia")) {
                    return regionName;
                }
                if ("russia".equals(parentParentId) || "japan_asia".equals(parentParentId)) {
                    String format = reversed ? LOCALE_NAME_REVERSED_FORMAT : LOCALE_NAME_DEFAULT_FORMAT;
                    return String.format(format, parentParent.getLocaleName(), regionName);
                }
            }
            if (!Algorithms.isEmpty(superRegions = region.getSuperRegions(baseParentRegion))) {
                return this.getLocaleNameWithParent(superRegions, regionName, divider, reversed);
            }
        }
        return regionName;
    }

    private String getLocaleNameWithParent(List<WorldRegion> superRegions, String regionName, String divider, boolean reversed) {
        StringBuilder builder = new StringBuilder();
        List<String> topRegionsIds = this.getTopRegionsIds();
        if (reversed) {
            builder.append(regionName);
            for (WorldRegion region : superRegions) {
                String regionId = region.getRegionId();
                if (topRegionsIds.contains(regionId) && !"russia".equals(regionId) || "world".equals(regionId)) continue;
                builder.append(divider).append(region.getLocaleName());
            }
        } else {
            ListIterator<WorldRegion> iterator = superRegions.listIterator(superRegions.size());
            while (iterator.hasPrevious()) {
                WorldRegion region = iterator.previous();
                String regionId = region.getRegionId();
                if (topRegionsIds.contains(regionId) && !"russia".equals(regionId) || "world".equals(regionId)) continue;
                builder.append(region.getLocaleName()).append(divider);
            }
            builder.append(regionName);
        }
        return builder.toString();
    }

    public WorldRegion getWorldRegion() {
        return this.worldRegion;
    }

    public boolean isInitialized() {
        return this.reader != null;
    }

    public static boolean contain(BinaryMapDataObject bo, int tx, int ty) {
        int t = 0;
        for (int i = 1; i < bo.getPointsLength(); ++i) {
            int fx = MapAlgorithms.ray_intersect_x(bo.getPoint31XTile(i - 1), bo.getPoint31YTile(i - 1), bo.getPoint31XTile(i), bo.getPoint31YTile(i), ty);
            if (Integer.MIN_VALUE == fx || tx < fx) continue;
            ++t;
        }
        return t % 2 == 1;
    }

    public static boolean intersect(BinaryMapDataObject bo, int lx, int ty, int rx, int by) {
        if (OsmandRegions.contain(bo, lx, ty)) {
            return true;
        }
        if (bo.getPointsLength() == 0) {
            return false;
        }
        if (bo.getPoint31XTile(0) >= lx && bo.getPoint31XTile(0) <= rx && bo.getPoint31YTile(0) >= ty && bo.getPoint31YTile(0) <= by) {
            return true;
        }
        for (int i = 1; i < bo.getPointsLength(); ++i) {
            long in;
            int px = bo.getPoint31XTile(i - 1);
            int x = bo.getPoint31XTile(i);
            int py = bo.getPoint31YTile(i - 1);
            int y = bo.getPoint31YTile(i);
            if (x < lx && px < lx || x > rx && px > rx || y > by && py > by || y < ty && py < ty || (in = MapAlgorithms.calculateIntersection(px, py, x, y, lx, rx, by, ty)) == -1L) continue;
            return true;
        }
        return false;
    }

    public static double getArea(BinaryMapDataObject bo) {
        double area = 0.0;
        if (bo.getPointsLength() > 0) {
            for (int i = 1; i < bo.getPointsLength(); ++i) {
                double ax = bo.getPoint31XTile(i - 1);
                double bx = bo.getPoint31XTile(i);
                double ay = bo.getPoint31YTile(i - 1);
                double by = bo.getPoint31YTile(i);
                area += (bx + ax) * (by - ay) / 1.631E10;
            }
        }
        return Math.abs(area);
    }

    private List<BinaryMapDataObject> getCountries(int lx, int rx, int ty, int by, boolean checkCenter) throws IOException {
        HashSet<String> set = new HashSet<String>(this.quadTree.queryInBox(new QuadRect(lx, ty, rx, by), new ArrayList()));
        ArrayList<BinaryMapDataObject> result = new ArrayList<BinaryMapDataObject>();
        Iterator<String> it = set.iterator();
        int mx = lx / 2 + rx / 2;
        int my = ty / 2 + by / 2;
        while (it.hasNext()) {
            String cname = it.next();
            BinaryMapDataObject container = null;
            int count = 0;
            for (BinaryMapDataObject bo : this.countriesByDownloadName.get(cname)) {
                if (checkCenter && !OsmandRegions.contain(bo, mx, my)) continue;
                ++count;
                container = bo;
                break;
            }
            if (count % 2 != 1) continue;
            result.add(container);
        }
        return result;
    }

    public String getCountryName(LatLon ll) {
        double lat = ll.getLatitude();
        double lon = ll.getLongitude();
        int y = MapUtils.get31TileNumberY(lat);
        int x = MapUtils.get31TileNumberX(lon);
        try {
            List<BinaryMapDataObject> list = this.query(x, y);
            for (BinaryMapDataObject o : list) {
                String name;
                if (!OsmandRegions.contain(o, x, y) || (name = this.mapIndexFields.get(this.mapIndexFields.nameType, o)) == null) continue;
                return name;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<BinaryMapDataObject> query(int lx, int rx, int ty, int by) throws IOException {
        return this.query(lx, rx, ty, by, true);
    }

    public List<BinaryMapDataObject> query(int lx, int rx, int ty, int by, boolean checkCenter) throws IOException {
        if (this.quadTree != null) {
            return this.getCountries(lx, rx, ty, by, checkCenter);
        }
        return this.queryBboxNoInit(lx, rx, ty, by, checkCenter);
    }

    public List<BinaryMapDataObject> query(int tile31x, int tile31y) throws IOException {
        if (this.quadTree != null) {
            return this.getCountries(tile31x, tile31x, tile31y, tile31y, true);
        }
        return this.queryBboxNoInit(tile31x, tile31x, tile31y, tile31y, true);
    }

    private synchronized List<BinaryMapDataObject> queryBboxNoInit(int lx, int rx, int ty, int by, final boolean checkCenter) throws IOException {
        final ArrayList<BinaryMapDataObject> result = new ArrayList<BinaryMapDataObject>();
        final int mx = lx / 2 + rx / 2;
        final int my = ty / 2 + by / 2;
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> sr = BinaryMapIndexReader.buildSearchRequest(lx, rx, ty, by, 5, new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                if (object.getPointsLength() < 1) {
                    return false;
                }
                OsmandRegions.this.initTypes(object);
                if (!checkCenter || OsmandRegions.contain(object, mx, my)) {
                    result.add(object);
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        sr.log = false;
        if (this.reader == null) {
            throw new IOException("Reader == null");
        }
        this.reader.searchMapIndex(sr);
        return result;
    }

    public void setLocale(String locale) {
        this.setLocale(locale, null);
    }

    public void setLocale(String locale, String country) {
        this.locale = locale;
        if ("zh".equals(locale)) {
            if ("TW".equalsIgnoreCase(country)) {
                this.locale2 = "zh-hant";
            } else if ("CN".equalsIgnoreCase(country)) {
                this.locale2 = "zh-hans";
            }
        }
    }

    public WorldRegion getRegionData(String fullName) {
        if ("world".equals(fullName)) {
            return this.worldRegion;
        }
        return this.fullNamesToRegionData.get(fullName);
    }

    public WorldRegion getCountryRegionDataByDownloadName(String downloadName) {
        WorldRegion region = this.getRegionDataByDownloadName(downloadName);
        return region != null ? region.getCountryRegion() : null;
    }

    public WorldRegion getRegionDataByDownloadName(String downloadName) {
        if (downloadName == null) {
            return null;
        }
        return this.getRegionData(this.downloadNamesToFullNames.get(downloadName.toLowerCase()));
    }

    public String getDownloadName(BinaryMapDataObject o) {
        return this.mapIndexFields.get(this.mapIndexFields.downloadNameType, o);
    }

    public String getFullName(BinaryMapDataObject o) {
        return this.mapIndexFields.get(this.mapIndexFields.fullNameType, o);
    }

    public List<String> getFlattenedWorldRegionIds() {
        ArrayList<String> regionIds = new ArrayList<String>();
        for (WorldRegion region : this.getFlattenedWorldRegions()) {
            regionIds.add(region.getRegionId());
        }
        return regionIds;
    }

    public List<WorldRegion> getFlattenedWorldRegions() {
        ArrayList<WorldRegion> result = new ArrayList<WorldRegion>();
        result.add(this.getWorldRegion());
        result.addAll(this.getAllRegionData());
        return result;
    }

    public List<WorldRegion> getAllRegionData() {
        return new ArrayList<WorldRegion>(this.fullNamesToRegionData.values());
    }

    private WorldRegion initRegionData(Map<String, String> parentRelations, BinaryMapDataObject object) {
        String regionDownloadName = this.mapIndexFields.get(this.mapIndexFields.downloadNameType, object);
        String regionFullName = this.mapIndexFields.get(this.mapIndexFields.fullNameType, object);
        if (Algorithms.isEmpty(regionFullName)) {
            return null;
        }
        WorldRegion rd = new WorldRegion(regionFullName, regionDownloadName);
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < object.getPointsLength(); ++i) {
            cx += (double)object.getPoint31XTile(i);
            cy += (double)object.getPoint31YTile(i);
        }
        if (object.getPointsLength() > 0) {
            rd.regionCenter = new LatLon(MapUtils.get31LatitudeY((int)(cy /= (double)object.getPointsLength())), MapUtils.get31LongitudeX((int)(cx /= (double)object.getPointsLength())));
            this.findBoundaries(rd, object);
        }
        rd.regionParentFullName = this.mapIndexFields.get(this.mapIndexFields.parentFullName, object);
        if (!Algorithms.isEmpty(rd.regionParentFullName)) {
            parentRelations.put(rd.regionFullName, rd.regionParentFullName);
        }
        rd.regionName = this.mapIndexFields.get(this.mapIndexFields.nameType, object);
        if (this.mapIndexFields.nameLocale2Type != null) {
            rd.regionNameLocale = this.mapIndexFields.get(this.mapIndexFields.nameLocale2Type, object);
        }
        if (rd.regionNameLocale == null) {
            rd.regionNameLocale = this.mapIndexFields.get(this.mapIndexFields.nameLocaleType, object);
        }
        rd.regionNameEn = this.mapIndexFields.get(this.mapIndexFields.nameEnType, object);
        rd.params.regionLang = this.mapIndexFields.get(this.mapIndexFields.langType, object);
        rd.params.regionLeftHandDriving = this.mapIndexFields.get(this.mapIndexFields.leftHandDrivingType, object);
        rd.params.regionMetric = this.mapIndexFields.get(this.mapIndexFields.metricType, object);
        rd.params.regionRoadSigns = this.mapIndexFields.get(this.mapIndexFields.roadSignsType, object);
        rd.params.wikiLink = this.mapIndexFields.get(this.mapIndexFields.wikiLinkType, object);
        rd.params.population = this.mapIndexFields.get(this.mapIndexFields.populationType, object);
        rd.regionSearchText = this.getSearchIndex(object);
        rd.regionMapDownload = this.isDownloadOfType(object, MAP_TYPE);
        rd.regionRoadsDownload = this.isDownloadOfType(object, ROADS_TYPE);
        rd.regionJoinMapDownload = this.isDownloadOfType(object, MAP_JOIN_TYPE);
        rd.regionJoinRoadsDownload = this.isDownloadOfType(object, ROADS_JOIN_TYPE);
        return rd;
    }

    private void findBoundaries(WorldRegion rd, BinaryMapDataObject object) {
        if (object.getPointsLength() == 0) {
            return;
        }
        ArrayList<LatLon> polygon = new ArrayList<LatLon>();
        double x = MapUtils.get31LongitudeX(object.getPoint31XTile(0));
        double y = MapUtils.get31LatitudeY(object.getPoint31YTile(0));
        polygon.add(new LatLon(y, x));
        double minX = x;
        double maxX = x;
        double minY = y;
        double maxY = y;
        if (object.getPointsLength() > 1) {
            for (int i = 1; i < object.getPointsLength(); ++i) {
                x = MapUtils.get31LongitudeX(object.getPoint31XTile(i));
                y = MapUtils.get31LatitudeY(object.getPoint31YTile(i));
                if (x > maxX) {
                    maxX = x;
                } else if (x < minX) {
                    minX = x;
                }
                if (y < maxY) {
                    maxY = y;
                } else if (y > minY) {
                    minY = y;
                }
                polygon.add(new LatLon(y, x));
            }
        }
        rd.boundingBox = new QuadRect(minX, minY, maxX, maxY);
        rd.polygon = polygon;
    }

    private String getSearchIndex(BinaryMapDataObject object) {
        BinaryMapIndexReader.MapIndex mi = object.getMapIndex();
        TIntObjectIterator it = object.getObjectNames().iterator();
        StringBuilder ind = new StringBuilder();
        while (it.hasNext()) {
            String vl;
            it.advance();
            BinaryMapIndexReader.TagValuePair tp = mi.decodeType(it.key());
            if (!tp.tag.startsWith(FIELD_NAME) && !tp.tag.equals("key_name") && !tp.tag.startsWith("alt_name") && !tp.tag.startsWith("short_name") && !tp.tag.equals("name:abbreviation") && !tp.tag.equals("ref") || ind.indexOf(vl = ((String)it.value()).toLowerCase()) != -1 && !tp.tag.equals("ref")) continue;
            ind.append(" ").append(vl);
        }
        return ind.toString();
    }

    public boolean isDownloadOfType(BinaryMapDataObject object, String type) {
        int[] addtypes = object.getAdditionalTypes();
        for (int i = 0; i < addtypes.length; ++i) {
            BinaryMapIndexReader.TagValuePair tp = object.getMapIndex().decodeType(addtypes[i]);
            if (!type.equals(tp.tag) || !"yes".equals(tp.value)) continue;
            return true;
        }
        return false;
    }

    public Map<String, LinkedList<BinaryMapDataObject>> cacheAllCountries() throws IOException {
        return this.cacheAllCountries(true);
    }

    public Map<String, LinkedList<BinaryMapDataObject>> cacheAllCountries(final boolean useDownloadName) throws IOException {
        this.quadTree = new QuadTree(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 8, 0.55f);
        ResultMatcher<BinaryMapDataObject> resultMatcher = new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                if (object.getPointsLength() < 1) {
                    return false;
                }
                OsmandRegions.this.initTypes(object);
                String nm = OsmandRegions.this.mapIndexFields.get(useDownloadName ? OsmandRegions.this.mapIndexFields.downloadNameType : OsmandRegions.this.mapIndexFields.fullNameType, object);
                if (!OsmandRegions.this.countriesByDownloadName.containsKey(nm)) {
                    LinkedList<BinaryMapDataObject> ls = new LinkedList<BinaryMapDataObject>();
                    OsmandRegions.this.countriesByDownloadName.put(nm, ls);
                    ls.add(object);
                } else {
                    OsmandRegions.this.countriesByDownloadName.get(nm).add(object);
                }
                int maxx = object.getPoint31XTile(0);
                int maxy = object.getPoint31YTile(0);
                int minx = maxx;
                int miny = maxy;
                for (int i = 1; i < object.getPointsLength(); ++i) {
                    int x = object.getPoint31XTile(i);
                    int y = object.getPoint31YTile(i);
                    if (y < miny) {
                        miny = y;
                    } else if (y > maxy) {
                        maxy = y;
                    }
                    if (x < minx) {
                        minx = x;
                        continue;
                    }
                    if (x <= maxx) continue;
                    maxx = x;
                }
                OsmandRegions.this.quadTree.insert(nm, new QuadRect(minx, miny, maxx, maxy));
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        this.iterateOverAllObjects(resultMatcher);
        return this.countriesByDownloadName;
    }

    private synchronized void iterateOverAllObjects(ResultMatcher<BinaryMapDataObject> resultMatcher) throws IOException {
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> sr = BinaryMapIndexReader.buildSearchRequest(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, 5, new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, resultMatcher);
        if (this.reader != null) {
            this.reader.searchMapIndex(sr);
        }
    }

    private void initTypes(BinaryMapDataObject object) {
        if (this.mapIndexFields == null) {
            this.mapIndexFields = new MapIndexFields();
            this.mapIndexFields.downloadNameType = object.getMapIndex().getRule(FIELD_DOWNLOAD_NAME, null);
            this.mapIndexFields.nameType = object.getMapIndex().getRule(FIELD_NAME, null);
            this.mapIndexFields.nameEnType = object.getMapIndex().getRule(FIELD_NAME_EN, null);
            this.mapIndexFields.nameLocaleType = object.getMapIndex().getRule("name:" + this.locale, null);
            if (this.locale2 != null) {
                this.mapIndexFields.nameLocale2Type = object.getMapIndex().getRule("name:" + this.locale2, null);
            }
            this.mapIndexFields.parentFullName = object.getMapIndex().getRule(FIELD_REGION_PARENT_NAME, null);
            this.mapIndexFields.fullNameType = object.getMapIndex().getRule(FIELD_REGION_FULL_NAME, null);
            this.mapIndexFields.langType = object.getMapIndex().getRule(FIELD_LANG, null);
            this.mapIndexFields.metricType = object.getMapIndex().getRule(FIELD_METRIC, null);
            this.mapIndexFields.leftHandDrivingType = object.getMapIndex().getRule(FIELD_LEFT_HAND_DRIVING, null);
            this.mapIndexFields.roadSignsType = object.getMapIndex().getRule(FIELD_ROAD_SIGNS, null);
            this.mapIndexFields.wikiLinkType = object.getMapIndex().getRule(FIELD_WIKI_LINK, null);
            this.mapIndexFields.populationType = object.getMapIndex().getRule(FIELD_POPULATION, null);
        }
    }

    private static void testCountry(OsmandRegions or, double lat, double lon, String ... test) throws IOException {
        long t = System.currentTimeMillis();
        List<BinaryMapDataObject> cs = or.query(MapUtils.get31TileNumberX(lon), MapUtils.get31TileNumberY(lat));
        TreeSet<String> expected = new TreeSet<String>(Arrays.asList(test));
        TreeSet<String> found = new TreeSet<String>();
        for (BinaryMapDataObject b : cs) {
            String nm = b.getNameByType(or.mapIndexFields.nameEnType);
            if (nm == null) {
                nm = b.getName();
                System.out.println(or.getLocaleName(or.getDownloadName(b), false));
            }
            if (!or.isDownloadOfType(b, MAP_TYPE)) continue;
            found.add(nm.toLowerCase());
            String localName = b.getNameByType(or.mapIndexFields.nameLocaleType);
            if (or.mapIndexFields.nameLocale2Type != null) {
                localName = b.getNameByType(or.mapIndexFields.nameLocale2Type);
            }
            System.out.printf("Region %s %s%n", b.getName(), localName);
        }
        if (!found.equals(expected)) {
            throw new IllegalStateException(" Expected " + String.valueOf(expected) + " but was " + String.valueOf(found));
        }
        System.out.println("Found " + String.valueOf(expected) + " in " + (System.currentTimeMillis() - t) + " ms");
    }

    public static void main(String[] args) throws IOException {
        OsmandRegions or = new OsmandRegions();
        Locale tw = Locale.CHINA;
        or.setLocale(tw.getLanguage(), null);
        LinkedList<WorldRegion> lst = new LinkedList<WorldRegion>();
        lst.add(or.getWorldRegion());
        while (!lst.isEmpty()) {
            WorldRegion wd = (WorldRegion)lst.pollFirst();
            System.out.println((wd.superregion == null ? "" : wd.superregion.getLocaleName()) + " " + wd.getLocaleName() + " " + wd.getRegionDownloadName());
        }
        or.cacheAllCountries();
        OsmandRegions.testCountry(or, 53.882, 27.5726, "belarus", "minsk");
    }

    private void initWorldRegion(WorldRegion world, String id) {
        WorldRegion rg = new WorldRegion(id);
        rg.regionParentFullName = world.regionFullName;
        if (this.translator != null) {
            rg.regionName = this.translator.getTranslation(id);
        }
        world.addSubregion(rg);
    }

    private List<String> getTopRegionsIds() {
        ArrayList<String> regionIds = new ArrayList<String>();
        regionIds.add("antarctica");
        regionIds.add("africa");
        regionIds.add("asia");
        regionIds.add("centralamerica");
        regionIds.add("europe");
        regionIds.add("northamerica");
        regionIds.add("russia");
        regionIds.add("southamerica");
        regionIds.add("australia-oceania-all");
        return regionIds;
    }

    public void structureWorldRegions(List<WorldRegion> loadedItems) {
        if (loadedItems.size() == 0) {
            return;
        }
        WorldRegion world = new WorldRegion("world");
        for (String regionId : this.getTopRegionsIds()) {
            this.initWorldRegion(world, regionId);
        }
        Iterator<WorldRegion> it = loadedItems.iterator();
        while (it.hasNext()) {
            WorldRegion region = it.next();
            if (region.superregion == null) {
                boolean found = false;
                for (WorldRegion worldSubregion : world.subregions) {
                    if (!worldSubregion.getRegionId().equalsIgnoreCase(region.regionFullName)) continue;
                    for (WorldRegion rg : region.subregions) {
                        worldSubregion.addSubregion(rg);
                    }
                    found = true;
                    break;
                }
                if (found) {
                    it.remove();
                    continue;
                }
                if (region.getRegionId().contains("basemap")) {
                    it.remove();
                    continue;
                }
                if (!region.getRegionId().startsWith("World_")) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
        Comparator<WorldRegion> nameComparator = new Comparator<WorldRegion>(){
            final Collator collator = OsmAndCollator.primaryCollator();

            @Override
            public int compare(WorldRegion w1, WorldRegion w2) {
                return this.collator.compare(w1.getLocaleName(), w2.getLocaleName());
            }
        };
        this.sortSubregions(world, nameComparator);
        this.worldRegion = world;
        if (loadedItems.size() > 0) {
            LOG.warn((Object)("Found orphaned regions: " + loadedItems.size()));
            for (WorldRegion regionId : loadedItems) {
                LOG.warn((Object)("FullName = " + regionId.regionFullName + " parent=" + regionId.regionParentFullName));
            }
        }
    }

    private void sortSubregions(WorldRegion region, Comparator<WorldRegion> comparator) {
        Collections.sort(region.subregions, comparator);
        for (WorldRegion r : region.subregions) {
            if (r.subregions.size() <= 0) continue;
            this.sortSubregions(r, comparator);
        }
    }

    public List<WorldRegion> getWorldRegionsAt(LatLon latLon) throws IOException {
        return this.getWorldRegionsAt(latLon, false);
    }

    public List<WorldRegion> getWorldRegionsAt(LatLon latLon, boolean includeRoadRegions) throws IOException {
        Map<WorldRegion, BinaryMapDataObject> mapDataObjects = this.getBinaryMapDataObjectsWithRegionsAt(latLon, includeRoadRegions);
        return new ArrayList<WorldRegion>(mapDataObjects.keySet());
    }

    public Map.Entry<WorldRegion, BinaryMapDataObject> getSmallestBinaryMapDataObjectAt(LatLon latLon) throws IOException {
        Map<WorldRegion, BinaryMapDataObject> mapDataObjectsWithRegions = this.getBinaryMapDataObjectsWithRegionsAt(latLon);
        return this.getSmallestBinaryMapDataObjectAt(mapDataObjectsWithRegions);
    }

    public Map.Entry<WorldRegion, BinaryMapDataObject> getSmallestBinaryMapDataObjectAt(Map<WorldRegion, BinaryMapDataObject> mapDataObjectsWithRegions) {
        Map.Entry<WorldRegion, BinaryMapDataObject> res = null;
        double smallestArea = -1.0;
        for (Map.Entry<WorldRegion, BinaryMapDataObject> o : mapDataObjectsWithRegions.entrySet()) {
            double area = OsmandRegions.getArea(o.getValue());
            if (smallestArea == -1.0) {
                smallestArea = area;
                res = o;
                continue;
            }
            if (!(area < smallestArea)) continue;
            smallestArea = area;
            res = o;
        }
        return res;
    }

    private Map<WorldRegion, BinaryMapDataObject> getBinaryMapDataObjectsWithRegionsAt(LatLon latLon) throws IOException {
        return this.getBinaryMapDataObjectsWithRegionsAt(latLon, false);
    }

    private Map<WorldRegion, BinaryMapDataObject> getBinaryMapDataObjectsWithRegionsAt(LatLon latLon, boolean includeRoadRegions) throws IOException {
        List<BinaryMapDataObject> mapDataObjects;
        int point31x = MapUtils.get31TileNumberX(latLon.getLongitude());
        int point31y = MapUtils.get31TileNumberY(latLon.getLatitude());
        LinkedHashMap<WorldRegion, BinaryMapDataObject> foundObjects = new LinkedHashMap<WorldRegion, BinaryMapDataObject>();
        try {
            mapDataObjects = this.queryBboxNoInit(point31x, point31x, point31y, point31y, true);
        }
        catch (IOException e) {
            throw new IOException("Error while calling queryBbox");
        }
        Iterator<BinaryMapDataObject> it = mapDataObjects.iterator();
        while (it.hasNext()) {
            WorldRegion downloadRegion;
            BinaryMapDataObject o;
            block6: {
                block5: {
                    o = it.next();
                    if (o.getTypes() == null) continue;
                    downloadRegion = this.getRegionData(this.getFullName(o));
                    if (downloadRegion == null || (!includeRoadRegions ? !downloadRegion.isRegionMapDownload() : !downloadRegion.isRegionRoadsDownload() && !downloadRegion.isRegionMapDownload())) break block5;
                    if (OsmandRegions.contain(o, point31x, point31y)) break block6;
                }
                it.remove();
                continue;
            }
            foundObjects.put(downloadRegion, o);
        }
        return foundObjects;
    }

    public List<BinaryMapDataObject> getRegionsToDownload(double lat, double lon) throws IOException {
        ArrayList<BinaryMapDataObject> l = new ArrayList<BinaryMapDataObject>();
        int x31 = MapUtils.get31TileNumberX(lon);
        int y31 = MapUtils.get31TileNumberY(lat);
        List<BinaryMapDataObject> cs = this.query(x31, y31);
        for (BinaryMapDataObject b : cs) {
            if (!OsmandRegions.contain(b, x31, y31) || Algorithms.isEmpty(this.getDownloadName(b))) continue;
            l.add(b);
        }
        return l;
    }

    public List<String> getRegionsToDownload(double lat, double lon, List<String> keyNames) throws IOException {
        keyNames.clear();
        int x31 = MapUtils.get31TileNumberX(lon);
        int y31 = MapUtils.get31TileNumberY(lat);
        List<BinaryMapDataObject> cs = this.query(x31, y31);
        for (BinaryMapDataObject b : cs) {
            String downloadName;
            if (!OsmandRegions.contain(b, x31, y31) || Algorithms.isEmpty(downloadName = this.getDownloadName(b))) continue;
            keyNames.add(downloadName);
        }
        return keyNames;
    }

    private void addPolygonToRegionIfValid(BinaryMapDataObject mapObject, WorldRegion worldRegion) {
        if (mapObject.getPointsLength() < 3) {
            return;
        }
        ArrayList<LatLon> polygon = new ArrayList<LatLon>();
        for (int i = 0; i < mapObject.getPointsLength(); ++i) {
            int x = mapObject.getPoint31XTile(i);
            int y = mapObject.getPoint31YTile(i);
            double lat = MapUtils.get31LatitudeY(y);
            double lon = MapUtils.get31LongitudeX(x);
            polygon.add(new LatLon(lat, lon));
        }
        boolean outside = true;
        for (LatLon point : polygon) {
            if (!worldRegion.containsPoint(point)) continue;
            outside = false;
            break;
        }
        if (outside) {
            worldRegion.additionalPolygons.add(polygon);
        }
    }

    public static interface RegionTranslation {
        public String getTranslation(String var1);
    }

    private static class MapIndexFields {
        Integer parentFullName = null;
        Integer fullNameType = null;
        Integer downloadNameType = null;
        Integer nameEnType = null;
        Integer nameType = null;
        Integer nameLocaleType = null;
        Integer nameLocale2Type = null;
        Integer langType = null;
        Integer metricType = null;
        Integer leftHandDrivingType = null;
        Integer roadSignsType = null;
        Integer wikiLinkType = null;
        Integer populationType = null;

        private MapIndexFields() {
        }

        public String get(Integer tp, BinaryMapDataObject object) {
            if (tp == null) {
                return null;
            }
            return object.getNameByType(tp);
        }
    }
}

