/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.sqlite.SQLiteJDBCLoader;

public enum DBDialect {
    SQLITE,
    SQLITE_IN_MEMORY;


    public void deleteTableIfExists(String table, Statement stat) throws SQLException {
        stat.executeUpdate("drop table if exists " + table);
    }

    public boolean checkTableIfExists(String table, Statement stat) throws SQLException {
        ResultSet rs = stat.getConnection().getMetaData().getTables(null, null, table, null);
        boolean next = rs.next();
        rs.close();
        return next;
    }

    public boolean databaseFileExists(File dbFile) {
        return dbFile.exists();
    }

    public void removeDatabase(File file) {
        Algorithms.removeAllFiles((File)file);
    }

    public void commitDatabase(Object connection) throws SQLException {
        if (!((Connection)connection).getAutoCommit()) {
            ((Connection)connection).commit();
        }
    }

    public void closeDatabase(Object dbConn) throws SQLException {
        ((Connection)dbConn).close();
    }

    public Connection getDatabaseConnection(String fileName, Log log) throws SQLException {
        if (SQLITE == this || SQLITE_IN_MEMORY == this) {
            if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                System.setProperty("org.sqlite.lib.name", "libsqlitejdbc.jnilib");
            }
            try {
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Illegal configuration", (Throwable)e);
                throw new IllegalStateException(e);
            }
            Connection connection = DriverManager.getConnection("jdbc:sqlite:" + (SQLITE_IN_MEMORY == this ? ":memory:" : fileName));
            Statement statement = connection.createStatement();
            statement.executeUpdate("PRAGMA synchronous = 0");
            statement.executeQuery("PRAGMA journal_mode = OFF");
            statement.executeQuery("PRAGMA locking_mode = EXCLUSIVE");
            statement.close();
            try {
                log.info((Object)String.format("Access sqlite %s running in %s mode %s ", fileName.substring(fileName.lastIndexOf(47) + 1), SQLiteJDBCLoader.isNativeMode() ? "native" : "pure-java", SQLITE_IN_MEMORY == this ? "in memory" : "using disk"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return connection;
        }
        throw new UnsupportedOperationException();
    }
}

