/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.IOException;
import java.io.RandomAccessFile;

public class BinaryFileReference {
    private final long pointerToWrite;
    private final long pointerToCalculateShiftFrom;
    private final boolean _8bit;
    private long pointerToCalculateShiftTo;

    public BinaryFileReference(long pointerToWrite, long pointerToCalculateShiftFrom, boolean _8bit) {
        this.pointerToWrite = pointerToWrite;
        this.pointerToCalculateShiftFrom = pointerToCalculateShiftFrom;
        this._8bit = _8bit;
    }

    public long getStartPointer() {
        return this.pointerToCalculateShiftFrom;
    }

    public long writeReference(RandomAccessFile raf, long pointerToCalculateShifTo) throws IOException {
        this.pointerToCalculateShiftTo = pointerToCalculateShifTo;
        long currentPosition = raf.getFilePointer();
        raf.seek(this.pointerToWrite);
        long val = this.pointerToCalculateShiftTo - this.pointerToCalculateShiftFrom;
        if (this._8bit) {
            raf.writeLong(val | Long.MIN_VALUE);
        } else if (val < Integer.MAX_VALUE) {
            raf.writeInt((int)val);
        } else {
            throw new IllegalStateException("Out of bounds value: " + val);
        }
        raf.seek(currentPosition);
        return val;
    }

    public static BinaryFileReference createLongSizeReference(long pointerToWrite) {
        return new BinaryFileReference(pointerToWrite, pointerToWrite + 8L, true);
    }

    public static BinaryFileReference createSizeReference(long pointerToWrite) {
        return new BinaryFileReference(pointerToWrite, pointerToWrite + 4L, false);
    }

    public static BinaryFileReference createShiftReference(long pointerToWrite, long pointerShiftFrom) {
        return new BinaryFileReference(pointerToWrite, pointerShiftFrom, false);
    }
}

