/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.event;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.observation.event.FilterableEvent;
import org.xwiki.observation.event.filter.AlwaysMatchingEventFilter;
import org.xwiki.observation.event.filter.EventFilter;
import org.xwiki.observation.event.filter.FixedNameEventFilter;

public abstract class AbstractFilterableEvent
implements FilterableEvent,
Serializable {
    private static final long serialVersionUID = 1L;
    private EventFilter eventFilter;

    public AbstractFilterableEvent() {
        this.eventFilter = AlwaysMatchingEventFilter.INSTANCE;
    }

    public AbstractFilterableEvent(String name) {
        this.eventFilter = new FixedNameEventFilter(name);
    }

    public AbstractFilterableEvent(EventFilter eventFilter) {
        this.eventFilter = eventFilter;
    }

    @Override
    public EventFilter getEventFilter() {
        return this.eventFilter;
    }

    @Override
    public boolean matches(Object otherEvent) {
        if (otherEvent == this) {
            return true;
        }
        boolean isMatching = false;
        if (this.getClass().isAssignableFrom(otherEvent.getClass())) {
            isMatching = this.getEventFilter().matches(((AbstractFilterableEvent)otherEvent).getEventFilter());
        }
        return isMatching;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        FilterableEvent rhs = (FilterableEvent)object;
        return Objects.equals(this.getEventFilter(), rhs.getEventFilter());
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 125).append((Object)this.getEventFilter()).toHashCode();
    }
}

