/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.ElevationApproximator;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.util.KMapUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 /2\u00020\u0001:\u0003-./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0013\u001a\u00020\u0010H&J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\fJ\b\u0010\u0019\u001a\u0004\u0018\u00010\fJ8\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\"J>\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00052\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\"0,H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/osmand/shared/gpx/ElevationDiffsCalculator;", "", "<init>", "()V", "ELE_THRESHOLD", "", "diffElevationUp", "diffElevationDown", "extremums", "", "Lnet/osmand/shared/gpx/ElevationDiffsCalculator$Extremum;", "lastUphill", "Lnet/osmand/shared/gpx/ElevationDiffsCalculator$SlopeInfo;", "lastDownhill", "getPointDistance", "index", "", "getPointElevation", "getPointIndex", "getPointsCount", "getDiffElevationUp", "getDiffElevationDown", "getExtremums", "", "getLastUphill", "getLastDownhill", "getProjectionDist", "x", "y", "fromx", "fromy", "tox", "toy", "findMaximumExtremumBetween", "", "start", "end", "points", "", "calculateElevationDiffs", "processLastSlope", "current", "eleDiffSumm", "setter", "Lkotlin/Function1;", "Extremum", "SlopeInfo", "Companion", "OsmAnd-shared"})
public abstract class ElevationDiffsCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double ELE_THRESHOLD;
    private double diffElevationUp;
    private double diffElevationDown;
    @NotNull
    private List<Extremum> extremums = new ArrayList();
    @Nullable
    private SlopeInfo lastUphill;
    @Nullable
    private SlopeInfo lastDownhill;

    public ElevationDiffsCalculator() {
        this.ELE_THRESHOLD = 7.0;
    }

    public abstract double getPointDistance(int var1);

    public abstract double getPointElevation(int var1);

    public abstract int getPointIndex(int var1);

    public abstract int getPointsCount();

    public final double getDiffElevationUp() {
        return this.diffElevationUp;
    }

    public final double getDiffElevationDown() {
        return this.diffElevationDown;
    }

    @NotNull
    public final List<Extremum> getExtremums() {
        return CollectionsKt.toList((Iterable)this.extremums);
    }

    @Nullable
    public final SlopeInfo getLastUphill() {
        return this.lastUphill;
    }

    @Nullable
    public final SlopeInfo getLastDownhill() {
        return this.lastDownhill;
    }

    private final double getProjectionDist(double x, double y, double fromx, double fromy, double tox, double toy) {
        double mDist = (fromx - tox) * (fromx - tox) + (fromy - toy) * (fromy - toy);
        double projection = KMapUtils.INSTANCE.scalarMultiplication(fromx, fromy, tox, toy, x, y);
        Pair pair = projection < 0.0 ? new Pair((Object)fromx, (Object)fromy) : (projection >= mDist ? new Pair((Object)tox, (Object)toy) : new Pair((Object)(fromx + (tox - fromx) * (projection / mDist)), (Object)(fromy + (toy - fromy) * (projection / mDist))));
        double prx = ((Number)pair.component1()).doubleValue();
        double pry = ((Number)pair.component2()).doubleValue();
        return Math.sqrt((prx - x) * (prx - x) + (pry - y) * (pry - y));
    }

    private final void findMaximumExtremumBetween(int start, int end, boolean[] points) {
        double firstPointDist = this.getPointDistance(start);
        double firstPointEle = this.getPointElevation(start);
        double endPointEle = this.getPointElevation(end);
        double endPointDist = this.getPointDistance(end);
        int max = start;
        double maxDiff = this.ELE_THRESHOLD;
        for (int i = start + 1; i < end; ++i) {
            double md = this.getProjectionDist(this.getPointDistance(i), this.getPointElevation(i), firstPointDist, firstPointEle, endPointDist, endPointEle);
            if (!(md > maxDiff)) continue;
            max = i;
            maxDiff = md;
        }
        if (max != start) {
            points[max] = true;
            this.findMaximumExtremumBetween(start, max, points);
            this.findMaximumExtremumBetween(max, end, points);
        }
    }

    public final void calculateElevationDiffs() {
        int pointsCount = this.getPointsCount();
        if (pointsCount < 2) {
            return;
        }
        this.lastUphill = null;
        this.lastDownhill = null;
        this.diffElevationUp = 0.0;
        this.diffElevationDown = 0.0;
        boolean[] points = new boolean[pointsCount];
        points[0] = true;
        points[pointsCount - 1] = true;
        this.findMaximumExtremumBetween(0, pointsCount - 1, points);
        this.extremums = new ArrayList();
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            if (!points[i]) continue;
            this.extremums.add(new Extremum(this.getPointDistance(i), this.getPointElevation(i), this.getPointIndex(i)));
        }
        SlopeInfo currentUphill = null;
        SlopeInfo currentDownhill = null;
        int n2 = this.extremums.size();
        for (int i = 1; i < n2; ++i) {
            Extremum start = this.extremums.get(i - 1);
            Extremum end = this.extremums.get(i);
            double eleDiffSumm = end.getEle() - start.getEle();
            if (eleDiffSumm > 0.0) {
                this.diffElevationUp += eleDiffSumm;
                currentUphill = this.processLastSlope(currentUphill, start, end, eleDiffSumm, (Function1<? super SlopeInfo, Unit>)((Function1)arg_0 -> ElevationDiffsCalculator.calculateElevationDiffs$lambda$0(this, arg_0)));
                currentDownhill = null;
                continue;
            }
            if (!(eleDiffSumm < 0.0)) continue;
            double elevAbs = -eleDiffSumm;
            this.diffElevationDown += elevAbs;
            currentDownhill = this.processLastSlope(currentDownhill, start, end, elevAbs, (Function1<? super SlopeInfo, Unit>)((Function1)arg_0 -> ElevationDiffsCalculator.calculateElevationDiffs$lambda$1(this, arg_0)));
            currentUphill = null;
        }
    }

    private final SlopeInfo processLastSlope(SlopeInfo current, Extremum start, Extremum end, double eleDiffSumm, Function1<? super SlopeInfo, Unit> setter) {
        SlopeInfo updated = current != null && current.getEndPointIndex() == start.getIndex() ? SlopeInfo.copy$default(current, 0, end.getIndex(), current.getElevDiff() + eleDiffSumm, 0.0, 0.0, 25, null) : new SlopeInfo(start.getIndex(), end.getIndex(), eleDiffSumm, 0.0, 0.0, 24, null);
        setter.invoke((Object)updated);
        return updated;
    }

    private static final Unit calculateElevationDiffs$lambda$0(ElevationDiffsCalculator this$0, SlopeInfo it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.lastUphill = it;
        return Unit.INSTANCE;
    }

    private static final Unit calculateElevationDiffs$lambda$1(ElevationDiffsCalculator this$0, SlopeInfo it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.lastDownhill = it;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lnet/osmand/shared/gpx/ElevationDiffsCalculator$Companion;", "", "<init>", "()V", "calculateDiffs", "", "points", "", "Lnet/osmand/shared/gpx/primitives/WptPt;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final void calculateDiffs(@NotNull List<WptPt> points) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            ElevationApproximator approximator2 = new ElevationApproximator(points){
                final /* synthetic */ List<WptPt> $points;
                {
                    this.$points = $points;
                }

                public double getPointLatitude(int index) {
                    return this.$points.get(index).getLat();
                }

                public double getPointLongitude(int index) {
                    return this.$points.get(index).getLon();
                }

                public double getPointElevation(int index) {
                    return this.$points.get(index).getEle();
                }

                public int getPointsCount() {
                    return this.$points.size();
                }
            };
            approximator2.approximate();
            double[] distances = approximator2.getDistances();
            double[] elevations = approximator2.getElevations();
            int[] pointIndexes = approximator2.getSurvivedIndexes();
            if (distances != null && elevations != null && pointIndexes != null) {
                double diffElevationUp = 0.0;
                double diffElevationDown = 0.0;
                ElevationDiffsCalculator elevationDiffsCalc2 = new ElevationDiffsCalculator(distances, elevations, pointIndexes){
                    final /* synthetic */ double[] $distances;
                    final /* synthetic */ double[] $elevations;
                    final /* synthetic */ int[] $pointIndexes;
                    {
                        this.$distances = $distances;
                        this.$elevations = $elevations;
                        this.$pointIndexes = $pointIndexes;
                    }

                    public double getPointDistance(int index) {
                        return this.$distances[index];
                    }

                    public double getPointElevation(int index) {
                        return this.$elevations[index];
                    }

                    public int getPointIndex(int index) {
                        return this.$pointIndexes[index];
                    }

                    public int getPointsCount() {
                        return this.$distances.length;
                    }
                };
                elevationDiffsCalc2.calculateElevationDiffs();
                String string = "GPX points=" + points.size() + " approx points=" + distances.length + " diffUp=" + (diffElevationUp += elevationDiffsCalc2.getDiffElevationUp()) + " diffDown=" + (diffElevationDown += elevationDiffsCalc2.getDiffElevationDown());
                System.out.println((Object)string);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lnet/osmand/shared/gpx/ElevationDiffsCalculator$Extremum;", "", "dist", "", "ele", "index", "", "<init>", "(DDI)V", "getDist", "()D", "getEle", "getIndex", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "OsmAnd-shared"})
    public static final class Extremum {
        private final double dist;
        private final double ele;
        private final int index;

        public Extremum(double dist, double ele, int index) {
            this.dist = dist;
            this.ele = ele;
            this.index = index;
        }

        public final double getDist() {
            return this.dist;
        }

        public final double getEle() {
            return this.ele;
        }

        public final int getIndex() {
            return this.index;
        }

        public final double component1() {
            return this.dist;
        }

        public final double component2() {
            return this.ele;
        }

        public final int component3() {
            return this.index;
        }

        @NotNull
        public final Extremum copy(double dist, double ele, int index) {
            return new Extremum(dist, ele, index);
        }

        public static /* synthetic */ Extremum copy$default(Extremum extremum, double d, double d2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = extremum.dist;
            }
            if ((n2 & 2) != 0) {
                d2 = extremum.ele;
            }
            if ((n2 & 4) != 0) {
                n = extremum.index;
            }
            return extremum.copy(d, d2, n);
        }

        @NotNull
        public String toString() {
            return "Extremum(dist=" + this.dist + ", ele=" + this.ele + ", index=" + this.index + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.dist);
            result = result * 31 + Double.hashCode(this.ele);
            result = result * 31 + Integer.hashCode(this.index);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Extremum)) {
                return false;
            }
            Extremum extremum = (Extremum)other;
            if (Double.compare(this.dist, extremum.dist) != 0) {
                return false;
            }
            if (Double.compare(this.ele, extremum.ele) != 0) {
                return false;
            }
            return this.index == extremum.index;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lnet/osmand/shared/gpx/ElevationDiffsCalculator$SlopeInfo;", "", "startPointIndex", "", "endPointIndex", "elevDiff", "", "distance", "maxSpeed", "<init>", "(IIDDD)V", "getStartPointIndex", "()I", "getEndPointIndex", "getElevDiff", "()D", "getDistance", "getMaxSpeed", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "OsmAnd-shared"})
    public static final class SlopeInfo {
        private final int startPointIndex;
        private final int endPointIndex;
        private final double elevDiff;
        private final double distance;
        private final double maxSpeed;

        public SlopeInfo(int startPointIndex, int endPointIndex, double elevDiff, double distance, double maxSpeed) {
            this.startPointIndex = startPointIndex;
            this.endPointIndex = endPointIndex;
            this.elevDiff = elevDiff;
            this.distance = distance;
            this.maxSpeed = maxSpeed;
        }

        public /* synthetic */ SlopeInfo(int n, int n2, double d, double d2, double d3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                d2 = 0.0;
            }
            if ((n3 & 0x10) != 0) {
                d3 = 0.0;
            }
            this(n, n2, d, d2, d3);
        }

        public final int getStartPointIndex() {
            return this.startPointIndex;
        }

        public final int getEndPointIndex() {
            return this.endPointIndex;
        }

        public final double getElevDiff() {
            return this.elevDiff;
        }

        public final double getDistance() {
            return this.distance;
        }

        public final double getMaxSpeed() {
            return this.maxSpeed;
        }

        public final int component1() {
            return this.startPointIndex;
        }

        public final int component2() {
            return this.endPointIndex;
        }

        public final double component3() {
            return this.elevDiff;
        }

        public final double component4() {
            return this.distance;
        }

        public final double component5() {
            return this.maxSpeed;
        }

        @NotNull
        public final SlopeInfo copy(int startPointIndex, int endPointIndex, double elevDiff, double distance, double maxSpeed) {
            return new SlopeInfo(startPointIndex, endPointIndex, elevDiff, distance, maxSpeed);
        }

        public static /* synthetic */ SlopeInfo copy$default(SlopeInfo slopeInfo, int n, int n2, double d, double d2, double d3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = slopeInfo.startPointIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = slopeInfo.endPointIndex;
            }
            if ((n3 & 4) != 0) {
                d = slopeInfo.elevDiff;
            }
            if ((n3 & 8) != 0) {
                d2 = slopeInfo.distance;
            }
            if ((n3 & 0x10) != 0) {
                d3 = slopeInfo.maxSpeed;
            }
            return slopeInfo.copy(n, n2, d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "SlopeInfo(startPointIndex=" + this.startPointIndex + ", endPointIndex=" + this.endPointIndex + ", elevDiff=" + this.elevDiff + ", distance=" + this.distance + ", maxSpeed=" + this.maxSpeed + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.startPointIndex);
            result = result * 31 + Integer.hashCode(this.endPointIndex);
            result = result * 31 + Double.hashCode(this.elevDiff);
            result = result * 31 + Double.hashCode(this.distance);
            result = result * 31 + Double.hashCode(this.maxSpeed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SlopeInfo)) {
                return false;
            }
            SlopeInfo slopeInfo = (SlopeInfo)other;
            if (this.startPointIndex != slopeInfo.startPointIndex) {
                return false;
            }
            if (this.endPointIndex != slopeInfo.endPointIndex) {
                return false;
            }
            if (Double.compare(this.elevDiff, slopeInfo.elevDiff) != 0) {
                return false;
            }
            if (Double.compare(this.distance, slopeInfo.distance) != 0) {
                return false;
            }
            return Double.compare(this.maxSpeed, slopeInfo.maxSpeed) == 0;
        }
    }
}

