/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b2\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 @2\u00020\u0001:\u0001@B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u00108\u001a\u000209\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\u00020<2\u0006\u00108\u001a\u0002092\u0006\u0010=\u001a\u00020\u0003J\u0006\u0010>\u001a\u00020\u0003J\u000e\u0010?\u001a\u00020\u00062\u0006\u00108\u001a\u000209R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\u001a\u0010\u001c\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\rR\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\rR\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\rR\u001a\u0010%\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\rR\u001a\u0010(\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u000b\"\u0004\b*\u0010\rR\u001a\u0010+\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u000b\"\u0004\b-\u0010\rR\u001a\u0010.\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u000b\"\u0004\b0\u0010\rR\u001a\u00101\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000b\"\u0004\b3\u0010\rR\u001a\u00104\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u000b\"\u0004\b6\u0010\r\u00a8\u0006A"}, d2={"Lnet/osmand/shared/gpx/PointAttributes;", "", "distance", "", "timeDiff", "firstPoint", "", "lastPoint", "<init>", "(FFZZ)V", "getDistance", "()F", "setDistance", "(F)V", "getTimeDiff", "setTimeDiff", "getFirstPoint", "()Z", "setFirstPoint", "(Z)V", "getLastPoint", "setLastPoint", "speed", "getSpeed", "setSpeed", "elevation", "getElevation", "setElevation", "heartRate", "getHeartRate", "setHeartRate", "sensorSpeed", "getSensorSpeed", "setSensorSpeed", "bikeCadence", "getBikeCadence", "setBikeCadence", "bikePower", "getBikePower", "setBikePower", "waterTemperature", "getWaterTemperature", "setWaterTemperature", "airTemperature", "getAirTemperature", "setAirTemperature", "rawZoom", "getRawZoom", "setRawZoom", "animatedZoom", "getAnimatedZoom", "setAnimatedZoom", "interpolationOffsetN", "getInterpolationOffsetN", "setInterpolationOffsetN", "getAttributeValue", "tag", "", "(Ljava/lang/String;)Ljava/lang/Float;", "setAttributeValue", "", "value", "getTemperature", "hasValidValue", "Companion", "OsmAnd-shared"})
public final class PointAttributes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float distance;
    private float timeDiff;
    private boolean firstPoint;
    private boolean lastPoint;
    private float speed;
    private float elevation;
    private float heartRate;
    private float sensorSpeed;
    private float bikeCadence;
    private float bikePower;
    private float waterTemperature;
    private float airTemperature;
    private float rawZoom;
    private float animatedZoom;
    private float interpolationOffsetN;
    @NotNull
    public static final String SENSOR_TAG_HEART_RATE = "gpxtpx:hr";
    @NotNull
    public static final String SENSOR_TAG_SPEED = "osmand:speed_sensor";
    @NotNull
    public static final String SENSOR_TAG_CADENCE = "gpxtpx:cad";
    @NotNull
    public static final String SENSOR_TAG_BIKE_POWER = "gpxtpx:power";
    @NotNull
    public static final String SENSOR_TAG_TEMPERATURE = "temp_sensor";
    @NotNull
    public static final String SENSOR_TAG_TEMPERATURE_W = "gpxtpx:wtemp";
    @NotNull
    public static final String SENSOR_TAG_TEMPERATURE_A = "gpxtpx:atemp";
    @NotNull
    public static final String SENSOR_TAG_DISTANCE = "osmand:bike_distance_sensor";
    @NotNull
    public static final String DEV_RAW_ZOOM = "raw_zoom";
    @NotNull
    public static final String DEV_ANIMATED_ZOOM = "animated_zoom";
    @NotNull
    public static final String DEV_INTERPOLATION_OFFSET_N = "offset";
    @NotNull
    public static final String POINT_SPEED = "point_speed";
    @NotNull
    public static final String POINT_ELEVATION = "point_elevation";

    public PointAttributes(float distance, float timeDiff, boolean firstPoint, boolean lastPoint) {
        this.distance = distance;
        this.timeDiff = timeDiff;
        this.firstPoint = firstPoint;
        this.lastPoint = lastPoint;
        this.speed = Float.NaN;
        this.elevation = Float.NaN;
        this.heartRate = Float.NaN;
        this.sensorSpeed = Float.NaN;
        this.bikeCadence = Float.NaN;
        this.bikePower = Float.NaN;
        this.waterTemperature = Float.NaN;
        this.airTemperature = Float.NaN;
        this.rawZoom = Float.NaN;
        this.animatedZoom = Float.NaN;
        this.interpolationOffsetN = Float.NaN;
    }

    public final float getDistance() {
        return this.distance;
    }

    public final void setDistance(float f) {
        this.distance = f;
    }

    public final float getTimeDiff() {
        return this.timeDiff;
    }

    public final void setTimeDiff(float f) {
        this.timeDiff = f;
    }

    public final boolean getFirstPoint() {
        return this.firstPoint;
    }

    public final void setFirstPoint(boolean bl) {
        this.firstPoint = bl;
    }

    public final boolean getLastPoint() {
        return this.lastPoint;
    }

    public final void setLastPoint(boolean bl) {
        this.lastPoint = bl;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final void setSpeed(float f) {
        this.speed = f;
    }

    public final float getElevation() {
        return this.elevation;
    }

    public final void setElevation(float f) {
        this.elevation = f;
    }

    public final float getHeartRate() {
        return this.heartRate;
    }

    public final void setHeartRate(float f) {
        this.heartRate = f;
    }

    public final float getSensorSpeed() {
        return this.sensorSpeed;
    }

    public final void setSensorSpeed(float f) {
        this.sensorSpeed = f;
    }

    public final float getBikeCadence() {
        return this.bikeCadence;
    }

    public final void setBikeCadence(float f) {
        this.bikeCadence = f;
    }

    public final float getBikePower() {
        return this.bikePower;
    }

    public final void setBikePower(float f) {
        this.bikePower = f;
    }

    public final float getWaterTemperature() {
        return this.waterTemperature;
    }

    public final void setWaterTemperature(float f) {
        this.waterTemperature = f;
    }

    public final float getAirTemperature() {
        return this.airTemperature;
    }

    public final void setAirTemperature(float f) {
        this.airTemperature = f;
    }

    public final float getRawZoom() {
        return this.rawZoom;
    }

    public final void setRawZoom(float f) {
        this.rawZoom = f;
    }

    public final float getAnimatedZoom() {
        return this.animatedZoom;
    }

    public final void setAnimatedZoom(float f) {
        this.animatedZoom = f;
    }

    public final float getInterpolationOffsetN() {
        return this.interpolationOffsetN;
    }

    public final void setInterpolationOffsetN(float f) {
        this.interpolationOffsetN = f;
    }

    @Nullable
    public final Float getAttributeValue(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return switch (tag) {
            case POINT_SPEED -> Float.valueOf(this.speed);
            case POINT_ELEVATION -> Float.valueOf(this.elevation);
            case SENSOR_TAG_HEART_RATE -> Float.valueOf(this.heartRate);
            case SENSOR_TAG_SPEED -> Float.valueOf(this.sensorSpeed);
            case SENSOR_TAG_CADENCE -> Float.valueOf(this.bikeCadence);
            case SENSOR_TAG_BIKE_POWER -> Float.valueOf(this.bikePower);
            case SENSOR_TAG_TEMPERATURE -> Float.valueOf(this.getTemperature());
            case SENSOR_TAG_TEMPERATURE_W -> Float.valueOf(this.waterTemperature);
            case SENSOR_TAG_TEMPERATURE_A -> Float.valueOf(this.airTemperature);
            case DEV_RAW_ZOOM -> Float.valueOf(this.rawZoom);
            case DEV_ANIMATED_ZOOM -> Float.valueOf(this.animatedZoom);
            case DEV_INTERPOLATION_OFFSET_N -> Float.valueOf(this.interpolationOffsetN);
            default -> null;
        };
    }

    public final void setAttributeValue(@NotNull String tag, float value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        switch (tag) {
            case "point_speed": {
                this.speed = value;
                break;
            }
            case "point_elevation": {
                this.elevation = value;
                break;
            }
            case "gpxtpx:hr": {
                this.heartRate = value;
                break;
            }
            case "osmand:speed_sensor": {
                this.sensorSpeed = value;
                break;
            }
            case "gpxtpx:cad": {
                this.bikeCadence = value;
                break;
            }
            case "gpxtpx:power": {
                this.bikePower = value;
                break;
            }
            case "gpxtpx:wtemp": {
                this.waterTemperature = value;
                break;
            }
            case "gpxtpx:atemp": {
                this.airTemperature = value;
                break;
            }
            case "raw_zoom": {
                this.rawZoom = value;
                break;
            }
            case "animated_zoom": {
                this.animatedZoom = value;
                break;
            }
            case "offset": {
                this.interpolationOffsetN = value;
            }
        }
    }

    public final float getTemperature() {
        return !Float.isNaN(this.airTemperature) ? (!Float.isNaN(this.waterTemperature) ? Math.max(this.waterTemperature, this.airTemperature) : this.airTemperature) : this.waterTemperature;
    }

    public final boolean hasValidValue(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Float f = this.getAttributeValue(tag);
        if (f == null) {
            return false;
        }
        float value = f.floatValue();
        Object[] objectArray = new String[]{SENSOR_TAG_TEMPERATURE, SENSOR_TAG_TEMPERATURE_W, SENSOR_TAG_TEMPERATURE_A, POINT_ELEVATION};
        return CollectionsKt.listOf((Object[])objectArray).contains(tag) ? !Float.isNaN(value) : value > 0.0f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/osmand/shared/gpx/PointAttributes$Companion;", "", "<init>", "()V", "SENSOR_TAG_HEART_RATE", "", "SENSOR_TAG_SPEED", "SENSOR_TAG_CADENCE", "SENSOR_TAG_BIKE_POWER", "SENSOR_TAG_TEMPERATURE", "SENSOR_TAG_TEMPERATURE_W", "SENSOR_TAG_TEMPERATURE_A", "SENSOR_TAG_DISTANCE", "DEV_RAW_ZOOM", "DEV_ANIMATED_ZOOM", "DEV_INTERPOLATION_OFFSET_N", "POINT_SPEED", "POINT_ELEVATION", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

