/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import com.google.protobuf.CodedOutputStream;
import gnu.trove.TLongCollection;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.data.Amenity;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Postcode;
import net.osmand.data.Street;
import net.osmand.obf.BinaryInspector;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.IndexAddressCreator;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.IndexPoiCreator;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.edit.Node;
import net.osmand.util.Algorithms;
import net.osmand.util.CountryOcbfGeneration;
import net.osmand.util.IndexUploader;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;
import rtree.RTreeException;

public class BinaryMerger {
    public static final int BUFFER_SIZE = 0x100000;
    private static final Log log = PlatformUtil.getLog(BinaryMerger.class);
    public static final String helpMessage = "output_file.obf [--address] [--poi] [input_file.obf] ...: merges all obf files and merges poi & address structure into 1";
    private static final Map<String, Integer> COMBINE_ARGS = new HashMap<String, Integer>();
    private BinaryMapIndexReader.OsmAndOwner osmAndOwner;

    public static void main(String[] args) throws IOException, SQLException {
        BinaryMerger in = new BinaryMerger();
        if (args.length == 1 && "test".equals(args[0])) {
            in.merger(new String[]{"/Users/macmini/OsmAnd/maps/Merged.obf", "/Users/macmini/OsmAnd/maps/Ukraine_khmelnytskyy_europe_2.obf", "/Users/macmini/OsmAnd/maps/Ukraine_vinnytsya_europe_2.obf", "/Users/macmini/OsmAnd/maps/Ukraine_zhytomyr_europe_2.obf"});
        } else {
            in.merger(args);
        }
    }

    public static void signObfFile(String[] args) throws IOException, SQLException {
        String pathToObf = "";
        String name = "";
        String pluginid = "";
        String description = "";
        String resource = "";
        String usage = "Usage: <path to obf> name=\"Owner name\" resource=\"Link to resource\"(optional) pluginid=\"Plugin name\"(optional) description>\"Description (any text)\"(optional)";
        if (args.length == 1 && args[0].equals("test")) {
            pathToObf = "/Users/macmini/OsmAnd/maps/Ukraine_vinnytsya_europe.obf";
            name = "owner=John";
            pluginid = "pluginid=Offroad tracks";
            description = "description=Offroad tracks of Middle-earth";
            resource = "https://osmand.net OsmAnd";
        } else {
            if (args.length < 2) {
                System.out.println(usage);
                System.exit(1);
                return;
            }
            pathToObf = args[0];
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("name=")) {
                    name = arg.replace("name=", "");
                    continue;
                }
                if (arg.startsWith("pluginid=")) {
                    pluginid = arg.replace("pluginid=", "");
                    continue;
                }
                if (arg.startsWith("description=")) {
                    description = arg.replace("description=", "");
                    continue;
                }
                if (!arg.startsWith("resource=")) continue;
                resource = arg.replace("resource=", "");
            }
        }
        if (pathToObf.isEmpty() || name.isEmpty()) {
            System.out.println(usage);
            System.exit(1);
            return;
        }
        if (!pathToObf.endsWith(".obf") && !pathToObf.endsWith(".obf.zip")) {
            System.out.println("Supported file formats are: *.obf, *.obf.zip");
            System.exit(1);
            return;
        }
        BinaryMerger in = new BinaryMerger();
        in.addOsmAndOwner(pathToObf, name, resource, description, pluginid);
    }

    public void addOsmAndOwner(String pathToFile, String name, String resource, String description, String pluginid) throws IOException, SQLException {
        String signed = "";
        boolean zip = false;
        if (pathToFile.endsWith(".obf.zip")) {
            signed = pathToFile.replace(".obf.zip", "_signed.obf");
            zip = true;
        } else {
            signed = pathToFile.replace(".obf", "_signed.obf");
        }
        String[] args = new String[]{signed, pathToFile};
        BinaryMerger in = new BinaryMerger();
        in.osmAndOwner = new BinaryMapIndexReader.OsmAndOwner(name, resource, pluginid, description);
        in.merger(args);
        File sFile = new File(signed);
        if (zip) {
            try {
                File zFile = new File(pathToFile);
                zFile.delete();
                sFile.renameTo(new File(pathToFile.replace(".obf.zip", ".obf")));
                IndexUploader.zip(sFile, zFile, "", System.currentTimeMillis());
                sFile.delete();
            }
            catch (IndexUploader.OneFileException e) {
                e.printStackTrace();
            }
        } else {
            File oFile = new File(pathToFile);
            oFile.delete();
            sFile.renameTo(oFile);
        }
        System.out.println("Sign added to file:" + pathToFile + " . Sign name=" + name + ", resource=" + resource + ", pluginid=" + pluginid + ", description=" + description);
    }

    public static void mergeStandardFiles(String[] args) throws IOException, SQLException, XmlPullParserException, RTreeException {
        BinaryMerger in = new BinaryMerger();
        String pathWithGeneratedMapZips = args[0];
        String pathToPutJointFiles = args[1];
        boolean mapFiles = false;
        boolean roadFiles = false;
        boolean skipExisting = false;
        boolean ignoreFailures = true;
        String filter = null;
        for (String arg : args) {
            String val = null;
            String[] s = arg.split("=");
            String key = s[0];
            if (s.length > 1) {
                val = s[1].trim();
            }
            if (key.equals("--map")) {
                mapFiles = true;
                roadFiles = false;
            }
            if (key.equals("--road")) {
                roadFiles = true;
                mapFiles = false;
                continue;
            }
            if (key.equals("--filter")) {
                filter = val;
                continue;
            }
            if (key.equals("--skip-existing")) {
                skipExisting = true;
                continue;
            }
            if (!key.equals("--fail-fast")) continue;
            ignoreFailures = false;
        }
        ArrayList<String> failedCountries = new ArrayList<String>();
        CountryOcbfGeneration.CountryRegion world = new CountryOcbfGeneration().parseDefaultOsmAndRegionStructure();
        Iterator<CountryOcbfGeneration.CountryRegion> it = world.iterator();
        while (it.hasNext()) {
            boolean road;
            CountryOcbfGeneration.CountryRegion cr = it.next();
            String roadExt = "_2.road.obf";
            String mapExt = "_2.obf";
            if ((!cr.jointMap || !mapFiles) && (!cr.jointRoads || !roadFiles || cr.jointMap)) continue;
            boolean bl = road = cr.jointRoads && !cr.jointMap;
            if (!Algorithms.isEmpty((CharSequence)filter) && !cr.getDownloadName().toLowerCase().startsWith(filter.toLowerCase())) continue;
            List<CountryOcbfGeneration.CountryRegion> list = cr.getChildren();
            ArrayList<Object> sargs = new ArrayList<Object>();
            String targetFileName = Algorithms.capitalizeFirstLetterAndLowercase((String)cr.getDownloadName()) + (road ? roadExt : mapExt);
            File targetFile = new File(pathToPutJointFiles, targetFileName);
            File targetUploadedFile = new File(pathWithGeneratedMapZips, targetFileName + ".zip");
            System.out.println("Checking " + targetFileName);
            if (skipExisting && targetFile.exists() || skipExisting && targetUploadedFile.exists()) continue;
            sargs.add(targetFileName);
            sargs.add("--address");
            sargs.add("--poi");
            sargs.add("--hhindex");
            for (CountryOcbfGeneration.CountryRegion reg : list) {
                if (!reg.map) continue;
                File fl = BinaryMerger.getExistingFile(pathWithGeneratedMapZips, reg, road ? roadExt : mapExt);
                if (!fl.exists() && road && (fl = BinaryMerger.getExistingFile(pathWithGeneratedMapZips, reg, mapExt)).exists()) {
                    File target = new File(fl.getParentFile(), fl.getName() + ".roadtmp");
                    IndexUploader.extractRoadOnlyFile(fl, target);
                    fl = target;
                }
                sargs.add(fl.getAbsolutePath());
            }
            log.info((Object)("Merge file with arguments: " + String.valueOf(sargs)));
            try {
                in.merger(sargs.toArray(new String[sargs.size()]));
                File genFile = new File(targetFileName);
                boolean moved = genFile.renameTo(targetFile);
                if (moved) continue;
                Algorithms.fileCopy((File)genFile, (File)targetFile);
                genFile.delete();
            }
            catch (IOException | SQLException e) {
                if (!ignoreFailures) {
                    throw e;
                }
                log.error((Object)e.getMessage(), (Throwable)e);
                failedCountries.add(cr.getDownloadName());
            }
        }
        if (!failedCountries.isEmpty()) {
            String msg = "Failed generation for such countries: " + String.valueOf(failedCountries);
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    private static File getExistingFile(String pathWithZips, CountryOcbfGeneration.CountryRegion reg, String mapExt) {
        File fl = new File(pathWithZips, Algorithms.capitalizeFirstLetterAndLowercase((String)reg.getDownloadName()) + mapExt);
        if (!fl.exists()) {
            fl = new File(fl.getParentFile(), fl.getName() + ".zip");
        }
        return fl;
    }

    public static final void writeInt(CodedOutputStream ous, long v) throws IOException {
        BinaryInspector.writeInt(ous, v);
    }

    private void mergeCitiesByNameDistance(List<City> orderedCities, Map<City, List<City>> mergeGroup, Map<City, BinaryMapIndexReader> cityMap, boolean rename) {
        for (int i = 0; i < orderedCities.size() - 1; ++i) {
            int j = i;
            City oc = orderedCities.get(i);
            City nc = orderedCities.get(j);
            BinaryMapIndexReader ocIndexReader = cityMap.get(oc);
            ArrayList<City> uniqueNamesakes = new ArrayList<City>();
            boolean renameGroup = false;
            while (MapObject.BY_NAME_COMPARATOR.areEqual((MapObject)nc, (MapObject)oc)) {
                boolean isUniqueCity = true;
                ListIterator uci = uniqueNamesakes.listIterator();
                while (uci.hasNext()) {
                    boolean shorter;
                    City uc = (City)uci.next();
                    if (!BinaryMerger.isSameCity(uc, nc)) continue;
                    boolean bl = shorter = nc.getName().length() < uc.getName().length();
                    if (shorter) {
                        mergeGroup.put(nc, mergeGroup.remove(uc));
                        uniqueNamesakes.remove(uc);
                        uniqueNamesakes.add(nc);
                        City tmp = uc;
                        uc = nc;
                        nc = tmp;
                    }
                    orderedCities.remove(nc);
                    mergeGroup.get(uc).add(nc);
                    isUniqueCity = false;
                    break;
                }
                if (isUniqueCity) {
                    uniqueNamesakes.add(nc);
                    mergeGroup.put(nc, new ArrayList());
                    ++j;
                }
                boolean areCitiesInSameRegion = ocIndexReader == cityMap.get(nc);
                renameGroup = renameGroup || rename && !areCitiesInSameRegion && uniqueNamesakes.size() > 1;
                nc = j < orderedCities.size() ? orderedCities.get(j) : null;
            }
            if (uniqueNamesakes.size() == 1 && mergeGroup.get(uniqueNamesakes.get(0)).size() == 0) {
                mergeGroup.remove(uniqueNamesakes.get(0));
                continue;
            }
            if (!renameGroup) continue;
            for (City uc : uniqueNamesakes) {
                for (City c : mergeGroup.get(uc)) {
                    this.addRegionToCityName(c, cityMap.get(c));
                }
                this.addRegionToCityName(uc, cityMap.get(uc));
            }
        }
    }

    private List<String> extractCountryAndRegionNames(BinaryMapIndexReader index) {
        List name = index.getRegionNames();
        if (name.size() > 0) {
            return Arrays.asList(((String)name.get(0)).split("_"));
        }
        return Collections.emptyList();
    }

    private String extractCountryName(BinaryMapIndexReader index) {
        List<String> lst = this.extractCountryAndRegionNames(index);
        if (lst.size() > 0) {
            return lst.get(0);
        }
        return null;
    }

    private String extractRegionName(BinaryMapIndexReader index) {
        List<String> names = this.extractCountryAndRegionNames(index);
        if (names.size() >= 2) {
            Object region = names.get(1);
            region = ((String)region).substring(0, 1).toUpperCase() + ((String)region).substring(1);
            return region;
        }
        return null;
    }

    private void addRegionToCityName(City city, BinaryMapIndexReader index) {
        String region = this.extractRegionName(index);
        city.setName((String)(region == null ? city.getName() : city.getName() + " (" + region + ")"));
    }

    private static boolean isSameCity(City namesake0, City namesake1) {
        double sameCityDistance = namesake0.isPostcode() ? 50000.0 : 5000.0;
        return MapUtils.getDistance((LatLon)namesake0.getLocation(), (LatLon)namesake1.getLocation()) < sameCityDistance;
    }

    private static City mergeCities(City city, City namesake, Map<City, Map<Street, List<Node>>> namesakesStreetNodes) {
        Map smap = city.mergeWith(namesake);
        Map<Street, List<Node>> wayNodes = namesakesStreetNodes.get(city);
        Map<Street, List<Node>> owayNodes = namesakesStreetNodes.get(namesake);
        for (Street o : smap.keySet()) {
            List<Node> nodes = owayNodes.get(o);
            wayNodes.put((Street)smap.get(o), nodes);
        }
        return city;
    }

    private void normalizePostcode(City city, String country) {
        String normalizedPostcode;
        if (city.isPostcode()) {
            normalizedPostcode = Postcode.normalize((String)city.getName(), (String)country);
            city.setName(normalizedPostcode);
            city.setEnName(normalizedPostcode);
        }
        if (city.getPostcode() != null) {
            normalizedPostcode = Postcode.normalize((String)city.getPostcode(), (String)country);
            city.setPostcode(normalizedPostcode);
        }
    }

    private void preloadStreetsAndBuildings(BinaryMapIndexReader rindex, City city, Map<City, Map<Street, List<Node>>> namesakesStreetNodes) throws IOException {
        rindex.preloadStreets(city, null);
        LinkedHashMap streetNodes = new LinkedHashMap();
        LinkedHashMap streetNodesN = new LinkedHashMap();
        for (Street street : city.getStreets()) {
            rindex.preloadBuildings(street, null);
            ArrayList<Node> nns = new ArrayList<Node>();
            for (Street is : street.getIntersectedStreets()) {
                List list = (List)streetNodesN.get(is.getName());
                Node nn = null;
                if (list != null) {
                    boolean nameEqual = false;
                    double dd = 100000.0;
                    for (Node n : list) {
                        double d = MapUtils.getDistance((LatLon)n.getLatLon(), (LatLon)is.getLocation());
                        if (Algorithms.objectEquals((Object)street.getName(), (Object)n.getTag("name")) && (d < dd || !nameEqual)) {
                            nn = n;
                            dd = d;
                            nameEqual = true;
                            continue;
                        }
                        if (nameEqual || !(d < dd)) continue;
                        nn = n;
                        dd = d;
                    }
                }
                if (nn == null) {
                    int ty = (int)MapUtils.getTileNumberY((float)24.0f, (double)is.getLocation().getLatitude());
                    int tx = (int)MapUtils.getTileNumberY((float)24.0f, (double)is.getLocation().getLongitude());
                    long id = (long)tx << 32 | (long)ty;
                    nn = new Node(is.getLocation().getLatitude(), is.getLocation().getLongitude(), id);
                    nn.putTag("name", is.getName());
                }
                nns.add(nn);
            }
            streetNodes.put(street, nns);
            if (streetNodesN.containsKey(street.getName())) {
                ((List)streetNodesN.get(street.getName())).addAll(nns);
                continue;
            }
            streetNodesN.put(street.getName(), nns);
        }
        namesakesStreetNodes.put(city, streetNodes);
    }

    private void combineAddressIndex(String name, BinaryMapIndexWriter writer, BinaryMapAddressReaderAdapter.AddressRegion[] addressRegions, BinaryMapIndexReader[] indexes) throws IOException {
        IndexCreatorSettings settings = new IndexCreatorSettings();
        TreeSet<String> attributeTagsTableSet = new TreeSet<String>();
        for (int i = 0; i < addressRegions.length; ++i) {
            BinaryMapAddressReaderAdapter.AddressRegion region = addressRegions[i];
            if (region == null) continue;
            attributeTagsTableSet.addAll(region.getAttributeTagsTable());
        }
        writer.startWriteAddressIndex(name, attributeTagsTableSet);
        ArrayList<String> attributeTagsTable = new ArrayList<String>();
        attributeTagsTable.addAll(attributeTagsTableSet);
        HashMap<String, Integer> tagRules = new HashMap<String, Integer>();
        TreeMap namesIndex = new TreeMap(Collator.getInstance());
        ListIterator it = attributeTagsTable.listIterator();
        while (it.hasNext()) {
            tagRules.put((String)it.next(), it.previousIndex());
        }
        for (BinaryMapAddressReaderAdapter.CityBlocks cityBlockType : BinaryMapAddressReaderAdapter.CityBlocks.values()) {
            if (!cityBlockType.cityGroupType) continue;
            HashMap<City, BinaryMapIndexReader> cityMap = new HashMap<City, BinaryMapIndexReader>();
            HashMap<Long, City> cityIds = new HashMap<Long, City>();
            for (int i = 0; i < addressRegions.length; ++i) {
                BinaryMapAddressReaderAdapter.AddressRegion region = addressRegions[i];
                if (region == null) continue;
                BinaryMapIndexReader index = indexes[i];
                for (City city : index.getCities(region, null, cityBlockType)) {
                    this.normalizePostcode(city, this.extractCountryName(index));
                    if (cityIds.containsKey(city.getId())) {
                        index.preloadStreets(city, null);
                        City city2 = (City)cityIds.get(city.getId());
                        ((BinaryMapIndexReader)cityMap.get(city2)).preloadStreets(city2, null);
                        if (city.getStreets().size() <= city2.getStreets().size()) continue;
                        cityMap.remove(city2);
                        cityIds.put(city.getId(), city);
                        cityMap.put(city, index);
                        continue;
                    }
                    cityMap.put(city, index);
                    cityIds.put(city.getId(), city);
                }
            }
            ArrayList<City> cities = new ArrayList<City>(cityMap.keySet());
            HashMap<City, List<City>> mergeCityGroup = new HashMap<City, List<City>>();
            Collections.sort(cities, MapObject.BY_NAME_COMPARATOR);
            this.mergeCitiesByNameDistance(cities, mergeCityGroup, cityMap, cityBlockType == BinaryMapAddressReaderAdapter.CityBlocks.CITY_TOWN_TYPE);
            ArrayList<BinaryFileReference> refs = new ArrayList<BinaryFileReference>();
            writer.startCityBlockIndex(cityBlockType.index);
            HashMap<City, Map<Street, List<Node>>> namesakesStreetNodes = new HashMap<City, Map<Street, List<Node>>>();
            for (int i = 0; i < cities.size(); ++i) {
                City city = (City)cities.get(i);
                BinaryMapIndexReader rindex = (BinaryMapIndexReader)cityMap.get(city);
                this.preloadStreetsAndBuildings(rindex, city, namesakesStreetNodes);
                List namesakes = (List)mergeCityGroup.get(city);
                if (namesakes != null) {
                    for (City namesake : namesakes) {
                        this.preloadStreetsAndBuildings((BinaryMapIndexReader)cityMap.get(namesake), namesake, namesakesStreetNodes);
                        city = BinaryMerger.mergeCities(city, namesake, namesakesStreetNodes);
                    }
                }
                BinaryFileReference ref = writer.writeCityHeader(city, city.getType().ordinal(), tagRules);
                refs.add(ref);
                writer.writeCityIndex(city, city.getStreets(), (Map)namesakesStreetNodes.get(city), ref, tagRules);
                IndexAddressCreator.putNamedMapObject(namesIndex, (MapObject)city, ref.getStartPointer(), settings);
                if (!city.isPostcode()) {
                    for (Street s : city.getStreets()) {
                        IndexAddressCreator.putNamedMapObject(namesIndex, (MapObject)s, s.getFileOffset(), settings);
                    }
                }
                city.getStreets().clear();
                namesakesStreetNodes.clear();
            }
            writer.endCityBlockIndex();
        }
        writer.writeAddressNameIndex(namesIndex);
        writer.endWriteAddressIndex();
    }

    public static long latlon(Amenity amenity) {
        LatLon loc = amenity.getLocation();
        return (long)MapUtils.get31TileNumberX((double)loc.getLongitude()) << 31 | (long)MapUtils.get31TileNumberY((double)loc.getLatitude());
    }

    private void combinePoiIndex(String name, BinaryMapIndexWriter writer, long dateCreated, BinaryMapPoiReaderAdapter.PoiRegion[] poiRegions, BinaryMapIndexReader[] indexes) throws IOException, SQLException {
        final int[] writtenPoiCount = new int[]{0};
        MapRenderingTypesEncoder renderingTypes = new MapRenderingTypesEncoder(null, name);
        IndexCreatorSettings settings = new IndexCreatorSettings();
        settings.indexPOI = true;
        final IndexPoiCreator indexPoiCreator = new IndexPoiCreator(settings, renderingTypes);
        indexPoiCreator.createDatabaseStructure(new File(new File(System.getProperty("user.dir")), IndexCreator.getPoiFileName(name)));
        final HashMap amenityRelations = new HashMap();
        final TLongHashSet set = new TLongHashSet();
        final long[] generatedRelationId = new long[]{-1L};
        for (int i = 0; i < poiRegions.length; ++i) {
            BinaryMapIndexReader index = indexes[i];
            final TLongHashSet file = new TLongHashSet();
            log.info((Object)("Region: " + this.extractRegionName(index)));
            index.searchPoi(BinaryMapIndexReader.buildSearchPoiRequest((int)0, (int)Integer.MAX_VALUE, (int)0, (int)Integer.MAX_VALUE, (int)-1, (BinaryMapIndexReader.SearchPoiTypeFilter)BinaryMapIndexReader.ACCEPT_ALL_POI_TYPE_FILTER, (ResultMatcher)new ResultMatcher<Amenity>(){

                public boolean publish(Amenity amenity) {
                    try {
                        boolean isRelation;
                        boolean bl = isRelation = amenity.getId() < 0L;
                        if (isRelation) {
                            List list;
                            long j = BinaryMerger.latlon(amenity);
                            if (!amenityRelations.containsKey(j)) {
                                list = new ArrayList(1);
                                amenityRelations.put(j, list);
                            } else {
                                list = (List)amenityRelations.get(j);
                            }
                            boolean unique = true;
                            for (Amenity a : list) {
                                if (a.getType() != amenity.getType() || !Algorithms.objectEquals((Object)a.getSubType(), (Object)amenity.getSubType())) continue;
                                unique = false;
                                break;
                            }
                            if (unique) {
                                long l = generatedRelationId[0];
                                generatedRelationId[0] = l - 1L;
                                amenity.setId(Long.valueOf(l));
                                ((List)amenityRelations.get(j)).add(amenity);
                                indexPoiCreator.resetOrder(amenity);
                                indexPoiCreator.insertAmenityIntoPoi(amenity);
                                writtenPoiCount[0] = writtenPoiCount[0] + 1;
                            }
                        } else if (!set.contains(amenity.getId().longValue())) {
                            file.add(amenity.getId().longValue());
                            indexPoiCreator.resetOrder(amenity);
                            indexPoiCreator.insertAmenityIntoPoi(amenity);
                            writtenPoiCount[0] = writtenPoiCount[0] + 1;
                        }
                        return false;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            }));
            set.addAll((TLongCollection)file);
        }
        indexPoiCreator.writeBinaryPoiIndex(null, writer, name, null);
        indexPoiCreator.commitAndClosePoiFile(dateCreated);
        if (IndexCreator.REMOVE_POI_DB) {
            indexPoiCreator.removePoiFile();
        }
        log.info((Object)("Written " + writtenPoiCount[0] + " POI."));
    }

    public static void copyBinaryPart(CodedOutputStream ous, byte[] BUFFER, RandomAccessFile raf, long fp, long length) throws IOException {
        BinaryInspector.copyBinaryPart(ous, BUFFER, raf, fp, length);
    }

    public void combineParts(File fileToExtract, List<File> files, List<BinaryMapIndexReader> readers, Set<Integer> combineParts) throws IOException, SQLException {
        boolean combineFiles = files != null;
        BinaryMapIndexReader[] indexes = combineFiles ? new BinaryMapIndexReader[files.size()] : readers.toArray(new BinaryMapIndexReader[readers.size()]);
        RandomAccessFile[] rafs = combineFiles ? new RandomAccessFile[files.size()] : null;
        long dateCreated = 0L;
        int version = -1;
        int c = 0;
        if (combineFiles) {
            for (File f : files) {
                if (f.getAbsolutePath().equals(fileToExtract.getAbsolutePath())) {
                    System.err.println("Error : Input file is equal to output file " + f.getAbsolutePath());
                    return;
                }
                rafs[c] = new RandomAccessFile(f.getAbsolutePath(), "r");
                indexes[c] = new BinaryMapIndexReader(rafs[c], f);
                dateCreated = Math.max(dateCreated, indexes[c].getDateCreated());
                if (version == -1) {
                    version = indexes[c].getVersion();
                } else if (indexes[c].getVersion() != version) {
                    System.err.println("Error : Different input files has different input versions " + indexes[c].getVersion() + " != " + version);
                    return;
                }
                ++c;
            }
        } else {
            for (BinaryMapIndexReader index : indexes) {
                dateCreated = Math.max(dateCreated, index.getDateCreated());
                if (version == -1) {
                    version = index.getVersion();
                    continue;
                }
                if (index.getVersion() == version) continue;
                System.err.println("Error : Different input files has different input versions " + index.getVersion() + " != " + version);
                return;
            }
        }
        RandomAccessFile rafToExtract = new RandomAccessFile(fileToExtract, "rw");
        BinaryMapIndexWriter writer = new BinaryMapIndexWriter(rafToExtract, dateCreated);
        CodedOutputStream ous = writer.getCodedOutStream();
        byte[] BUFFER_TO_READ = new byte[0x100000];
        BinaryMapAddressReaderAdapter.AddressRegion[] addressRegions = new BinaryMapAddressReaderAdapter.AddressRegion[combineFiles ? files.size() : readers.size()];
        BinaryMapPoiReaderAdapter.PoiRegion[] poiRegions = new BinaryMapPoiReaderAdapter.PoiRegion[combineFiles ? files.size() : readers.size()];
        for (int k = 0; k < indexes.length; ++k) {
            BinaryMapIndexReader index = indexes[k];
            RandomAccessFile raf = rafs != null ? rafs[k] : null;
            for (int i = 0; i < index.getIndexes().size(); ++i) {
                BinaryIndexPart part = (BinaryIndexPart)index.getIndexes().get(i);
                if (combineParts.contains(part.getFieldNumber())) {
                    if (part.getFieldNumber() == 7) {
                        addressRegions[k] = (BinaryMapAddressReaderAdapter.AddressRegion)part;
                        continue;
                    }
                    if (part.getFieldNumber() == 8) {
                        poiRegions[k] = (BinaryMapPoiReaderAdapter.PoiRegion)part;
                        continue;
                    }
                    if (part.getFieldNumber() != 10) continue;
                    continue;
                }
                if (raf == null) continue;
                ous.writeTag(part.getFieldNumber(), 6);
                BinaryMerger.writeInt(ous, part.getLength());
                BinaryMerger.copyBinaryPart(ous, BUFFER_TO_READ, raf, part.getFilePointer(), part.getLength());
                System.out.println(MessageFormat.format("{2} part {0} is extracted {1} bytes", part.getName(), part.getLength(), part.getPartName()));
            }
        }
        String nm = fileToExtract.getName();
        int i = nm.indexOf(95);
        if (i > 0) {
            nm = nm.substring(0, i);
        }
        if (combineParts.contains(7)) {
            this.combineAddressIndex(nm, writer, addressRegions, indexes);
        }
        if (combineParts.contains(8)) {
            this.combinePoiIndex(nm, writer, dateCreated, poiRegions, indexes);
        }
        if (combineParts.contains(33) && this.osmAndOwner != null) {
            writer.writeOsmAndOwner(this.osmAndOwner);
        }
        ous.writeInt32(32, version);
        ous.flush();
    }

    public void merger(String[] args) throws IOException, SQLException {
        if (args == null || args.length == 0) {
            System.out.println(helpMessage);
            return;
        }
        File outputFile = null;
        ArrayList<File> parts = new ArrayList<File>();
        ArrayList<File> toDelete = new ArrayList<File>();
        HashSet<Integer> combineParts = new HashSet<Integer>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--")) {
                combineParts.add(COMBINE_ARGS.get(args[i]));
                continue;
            }
            if (outputFile == null) {
                outputFile = new File(args[i]);
                continue;
            }
            File file = new File(args[i]);
            if (file.getName().endsWith(".zip")) {
                ZipEntry ze;
                File tmp = File.createTempFile(file.getName(), "obf");
                ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
                while ((ze = zis.getNextEntry()) != null) {
                    String name = ze.getName();
                    if (ze.isDirectory() || !name.endsWith(".obf")) continue;
                    FileOutputStream fout = new FileOutputStream(tmp);
                    Algorithms.streamCopy((InputStream)zis, (OutputStream)fout);
                    fout.close();
                    parts.add(tmp);
                }
                zis.close();
                tmp.deleteOnExit();
                toDelete.add(tmp);
                continue;
            }
            parts.add(file);
        }
        if (combineParts.isEmpty()) {
            combineParts.addAll(COMBINE_ARGS.values());
        }
        if (outputFile.exists() && !outputFile.delete()) {
            throw new IOException("Cannot delete file " + String.valueOf(outputFile));
        }
        this.combineParts(outputFile, parts, null, combineParts);
        for (File f : toDelete) {
            if (f.delete()) continue;
            throw new IOException("Cannot delete file " + String.valueOf(outputFile));
        }
    }

    static {
        COMBINE_ARGS.put("--address", 7);
        COMBINE_ARGS.put("--poi", 8);
        COMBINE_ARGS.put("--hhindex", 10);
        COMBINE_ARGS.put("--owner", 33);
    }
}

