/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.CachedOsmandIndexes;
import net.osmand.binary.MapZooms;
import net.osmand.data.LatLon;
import net.osmand.router.RoutingConfiguration;
import net.osmand.util.Algorithms;
import org.xmlpull.v1.XmlPullParserException;

public class DataExtractionSettings {
    public static final String INDEXES_CACHE = "indexes.cache";
    private static DataExtractionSettings settings = null;
    Map<String, BinaryMapIndexReaderReference> obfFiles = new ConcurrentHashMap<String, BinaryMapIndexReaderReference>();
    Preferences preferences = Preferences.userRoot();
    long lastSaved = 0L;

    public static DataExtractionSettings getSettings() {
        if (settings == null) {
            settings = new DataExtractionSettings();
        }
        return settings;
    }

    public BinaryMapIndexReader[] getObfReaders() throws IOException {
        File[] sortedFiles;
        ArrayList<BinaryMapIndexReader> files = new ArrayList<BinaryMapIndexReader>();
        File mapsFolder = new File(this.getBinaryFilesDir());
        CachedOsmandIndexes cache = null;
        File cacheFile = new File(mapsFolder, INDEXES_CACHE);
        if (mapsFolder.exists() && this.obfFiles.isEmpty() && INDEXES_CACHE.length() > 0) {
            cache = new CachedOsmandIndexes();
            if (cacheFile.exists()) {
                cache.readFromFile(cacheFile);
            }
        }
        if ((sortedFiles = Algorithms.getSortedFilesVersions((File)mapsFolder)) != null) {
            for (File obf : sortedFiles) {
                if (!obf.getName().endsWith(".obf")) continue;
                BinaryMapIndexReaderReference ref = this.obfFiles.get(obf.getAbsolutePath());
                if (ref == null || ref.reader == null) {
                    ref = new BinaryMapIndexReaderReference();
                    ref.file = obf;
                    if (cache == null) {
                        RandomAccessFile raf = new RandomAccessFile(obf, "r");
                        ref.reader = new BinaryMapIndexReader(raf, obf);
                    } else {
                        ref.reader = cache.getReader(obf, true);
                    }
                    this.obfFiles.put(obf.getAbsolutePath(), ref);
                }
                files.add(ref.reader);
            }
        }
        if (cache != null && !files.isEmpty()) {
            cache.writeToFile(cacheFile);
        }
        return files.toArray(new BinaryMapIndexReader[files.size()]);
    }

    public void saveLocation(double lat, double lon, int zoom, boolean save) {
        long ms = System.currentTimeMillis();
        if (ms - this.lastSaved > 5000L || save) {
            this.saveDefaultLocation(lat, lon);
            this.saveDefaultZoom(zoom);
            this.lastSaved = ms;
        }
    }

    public File getTilesDirectory() {
        return new File(this.getDefaultWorkingDir(), "tiles");
    }

    public File getDefaultWorkingDir() {
        Object workingDir = this.preferences.get("working_dir", System.getProperty("user.home"));
        if (((String)workingDir).equals(System.getProperty("user.home"))) {
            workingDir = (String)workingDir + "/osmand";
            new File((String)workingDir).mkdir();
        }
        return new File((String)workingDir);
    }

    public void saveDefaultWorkingDir(File path) {
        this.preferences.put("working_dir", path.getAbsolutePath());
    }

    public LatLon getDefaultLocation() {
        double lat = this.preferences.getDouble("default_lat", 53.9);
        double lon = this.preferences.getDouble("default_lon", 27.56);
        return new LatLon(lat, lon);
    }

    public LatLon getStartLocation() {
        double lat = this.preferences.getDouble("start_lat", 53.9);
        double lon = this.preferences.getDouble("start_lon", 27.56);
        return new LatLon(lat, lon);
    }

    public LatLon getEndLocation() {
        double lat = this.preferences.getDouble("end_lat", 53.9);
        double lon = this.preferences.getDouble("end_lon", 27.56);
        return new LatLon(lat, lon);
    }

    public void saveDefaultLocation(double lat, double lon) {
        this.preferences.putDouble("default_lat", lat);
        this.preferences.putDouble("default_lon", lon);
    }

    public void saveStartLocation(double lat, double lon) {
        this.preferences.putDouble("start_lat", lat);
        this.preferences.putDouble("start_lon", lon);
    }

    public void saveEndLocation(double lat, double lon) {
        this.preferences.putDouble("end_lat", lat);
        this.preferences.putDouble("end_lon", lon);
    }

    public MapZooms getMapZooms() {
        String value = this.preferences.get("map_zooms", MapZooms.MAP_ZOOMS_DEFAULT);
        return MapZooms.parseZooms((String)value);
    }

    public String getMapZoomsValue() {
        return this.preferences.get("map_zooms", MapZooms.MAP_ZOOMS_DEFAULT);
    }

    public void setMapZooms(String zooms) {
        MapZooms.parseZooms((String)zooms);
        this.preferences.put("map_zooms", zooms);
    }

    public String getLineSmoothness() {
        return this.preferences.get("line_smoothness", "2");
    }

    public void setLineSmoothness(String smooth) {
        Integer.parseInt(smooth);
        this.preferences.put("line_smoothness", smooth);
    }

    public String getPoiTypesFile() {
        return this.preferences.get("poi_types_file", "");
    }

    public void setPoiTypesFile(String fileName) {
        this.preferences.put("poi_types_file", fileName);
    }

    public String getMapRenderingTypesFile() {
        return this.preferences.get("rendering_types_file", "");
    }

    public void setMapRenderingTypesFile(String fileName) {
        this.preferences.put("rendering_types_file", fileName);
    }

    public int getDefaultZoom() {
        return this.preferences.getInt("default_zoom", 5);
    }

    public void saveDefaultZoom(int zoom) {
        this.preferences.putInt("default_zoom", zoom);
    }

    public boolean getLoadEntityInfo() {
        return this.preferences.getBoolean("load_entity_info", true);
    }

    public void setLoadEntityInfo(boolean loadEntityInfo) {
        this.preferences.putBoolean("load_entity_info", loadEntityInfo);
    }

    public Rectangle getWindowBounds() {
        Rectangle r = new Rectangle();
        r.x = this.preferences.getInt("window_x", 0);
        r.y = this.preferences.getInt("window_y", 0);
        r.width = this.preferences.getInt("window_width", 800);
        r.height = this.preferences.getInt("window_height", 600);
        return r;
    }

    public void saveWindowBounds(Rectangle r) {
        this.preferences.putInt("window_x", r.x);
        this.preferences.putInt("window_y", r.y);
        this.preferences.putInt("window_width", r.width);
        this.preferences.putInt("window_height", r.height);
    }

    public boolean useAdvancedRoutingUI() {
        return this.preferences.getBoolean("use_advanced_routing_ui", false);
    }

    public void setUseAdvancedRoutingUI(boolean b) {
        this.preferences.putBoolean("use_advanced_routing_ui", b);
    }

    public boolean useInternetToLoadImages() {
        return this.preferences.getBoolean("use_internet", true);
    }

    public void setUseInterentToLoadImages(boolean b) {
        this.preferences.putBoolean("use_internet", b);
    }

    public String getSearchLocale() {
        return this.preferences.get("searchLocale", "");
    }

    public void setSearchLocale(String s) {
        this.preferences.put("searchLocale", s);
    }

    public String getRouteMode() {
        return this.preferences.get("routeMode", "car,short_way");
    }

    public void setRouteMode(String mode) {
        this.preferences.put("routeMode", mode);
    }

    public String getNativeLibFile() {
        String fl = this.preferences.get("nativeLibFile", null);
        if (fl != null) {
            return fl;
        }
        return "";
    }

    public String getQtLibFolder() {
        String fl = this.preferences.get("qtLibFolder", null);
        if (fl != null) {
            return fl;
        }
        return "";
    }

    public void setNativeLibFile(String file) {
        this.preferences.put("nativeLibFile", file);
    }

    public void setQtLibFolder(String file) {
        this.preferences.put("qtLibFolder", file);
    }

    public String getRenderXmlPath() {
        return this.preferences.get("renderXmlPath", "default.render.xml");
    }

    public void setRenderXmlPath(String file) {
        this.preferences.put("renderXmlPath", file);
    }

    public String getRenderGenXmlPath() {
        return this.preferences.get("renderGenXmlPath", "");
    }

    public void setRenderGenXmlPath(String path) {
        this.preferences.put("renderGenXmlPath", path);
    }

    public String getRoutingXmlPath() {
        return this.preferences.get("routingXmlPath", "routing.xml");
    }

    public RoutingConfiguration.Builder getRoutingConfig() {
        RoutingConfiguration.Builder builder;
        String xmlPath = this.getRoutingXmlPath();
        if (xmlPath.equals("routing.xml")) {
            builder = RoutingConfiguration.getDefault();
        } else {
            try {
                builder = RoutingConfiguration.parseFromInputStream((InputStream)new FileInputStream(xmlPath));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error parsing routing.xml file", e);
            }
            catch (XmlPullParserException e) {
                throw new IllegalArgumentException("Error parsing routing.xml file", e);
            }
        }
        return builder;
    }

    public void setRoutingXmlPath(String file) {
        this.preferences.put("routingXmlPath", file);
    }

    public String getBinaryFilesDir() {
        String fl = this.preferences.get("binaryFilesDir", null);
        if (fl != null) {
            return fl;
        }
        return this.getDefaultWorkingDir().getAbsolutePath();
    }

    public void setBinaryFilesDir(String file) {
        this.preferences.put("binaryFilesDir", file);
    }

    public String getLastUsedDir() {
        String fl = this.preferences.get("lastUsedDir", null);
        if (fl != null) {
            return fl;
        }
        return this.getDefaultWorkingDir().getAbsolutePath();
    }

    public void setLastUsedDir(String file) {
        this.preferences.put("lastUsedDir", file);
    }

    public String getOsrmServerAddress() {
        return this.preferences.get("osrmServerAddress", "http://127.0.0.1:5000");
    }

    public void setOsrmServerAddress(String s) {
        this.preferences.put("osrmServerAddress", s);
    }

    public boolean isSupressWarningsForDuplicatedId() {
        return this.preferences.getBoolean("supress_duplicated_id", true);
    }

    public void setSupressWarningsForDuplicatedId(boolean b) {
        this.preferences.putBoolean("supress_duplicated_id", b);
    }

    public boolean isAnimateRouting() {
        return this.preferences.getBoolean("animate_routing", false);
    }

    public boolean useNativeRouting() {
        return this.preferences.getBoolean("native_routing", false);
    }

    public void setAnimateRouting(boolean b) {
        this.preferences.putBoolean("animate_routing", b);
    }

    public void setNativeRouting(boolean b) {
        this.preferences.putBoolean("native_routing", b);
    }

    public void preferHousenumber(boolean b) {
        this.preferences.putBoolean("prefer_housenumber", b);
    }

    public boolean isHousenumberPrefered() {
        return this.preferences.getBoolean("prefer_housenumber", true);
    }

    public void AdditionalInfo(boolean b) {
        this.preferences.putBoolean("additional_address_info", b);
    }

    public boolean isAdditionalInfo() {
        return this.preferences.getBoolean("additional_address_info", true);
    }

    public void setRenderingProperties(String renderingProperties) {
        this.preferences.put("rendering_props", renderingProperties);
    }

    public String getRenderingProperties() {
        return this.preferences.get("rendering_props", "nightMode=false, appMode=default, noPolygons=false, hmRendered=false");
    }

    public static class BinaryMapIndexReaderReference {
        File file;
        BinaryMapIndexReader reader;
    }
}

