/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.osmand.Location;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataBundle;
import net.osmand.binary.StringBundle;
import net.osmand.router.RouteDataResources;
import net.osmand.router.RouteSegmentResult;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.util.Algorithms;

public class RouteExporter {
    public static final String OSMAND_ROUTER_V2 = "OsmAndRouterV2";
    private final String name;
    private final List<RouteSegmentResult> route;
    private final List<Location> locations;
    private final List<Integer> routePointIndexes;
    private final List<WptPt> points;

    public RouteExporter(String name, List<RouteSegmentResult> route, List<Location> locations, List<Integer> routePointIndexes, List<WptPt> points) {
        this.name = name;
        this.route = route;
        this.locations = locations;
        this.routePointIndexes = routePointIndexes == null ? new ArrayList() : routePointIndexes;
        this.points = points;
    }

    public GpxFile exportRoute() {
        GpxFile gpx = new GpxFile(OSMAND_ROUTER_V2);
        Track track = new Track();
        track.setName(this.name);
        gpx.getTracks().add(track);
        track.getSegments().add(this.generateRouteSegment());
        if (this.points != null) {
            for (WptPt pt : this.points) {
                gpx.addPoint(pt);
            }
        }
        return gpx;
    }

    public static GpxFile exportRoute(String name, List<TrkSegment> trkSegments, List<WptPt> points, List<List<WptPt>> routePoints) {
        GpxFile gpx = new GpxFile(OSMAND_ROUTER_V2);
        Track track = new Track();
        track.setName(name);
        gpx.getTracks().add(track);
        track.getSegments().addAll(trkSegments);
        if (points != null) {
            for (WptPt wptPt : points) {
                gpx.addPoint(wptPt);
            }
        }
        if (routePoints != null) {
            for (List list : routePoints) {
                gpx.addRoutePoints(list, true);
            }
        }
        return gpx;
    }

    public TrkSegment generateRouteSegment() {
        RouteDataResources resources = new RouteDataResources(this.locations, this.routePointIndexes);
        ArrayList<Object> routeItems = new ArrayList<Object>();
        if (!Algorithms.isEmpty(this.route)) {
            for (RouteSegmentResult sr : this.route) {
                sr.collectTypes(resources);
            }
            for (RouteSegmentResult sr : this.route) {
                sr.collectNames(resources);
            }
            for (RouteSegmentResult sr : this.route) {
                RouteDataBundle itemBundle = new RouteDataBundle(resources);
                sr.writeToBundle(itemBundle);
                routeItems.add(itemBundle);
            }
        }
        ArrayList<RouteDataBundle> typeList = new ArrayList<RouteDataBundle>();
        Map<BinaryMapRouteReaderAdapter.RouteTypeRule, Integer> rules = resources.getRules();
        for (BinaryMapRouteReaderAdapter.RouteTypeRule rule : rules.keySet()) {
            RouteDataBundle typeBundle = new RouteDataBundle(resources);
            rule.writeToBundle(typeBundle);
            typeList.add(typeBundle);
        }
        TrkSegment trkSegment = new TrkSegment();
        if (this.locations == null || this.locations.isEmpty()) {
            return trkSegment;
        }
        for (int i = 0; i < this.locations.size(); ++i) {
            Location loc = this.locations.get(i);
            WptPt wptPt = new WptPt();
            wptPt.setLat(loc.getLatitude());
            wptPt.setLon(loc.getLongitude());
            if (loc.hasSpeed()) {
                wptPt.setSpeed((double)loc.getSpeed());
            }
            if (loc.hasAltitude()) {
                wptPt.setEle(loc.getAltitude());
            }
            if (loc.hasAccuracy()) {
                wptPt.setHdop((double)loc.getAccuracy());
            }
            trkSegment.getPoints().add(wptPt);
        }
        ArrayList<GpxUtilities.RouteSegment> routeSegments = new ArrayList<GpxUtilities.RouteSegment>();
        for (StringBundle stringBundle : routeItems) {
            net.osmand.shared.util.StringBundle stringBundle2 = this.kStringBundleJustStrings(stringBundle);
            routeSegments.add(GpxUtilities.RouteSegment.Companion.fromStringBundle(stringBundle2));
        }
        trkSegment.setRouteSegments(routeSegments);
        ArrayList<GpxUtilities.RouteType> routeTypes = new ArrayList<GpxUtilities.RouteType>();
        for (StringBundle stringBundle : typeList) {
            net.osmand.shared.util.StringBundle itemInStrings = this.kStringBundleJustStrings(stringBundle);
            routeTypes.add(GpxUtilities.RouteType.Companion.fromStringBundle(itemInStrings));
        }
        trkSegment.setRouteTypes(routeTypes);
        return trkSegment;
    }

    private net.osmand.shared.util.StringBundle kStringBundleJustStrings(StringBundle in) {
        net.osmand.shared.util.StringBundle out = new net.osmand.shared.util.StringBundle();
        in.getMap().forEach((key, item) -> {
            String asString = in.getString((String)key, null);
            if (asString != null) {
                out.putString(key, asString);
            }
        });
        return out;
    }
}

