/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.QuadRect;
import net.osmand.data.Ring;
import net.osmand.map.OsmandRegions;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.xmlpull.v1.XmlPullParserException;

public class TileListsForRegions {
    private static final String LOCK_EXTENSION = ".proc";
    private static int ZOOM = 9;
    private static boolean SKIP_EXISTING = true;
    private static String EXTENSION = ".tif";

    public static void main(String[] args) throws IOException {
        File directoryWithTargetFiles = new File(args[0]);
        String filter = null;
        String prefix = "Hillshade_";
        String regionAttribute = "region_hillshade";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("--prefix=")) {
                prefix = args[i].substring("--prefix=".length());
                continue;
            }
            if (args[i].startsWith("--skip-existing=")) {
                SKIP_EXISTING = Boolean.parseBoolean(args[i].substring("--skip-existing=".length()));
                continue;
            }
            if (args[i].startsWith("--extension=")) {
                EXTENSION = args[i].substring("--extension=".length());
                continue;
            }
            if (args[i].startsWith("--zoom=")) {
                ZOOM = Integer.parseInt(args[i].substring("--zoom=".length()));
                continue;
            }
            if (args[i].startsWith("--region-ocbf-attr=")) {
                regionAttribute = args[i].substring("--region-ocbf-attr=".length());
                continue;
            }
            if (!args[i].startsWith("--filter=") || (filter = args[i].substring("--filter=".length())).length() != 0) continue;
            filter = null;
        }
        OsmandRegions or = new OsmandRegions();
        BinaryMapIndexReader fl = or.prepareFile();
        Map allCountries = or.cacheAllCountries();
        BinaryMapIndexReader.MapIndex mapIndex = (BinaryMapIndexReader.MapIndex)fl.getMapIndexes().get(0);
        int regAttr = Algorithms.isEmpty((CharSequence)regionAttribute) ? -1 : mapIndex.getRule(regionAttribute, "yes");
        int downloadName = mapIndex.getRule("download_name", null);
        int boundary = mapIndex.getRule("osmand_region", "boundary");
        int cnt = 1;
        HashSet<String> failedCountries = new HashSet<String>();
        for (String fullName : allCountries.keySet()) {
            LinkedList lst = (LinkedList)allCountries.get(fullName);
            if (fullName == null || filter != null && !fullName.contains(filter)) continue;
            BinaryMapDataObject rc = null;
            for (BinaryMapDataObject r : lst) {
                if (r.containsType(boundary)) continue;
                rc = r;
                break;
            }
            if (rc != null && (regAttr == -1 || rc.containsAdditionalType(regAttr))) {
                String dw = rc.getNameByType(downloadName);
                System.out.println("Region " + fullName + " " + cnt++ + " out of " + allCountries.size());
                try {
                    TileListsForRegions.process(rc, lst, dw, directoryWithTargetFiles, prefix);
                }
                catch (Exception e) {
                    failedCountries.add(fullName);
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println(String.format("Region %s skipped as it doesn't attribute %s = yes. ", fullName, regionAttribute));
        }
        if (!failedCountries.isEmpty()) {
            throw new IllegalStateException("Failed countries " + String.valueOf(failedCountries));
        }
    }

    private static void process(BinaryMapDataObject country, List<BinaryMapDataObject> boundaries, String downloadName, File directoryWithTargetFiles, String prefix) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        String name = country.getName();
        String dwName = prefix + Algorithms.capitalizeFirstLetterAndLowercase((String)downloadName) + ".txt";
        File targetFile = new File(directoryWithTargetFiles, dwName);
        if (!SKIP_EXISTING) {
            File lockFile = new File(directoryWithTargetFiles, dwName + LOCK_EXTENSION);
            lockFile.delete();
            if (!lockFile.exists()) {
                targetFile.delete();
            }
        }
        if (targetFile.exists()) {
            System.out.println("Already processed " + name);
            return;
        }
        FileOutputStream fos = new FileOutputStream(targetFile);
        BufferedWriter wb = new BufferedWriter(new OutputStreamWriter(fos));
        QuadRect qr = new QuadRect(180.0, -90.0, -180.0, 90.0);
        MultipolygonBuilder bld = new MultipolygonBuilder();
        if (boundaries != null) {
            for (BinaryMapDataObject o : boundaries) {
                bld.addOuterWay(TileListsForRegions.convertToWay(o));
                TileListsForRegions.updateBbox(o, qr);
            }
        } else {
            bld.addOuterWay(TileListsForRegions.convertToWay(country));
            TileListsForRegions.updateBbox(country, qr);
        }
        Multipolygon polygon = bld.build();
        int rightLon = (int)Math.floor(MapUtils.getTileNumberX((float)ZOOM, (double)qr.right));
        int leftLon = (int)Math.floor(MapUtils.getTileNumberX((float)ZOOM, (double)qr.left));
        int bottomLat = (int)Math.floor(MapUtils.getTileNumberY((float)ZOOM, (double)qr.bottom));
        int topLat = (int)Math.floor(MapUtils.getTileNumberY((float)ZOOM, (double)qr.top));
        boolean onetile = leftLon == rightLon && bottomLat == topLat;
        for (int tileX = leftLon; tileX <= rightLon; ++tileX) {
            for (int tileY = topLat; tileY <= bottomLat; ++tileY) {
                double blat;
                boolean isOut;
                double llon = MapUtils.getLongitudeFromTile((double)ZOOM, (double)tileX);
                double rlon = MapUtils.getLongitudeFromTile((double)ZOOM, (double)(tileX + 1));
                double tlat = MapUtils.getLatitudeFromTile((float)ZOOM, (double)tileY);
                boolean bl = isOut = !polygon.containsPoint(tlat / 2.0 + (blat = MapUtils.getLatitudeFromTile((float)ZOOM, (double)(tileY + 1))) / 2.0, llon / 2.0 + rlon / 2.0) && !onetile;
                if (isOut) {
                    LatLon bl2 = new LatLon(blat, llon);
                    LatLon br = new LatLon(blat, rlon);
                    LatLon tr = new LatLon(tlat, rlon);
                    LatLon tl = new LatLon(tlat, llon);
                    for (Ring r : polygon.getOuterRings()) {
                        List border = r.getBorder();
                        Node prev = (Node)border.get(border.size() - 1);
                        for (int i = 0; i < border.size() && isOut; ++i) {
                            Node n = (Node)border.get(i);
                            if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)tr, (LatLon)tl)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)tr, (LatLon)br)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)bl2, (LatLon)tl)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)br, (LatLon)bl2)) {
                                isOut = false;
                            }
                            prev = n;
                        }
                        if (isOut) continue;
                        break;
                    }
                }
                if (isOut) continue;
                int x = tileX;
                int y = tileY;
                wb.write("./" + ZOOM + "/" + tileX + "/" + tileY + EXTENSION);
                wb.newLine();
            }
        }
        wb.close();
    }

    private static Way convertToWay(BinaryMapDataObject o) {
        Way w = new Way(-1L);
        for (int i = 0; i < o.getPointsLength(); ++i) {
            double lat = MapUtils.get31LatitudeY((int)o.getPoint31YTile(i));
            double lon = MapUtils.get31LongitudeX((int)o.getPoint31XTile(i));
            w.addNode(new Node(lat, lon, -1L));
        }
        return w;
    }

    private static void updateBbox(BinaryMapDataObject country, QuadRect qr) {
        for (int i = 0; i < country.getPointsLength(); ++i) {
            double lat = MapUtils.get31LatitudeY((int)country.getPoint31YTile(i));
            double lon = MapUtils.get31LongitudeX((int)country.getPoint31XTile(i));
            qr.left = Math.min(lon, qr.left);
            qr.right = Math.max(lon, qr.right);
            qr.top = Math.max(lat, qr.top);
            qr.bottom = Math.min(lat, qr.bottom);
        }
    }
}

