/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.GpxDirItem;
import net.osmand.shared.gpx.GpxHelper;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.data.ComparableTracksGroup;
import net.osmand.shared.gpx.data.TracksGroup;
import net.osmand.shared.gpx.filters.TrackFolderAnalysis;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.KCollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010(\u001a\u00020\u0000J\b\u0010)\u001a\u0004\u0018\u00010\u0000J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bJ\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0014\u0010,\u001a\u00020\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bJ\u000e\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0000J\u0014\u0010/\u001a\u00020\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f00J\u000e\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\fJ\u0014\u00103\u001a\u00020\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bJ\b\u0010=\u001a\u00020\u0011H\u0016J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020&H\u0016J\u0006\u0010@\u001a\u00020\u0013J\u0006\u0010A\u001a\u00020\u001bJ\u0006\u0010B\u001a\u00020\u001bJ\b\u0010C\u001a\u000206H\u0016J\u0013\u0010D\u001a\u00020&2\b\u0010E\u001a\u0004\u0018\u00010FH\u0096\u0002J\b\u0010G\u001a\u00020\u001eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\"\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0011\u00104\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010'R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b:\u00108\u00a8\u0006H"}, d2={"Lnet/osmand/shared/gpx/data/TrackFolder;", "Lnet/osmand/shared/gpx/data/TracksGroup;", "Lnet/osmand/shared/gpx/data/ComparableTracksGroup;", "dirFile", "Lnet/osmand/shared/io/KFile;", "parentFolder", "<init>", "(Lnet/osmand/shared/io/KFile;Lnet/osmand/shared/gpx/data/TrackFolder;)V", "trackFolder", "(Lnet/osmand/shared/gpx/data/TrackFolder;)V", "trackItems", "", "Lnet/osmand/shared/gpx/TrackItem;", "subFolders", "flattenedTrackItems", "flattenedSubFolders", "folderAnalysis", "Lnet/osmand/shared/gpx/filters/TrackFolderAnalysis;", "lastModified", "", "dirItem", "Lnet/osmand/shared/gpx/GpxDirItem;", "getDirItem", "()Lnet/osmand/shared/gpx/GpxDirItem;", "setDirItem", "(Lnet/osmand/shared/gpx/GpxDirItem;)V", "update", "", "folder", "getId", "", "getName", "getDirFile", "setDirFile", "relativePath", "getRelativePath", "()Ljava/lang/String;", "isRootFolder", "", "()Z", "getRootFolder", "getParentFolder", "getSubFolders", "getTrackItems", "setSubFolders", "addSubFolder", "subFolder", "setTrackItems", "", "addTrackItem", "trackItem", "addTrackItems", "isEmpty", "color", "", "getColor", "()I", "totalTracksCount", "getTotalTracksCount", "getFlattenedTrackItems", "getFlattenedSubFolders", "getFolderAnalysis", "getDirName", "includingSubdirs", "getLastModified", "clearData", "resetCachedData", "hashCode", "equals", "other", "", "toString", "OsmAnd-shared"})
public final class TrackFolder
implements TracksGroup,
ComparableTracksGroup {
    @NotNull
    private KFile dirFile;
    @Nullable
    private final TrackFolder parentFolder;
    @NotNull
    private List<TrackItem> trackItems;
    @NotNull
    private List<TrackFolder> subFolders;
    @Nullable
    private List<TrackItem> flattenedTrackItems;
    @Nullable
    private List<TrackFolder> flattenedSubFolders;
    @Nullable
    private TrackFolderAnalysis folderAnalysis;
    private long lastModified;
    @Nullable
    private GpxDirItem dirItem;

    public TrackFolder(@NotNull KFile dirFile, @Nullable TrackFolder parentFolder) {
        Intrinsics.checkNotNullParameter((Object)dirFile, (String)"dirFile");
        this.trackItems = CollectionsKt.emptyList();
        this.subFolders = CollectionsKt.emptyList();
        this.lastModified = -1L;
        this.dirFile = dirFile;
        this.parentFolder = parentFolder;
    }

    @Nullable
    public final GpxDirItem getDirItem() {
        return this.dirItem;
    }

    public final void setDirItem(@Nullable GpxDirItem gpxDirItem) {
        this.dirItem = gpxDirItem;
    }

    public TrackFolder(@NotNull TrackFolder trackFolder) {
        Intrinsics.checkNotNullParameter((Object)trackFolder, (String)"trackFolder");
        this(trackFolder.dirFile, trackFolder.parentFolder);
        this.update(trackFolder);
    }

    public final void update(@NotNull TrackFolder folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.trackItems = new ArrayList(folder.trackItems);
        this.subFolders = new ArrayList(folder.subFolders);
        List<TrackItem> list = folder.flattenedTrackItems;
        this.flattenedTrackItems = list != null ? CollectionsKt.toList((Iterable)list) : null;
        List<TrackFolder> list2 = folder.flattenedSubFolders;
        this.flattenedSubFolders = list2 != null ? CollectionsKt.toList((Iterable)list2) : null;
        this.folderAnalysis = folder.folderAnalysis;
        this.lastModified = folder.lastModified;
    }

    @Override
    @NotNull
    public String getId() {
        return this.getRelativePath();
    }

    @Override
    @NotNull
    public String getName() {
        return GpxHelper.INSTANCE.getFolderName(this.dirFile, false);
    }

    @NotNull
    public final KFile getDirFile() {
        return this.dirFile;
    }

    public final void setDirFile(@NotNull KFile dirFile) {
        Intrinsics.checkNotNullParameter((Object)dirFile, (String)"dirFile");
        this.dirFile = dirFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRelativePath() {
        Object object;
        if (!this.isRootFolder()) {
            void var1_1;
            TrackFolder parent;
            String dirName = this.dirFile.name();
            TrackFolder trackFolder = parent = this.getParentFolder();
            object = (trackFolder != null ? !trackFolder.isRootFolder() : false) ? parent.getRelativePath() + "/" + dirName : var1_1;
        } else {
            object = "";
        }
        return object;
    }

    public final boolean isRootFolder() {
        return this.getParentFolder() == null;
    }

    @NotNull
    public final TrackFolder getRootFolder() {
        TrackFolder trackFolder = this.getParentFolder();
        if (trackFolder == null || (trackFolder = trackFolder.getRootFolder()) == null) {
            trackFolder = this;
        }
        return trackFolder;
    }

    @Nullable
    public final TrackFolder getParentFolder() {
        return this.parentFolder;
    }

    @NotNull
    public final List<TrackFolder> getSubFolders() {
        return this.subFolders;
    }

    @Override
    @NotNull
    public List<TrackItem> getTrackItems() {
        return this.trackItems;
    }

    public final void setSubFolders(@NotNull List<TrackFolder> subFolders) {
        Intrinsics.checkNotNullParameter(subFolders, (String)"subFolders");
        this.subFolders = new ArrayList(subFolders);
    }

    public final void addSubFolder(@NotNull TrackFolder subFolder) {
        Intrinsics.checkNotNullParameter((Object)subFolder, (String)"subFolder");
        this.subFolders = KCollectionUtils.INSTANCE.addToList((Collection)this.subFolders, subFolder);
    }

    public final void setTrackItems(@NotNull List<TrackItem> trackItems) {
        Intrinsics.checkNotNullParameter(trackItems, (String)"trackItems");
        this.trackItems = new ArrayList(trackItems);
    }

    public final void addTrackItem(@NotNull TrackItem trackItem) {
        Intrinsics.checkNotNullParameter((Object)trackItem, (String)"trackItem");
        this.trackItems = KCollectionUtils.INSTANCE.addToList((Collection)this.trackItems, trackItem);
    }

    public final void addTrackItems(@NotNull List<TrackItem> trackItems) {
        Intrinsics.checkNotNullParameter(trackItems, (String)"trackItems");
        this.trackItems = KCollectionUtils.INSTANCE.addAllToList((Collection)this.trackItems, (Collection)trackItems);
    }

    public final boolean isEmpty() {
        return KAlgorithms.INSTANCE.isEmpty((Collection)this.trackItems) && KAlgorithms.INSTANCE.isEmpty((Collection)this.getSubFolders());
    }

    public final int getColor() {
        return KAlgorithms.INSTANCE.parseColor("#727272");
    }

    public final int getTotalTracksCount() {
        return this.getFlattenedTrackItems().size();
    }

    @NotNull
    public final List<TrackItem> getFlattenedTrackItems() {
        List flattenedTrackItems = this.flattenedTrackItems;
        if (flattenedTrackItems == null) {
            flattenedTrackItems = new ArrayList();
            ArrayDeque stack = new ArrayDeque();
            stack.add((Object)this);
            while (!stack.isEmpty()) {
                TrackFolder current = (TrackFolder)stack.removeLast();
                flattenedTrackItems.addAll((Collection)current.trackItems);
                for (TrackFolder folder : current.subFolders) {
                    stack.addLast((Object)folder);
                }
            }
            this.flattenedTrackItems = flattenedTrackItems;
        }
        return flattenedTrackItems;
    }

    @NotNull
    public final List<TrackFolder> getFlattenedSubFolders() {
        List flattenedSubFolders = this.flattenedSubFolders;
        if (flattenedSubFolders == null) {
            flattenedSubFolders = new ArrayList();
            ArrayDeque stack = new ArrayDeque();
            stack.addLast((Object)this);
            while (!stack.isEmpty()) {
                TrackFolder current = (TrackFolder)stack.removeLast();
                flattenedSubFolders.addAll((Collection)current.subFolders);
                for (TrackFolder folder : current.subFolders) {
                    stack.addLast((Object)folder);
                }
            }
            this.flattenedSubFolders = flattenedSubFolders;
        }
        return flattenedSubFolders;
    }

    @Override
    @NotNull
    public TrackFolderAnalysis getFolderAnalysis() {
        TrackFolderAnalysis analysis = this.folderAnalysis;
        if (analysis == null) {
            this.folderAnalysis = analysis = new TrackFolderAnalysis(this);
        }
        return analysis;
    }

    @Override
    @NotNull
    public String getDirName(boolean includingSubdirs) {
        return includingSubdirs ? this.getRelativePath() : this.dirFile.name();
    }

    public final long getLastModified() {
        if (this.lastModified < 0L) {
            this.lastModified = this.dirFile.lastModified();
            for (TrackFolder folder : this.getSubFolders()) {
                this.lastModified = Math.max(this.lastModified, folder.getLastModified());
            }
            for (TrackItem item : this.trackItems) {
                this.lastModified = Math.max(this.lastModified, item.getLastModified());
            }
        }
        return this.lastModified;
    }

    public final void clearData() {
        this.resetCachedData();
        this.trackItems = new ArrayList();
        this.subFolders = new ArrayList();
    }

    public final void resetCachedData() {
        this.lastModified = -1L;
        this.flattenedTrackItems = null;
        this.flattenedSubFolders = null;
        this.folderAnalysis = null;
    }

    public int hashCode() {
        return this.dirFile.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TrackFolder trackFolder = (TrackFolder)other;
        return Intrinsics.areEqual((Object)trackFolder.dirFile, (Object)this.dirFile);
    }

    @NotNull
    public String toString() {
        return this.dirFile.absolutePath();
    }

    @Override
    public long lastModified() {
        return this.getDirFile().lastModified();
    }
}

