/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.data.City;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.data.Street;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelLayer;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapAddressLayer
implements MapPanelLayer {
    private Log log = LogFactory.getLog(MapAddressLayer.class);
    private MapPanel map;
    private static int distance = 15000;

    @Override
    public void destroyLayer() {
    }

    @Override
    public void initLayer(MapPanel map) {
        this.map = map;
    }

    @Override
    public void fillPopupMenuWithActions(JPopupMenu menu) {
        AbstractAction where = new AbstractAction("Where am I?"){
            private static final long serialVersionUID = 7477484340246483239L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapAddressLayer.this.whereAmI();
            }
        };
        menu.add(where);
        AbstractAction add = new AbstractAction("Show address"){
            private static final long serialVersionUID = 7477484340246483239L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapAddressLayer.this.showCurrentCityActions();
            }
        };
        menu.add(add);
        AbstractAction poi = new AbstractAction("Show POIs"){
            private static final long serialVersionUID = 7477484340246483239L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapAddressLayer.this.showCurrentPOIs();
            }
        };
        menu.add(poi);
    }

    private void whereAmI() {
        Point popupMenuPoint = this.map.getPopupMenuPoint();
        double fy = ((double)popupMenuPoint.y - this.map.getCenterPointY()) / this.map.getTileSize();
        double fx = ((double)popupMenuPoint.x - this.map.getCenterPointX()) / this.map.getTileSize();
        final double latitude = MapUtils.getLatitudeFromTile((float)this.map.getZoom(), (double)(this.map.getYTile() + fy));
        final double longitude = MapUtils.getLongitudeFromTile((double)this.map.getZoom(), (double)(this.map.getXTile() + fx));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DataTileManager points = new DataTileManager(15);
                    List<Entity> os = MapAddressLayer.this.whereAmI(latitude, longitude, (DataTileManager<Entity>)points);
                    for (Entity w : os) {
                        LatLon n = w.getLatLon();
                        points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w);
                    }
                    MapAddressLayer.this.map.setPoints((DataTileManager<Entity>)points);
                    MapAddressLayer.this.map.repaint();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void showCurrentCityActions() {
        Point popupMenuPoint = this.map.getPopupMenuPoint();
        double fy = ((double)popupMenuPoint.y - this.map.getCenterPointY()) / this.map.getTileSize();
        double fx = ((double)popupMenuPoint.x - this.map.getCenterPointX()) / this.map.getTileSize();
        final double latitude = MapUtils.getLatitudeFromTile((float)this.map.getZoom(), (double)(this.map.getYTile() + fy));
        final double longitude = MapUtils.getLongitudeFromTile((double)this.map.getZoom(), (double)(this.map.getXTile() + fx));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DataTileManager points = new DataTileManager(15);
                    List<Entity> os = MapAddressLayer.this.searchAddress(latitude, longitude, (DataTileManager<Entity>)points);
                    for (Entity w : os) {
                        LatLon n = w.getLatLon();
                        points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w);
                    }
                    MapAddressLayer.this.map.setPoints((DataTileManager<Entity>)points);
                    MapAddressLayer.this.map.repaint();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void showCurrentPOIs() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MapAddressLayer.this.map.getPrinter().searchPOIs(true);
            }
        }).start();
    }

    private List<Entity> searchAddress(double lat, double lon, DataTileManager<Entity> points) throws IOException {
        ArrayList<Entity> results = new ArrayList<Entity>();
        for (File f : new File(DataExtractionSettings.getSettings().getBinaryFilesDir()).listFiles()) {
            if (!f.getName().endsWith(".obf")) continue;
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            BinaryMapIndexReader rd = new BinaryMapIndexReader(raf, f);
            int x31 = MapUtils.get31TileNumberX((double)lon);
            int y31 = MapUtils.get31TileNumberY((double)lat);
            if (rd.containsAddressData() && (!rd.containsPoiData() || rd.containsPoiData(x31, y31, x31, y31))) {
                this.searchAddressDetailedInfo(rd, lat, lon, results);
            }
            rd.close();
            raf.close();
        }
        return results;
    }

    private List<Entity> whereAmI(double lat, double lon, DataTileManager<Entity> points) throws IOException {
        ArrayList<Entity> results = new ArrayList<Entity>();
        int x = MapUtils.get31TileNumberX((double)lon);
        int y = MapUtils.get31TileNumberY((double)lat);
        ArrayList<BinaryMapIndexReader> list = new ArrayList<BinaryMapIndexReader>();
        for (File f : new File(DataExtractionSettings.getSettings().getBinaryFilesDir()).listFiles()) {
            if (!f.getName().endsWith(".obf")) continue;
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            BinaryMapIndexReader rd = new BinaryMapIndexReader(raf, f);
            if (rd.containsAddressData() && rd.containsRouteData(x, y, x, y, 15)) {
                list.add(rd);
                continue;
            }
            rd.close();
            raf.close();
        }
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(90, 256);
        RoutingConfiguration cfg = DataExtractionSettings.getSettings().getRoutingConfig().build("geocoding", memoryLimit, new HashMap());
        RoutingContext ctx = new RoutePlannerFrontEnd().buildRoutingContext(cfg, null, list.toArray(new BinaryMapIndexReader[list.size()]));
        GeocodingUtilities su = new GeocodingUtilities();
        List res = su.reverseGeocodingSearch(ctx, lat, lon, false);
        List complete = su.sortGeocodingResults(list, res);
        long lid = -1L;
        for (GeocodingUtilities.GeocodingResult r : complete) {
            Node n = new Node(r.getLocation().getLatitude(), r.getLocation().getLongitude(), lid--);
            n.putTag(OSMSettings.OSMTagKey.NAME.getValue(), r.toString());
            results.add((Entity)n);
        }
        for (BinaryMapIndexReader l : list) {
            l.close();
        }
        return results;
    }

    private void searchAddressDetailedInfo(BinaryMapIndexReader index, double lat, double lon, List<Entity> results) throws IOException {
        LinkedHashMap streets = new LinkedHashMap();
        this.log.info((Object)"Searching region ");
        BinaryMapAddressReaderAdapter.CityBlocks[] cityType = new BinaryMapAddressReaderAdapter.CityBlocks[]{BinaryMapAddressReaderAdapter.CityBlocks.CITY_TOWN_TYPE, BinaryMapAddressReaderAdapter.CityBlocks.POSTCODES_TYPE, BinaryMapAddressReaderAdapter.CityBlocks.VILLAGES_TYPE};
        for (int j = 0; j < cityType.length; ++j) {
            BinaryMapAddressReaderAdapter.CityBlocks type = cityType[j];
            for (City c : index.getCities(null, type)) {
                if (!(MapUtils.getDistance((LatLon)c.getLocation(), (double)lat, (double)lon) < (double)distance)) continue;
                this.log.info((Object)("Searching city " + c.getName()));
                index.preloadStreets(c, null);
                for (Street t : c.getStreets()) {
                    Long id = t.getId();
                    if (!streets.containsKey(t.getName())) {
                        streets.put(t.getName(), new ArrayList());
                    }
                    ((List)streets.get(t.getName())).add(t);
                }
            }
        }
        for (List l : streets.values()) {
            while (l.size() > 0) {
                Street s = (Street)l.remove(l.size() - 1);
                Object cityName = s.getCity().getName();
                LatLon loc = s.getLocation();
                Node n = new Node(loc.getLatitude(), loc.getLongitude(), -1L);
                int k = 0;
                while (k < l.size()) {
                    if (MapUtils.getDistance((LatLon)((Street)l.get(k)).getLocation(), (LatLon)loc) < 50.0) {
                        Street ks = (Street)l.remove(k);
                        cityName = (String)cityName + ";" + ks.getCity().getName();
                        continue;
                    }
                    ++k;
                }
                n.putTag(OSMSettings.OSMTagKey.NAME.getValue(), s.getName() + "\n" + (String)cityName);
                results.add((Entity)n);
            }
        }
    }

    @Override
    public void prepareToDraw() {
    }

    @Override
    public void paintLayer(Graphics2D g) {
    }

    @Override
    public void applySettings() {
    }
}

