/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.services.batch.model.ResourceRequirement;
import software.amazon.awssdk.services.batch.model.ResourceRequirementsCopier;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerOverrides> {
    private static final SdkField<Integer> VCPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vcpus").getter(ContainerOverrides.getter(ContainerOverrides::vcpus)).setter(ContainerOverrides.setter(Builder::vcpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcpus").build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(ContainerOverrides.getter(ContainerOverrides::memory)).setter(ContainerOverrides.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(ContainerOverrides.getter(ContainerOverrides::command)).setter(ContainerOverrides.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(ContainerOverrides.getter(ContainerOverrides::instanceType)).setter(ContainerOverrides.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environment").getter(ContainerOverrides.getter(ContainerOverrides::environment)).setter(ContainerOverrides.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceRequirements").getter(ContainerOverrides.getter(ContainerOverrides::resourceRequirements)).setter(ContainerOverrides.setter(Builder::resourceRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VCPUS_FIELD, MEMORY_FIELD, COMMAND_FIELD, INSTANCE_TYPE_FIELD, ENVIRONMENT_FIELD, RESOURCE_REQUIREMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer vcpus;
    private final Integer memory;
    private final List<String> command;
    private final String instanceType;
    private final List<KeyValuePair> environment;
    private final List<ResourceRequirement> resourceRequirements;

    private ContainerOverrides(BuilderImpl builder) {
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.instanceType = builder.instanceType;
        this.environment = builder.environment;
        this.resourceRequirements = builder.resourceRequirements;
    }

    public Integer vcpus() {
        return this.vcpus;
    }

    public Integer memory() {
        return this.memory;
    }

    public boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public List<String> command() {
        return this.command;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public List<KeyValuePair> environment() {
        return this.environment;
    }

    public boolean hasResourceRequirements() {
        return this.resourceRequirements != null && !(this.resourceRequirements instanceof SdkAutoConstructList);
    }

    public List<ResourceRequirement> resourceRequirements() {
        return this.resourceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vcpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRequirements());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerOverrides)) {
            return false;
        }
        ContainerOverrides other = (ContainerOverrides)obj;
        return Objects.equals(this.vcpus(), other.vcpus()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.resourceRequirements(), other.resourceRequirements());
    }

    public String toString() {
        return ToString.builder((String)"ContainerOverrides").add("Vcpus", (Object)this.vcpus()).add("Memory", (Object)this.memory()).add("Command", this.command()).add("InstanceType", (Object)this.instanceType()).add("Environment", this.environment()).add("ResourceRequirements", this.resourceRequirements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vcpus": {
                return Optional.ofNullable(clazz.cast(this.vcpus()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "resourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.resourceRequirements()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerOverrides, T> g) {
        return obj -> g.apply((ContainerOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer vcpus;
        private Integer memory;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;
        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerOverrides model) {
            this.vcpus(model.vcpus);
            this.memory(model.memory);
            this.command(model.command);
            this.instanceType(model.instanceType);
            this.environment(model.environment);
            this.resourceRequirements(model.resourceRequirements);
        }

        public final Integer getVcpus() {
            return this.vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Collection<String> getCommand() {
            return this.command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Collection<KeyValuePair.Builder> getEnvironment() {
            return this.environment != null ? (Collection)this.environment.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        public final Collection<ResourceRequirement.Builder> getResourceRequirements() {
            return this.resourceRequirements != null ? (Collection)this.resourceRequirements.stream().map(ResourceRequirement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(ResourceRequirement ... resourceRequirements) {
            this.resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... resourceRequirements) {
            this.resourceRequirements(Stream.of(resourceRequirements).map(c -> (ResourceRequirement)((ResourceRequirement.Builder)ResourceRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRequirements(Collection<ResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copyFromBuilder(resourceRequirements);
        }

        public ContainerOverrides build() {
            return new ContainerOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerOverrides> {
        public Builder vcpus(Integer var1);

        public Builder memory(Integer var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder instanceType(String var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder environment(Consumer<KeyValuePair.Builder> ... var1);

        public Builder resourceRequirements(Collection<ResourceRequirement> var1);

        public Builder resourceRequirements(ResourceRequirement ... var1);

        public Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... var1);
    }
}

