/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.io;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.osmand.IProgress;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityInfo;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;

public class OsmBaseStoragePbf
extends OsmBaseStorage {
    public synchronized void parseOSMPbf(final InputStream stream, final IProgress progress, final boolean entityInfo) throws IOException {
        BinaryParser parser = new BinaryParser(){
            private DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

            public void updateProgress(int count) {
                OsmBaseStoragePbf.this.progressEntity += count;
                if (progress != null && OsmBaseStoragePbf.this.progressEntity > 1024 && !progress.isIndeterminate()) {
                    try {
                        OsmBaseStoragePbf.this.progressEntity = 0;
                        progress.remaining(stream.available());
                    }
                    catch (IOException e) {
                        progress.startWork(-1);
                    }
                }
            }

            public void registerEntity(Entity.EntityType type, Entity e, EntityInfo info) {
                Entity.EntityId entityId = new Entity.EntityId(type, Long.valueOf(e.getId()));
                if (OsmBaseStoragePbf.this.acceptEntityToLoad(entityId, e)) {
                    Entity oldEntity = OsmBaseStoragePbf.this.entities.put(entityId, e);
                    if (info != null) {
                        OsmBaseStoragePbf.this.entityInfo.put(entityId, info);
                    }
                    if (!OsmBaseStoragePbf.this.supressWarnings && oldEntity != null) {
                        throw new UnsupportedOperationException("Entity with id=" + oldEntity.getId() + " is duplicated in osm map");
                    }
                }
            }

            @Override
            protected void parse(Osmformat.HeaderBlock header) {
            }

            @Override
            protected void parseDense(Osmformat.DenseNodes n) {
                EntityInfo info = null;
                long changeset = 0L;
                long timestamp = 0L;
                int uid = 0;
                int user = 0;
                long id = 0L;
                long lat = 0L;
                long lon = 0L;
                int keyInd = 0;
                boolean tagsEmpty = n.getKeysValsCount() == 0;
                for (int i = 0; i < n.getIdCount(); ++i) {
                    Node node = new Node(this.parseLat(lat += n.getLat(i)), this.parseLon(lon += n.getLon(i)), id += n.getId(i));
                    if (entityInfo && n.getDenseinfo() != null) {
                        info = new EntityInfo();
                        info.setChangeset(String.valueOf(changeset += n.getDenseinfo().getChangeset(i)));
                        info.setTimestamp(this.format.format(new Date((long)this.date_granularity * (timestamp += n.getDenseinfo().getTimestamp(i)))));
                        info.setUser(this.getStringById(user += n.getDenseinfo().getUserSid(i)));
                        info.setUid(String.valueOf(uid += n.getDenseinfo().getUid(i)));
                        info.setVersion(String.valueOf(n.getDenseinfo().getVersion(i)));
                        info.setVisible("true");
                    }
                    if (!tagsEmpty) {
                        while (n.getKeysVals(keyInd) != 0) {
                            String key = this.getStringById(n.getKeysVals(keyInd));
                            String val = this.getStringById(n.getKeysVals(keyInd + 1));
                            node.putTag(key, val);
                            keyInd += 2;
                        }
                        ++keyInd;
                    }
                    this.registerEntity(Entity.EntityType.NODE, (Entity)node, info);
                }
                this.updateProgress(n.getIdCount());
            }

            protected EntityInfo parseEntityInfo(Osmformat.Info i) {
                EntityInfo info = new EntityInfo();
                info.setChangeset(String.valueOf(i.getChangeset()));
                info.setTimestamp(this.format.format(this.getDate(i)));
                info.setUser(this.getStringById(i.getUserSid()));
                info.setUid(String.valueOf(i.getUid()));
                info.setVersion(String.valueOf(i.getVersion()));
                info.setVisible("true");
                return info;
            }

            @Override
            protected void parseNodes(List<Osmformat.Node> n) {
                EntityInfo info = null;
                int nsize = n.size();
                for (int i = 0; i < nsize; ++i) {
                    Osmformat.Node nod = n.get(i);
                    Node e = new Node(this.parseLat(nod.getLat()), this.parseLon(nod.getLon()), nod.getId());
                    for (int j = 0; j < nod.getKeysCount(); ++j) {
                        String key = this.getStringById(nod.getKeys(j));
                        String val = this.getStringById(nod.getVals(j));
                        e.putTag(key, val);
                    }
                    if (entityInfo) {
                        info = this.parseEntityInfo(nod.getInfo());
                    }
                    this.registerEntity(Entity.EntityType.NODE, (Entity)e, info);
                }
                this.updateProgress(nsize);
            }

            @Override
            protected void parseRelations(List<Osmformat.Relation> r) {
                EntityInfo info = null;
                int rsize = r.size();
                for (int i = 0; i < rsize; ++i) {
                    int j;
                    Osmformat.Relation rel = r.get(i);
                    Relation e = new Relation(rel.getId());
                    long id = 0L;
                    for (j = 0; j < rel.getMemidsCount(); ++j) {
                        id += rel.getMemids(j);
                        String role = this.getStringById(rel.getRolesSid(j));
                        Osmformat.Relation.MemberType t = rel.getTypes(j);
                        Entity.EntityType ts = Entity.EntityType.NODE;
                        switch (t) {
                            case NODE: {
                                ts = Entity.EntityType.NODE;
                                break;
                            }
                            case WAY: {
                                ts = Entity.EntityType.WAY;
                                break;
                            }
                            case RELATION: {
                                ts = Entity.EntityType.RELATION;
                            }
                        }
                        e.addMember(Long.valueOf(id), ts, role);
                    }
                    for (j = 0; j < rel.getKeysCount(); ++j) {
                        String key = this.getStringById(rel.getKeys(j));
                        String val = this.getStringById(rel.getVals(j));
                        e.putTag(key, val);
                    }
                    if (entityInfo) {
                        info = this.parseEntityInfo(rel.getInfo());
                    }
                    this.registerEntity(Entity.EntityType.RELATION, (Entity)e, info);
                }
                this.updateProgress(rsize);
            }

            @Override
            protected void parseWays(List<Osmformat.Way> w) {
                EntityInfo info = null;
                int wsize = w.size();
                for (int i = 0; i < wsize; ++i) {
                    int j;
                    Osmformat.Way way = w.get(i);
                    Way e = new Way(way.getId());
                    long id = 0L;
                    for (j = 0; j < way.getRefsCount(); ++j) {
                        e.addNode(id += way.getRefs(j));
                    }
                    for (j = 0; j < way.getKeysCount(); ++j) {
                        String key = this.getStringById(way.getKeys(j));
                        String val = this.getStringById(way.getVals(j));
                        e.putTag(key, val);
                    }
                    if (entityInfo) {
                        info = this.parseEntityInfo(way.getInfo());
                    }
                    this.registerEntity(Entity.EntityType.WAY, (Entity)e, info);
                }
                this.updateProgress(wsize);
            }

            @Override
            public void complete() {
            }
        };
        this.progressEntity = 0;
        this.entities.clear();
        this.entityInfo.clear();
        if (progress != null) {
            progress.startWork(stream.available());
        }
        BlockInputStream bis = new BlockInputStream(stream, parser);
        bis.process();
        if (progress != null) {
            progress.finishTask();
        }
        this.completeReading();
    }
}

