/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.data.Boundary;
import net.osmand.data.City;
import net.osmand.data.DataTileManager;
import net.osmand.osm.edit.Entity;

public class CityDataStorage {
    public Map<City, Boundary> cityBoundaries = new HashMap<City, Boundary>();
    public Map<Boundary, List<City>> boundaryToContainingCities = new HashMap<Boundary, List<City>>();
    private static final double CITY_VILLAGE_DIST = 30000.0;
    private DataTileManager<City> cityVillageManager = new DataTileManager(13);
    private static final double CITY_DIST = 70000.0;
    private DataTileManager<City> cityManager = new DataTileManager(10);
    private Map<Entity.EntityId, City> cities = new LinkedHashMap<Entity.EntityId, City>();
    private List<Boundary> notAssignedBoundaries = new ArrayList<Boundary>();
    private static final int SHIFT_BOUNDARY_CENTER = 2;

    public List<City> getClosestObjects(double latitude, double longitude) {
        List<City> result = new ArrayList();
        result = this.cityManager.getClosestObjects(latitude, longitude, 70000.0);
        result.addAll(this.cityVillageManager.getClosestObjects(latitude, longitude, 30000.0));
        return result;
    }

    public void registerObject(double latitude, double longitude, City city, Entity e) {
        if (city.getType() == City.CityType.CITY || city.getType() == City.CityType.TOWN) {
            this.cityManager.registerObject(latitude, longitude, (Object)city);
        } else {
            this.cityVillageManager.registerObject(latitude, longitude, (Object)city);
        }
        this.cities.put(Entity.EntityId.valueOf((Entity)e), city);
    }

    public Boundary getBoundaryByCity(City c) {
        return this.cityBoundaries.get(c);
    }

    public void setCityBoundary(City c, Boundary b) {
        this.cityBoundaries.put(c, b);
    }

    public boolean isCityHasBoundary(City c) {
        return this.cityBoundaries.containsKey(c);
    }

    public List<City> getCityListByBoundary(Boundary b) {
        if (this.boundaryToContainingCities.containsKey(b)) {
            return this.boundaryToContainingCities.get(b);
        }
        return null;
    }

    public void attachAllCitiesToBoundary(Boundary boundary) {
        ArrayList<City> list = new ArrayList<City>(1);
        for (City c : this.cities.values()) {
            if (!boundary.containsPoint(c.getLocation())) continue;
            list.add(c);
        }
        if (list.size() > 0) {
            this.boundaryToContainingCities.put(boundary, list);
        }
    }

    public List<Boundary> getNotAssignedBoundaries() {
        return this.notAssignedBoundaries;
    }

    public void addNotAssignedBoundary(Boundary boundary) {
        this.notAssignedBoundaries.add(boundary);
    }

    public void removeNotAssignedBoundary(Boundary boundary) {
        this.notAssignedBoundaries.remove(boundary);
    }

    public Collection<City> getAllCities() {
        return this.cities.values();
    }

    public int citiesSize() {
        return this.cities.size();
    }
}

