/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import com.google.protobuf.CodedInputStream;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TreeMap;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingDB;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;

public class HHRouteDataStructure {
    public static <T extends NetworkDBPoint> void setSegments(HHRoutingContext<T> ctx, T point, byte[] in, byte[] out) {
        point.connectedSet(true, HHRouteDataStructure.parseSegments(in, ctx.pointsById, ctx.getIncomingPoints(point), point, false));
        point.connectedSet(false, HHRouteDataStructure.parseSegments(out, ctx.pointsById, ctx.getOutgoingPoints(point), point, true));
    }

    private static List<NetworkDBSegment> parseSegments(byte[] bytes, TLongObjectHashMap<? extends NetworkDBPoint> pntsById, List<? extends NetworkDBPoint> lst, NetworkDBPoint pnt, boolean out) {
        try {
            ArrayList<NetworkDBSegment> l = new ArrayList<NetworkDBSegment>();
            if (bytes == null || bytes.length == 0 || pnt.incomplete) {
                return l;
            }
            ByteArrayInputStream str = new ByteArrayInputStream(bytes);
            for (int i = 0; i < lst.size(); ++i) {
                int d = CodedInputStream.readRawVarint32(str);
                if (d <= 0) continue;
                double dist = (double)d / 10.0;
                NetworkDBPoint start = out ? pnt : lst.get(i);
                NetworkDBPoint end = out ? lst.get(i) : pnt;
                NetworkDBSegment seg = new NetworkDBSegment(start, end, dist, out, false);
                l.add(seg);
            }
            if (str.available() > 0) {
                System.err.println("Error reading file: " + String.valueOf(pnt) + " " + out);
            }
            return l;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class HHRoutingContext<T extends NetworkDBPoint> {
        static boolean USE_GLOBAL_QUEUE = false;
        RoutingContext rctx;
        List<HHRouteRegionPointsCtx<T>> regions = new ArrayList<HHRouteRegionPointsCtx<T>>();
        TreeMap<String, String> filterRoutingParameters = new TreeMap();
        TLongObjectHashMap<T> pointsById;
        TLongObjectHashMap<T> pointsByGeo;
        TIntObjectHashMap<List<T>> clusterInPoints;
        TIntObjectHashMap<List<T>> clusterOutPoints;
        DataTileManager<T> pointsRect = new DataTileManager(11);
        TLongObjectHashMap<BinaryRoutePlanner.RouteSegment> boundaries;
        boolean initialized = false;
        RoutingStats stats = new RoutingStats();
        HHRoutingConfig config;
        int startX;
        int startY;
        int endY;
        int endX;
        List<T> queueAdded = new ArrayList<T>();
        List<T> visited = new ArrayList<T>();
        List<T> visitedRev = new ArrayList<T>();
        Queue<NetworkDBPointCost<T>> queue = this.createQueue();
        Queue<NetworkDBPointCost<T>> queuePos = this.createQueue();
        Queue<NetworkDBPointCost<T>> queueRev = this.createQueue();

        private PriorityQueue<NetworkDBPointCost<T>> createQueue() {
            return new PriorityQueue<NetworkDBPointCost<T>>(new Comparator<NetworkDBPointCost<T>>(){

                @Override
                public int compare(NetworkDBPointCost<T> o1, NetworkDBPointCost<T> o2) {
                    return Double.compare(o1.cost, o2.cost);
                }
            });
        }

        public void clearAll(TLongObjectHashMap<T> stPoints, TLongObjectHashMap<T> endPoints) {
            this.clearVisited();
            if (stPoints != null) {
                for (NetworkDBPoint p : stPoints.valueCollection()) {
                    p.clearRouting();
                }
            }
            if (endPoints != null) {
                for (NetworkDBPoint p : endPoints.valueCollection()) {
                    p.clearRouting();
                }
            }
        }

        public void clearSegments() {
            for (NetworkDBPoint p : this.pointsById.valueCollection()) {
                p.markSegmentsNotLoaded();
            }
        }

        public void clearVisited() {
            this.queue(false).clear();
            this.queue(true).clear();
            for (NetworkDBPoint p : this.queueAdded) {
                p.clearRouting();
            }
            this.queueAdded.clear();
            this.visited.clear();
            this.visitedRev.clear();
        }

        public List<T> getIncomingPoints(T point) {
            return (List)this.clusterInPoints.get(((NetworkDBPoint)point).clusterId);
        }

        public List<T> getOutgoingPoints(T point) {
            return (List)this.clusterOutPoints.get(((NetworkDBPoint)point).dualPoint.clusterId);
        }

        public void clearVisited(TLongObjectHashMap<T> stPoints, TLongObjectHashMap<T> endPoints) {
            this.queue(false).clear();
            this.queue(true).clear();
            for (NetworkDBPoint p : this.queueAdded) {
                BinaryRoutePlanner.FinalRouteSegment pos = p.rt((boolean)false).rtDetailedRoute;
                BinaryRoutePlanner.FinalRouteSegment rev = p.rt((boolean)true).rtDetailedRoute;
                p.clearRouting();
                if (pos != null && stPoints.containsKey((long)p.index)) {
                    p.setDistanceToEnd(false, this.distanceToEnd(false, p));
                    p.setDetailedParentRt(false, pos);
                }
                if (rev == null || !endPoints.containsKey((long)p.index)) continue;
                p.setDistanceToEnd(true, this.distanceToEnd(true, p));
                p.setDetailedParentRt(true, rev);
            }
            this.queueAdded.clear();
            this.visited.clear();
            this.visitedRev.clear();
        }

        public void unloadAllConnections() {
            for (NetworkDBPoint p : this.pointsById.valueCollection()) {
                p.markSegmentsNotLoaded();
            }
        }

        public void setStartEnd(LatLon start, LatLon end) {
            if (start != null) {
                this.startY = MapUtils.get31TileNumberY(start.getLatitude());
                this.startX = MapUtils.get31TileNumberX(start.getLongitude());
            }
            if (end != null) {
                this.endY = MapUtils.get31TileNumberY(end.getLatitude());
                this.endX = MapUtils.get31TileNumberX(end.getLongitude());
            }
        }

        public Queue<NetworkDBPointCost<T>> queue(boolean rev) {
            return USE_GLOBAL_QUEUE ? this.queue : (rev ? this.queueRev : this.queuePos);
        }

        public TLongObjectHashMap<T> loadNetworkPoints(Class<T> pointClass) throws SQLException, IOException {
            TLongObjectHashMap points = new TLongObjectHashMap();
            for (HHRouteRegionPointsCtx<T> r : this.regions) {
                TLongObjectHashMap<T> pnts = null;
                if (r.networkDB != null) {
                    pnts = r.networkDB.loadNetworkPoints(r.id, pointClass);
                }
                if (r.file != null) {
                    pnts = r.file.initHHPoints(r.fileRegion, r.id, pointClass);
                }
                if (pnts == null) continue;
                TLongObjectIterator it = pnts.iterator();
                while (it.hasNext()) {
                    it.advance();
                    NetworkDBPoint pnt = (NetworkDBPoint)it.value();
                    if (pnt.incomplete && points.contains(it.key())) continue;
                    points.put(it.key(), (Object)pnt);
                }
            }
            return points;
        }

        public int loadNetworkSegments(Collection<T> valueCollection) throws SQLException {
            int loaded = 0;
            for (HHRouteRegionPointsCtx<T> r : this.regions) {
                if (r.networkDB != null) {
                    loaded += r.networkDB.loadNetworkSegments(valueCollection, r.routingProfile);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return loaded;
        }

        public boolean loadGeometry(NetworkDBSegment segment, boolean reload) throws SQLException {
            if (!segment.getGeometry().isEmpty() && !reload) {
                return true;
            }
            for (HHRouteRegionPointsCtx<T> r : this.regions) {
                if (r.networkDB == null || r.networkDB.compactDB || !r.networkDB.loadGeometry(segment, r.routingProfile, reload)) continue;
                return true;
            }
            return false;
        }

        public int loadNetworkSegmentPoint(T point, boolean reverse) throws SQLException, IOException {
            short mapId = ((NetworkDBPoint)point).mapId;
            HHRouteRegionPointsCtx<T> r = this.regions.get(mapId);
            if (r.networkDB != null) {
                return r.networkDB.loadNetworkSegmentPoint(this, r, point, reverse);
            }
            if (r.file != null) {
                return r.file.loadNetworkSegmentPoint(this, r, point, reverse);
            }
            throw new UnsupportedOperationException();
        }

        public String getRoutingInfo() {
            StringBuilder b = new StringBuilder();
            for (HHRouteRegionPointsCtx<T> r : this.regions) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                if (r.networkDB != null) {
                    b.append(String.format("db %s [%s]", r.networkDB.getRoutingProfile(), r.networkDB.getRoutingProfiles().get(r.routingProfile)));
                    continue;
                }
                if (r.fileRegion != null) {
                    b.append(String.format("%s %s [%s]", r.file.getFile().getName(), r.fileRegion.profile, r.fileRegion.profileParams.get(r.routingProfile)));
                    continue;
                }
                b.append("unknown");
            }
            return b.toString();
        }

        public double distanceToEnd(boolean reverse, NetworkDBPoint nextPoint) {
            if (this.config.HEURISTIC_COEFFICIENT > 0.0f) {
                double distanceToEnd = nextPoint.rt((boolean)reverse).rtDistanceToEnd;
                if (distanceToEnd == 0.0) {
                    double dist = HHRoutePlanner.squareRootDist31(reverse ? this.startX : this.endX, reverse ? this.startY : this.endY, nextPoint.midX(), nextPoint.midY());
                    distanceToEnd = (double)this.config.HEURISTIC_COEFFICIENT * dist / (double)this.rctx.getRouter().getMaxSpeed();
                    nextPoint.setDistanceToEnd(reverse, distanceToEnd);
                }
                return distanceToEnd;
            }
            return 0.0;
        }
    }

    public static class NetworkDBPoint {
        public List<BinaryMapIndexReader.TagValuePair> tagValues = null;
        public NetworkDBPoint dualPoint;
        public int index;
        public int clusterId;
        public int fileId;
        public short mapId;
        public boolean incomplete;
        public long roadId;
        public short start;
        public short end;
        public int startX;
        public int startY;
        public int endX;
        public int endY;
        boolean rtExclude;
        NetworkDBPointRouteInfo rtRev;
        NetworkDBPointRouteInfo rtPos;
        List<NetworkDBSegment> connected = new ArrayList<NetworkDBSegment>();
        List<NetworkDBSegment> connectedReverse = new ArrayList<NetworkDBSegment>();

        public int midX() {
            return this.startX / 2 + this.endX / 2;
        }

        public int midY() {
            return this.startY / 2 + this.endY / 2;
        }

        public NetworkDBPointRouteInfo rt(boolean rev) {
            if (rev) {
                if (this.rtRev == null) {
                    this.rtRev = new NetworkDBPointRouteInfo();
                }
                return this.rtRev;
            }
            if (this.rtPos == null) {
                this.rtPos = new NetworkDBPointRouteInfo();
            }
            return this.rtPos;
        }

        public List<NetworkDBSegment> connected(boolean rev) {
            return rev ? this.connectedReverse : this.connected;
        }

        public void setDistanceToEnd(boolean rev, double segmentDist) {
            this.rt((boolean)rev).rtDistanceToEnd = segmentDist;
        }

        public void markVisited(boolean rev) {
            this.rt((boolean)rev).rtVisited = true;
        }

        public void connectedSet(boolean rev, List<NetworkDBSegment> l) {
            if (rev) {
                this.connectedReverse = l;
            } else {
                this.connected = l;
            }
        }

        public void setCostParentRt(boolean reverse, double cost, NetworkDBPoint point, double segmentDist) {
            this.rt(reverse).setCostParentRt(reverse, cost, point, segmentDist);
        }

        public void setDetailedParentRt(boolean reverse, BinaryRoutePlanner.FinalRouteSegment r) {
            this.rt(reverse).setDetailedParentRt(r);
        }

        public void markSegmentsNotLoaded() {
            this.connected = null;
            this.connectedReverse = null;
        }

        public String toString() {
            return String.format("Point %d (%d %d-%d)", this.index, this.roadId / 64L, this.start, this.end);
        }

        public LatLon getPoint() {
            return new LatLon(MapUtils.get31LatitudeY(this.startY / 2 + this.endY / 2), MapUtils.get31LongitudeX(this.startX / 2 + this.endX / 2));
        }

        public NetworkDBSegment getSegment(NetworkDBPoint target, boolean dir) {
            List<NetworkDBSegment> l;
            List<NetworkDBSegment> list = l = dir ? this.connected : this.connectedReverse;
            if (l == null) {
                return null;
            }
            for (NetworkDBSegment s : l) {
                if (dir && s.end == target) {
                    return s;
                }
                if (dir || s.start != target) continue;
                return s;
            }
            return null;
        }

        public void clearRouting() {
            this.rtExclude = false;
            this.rtPos = null;
            this.rtRev = null;
        }

        public int chInd() {
            return 0;
        }

        public int midPntDepth() {
            return 0;
        }

        public long getGeoPntId() {
            return HHRoutePlanner.calculateRoutePointInternalId(this.roadId, (int)this.start, (int)this.end);
        }
    }

    static class NetworkDBSegment {
        final boolean direction;
        final NetworkDBPoint start;
        final NetworkDBPoint end;
        final boolean shortcut;
        double dist;
        List<LatLon> geom;

        public NetworkDBSegment(NetworkDBPoint start, NetworkDBPoint end, double dist, boolean direction, boolean shortcut) {
            this.direction = direction;
            this.start = start;
            this.end = end;
            this.shortcut = shortcut;
            this.dist = dist;
        }

        public List<LatLon> getGeometry() {
            if (this.geom == null) {
                this.geom = new ArrayList<LatLon>();
            }
            return this.geom;
        }

        public String toString() {
            return String.format("Segment %s -> %s [%.2f] %s", this.start, this.end, this.dist, this.shortcut ? "sh" : "bs");
        }
    }

    static class NetworkDBPointCh
    extends NetworkDBPoint {
        int chInd;

        NetworkDBPointCh() {
        }

        @Override
        public int chInd() {
            return this.chInd;
        }
    }

    static class NetworkDBPointMid
    extends NetworkDBPoint {
        int rtMidPointDepth = 0;

        NetworkDBPointMid() {
        }

        @Override
        public int midPntDepth() {
            return this.rtMidPointDepth;
        }
    }

    static class NetworkDBPointRouteInfo {
        NetworkDBPoint rtRouteToPoint;
        boolean rtVisited;
        double rtDistanceFromStart;
        int rtDepth = -1;
        double rtDistanceToEnd;
        double rtCost;
        BinaryRoutePlanner.FinalRouteSegment rtDetailedRoute;

        NetworkDBPointRouteInfo() {
        }

        public int getDepth(boolean rev) {
            if (this.rtDepth > 0) {
                return this.rtDepth;
            }
            if (this.rtRouteToPoint != null) {
                this.rtDepth = this.rtRouteToPoint.rt(rev).getDepth(rev) + 1;
                return this.rtDepth;
            }
            return 0;
        }

        public void setDetailedParentRt(BinaryRoutePlanner.FinalRouteSegment r) {
            double segmentDist = r.getDistanceFromStart();
            this.rtRouteToPoint = null;
            this.rtCost = this.rtDistanceToEnd + segmentDist;
            this.rtDetailedRoute = r;
            this.rtDistanceFromStart = segmentDist;
        }

        public void setCostParentRt(boolean rev, double cost, NetworkDBPoint point, double segmentDist) {
            this.rtCost = cost;
            this.rtRouteToPoint = point;
            this.rtDistanceFromStart = (point == null ? 0.0 : point.rt((boolean)rev).rtDistanceFromStart) + segmentDist;
        }
    }

    public static class HHNetworkSegmentRes {
        public NetworkDBSegment segment;
        public List<RouteSegmentResult> list = null;
        public double rtTimeDetailed;
        public double rtTimeHHSegments;

        public HHNetworkSegmentRes(NetworkDBSegment s) {
            this.segment = s;
        }
    }

    public static class HHNetworkRouteRes
    extends RouteResultPreparation.RouteCalcResult {
        public RoutingStats stats;
        public List<HHNetworkSegmentRes> segments = new ArrayList<HHNetworkSegmentRes>();
        public List<HHNetworkRouteRes> altRoutes = new ArrayList<HHNetworkRouteRes>();
        public TLongHashSet uniquePoints = new TLongHashSet();

        public HHNetworkRouteRes() {
            super(new ArrayList<RouteSegmentResult>());
        }

        public HHNetworkRouteRes(String error) {
            super(error);
        }

        public double getHHRoutingTime() {
            double d = 0.0;
            for (HHNetworkSegmentRes r : this.segments) {
                d += r.rtTimeHHSegments;
            }
            return d;
        }

        public double getHHRoutingDetailed() {
            double d = 0.0;
            for (HHNetworkSegmentRes r : this.segments) {
                d += r.rtTimeDetailed;
            }
            return d;
        }

        public void append(HHNetworkRouteRes res) {
            if (res == null || res.error != null) {
                this.error = "Can't build a route with intermediate point";
            } else {
                this.detailed.addAll(res.detailed);
                this.segments.addAll(res.segments);
                this.altRoutes.clear();
                this.uniquePoints.clear();
            }
        }
    }

    public static class RoutingStats {
        int firstRouteVisitedVertices = 0;
        int visitedVertices = 0;
        int uniqueVisitedVertices = 0;
        int addedVertices = 0;
        double loadPointsTime = 0.0;
        int loadEdgesCnt;
        double loadEdgesTime = 0.0;
        double altRoutingTime;
        double routingTime = 0.0;
        double searchPointsTime = 0.0;
        double addQueueTime = 0.0;
        double pollQueueTime = 0.0;
        double prepTime = 0.0;
    }

    static class NetworkDBPointCost<T> {
        final T point;
        final double cost;
        final boolean rev;

        NetworkDBPointCost(T p, double cost, boolean rev) {
            this.point = p;
            this.cost = cost;
            this.rev = rev;
        }
    }

    public static class HHRouteRegionPointsCtx<T extends NetworkDBPoint> {
        final HHRoutingDB networkDB;
        final BinaryMapIndexReader file;
        final BinaryHHRouteReaderAdapter.HHRouteRegion fileRegion;
        public final short id;
        int routingProfile = 0;
        TLongObjectHashMap<T> pntsByFileId = new TLongObjectHashMap();

        public HHRouteRegionPointsCtx(short id, HHRoutingDB networkDB) {
            this.id = id;
            this.fileRegion = null;
            this.file = null;
            this.networkDB = networkDB;
        }

        public HHRouteRegionPointsCtx(short id, BinaryHHRouteReaderAdapter.HHRouteRegion fileRegion, BinaryMapIndexReader file, int routingProfile) {
            this.id = id;
            this.fileRegion = fileRegion;
            this.file = file;
            this.networkDB = null;
            if (routingProfile >= 0) {
                this.routingProfile = routingProfile;
            }
        }

        public int getRoutingProfile() {
            return this.routingProfile;
        }

        public BinaryHHRouteReaderAdapter.HHRouteRegion getFileRegion() {
            return this.fileRegion;
        }

        public T getPoint(int pntFileId) {
            return (T)((NetworkDBPoint)this.pntsByFileId.get((long)pntFileId));
        }
    }

    public static class HHRoutingConfig {
        public static final int CALCULATE_ALL_DETAILED = 3;
        public static int STATS_VERBOSE_LEVEL = 1;
        float HEURISTIC_COEFFICIENT = 0.0f;
        float DIJKSTRA_DIRECTION = 0.0f;
        public HHRoutingContext<NetworkDBPoint> cacheCtx;
        int FULL_DIJKSTRA_NETWORK_RECALC = 10;
        int MAX_START_END_REITERATIONS = 50;
        double MAX_INC_COST_CF = 1.25;
        int MAX_COUNT_REITERATION = 30;
        Double INITIAL_DIRECTION = null;
        boolean STRICT_BEST_GROUP_MAPS = false;
        boolean ROUTE_LAST_MILE = false;
        boolean ROUTE_ALL_SEGMENTS = false;
        boolean ROUTE_ALL_ALT_SEGMENTS = false;
        boolean PRELOAD_SEGMENTS = false;
        boolean CACHE_CALCULATION_CONTEXT = false;
        boolean CALC_ALTERNATIVES = false;
        boolean USE_GC_MORE_OFTEN = false;
        double ALT_EXCLUDE_RAD_MULT = 0.3;
        double ALT_EXCLUDE_RAD_MULT_IN = 3.0;
        double ALT_NON_UNIQUENESS = 0.7;
        double MAX_COST;
        int MAX_DEPTH = -1;
        int MAX_SETTLE_POINTS = -1;
        boolean USE_CH;
        boolean USE_CH_SHORTCUTS;
        boolean USE_MIDPOINT;
        int MIDPOINT_ERROR = 3;
        int MIDPOINT_MAX_DEPTH = 20 + this.MIDPOINT_ERROR;

        public static HHRoutingConfig dijkstra(int direction) {
            HHRoutingConfig df = new HHRoutingConfig();
            df.HEURISTIC_COEFFICIENT = 0.0f;
            df.DIJKSTRA_DIRECTION = direction;
            return df;
        }

        public static HHRoutingConfig astar(int direction) {
            HHRoutingConfig df = new HHRoutingConfig();
            df.HEURISTIC_COEFFICIENT = 1.0f;
            df.DIJKSTRA_DIRECTION = direction;
            return df;
        }

        public static HHRoutingConfig ch() {
            HHRoutingConfig df = new HHRoutingConfig();
            df.HEURISTIC_COEFFICIENT = 0.0f;
            df.USE_CH = true;
            df.USE_CH_SHORTCUTS = true;
            df.DIJKSTRA_DIRECTION = 0.0f;
            return df;
        }

        public static HHRoutingConfig midPoints(boolean astar, int dir) {
            HHRoutingConfig df = new HHRoutingConfig();
            df.HEURISTIC_COEFFICIENT = astar ? 1.0f : 0.0f;
            df.USE_MIDPOINT = true;
            df.DIJKSTRA_DIRECTION = dir;
            return df;
        }

        public HHRoutingConfig preloadSegments() {
            this.PRELOAD_SEGMENTS = true;
            return this;
        }

        public HHRoutingConfig cacheContext(HHRoutingContext<NetworkDBPoint> toCache) {
            this.CACHE_CALCULATION_CONTEXT = true;
            this.cacheCtx = toCache;
            return this;
        }

        public HHRoutingConfig calcAlternative() {
            this.CALC_ALTERNATIVES = true;
            return this;
        }

        public HHRoutingConfig calcDetailed(int segments) {
            this.ROUTE_LAST_MILE = true;
            this.ROUTE_ALL_SEGMENTS = segments >= 1;
            this.ROUTE_ALL_ALT_SEGMENTS = segments >= 2;
            return this;
        }

        public HHRoutingConfig useShortcuts() {
            this.USE_CH_SHORTCUTS = true;
            return this;
        }

        public HHRoutingConfig gc() {
            this.USE_GC_MORE_OFTEN = true;
            return this;
        }

        public HHRoutingConfig maxCost(double cost) {
            this.MAX_COST = cost;
            return this;
        }

        public HHRoutingConfig maxDepth(int depth) {
            this.MAX_DEPTH = depth;
            return this;
        }

        public HHRoutingConfig maxSettlePoints(int maxPoints) {
            this.MAX_SETTLE_POINTS = maxPoints;
            return this;
        }

        public HHRoutingConfig applyCalculateMissingMaps(boolean calculateMissingMaps) {
            this.STRICT_BEST_GROUP_MAPS = calculateMissingMaps;
            return this;
        }

        public String toString() {
            return this.toString(null, null);
        }

        public String toString(LatLon start, LatLon end) {
            return String.format("Routing %s -> %s (HC %d, dir %d)", start == null ? "?" : start.toString(), end == null ? "?" : end.toString(), (int)this.HEURISTIC_COEFFICIENT, (int)this.DIJKSTRA_DIRECTION);
        }
    }
}

