/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.osmand.CollatorStringMatcher;
import net.osmand.PlatformUtil;
import net.osmand.StringMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Postcode;
import net.osmand.data.Street;
import net.osmand.util.MapUtils;
import net.osmand.util.TransliterationHelper;
import org.apache.commons.logging.Log;

public class BinaryMapAddressReaderAdapter {
    public static final int CITY_TOWN_TYPE = 1;
    public static final int POSTCODES_TYPE = 2;
    public static final int VILLAGES_TYPE = 3;
    public static final int STREET_TYPE = 4;
    private static final Log LOG = PlatformUtil.getLog(BinaryMapAddressReaderAdapter.class);
    public static final List<Integer> TYPES = Arrays.asList(1, 2, 3, 4);
    public static final int[] CITY_TYPES = new int[]{1, 2, 3};
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;

    protected BinaryMapAddressReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private long readInt() throws IOException {
        return this.map.readInt();
    }

    private void readBoundariesIndex(AddressRegion region) throws IOException {
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    region.left31 = this.codedIS.readUInt32();
                    continue block7;
                }
                case 2: {
                    region.right31 = this.codedIS.readUInt32();
                    continue block7;
                }
                case 3: {
                    region.top31 = this.codedIS.readUInt32();
                    continue block7;
                }
                case 4: {
                    region.bottom31 = this.codedIS.readUInt32();
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void readAddressIndex(AddressRegion region) throws IOException {
        block9: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (region.enName == null || region.enName.length() == 0) {
                        region.enName = region.name == null ? "" : TransliterationHelper.transliterate(region.name);
                    }
                    return;
                }
                case 1: {
                    region.name = this.codedIS.readString();
                    continue block9;
                }
                case 2: {
                    region.enName = this.codedIS.readString();
                    continue block9;
                }
                case 3: {
                    long length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readBoundariesIndex(region);
                    this.codedIS.popLimit(oldLimit);
                    region.enName = this.codedIS.readString();
                    continue block9;
                }
                case 4: {
                    long length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    region.attributeTagsTable = this.map.readStringTable();
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 6: {
                    int tt;
                    int ttag;
                    CitiesBlock block = new CitiesBlock();
                    region.cities.add(block);
                    block.type = 1;
                    block.length = this.readInt();
                    block.filePointer = this.codedIS.getTotalBytesRead();
                    while ((ttag = WireFormat.getTagFieldNumber(tt = this.codedIS.readTag())) != 0) {
                        if (ttag == 2) {
                            block.type = this.codedIS.readUInt32();
                            break;
                        }
                        this.skipUnknownField(tt);
                    }
                    this.codedIS.seek(block.filePointer + block.length);
                    continue block9;
                }
                case 7: {
                    region.indexNameOffset = this.codedIS.getTotalBytesRead();
                    long length = this.readInt();
                    this.codedIS.seek(region.indexNameOffset + length + 4L);
                    continue block9;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void readCities(List<City> cities, BinaryMapIndexReader.SearchRequest<City> resultMatcher, StringMatcher matcher, List<String> additionalTagsTable) throws IOException {
        block4: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 5: {
                    long fp = this.codedIS.getTotalBytesRead();
                    long length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    City c = this.readCityHeader(resultMatcher, new DefaultCityMatcher(matcher), fp, additionalTagsTable);
                    if (c != null && (resultMatcher == null || resultMatcher.publish(c))) {
                        cities.add(c);
                    }
                    this.codedIS.popLimit(oldLimit);
                    if (resultMatcher == null || !resultMatcher.isCancelled()) continue block4;
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void readCityStreets(BinaryMapIndexReader.SearchRequest<Street> resultMatcher, City city, List<String> attributeTagsTable) throws IOException {
        int x = MapUtils.get31TileNumberX(city.getLocation().getLongitude());
        int y = MapUtils.get31TileNumberY(city.getLocation().getLatitude());
        block5: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 12: {
                    Street s = new Street(city);
                    s.setFileOffset(this.codedIS.getTotalBytesRead());
                    long length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readStreet(s, null, false, x >> 7, y >> 7, city.isPostcode() ? city.getName() : null, attributeTagsTable);
                    this.publishRawData(resultMatcher, s);
                    if (resultMatcher == null || resultMatcher.publish(s)) {
                        city.registerStreet(s);
                    }
                    if (resultMatcher != null && resultMatcher.isCancelled()) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 10: {
                    this.skipUnknownField(t);
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected City readCityHeader(BinaryMapIndexReader.SearchRequest<? super City> resultMatcher, CityMatcher matcher, long filePointer, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        MapObject c = null;
        LinkedList<String> additionalTags = null;
        block12: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    this.publishRawData(resultMatcher, c);
                    return matcher == null || matcher.matches((City)c) ? c : null;
                }
                case 1: {
                    int type = this.codedIS.readUInt32();
                    c = new City(City.CityType.values()[type]);
                    break;
                }
                case 4: {
                    c.setId(this.codedIS.readUInt64());
                    break;
                }
                case 7: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block12;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 8: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block12;
                    c.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 3: {
                    String enName = this.codedIS.readString();
                    c.setEnName(enName);
                    break;
                }
                case 2: {
                    String name = this.codedIS.readString();
                    if (c == null) {
                        c = City.createPostcode(name);
                    }
                    c.setName(name);
                    break;
                }
                case 5: {
                    x = this.codedIS.readUInt32();
                    break;
                }
                case 6: {
                    y = this.codedIS.readUInt32();
                    c.setLocation(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
                    break;
                }
                case 10: {
                    long offset = this.readInt();
                    c.setFileOffset(offset += filePointer);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    protected Street readStreet(Street s, BinaryMapIndexReader.SearchRequest<Building> buildingsMatcher, boolean loadBuildingsAndIntersected, int city24X, int city24Y, String postcodeFilter, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        LinkedList<String> additionalTags = null;
        boolean loadLocation = city24X != 0 || city24Y != 0;
        block12: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (loadLocation) {
                        s.setLocation(MapUtils.getLatitudeFromTile(24.0f, y), MapUtils.getLongitudeFromTile(24.0, x));
                    }
                    return s;
                }
                case 6: {
                    s.setId(this.codedIS.readUInt64());
                    break;
                }
                case 7: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block12;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 8: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block12;
                    s.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 2: {
                    s.setEnName(this.codedIS.readString());
                    break;
                }
                case 1: {
                    s.setName(this.codedIS.readString());
                    break;
                }
                case 3: {
                    int sx = this.codedIS.readSInt32();
                    if (loadLocation) {
                        x = sx + city24X;
                        break;
                    }
                    x = (int)MapUtils.getTileNumberX(24.0f, s.getLocation().getLongitude());
                    break;
                }
                case 4: {
                    int sy = this.codedIS.readSInt32();
                    if (loadLocation) {
                        y = sy + city24Y;
                        break;
                    }
                    y = (int)MapUtils.getTileNumberY(24.0f, s.getLocation().getLatitude());
                    break;
                }
                case 5: {
                    long length = this.codedIS.readRawVarint32();
                    if (loadBuildingsAndIntersected) {
                        long oldLimit = this.codedIS.pushLimitLong(length);
                        Street si = this.readIntersectedStreet(s.getCity(), x, y, additionalTagsTable);
                        s.addIntersectedStreet(si);
                        this.codedIS.popLimit(oldLimit);
                        break;
                    }
                    this.codedIS.skipRawBytes(length);
                    break;
                }
                case 12: {
                    long offset = this.codedIS.getTotalBytesRead();
                    long length = this.codedIS.readRawVarint32();
                    if (loadBuildingsAndIntersected) {
                        long oldLimit = this.codedIS.pushLimitLong(length);
                        Building b = this.readBuilding(offset, x, y, additionalTagsTable);
                        this.publishRawData(buildingsMatcher, b);
                        if ((postcodeFilter == null || postcodeFilter.equalsIgnoreCase(b.getPostcode())) && (buildingsMatcher == null || buildingsMatcher.publish(b))) {
                            s.addBuilding(b);
                        }
                        this.codedIS.popLimit(oldLimit);
                        break;
                    }
                    this.codedIS.skipRawBytes(length);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    protected Street readIntersectedStreet(City c, int street24X, int street24Y, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        Street s = new Street(c);
        LinkedList<String> additionalTags = null;
        block10: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    s.setLocation(MapUtils.getLatitudeFromTile(24.0f, y), MapUtils.getLongitudeFromTile(24.0, x));
                    return s;
                }
                case 13: {
                    s.setId(this.codedIS.readUInt64());
                    break;
                }
                case 3: {
                    s.setEnName(this.codedIS.readString());
                    break;
                }
                case 2: {
                    s.setName(this.codedIS.readString());
                    break;
                }
                case 7: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block10;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 8: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block10;
                    s.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 4: {
                    x = this.codedIS.readSInt32() + street24X;
                    break;
                }
                case 5: {
                    y = this.codedIS.readSInt32() + street24Y;
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    protected Building readBuilding(long fileOffset, int street24X, int street24Y, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        int x2 = 0;
        int y2 = 0;
        LinkedList<String> additionalTags = null;
        Building b = new Building();
        b.setFileOffset(fileOffset);
        block16: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    b.setLocation(MapUtils.getLatitudeFromTile(24.0f, y), MapUtils.getLongitudeFromTile(24.0, x));
                    if (x2 != 0 && y2 != 0) {
                        b.setLatLon2(new LatLon(MapUtils.getLatitudeFromTile(24.0f, y2), MapUtils.getLongitudeFromTile(24.0, x2)));
                    }
                    return b;
                }
                case 13: {
                    b.setId(this.codedIS.readUInt64());
                    break;
                }
                case 2: {
                    b.setEnName(this.codedIS.readString());
                    break;
                }
                case 1: {
                    b.setName(this.codedIS.readString());
                    break;
                }
                case 15: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block16;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 16: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block16;
                    b.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 4: {
                    this.codedIS.readString();
                    break;
                }
                case 3: {
                    b.setName2(this.codedIS.readString());
                    break;
                }
                case 5: {
                    int sint = this.codedIS.readSInt32();
                    if (sint > 0) {
                        b.setInterpolationInterval(sint);
                        break;
                    }
                    b.setInterpolationType(Building.BuildingInterpolation.fromValue(sint));
                    break;
                }
                case 7: {
                    x = this.codedIS.readSInt32() + street24X;
                    break;
                }
                case 9: {
                    x2 = this.codedIS.readSInt32() + street24X;
                    break;
                }
                case 8: {
                    y = this.codedIS.readSInt32() + street24Y;
                    break;
                }
                case 10: {
                    y2 = this.codedIS.readSInt32() + street24Y;
                    break;
                }
                case 14: {
                    b.setPostcode(this.codedIS.readString());
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    public void searchAddressDataByName(AddressRegion reg, BinaryMapIndexReader.SearchRequest<MapObject> req, List<Integer> typeFilter) throws IOException {
        TIntArrayList loffsets = new TIntArrayList();
        CollatorStringMatcher stringMatcher = new CollatorStringMatcher(req.nameQuery, req.matcherMode);
        String postcode = Postcode.normalize(req.nameQuery, this.map.getCountryName());
        final DefaultCityMatcher postcodeMatcher = new DefaultCityMatcher(new CollatorStringMatcher(postcode, req.matcherMode));
        final DefaultCityMatcher cityMatcher = new DefaultCityMatcher(stringMatcher);
        CityMatcher cityPostcodeMatcher = new CityMatcher(){

            @Override
            public boolean matches(City city) {
                return city.isPostcode() ? postcodeMatcher.matches(city) : cityMatcher.matches(city);
            }
        };
        long time = System.currentTimeMillis();
        long indexOffset = 0L;
        block5: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    long length = this.readInt();
                    indexOffset = this.codedIS.getTotalBytesRead();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    TIntArrayList charsList = new TIntArrayList();
                    charsList.add(0);
                    this.map.readIndexedStringTable(stringMatcher.getCollator(), Collections.singletonList(req.nameQuery), "", Collections.singletonList(loffsets), charsList);
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 7: {
                    int i;
                    loffsets.sort();
                    TIntArrayList[] refs = new TIntArrayList[5];
                    TIntArrayList[] refsContainer = new TIntArrayList[5];
                    for (i = 0; i < refs.length; ++i) {
                        refs[i] = new TIntArrayList();
                        refsContainer[i] = new TIntArrayList();
                    }
                    for (int j = 0; j < loffsets.size(); ++j) {
                        long fp = indexOffset + (long)loffsets.get(j);
                        this.codedIS.seek(fp);
                        long len = this.codedIS.readRawVarint32();
                        long oldLim = this.codedIS.pushLimitLong(len);
                        int stag = 0;
                        do {
                            int st;
                            if ((stag = WireFormat.getTagFieldNumber(st = this.codedIS.readTag())) == 4) {
                                long slen = this.codedIS.readRawVarint32();
                                long soldLim = this.codedIS.pushLimitLong(slen);
                                this.readAddressNameData(req, refs, refsContainer, fp);
                                this.codedIS.popLimit(soldLim);
                                continue;
                            }
                            if (stag == 0) continue;
                            this.skipUnknownField(st);
                        } while (stag != 0);
                        this.codedIS.popLimit(oldLim);
                        if (!req.isCancelled()) continue;
                        return;
                    }
                    if (typeFilter == null) {
                        typeFilter = TYPES;
                    }
                    for (i = 0; i < typeFilter.size() && !req.isCancelled(); ++i) {
                        int offset;
                        int j;
                        TIntArrayList list = refs[typeFilter.get(i)];
                        TIntArrayList listContainer = refsContainer[typeFilter.get(i)];
                        if (typeFilter.get(i) == 4) {
                            TIntLongHashMap mp = new TIntLongHashMap();
                            for (j = 0; j < list.size(); ++j) {
                                mp.put(list.get(j), (long)listContainer.get(j));
                            }
                            list.sort();
                            for (j = 0; j < list.size() && !req.isCancelled(); ++j) {
                                offset = list.get(j);
                                if (j > 0 && offset == list.get(j - 1)) continue;
                                int contOffset = (int)mp.get(offset);
                                this.codedIS.seek(contOffset);
                                long len = this.codedIS.readRawVarint32();
                                long old = this.codedIS.pushLimitLong(len);
                                City obj = this.readCityHeader(req, null, contOffset, reg.attributeTagsTable);
                                this.codedIS.popLimit(old);
                                if (obj == null) continue;
                                this.codedIS.seek(offset);
                                long len2 = this.codedIS.readRawVarint32();
                                long old2 = this.codedIS.pushLimitLong(len2);
                                LatLon l = obj.getLocation();
                                Street s = new Street(obj);
                                s.setFileOffset(offset);
                                this.readStreet(s, null, false, MapUtils.get31TileNumberX(l.getLongitude()) >> 7, MapUtils.get31TileNumberY(l.getLatitude()) >> 7, obj.isPostcode() ? obj.getName() : null, reg.attributeTagsTable);
                                this.publishRawData(req, s);
                                boolean matches = stringMatcher.matches(s.getName());
                                if (!matches) {
                                    String n;
                                    Iterator<String> iterator = s.getOtherNames().iterator();
                                    while (iterator.hasNext() && !(matches = stringMatcher.matches(n = iterator.next()))) {
                                    }
                                }
                                if (matches) {
                                    req.publish(s);
                                }
                                this.codedIS.popLimit(old2);
                            }
                            continue;
                        }
                        list.sort();
                        TIntHashSet published = new TIntHashSet();
                        for (j = 0; j < list.size() && !req.isCancelled(); ++j) {
                            offset = list.get(j);
                            if (j > 0 && offset == list.get(j - 1)) continue;
                            this.codedIS.seek(offset);
                            long len = this.codedIS.readRawVarint32();
                            long old = this.codedIS.pushLimitLong(len);
                            City obj = this.readCityHeader(req, cityPostcodeMatcher, list.get(j), reg.attributeTagsTable);
                            this.publishRawData(req, obj);
                            if (obj != null && !published.contains(offset)) {
                                req.publish(obj);
                                published.add(offset);
                            }
                            this.codedIS.popLimit(old);
                        }
                    }
                    return;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private void readAddressNameData(BinaryMapIndexReader.SearchRequest<MapObject> req, TIntArrayList[] refs, TIntArrayList[] refsContainer, long fp) throws IOException {
        TIntArrayList toAdd = null;
        TIntArrayList toAddCity = null;
        int shiftindex = 0;
        int shiftcityindex = 0;
        boolean add = true;
        block9: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            if ((tag == 0 || tag == 5) && toAdd != null && add) {
                if (shiftindex != 0) {
                    toAdd.add(shiftindex);
                }
                if (shiftcityindex != 0) {
                    toAddCity.add(shiftcityindex);
                }
            }
            switch (tag) {
                case 0: {
                    return;
                }
                case 2: {
                    this.codedIS.readString();
                    continue block9;
                }
                case 1: {
                    this.codedIS.readString();
                    continue block9;
                }
                case 6: {
                    if (toAddCity == null) continue block9;
                    shiftcityindex = (int)(fp - (long)this.codedIS.readInt32());
                    continue block9;
                }
                case 7: {
                    int in32 = this.codedIS.readInt32();
                    int x16 = in32 >>> 16 << 15;
                    int y16 = (in32 & 0xFFFF) << 15;
                    add = !req.isBboxSpecified() || req.contains(x16, y16, x16, y16);
                    continue block9;
                }
                case 5: {
                    shiftindex = (int)(fp - (long)this.codedIS.readInt32());
                    continue block9;
                }
                case 3: {
                    int type = this.codedIS.readInt32();
                    toAdd = refs[type];
                    toAddCity = refsContainer[type];
                    continue block9;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private <T> void publishRawData(BinaryMapIndexReader.SearchRequest<T> resultMatcher, T obj) {
        if (resultMatcher != null && obj != null) {
            resultMatcher.collectRawData(obj);
        }
    }

    public static class AddressRegion
    extends BinaryIndexPart {
        String enName;
        long indexNameOffset = -1L;
        List<String> attributeTagsTable = new ArrayList<String>();
        List<CitiesBlock> cities = new ArrayList<CitiesBlock>();
        LatLon calculatedCenter = null;
        int bottom31;
        int top31;
        int right31;
        int left31;

        public String getEnName() {
            return this.enName;
        }

        public List<CitiesBlock> getCities() {
            return this.cities;
        }

        public List<String> getAttributeTagsTable() {
            return this.attributeTagsTable;
        }

        public long getIndexNameOffset() {
            return this.indexNameOffset;
        }

        @Override
        public String getPartName() {
            return "Address";
        }

        @Override
        public int getFieldNumber() {
            return 7;
        }
    }

    public static class CitiesBlock
    extends BinaryIndexPart {
        int type;

        public int getType() {
            return this.type;
        }

        @Override
        public String getPartName() {
            return "City";
        }

        @Override
        public int getFieldNumber() {
            return 6;
        }
    }

    private class DefaultCityMatcher
    implements CityMatcher {
        private StringMatcher stringMatcher = null;

        DefaultCityMatcher(StringMatcher stringMatcher) {
            this.stringMatcher = stringMatcher;
        }

        @Override
        public boolean matches(City city) {
            boolean matches;
            block2: {
                String n;
                if (this.stringMatcher == null) {
                    return true;
                }
                matches = this.stringMatcher.matches(city.getName());
                if (matches) break block2;
                Iterator<String> iterator = city.getOtherNames().iterator();
                while (iterator.hasNext() && !(matches = this.stringMatcher.matches(n = iterator.next()))) {
                }
            }
            return matches;
        }
    }

    static interface CityMatcher {
        public boolean matches(City var1);
    }
}

