/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.adapt.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IGeometryFilter;

public final class GeomMinSizeFilter
implements IGeometryFilter {
    private final double minArea;
    private final double minLength;

    public GeomMinSizeFilter(double minArea, double minLength) {
        if (minArea < 0.0) {
            throw new IllegalArgumentException("minArea must be >= 0");
        }
        if (minLength < 0.0) {
            throw new IllegalArgumentException("minLength must be >= 0");
        }
        this.minArea = minArea;
        this.minLength = minLength;
    }

    @Override
    public boolean accept(Geometry geometry) {
        boolean accept = true;
        if ((geometry instanceof Polygon || geometry instanceof MultiPolygon) && geometry.getArea() < this.minArea) {
            accept = false;
        } else if ((geometry instanceof LineString || geometry instanceof MultiLineString) && geometry.getLength() < this.minLength) {
            accept = false;
        }
        return accept;
    }
}

