/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.SingletonInstance;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SingletonInstanceServerSocket
extends SingletonInstance {
    private final Server singletonServer;
    private final String fullName;

    public SingletonInstanceServerSocket(long l, int n) {
        super(l);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByName("localhost");
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            throw new RuntimeException(this.infoPrefix() + " EEE Could not determine local InetAddress");
        }
        this.fullName = inetAddress.toString() + ":" + n;
        this.singletonServer = new Server(inetAddress, n);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SingletonInstanceServerSocket.this.singletonServer.kill();
            }
        });
    }

    public final InetAddress getLocalInetAddress() {
        return this.singletonServer.getLocalInetAddress();
    }

    public final int getPortNumber() {
        return this.singletonServer.getPortNumber();
    }

    @Override
    public final String getName() {
        return this.fullName;
    }

    @Override
    protected boolean tryLockImpl() {
        if (this.singletonServer.isRunning()) {
            return false;
        }
        Socket socket = this.singletonServer.connect();
        if (null != socket) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return this.singletonServer.start();
    }

    @Override
    protected boolean unlockImpl() {
        return this.singletonServer.shutdown();
    }

    public class Server
    implements Runnable {
        private final InetAddress localInetAddress;
        private final int portNumber;
        private volatile boolean shallQuit = false;
        private volatile boolean alive = false;
        private final Object syncOnStartStop = new Object();
        private ServerSocket serverSocket = null;
        private Thread serverThread = null;

        public Server(InetAddress inetAddress, int n) {
            this.localInetAddress = inetAddress;
            this.portNumber = n;
        }

        public final InetAddress getLocalInetAddress() {
            return this.localInetAddress;
        }

        public final int getPortNumber() {
            return this.portNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean start() {
            if (this.alive) {
                return true;
            }
            Object object = this.syncOnStartStop;
            synchronized (object) {
                this.serverThread = new Thread(this);
                this.serverThread.setDaemon(true);
                this.serverThread.start();
                try {
                    this.syncOnStartStop.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            boolean bl = this.isBound();
            if (!bl) {
                this.shutdown();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean shutdown() {
            if (!this.alive) {
                return true;
            }
            Object object = this.syncOnStartStop;
            synchronized (object) {
                this.shallQuit = true;
                this.connect();
                try {
                    this.syncOnStartStop.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.alive) {
                System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE " + SingletonInstanceServerSocket.this.getName() + " - Unable to remove lock: ServerThread still alive ?");
                this.kill();
            }
            return true;
        }

        public final void kill() {
            if (this.alive) {
                System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " XXX " + SingletonInstanceServerSocket.this.getName() + " - Kill @ JVM Shutdown");
            }
            this.alive = false;
            if (null != this.serverThread) {
                try {
                    this.serverThread.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (null != this.serverSocket) {
                try {
                    ServerSocket serverSocket = this.serverSocket;
                    this.serverSocket = null;
                    serverSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public final boolean isRunning() {
            return this.alive;
        }

        public final boolean isBound() {
            return this.alive && null != this.serverSocket && this.serverSocket.isBound();
        }

        public final Socket connect() {
            try {
                return new Socket(this.localInetAddress, this.portNumber);
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Thread.currentThread();
            ((Thread)object).setName(((Thread)object).getName() + " - SISock: " + SingletonInstanceServerSocket.this.getName());
            System.err.println(((Thread)object).getName() + " - started");
            this.alive = false;
            object = this.syncOnStartStop;
            synchronized (object) {
                try {
                    this.serverSocket = new ServerSocket(this.portNumber, 1, this.localInetAddress);
                    this.serverSocket.setReuseAddress(true);
                    this.alive = true;
                }
                catch (IOException iOException) {
                    System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " III - Unable to install ServerSocket: " + iOException.getMessage());
                    this.shallQuit = true;
                }
                finally {
                    this.syncOnStartStop.notifyAll();
                }
            }
            while (!this.shallQuit) {
                try {
                    object = this.serverSocket.accept();
                    ((Socket)object).close();
                }
                catch (IOException iOException) {
                    System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE - Exception during accept: " + iOException.getMessage());
                }
            }
            object = this.syncOnStartStop;
            synchronized (object) {
                try {
                    if (null != this.serverSocket) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE - Exception during close: " + iOException.getMessage());
                }
                finally {
                    this.serverSocket = null;
                    this.alive = false;
                    this.shallQuit = false;
                    this.syncOnStartStop.notifyAll();
                }
            }
        }
    }
}

