/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.tester;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import net.osmand.MainUtilities;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.routes.RouteRelationExtractor;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class RandomClickGenerator {
    private int zoom = 17;
    private int maxClicks = 1000;
    private int maxShiftMeters = 5;
    private PseudoRandom pseudoRandom = PseudoRandom.MONTH;
    private final List<String> obfFileNames = new ArrayList<String>();
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILED = 1;
    private final RenderingRuleSearchRequest renderingSearchRequest;
    private final Map<String, List<ClickableObject>> allObjectsMap = new HashMap<String, List<ClickableObject>>();
    private final List<ClickableObject> generatedRandomClicks = new ArrayList<ClickableObject>();

    public static void main(String[] args) throws IOException {
        long started = System.currentTimeMillis();
        RandomClickGenerator generator = new RandomClickGenerator(args);
        List<ClickableObject> clicks = generator.generate();
        System.out.println(new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).writerWithDefaultPrettyPrinter().writeValueAsString(Map.of("clicks", clicks)));
        System.err.printf("Finished in %.2f seconds (%d types found, %d clicks generated)\n", (double)(System.currentTimeMillis() - started) / 1000.0, generator.allObjectsMap.size(), clicks.size());
        System.exit(clicks.isEmpty() ? 1 : 0);
    }

    private RandomClickGenerator(String[] args) {
        this.applyCommandLineOpts(new MainUtilities.CommandLineOpts(args));
        String[] styles = RouteRelationExtractor.customStyles;
        Map<String, String> properties = RouteRelationExtractor.customProperties;
        RenderingRulesStorage renderingRules = RenderingRulesStorage.initWithStylesFromResources((String[])styles);
        this.renderingSearchRequest = RenderingRuleSearchRequest.initWithCustomProperties((RenderingRulesStorage)renderingRules, (int)this.zoom, properties);
    }

    private List<ClickableObject> generate() throws IOException {
        this.readObfFilesIndexes();
        this.generateRandomClicks();
        return this.generatedRandomClicks;
    }

    private void generateRandomClicks() {
        boolean added;
        ArrayList<String> orderedTypes = new ArrayList<String>(this.allObjectsMap.keySet());
        Collections.shuffle(orderedTypes, this.pseudoRandom.getNextRandom());
        for (String type : orderedTypes) {
            Collections.shuffle(this.allObjectsMap.get(type), this.pseudoRandom.getNextRandom());
        }
        block1: do {
            added = false;
            for (String type : orderedTypes) {
                if (this.generatedRandomClicks.size() >= this.maxClicks) continue block1;
                List<ClickableObject> objects = this.allObjectsMap.get(type);
                if (objects.isEmpty()) continue;
                this.generatedRandomClicks.add(objects.remove(objects.size() - 1));
                added = true;
            }
        } while (added);
    }

    private void readObfFilesIndexes() throws IOException {
        for (String fileName : this.obfFileNames) {
            File file = new File(fileName);
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            BinaryMapIndexReader reader = new BinaryMapIndexReader(raf, file);
            for (BinaryIndexPart part : reader.getIndexes()) {
                if (!(part instanceof BinaryMapIndexReader.MapIndex)) continue;
                this.readMapSection(reader, (BinaryMapIndexReader.MapIndex)part);
            }
            reader.close();
        }
    }

    private void readMapSection(BinaryMapIndexReader reader, BinaryMapIndexReader.MapIndex map) throws IOException {
        BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchRequest((int)0, (int)Integer.MAX_VALUE, (int)0, (int)Integer.MAX_VALUE, (int)this.zoom, null, (ResultMatcher)new ResultMatcher<BinaryMapDataObject>(){

            public boolean publish(BinaryMapDataObject object) {
                RandomClickGenerator.this.processBinaryMapDataObject(object);
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        });
        reader.searchMapIndex(req, map);
    }

    private void processBinaryMapDataObject(BinaryMapDataObject object) {
        if (object.getPolygonInnerCoordinates() != null && object.getPolygonInnerCoordinates().length > 0) {
            return;
        }
        if (object.isArea()) {
            return;
        }
        if (object.getPointsLength() > 1) {
            return;
        }
        if (object.getPointsLength() == 1) {
            this.processMapPoint(object);
        }
    }

    private Map<String, String> collectBinaryDataObjectOrderedTags(BinaryMapDataObject object) {
        int[] allObjectTypes;
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        int[] types = object.getTypes();
        int[] additionalTypes = object.getAdditionalTypes();
        for (int type : allObjectTypes = IntStream.concat(Arrays.stream(types != null ? types : new int[]{}), Arrays.stream(additionalTypes != null ? additionalTypes : new int[]{})).toArray()) {
            BinaryMapIndexReader.TagValuePair pair = object.getMapIndex().decodeType(type);
            if (pair == null || pair.tag == null || pair.value == null) continue;
            tags.put(pair.tag, pair.value);
        }
        return tags;
    }

    private void processMapPoint(BinaryMapDataObject point) {
        boolean isClickable;
        Map<String, String> tags = this.collectBinaryDataObjectOrderedTags(point);
        String icon = this.renderingSearchRequest.searchIconByTags(tags);
        boolean bl = isClickable = icon != null && !tags.isEmpty();
        if (isClickable) {
            BinaryMapIndexReader.TagValuePair pair;
            float lat = (float)MapUtils.get31LatitudeY((int)point.getPoint31YTile(0));
            float lon = (float)MapUtils.get31LongitudeX((int)point.getPoint31XTile(0));
            if (this.maxShiftMeters > 0) {
                lat = this.shiftLatOrLon(lat);
                lon = this.shiftLatOrLon(lon);
            }
            Map.Entry<String, String> firstTag = tags.entrySet().iterator().next();
            String mainTagValue = firstTag.getKey() + "=" + firstTag.getValue();
            String mainName = "";
            TIntArrayList order = point.getNamesOrder();
            TIntObjectHashMap names = point.getObjectNames();
            if (names != null && !names.isEmpty() && order != null && !order.isEmpty() && (pair = point.getMapIndex().decodeType(order.get(0))) != null) {
                String tag = pair.tag;
                String name = (String)names.get(order.get(0));
                tags.putIfAbsent(tag, name);
                mainName = name;
            }
            ClickableObject clickable = new ClickableObject(this.zoom, lat, lon, icon, mainName, mainTagValue, tags);
            this.allObjectsMap.computeIfAbsent(mainTagValue, k -> new ArrayList()).add(clickable);
        }
    }

    private float shiftLatOrLon(float ll) {
        float maxDegree = (float)this.maxShiftMeters / 111320.0f;
        float offset = (this.pseudoRandom.getNextFloat() * 2.0f - 1.0f) * maxDegree;
        return ll + offset;
    }

    private void applyCommandLineOpts(MainUtilities.CommandLineOpts opts) {
        String rs;
        if (opts.getOpt("--help") != null) {
            this.printHelpAndExit();
        }
        this.zoom = Algorithms.parseIntSilently((String)opts.getOpt("--zoom"), (int)this.zoom);
        this.maxClicks = Algorithms.parseIntSilently((String)opts.getOpt("--max-clicks"), (int)this.maxClicks);
        this.maxShiftMeters = Algorithms.parseIntSilently((String)opts.getOpt("--max-shift"), (int)this.maxShiftMeters);
        switch (rs = Objects.requireNonNullElse(opts.getOpt("--random-seed"), this.pseudoRandom.name().toLowerCase())) {
            case "random": {
                this.pseudoRandom = PseudoRandom.RANDOM;
                break;
            }
            case "month": {
                this.pseudoRandom = PseudoRandom.MONTH;
                break;
            }
            case "week": {
                this.pseudoRandom = PseudoRandom.WEEK;
                break;
            }
            case "day": {
                this.pseudoRandom = PseudoRandom.DAY;
            }
        }
        this.obfFileNames.addAll(opts.getStrings());
    }

    private void printHelpAndExit() {
        System.err.printf("%s\n", String.join((CharSequence)"\n", "", "Usage: random-click-generator [--options] [OBF-FILE(s)...]", "", "--random-seed=month|week|day|random (default based on month)", "--max-clicks=N (default 1000 clicks)", "--max-shift=N (default 5 meters)", "--zoom=N (default 17 zoom)", "", "--help show help", ""));
        System.exit(0);
    }

    private static enum PseudoRandom {
        MONTH(2678400000L),
        WEEK(604800000L),
        DAY(86400000L),
        RANDOM(1L);

        private final Random floatRandom;
        private final Random longRandom;

        private PseudoRandom(long millisPeriod) {
            long seed = System.currentTimeMillis() / millisPeriod;
            this.floatRandom = new Random(seed);
            this.longRandom = new Random(seed);
        }

        private float getNextFloat() {
            return this.floatRandom.nextFloat();
        }

        private long getNextLong() {
            return this.longRandom.nextLong();
        }

        private Random getNextRandom() {
            return new Random(this.getNextLong());
        }
    }

    private record ClickableObject(int zoom, float latitude, float longitude, String icon, String mainName, String mainTagValue, Map<String, String> tags) {
        @Override
        public String toString() {
            return String.format("%.5f,%.5f z%s %s %s (%s)", Float.valueOf(this.latitude), Float.valueOf(this.longitude), this.zoom, this.mainTagValue, this.icon, this.mainName);
        }
    }
}

