/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.osm.edit.Entity;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.ExcludeTLongObjectMap;
import net.osmand.router.GeneralRouter;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingOBFWriter;
import net.osmand.router.HHRoutingPreparationDB;
import net.osmand.router.HHRoutingPrepareContext;
import net.osmand.router.HHRoutingUtilities;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class HHRoutingShortcutCreator {
    static final Log LOG = PlatformUtil.getLog(HHRoutingShortcutCreator.class);
    static final int PROCESS_SET_NETWORK_POINTS = 1;
    static final int PROCESS_BUILD_NETWORK_SEGMENTS = 2;
    static boolean DEBUG_STORE_ALL_ROADS = false;
    static int DEBUG_LIMIT_START_OFFSET = 0;
    static int DEBUG_LIMIT_PROCESS = -1;
    static int DEBUG_VERBOSE_LEVEL = 0;
    private static HHRoutingPrepareContext prepareContext;
    private static boolean CLEAN;
    private static int BATCH_SIZE;
    private static int THREAD_POOL;
    private static String ROUTING_PROFILE;
    private static String ROUTING_PARAMS;

    private static File sourceFile() {
        CLEAN = true;
        DEBUG_VERBOSE_LEVEL = 0;
        THREAD_POOL = 1;
        String name = "Montenegro_europe_2.road.obf";
        return new File(System.getProperty("maps.dir"), name);
    }

    static void testCompact() throws SQLException, IOException {
        Object nameFile = System.getProperty("maps.dir");
        nameFile = (String)nameFile + "Montenegro_europe_2.road.obf_car";
        File source = new File((String)nameFile + ".hhdb");
        File target = new File((String)nameFile + ".chdb");
        HHRoutingPreparationDB.compact(source, target);
    }

    public static void main(String[] args) throws Exception {
        File obfFile = args.length == 0 ? HHRoutingShortcutCreator.sourceFile() : new File(args[0]);
        boolean onlyCompact = false;
        boolean debug = false;
        for (String a : args) {
            if (a.startsWith("--routing_profile=")) {
                ROUTING_PROFILE = a.substring("--routing_profile=".length());
                continue;
            }
            if (a.startsWith("--routing_params=")) {
                ROUTING_PARAMS = a.substring("--routing_params=".length()).trim();
                continue;
            }
            if (a.startsWith("--threads=")) {
                THREAD_POOL = Integer.parseInt(a.substring("--threads=".length()));
                continue;
            }
            if (a.equals("--clean")) {
                CLEAN = true;
                continue;
            }
            if (a.equals("--onlycompact")) {
                onlyCompact = true;
                continue;
            }
            if (!a.equals("--debug")) continue;
            debug = true;
        }
        Object prefixName = new File(".").getCanonicalFile().getName();
        if (args.length == 0) {
            File dir = HHRoutingShortcutCreator.sourceFile();
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            prefixName = dir.getAbsolutePath() + "/" + HHRoutingShortcutCreator.sourceFile().getCanonicalFile().getName();
        }
        int ind = 0;
        for (String routeProfile : ROUTING_PROFILE.split(",")) {
            String[] differentProfiles = ROUTING_PARAMS.split("@");
            String routeParamProfile = "";
            if (ind < differentProfiles.length) {
                routeParamProfile = differentProfiles[ind];
            }
            Object[] params = routeParamProfile.split("---");
            System.out.println("----------");
            System.out.println("Process profile: " + routeProfile + " profiles " + Arrays.toString(params));
            String name = (String)prefixName + "_" + routeProfile;
            File dbFile = new File(name + ".hhdb");
            if (onlyCompact) {
                File compactFile = new File(name + ".chdb");
                HHRoutingPreparationDB.compact(dbFile, compactFile);
                new HHRoutingOBFWriter(compactFile).writeFile(null, null, false, true);
                return;
            }
            HHRoutingPreparationDB networkDB = new HHRoutingPreparationDB(dbFile);
            if (CLEAN && dbFile.exists()) {
                networkDB.recreateSegments();
            }
            for (Object routingParam : params) {
                routingParam = ((String)routingParam).trim();
                prepareContext = new HHRoutingPrepareContext(obfFile, routeProfile, ((String)routingParam).split(","));
                int routingProfile = networkDB.insertRoutingProfile(routeProfile, (String)routingParam);
                HHRoutingShortcutCreator proc = new HHRoutingShortcutCreator();
                TLongObjectHashMap pnts = networkDB.loadNetworkPoints((short)0, HHRouteDataStructure.NetworkDBPoint.class);
                int segments = networkDB.loadNetworkSegments(pnts.valueCollection(), routingProfile);
                System.out.printf("Calculating segments for routing (%s) - existing segments %,d \n", routingParam, segments);
                Collection<Entity> objects = proc.buildNetworkShortcuts((TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint>)pnts, networkDB, routingProfile);
                if (!debug) continue;
                HHRoutingUtilities.saveOsmFile(objects, new File(name + "-hh.osm"));
            }
            networkDB.close();
            File compactFile = new File(name + ".chdb");
            HHRoutingPreparationDB.compact(dbFile, compactFile);
            new HHRoutingOBFWriter(compactFile).writeFile(null, null, false, true);
            ++ind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Entity> buildNetworkShortcuts(TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint> pnts, HHRoutingPreparationDB networkDB, int routingProfile) throws InterruptedException, IOException, SQLException, ExecutionException {
        int totalVisitedDirectSegments;
        int totalFinalSegmentsFound;
        int maxFinalSegmentsFound;
        int maxDirectedPointsGraph;
        ExecutorService service;
        TLongObjectHashMap segments;
        int ind;
        TLongObjectHashMap osmObjects;
        block14: {
            List<Runnable> runnable;
            void var12_13;
            osmObjects = new TLongObjectHashMap();
            double sz = (double)pnts.size() / 100.0;
            ind = 0;
            int prevPrintInd = 0;
            segments = new TLongObjectHashMap();
            for (HHRouteDataStructure.NetworkDBPoint pnt : pnts.valueCollection()) {
                BinaryRoutePlanner.RouteSegment routeSegment = new BinaryRoutePlanner.RouteSegment(null, (int)pnt.start, (int)pnt.end);
                segments.put(HHRoutePlanner.calculateRoutePointInternalId((long)pnt.roadId, (int)pnt.start, (int)pnt.end), (Object)routeSegment);
                HHRoutingUtilities.addNode((TLongObjectHashMap<Entity>)osmObjects, pnt, null, "highway", "stop");
            }
            service = Executors.newFixedThreadPool(THREAD_POOL);
            ArrayList<Future<BuildNetworkShortcutResult>> results = new ArrayList<Future<BuildNetworkShortcutResult>>();
            ArrayList arrayList = new ArrayList();
            int taskId = 0;
            int total = 0;
            int batchSize = BATCH_SIZE;
            if (pnts.size() / THREAD_POOL < batchSize) {
                batchSize = pnts.size() / THREAD_POOL + 1;
            }
            TLongObjectHashMap networkPointsByGeoId = new TLongObjectHashMap();
            for (Object pnt : pnts.valueCollection()) {
                networkPointsByGeoId.put(pnt.getGeoPntId(), pnt);
            }
            ArrayList<HHRouteDataStructure.NetworkDBPoint> lst = new ArrayList<HHRouteDataStructure.NetworkDBPoint>(pnts.valueCollection());
            lst.sort(new Comparator<HHRouteDataStructure.NetworkDBPoint>(){

                @Override
                public int compare(HHRouteDataStructure.NetworkDBPoint o1, HHRouteDataStructure.NetworkDBPoint o2) {
                    return Integer.compare(o1.index, o2.index);
                }
            });
            for (HHRouteDataStructure.NetworkDBPoint pnt : lst) {
                ++ind;
                if (pnt.connectedReverse.size() > 0) {
                    pnt.connectedReverse.clear();
                }
                if (pnt.connected.size() > 0) {
                    pnt.connected.clear();
                    continue;
                }
                if (ind < DEBUG_LIMIT_START_OFFSET) continue;
                var12_13.add(pnt);
                if (ind > DEBUG_LIMIT_PROCESS && DEBUG_LIMIT_PROCESS != -1) break;
                if (var12_13.size() != batchSize) continue;
                results.add(service.submit(new BuildNetworkShortcutTask(this, (List<HHRouteDataStructure.NetworkDBPoint>)var12_13, (TLongObjectHashMap<BinaryRoutePlanner.RouteSegment>)segments, (TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint>)networkPointsByGeoId, taskId++)));
                total += var12_13.size();
                ArrayList arrayList2 = new ArrayList();
            }
            System.gc();
            results.add(service.submit(new BuildNetworkShortcutTask(this, (List<HHRouteDataStructure.NetworkDBPoint>)var12_13, (TLongObjectHashMap<BinaryRoutePlanner.RouteSegment>)segments, (TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint>)networkPointsByGeoId, taskId++)));
            HHRoutingUtilities.logf("Scheduled %d tasks, %d total points", taskId, total += var12_13.size());
            maxDirectedPointsGraph = 0;
            maxFinalSegmentsFound = 0;
            totalFinalSegmentsFound = 0;
            totalVisitedDirectSegments = 0;
            ind = 1;
            service.shutdown();
            try {
                while (!results.isEmpty()) {
                    Thread.sleep(5000L);
                    Iterator it = results.iterator();
                    while (it.hasNext()) {
                        RouteCalculationProgress calculationProgress;
                        Future future = (Future)it.next();
                        if (!future.isDone()) continue;
                        BuildNetworkShortcutResult res = (BuildNetworkShortcutResult)future.get();
                        for (int k = 0; k < res.points.size(); totalVisitedDirectSegments += calculationProgress.visitedDirectSegments, totalFinalSegmentsFound += calculationProgress.finalSegmentsFound, ++k) {
                            HHRouteDataStructure.NetworkDBPoint rpnt = res.points.get(k);
                            calculationProgress = res.progress.get(k);
                            if (DEBUG_VERBOSE_LEVEL >= 1 || ++ind - prevPrintInd > 200) {
                                prevPrintInd = ind;
                                HHRoutingUtilities.logf("%.2f%% Process %d (%d shortcuts) - %.1f ms", (double)ind / sz, rpnt.roadId / 64L, res.shortcuts.get(k), rpnt.rt((boolean)false).rtDistanceFromStart);
                            }
                            networkDB.insertSegments(rpnt.connected, routingProfile);
                            if (DEBUG_VERBOSE_LEVEL >= 2) {
                                System.out.println(calculationProgress.getInfo(null));
                            }
                            maxDirectedPointsGraph = Math.max(maxDirectedPointsGraph, calculationProgress.visitedDirectSegments);
                            maxFinalSegmentsFound = Math.max(maxFinalSegmentsFound, calculationProgress.finalSegmentsFound);
                            rpnt.connected.clear();
                            rpnt.connectedReverse.clear();
                        }
                        osmObjects.putAll(res.osmObjects);
                        it.remove();
                        HHRoutingUtilities.logf("Task id %d executed %.1f seconds - %d (of %d) waiting completion", res.taskId, res.totalTime, results.size(), taskId);
                    }
                }
                runnable = service.shutdownNow();
                if (results.isEmpty()) break block14;
            }
            catch (Throwable throwable) {
                List<Runnable> runnable2 = service.shutdownNow();
                if (!results.isEmpty()) {
                    HHRoutingUtilities.logf("!!! %d runnable were not executed: exception occurred", runnable2 == null ? 0 : runnable2.size());
                }
                service.awaitTermination(5L, TimeUnit.MINUTES);
                throw throwable;
            }
            HHRoutingUtilities.logf("!!! %d runnable were not executed: exception occurred", runnable == null ? 0 : runnable.size());
        }
        service.awaitTermination(5L, TimeUnit.MINUTES);
        System.out.println(String.format("Total segments %d: %d total shorcuts, per border point max %d, average %d shortcuts (routing sub graph max %d, avg %d segments)", segments.size(), totalFinalSegmentsFound, maxFinalSegmentsFound, totalFinalSegmentsFound / ind, maxDirectedPointsGraph, totalVisitedDirectSegments / ind));
        return osmObjects.valueCollection();
    }

    private List<BinaryRoutePlanner.RouteSegment> runDijsktra(RoutingContext ctx, BinaryRoutePlanner routePlanner, BinaryRoutePlanner.RouteSegmentPoint s, TLongObjectMap<BinaryRoutePlanner.RouteSegment> segments) throws InterruptedException, IOException {
        BinaryRoutePlanner.MultiFinalRouteSegment frs;
        long pnt = HHRoutePlanner.calculateRoutePointInternalId((long)s.getRoad().getId(), (int)s.getSegmentEnd(), (int)s.getSegmentStart());
        segments = new ExcludeTLongObjectMap(segments, new long[]{pnt});
        TLongObjectHashMap resUnique = new TLongObjectHashMap();
        ctx.unloadAllData();
        ctx.calculationProgress = new RouteCalculationProgress();
        ctx.config.penaltyForReverseDirection = -1.0;
        try {
            frs = (BinaryRoutePlanner.MultiFinalRouteSegment)routePlanner.searchRouteInternal(ctx, s, null, (TLongObjectMap)segments);
        }
        catch (RuntimeException e) {
            ctx.unloadAllData();
            System.err.printf("Error calculating %d (start=%d) \n", s.getRoad().getId(), s.getSegmentStart());
            BinaryRoutePlanner.TRACE_ROUTING = true;
            BinaryRoutePlanner.MultiFinalRouteSegment frs2 = (BinaryRoutePlanner.MultiFinalRouteSegment)routePlanner.searchRouteInternal(ctx, s, null, (TLongObjectMap)segments);
            System.out.println("-----------");
            throw e;
        }
        if (frs != null) {
            for (BinaryRoutePlanner.RouteSegment o : frs.all) {
                long pntId = HHRoutePlanner.calculateRoutePointInternalId((long)o.getRoad().getId(), (int)o.getSegmentStart(), (int)o.getSegmentEnd());
                if (resUnique.containsKey(pntId)) {
                    if (!(((BinaryRoutePlanner.RouteSegment)resUnique.get(pntId)).getDistanceFromStart() > o.getDistanceFromStart())) continue;
                    throw new IllegalStateException(String.valueOf(resUnique.get(pntId)) + " > " + String.valueOf(o) + " - " + String.valueOf(s));
                }
                resUnique.put(pntId, (Object)o);
            }
        }
        return new ArrayList<BinaryRoutePlanner.RouteSegment>(resUnique.valueCollection());
    }

    static {
        BATCH_SIZE = 1000;
        THREAD_POOL = 2;
        ROUTING_PROFILE = "car";
        ROUTING_PARAMS = "";
    }

    private static class BuildNetworkShortcutTask
    implements Callable<BuildNetworkShortcutResult> {
        private static ThreadLocal<RoutingContext> context = new ThreadLocal();
        private List<HHRouteDataStructure.NetworkDBPoint> batch;
        private TLongObjectHashMap<BinaryRoutePlanner.RouteSegment> segments;
        private HHRoutingShortcutCreator creator;
        private TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint> networkPointsByGeoId;
        private int taskId;

        public BuildNetworkShortcutTask(HHRoutingShortcutCreator creator, List<HHRouteDataStructure.NetworkDBPoint> batch, TLongObjectHashMap<BinaryRoutePlanner.RouteSegment> segments, TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint> networkPointsByGeoId, int taskId) {
            this.creator = creator;
            this.batch = batch;
            this.segments = segments;
            this.networkPointsByGeoId = networkPointsByGeoId;
            this.taskId = taskId;
        }

        @Override
        public BuildNetworkShortcutResult call() throws Exception {
            RoutingContext ctx;
            ctx = prepareContext.gcMemoryLimitToUnloadAll(ctx, null, (ctx = context.get()) == null);
            ((GeneralRouter)ctx.getRouter()).clearCaches();
            ctx.unloadAllData();
            for (BinaryMapRouteReaderAdapter.RouteRegion r : ctx.reverseMap.keySet()) {
                for (BinaryMapRouteReaderAdapter.RouteSubregion s : r.getSubregions()) {
                    s.subregions = null;
                    s.dataObjects = null;
                }
            }
            context.set(ctx);
            BuildNetworkShortcutResult res = new BuildNetworkShortcutResult();
            res.taskId = this.taskId;
            long nt = System.nanoTime();
            for (HHRouteDataStructure.NetworkDBPoint pnt : this.batch) {
                if (Thread.interrupted()) {
                    return res;
                }
                ctx.calculationProgress = new RouteCalculationProgress();
                long nt2 = System.nanoTime();
                BinaryRoutePlanner.RouteSegmentPoint s = HHRoutePlanner.loadPoint((RoutingContext)ctx, (HHRouteDataStructure.NetworkDBPoint)pnt);
                if (s == null) {
                    System.out.printf("Skip segment %d as not accessible (%s) \n", pnt.roadId / 64L, pnt);
                    continue;
                }
                HHRoutingUtilities.addNode(res.osmObjects, pnt, HHRoutingUtilities.getPoint((BinaryRoutePlanner.RouteSegment)s), "highway", "stop");
                try {
                    BinaryRoutePlanner routePlanner = new BinaryRoutePlanner();
                    List<BinaryRoutePlanner.RouteSegment> result = this.creator.runDijsktra(ctx, routePlanner, s, (TLongObjectMap<BinaryRoutePlanner.RouteSegment>)this.segments);
                    boolean errorFound = false;
                    Iterator<BinaryRoutePlanner.RouteSegment> iterator = result.iterator();
                    while (iterator.hasNext()) {
                        float routeTime;
                        BinaryRoutePlanner.RouteSegment t;
                        HHRouteDataStructure.NetworkDBPoint end = (HHRouteDataStructure.NetworkDBPoint)this.networkPointsByGeoId.get(HHRoutePlanner.calculateRoutePointInternalId((long)t.getRoad().getId(), (int)t.getSegmentStart(), (int)t.getSegmentEnd()));
                        double h = MapUtils.squareRootDist31((int)pnt.midX(), (int)pnt.midY(), (int)end.midX(), (int)end.midY()) / (double)ctx.getRouter().getMaxSpeed();
                        if (h > (double)(routeTime = t.getDistanceFromStart() + routePlanner.calcRoutingSegmentTimeOnlyDist(ctx.getRouter(), t) / 2.0f) && h > (double)(routeTime += 1.0f)) {
                            throw new IllegalStateException(String.format("%s %s - %.2f > %.2f", pnt, end, h, Float.valueOf(routeTime)));
                        }
                        HHRouteDataStructure.NetworkDBSegment segment = new HHRouteDataStructure.NetworkDBSegment(pnt, end, (double)routeTime, true, false);
                        List geometry = segment.getGeometry();
                        for (t = iterator.next(); t != null; t = t.getParentRoute()) {
                            geometry.add(HHRoutingUtilities.getPoint(t));
                        }
                        Collections.reverse(geometry);
                        if (pnt.dualPoint.clusterId != end.clusterId) {
                            if (errorFound) continue;
                            errorFound = true;
                            StringBuilder b = new StringBuilder();
                            for (BinaryRoutePlanner.RouteSegment test : result) {
                                HHRouteDataStructure.NetworkDBPoint other = (HHRouteDataStructure.NetworkDBPoint)this.networkPointsByGeoId.get(HHRoutePlanner.calculateRoutePointInternalId((long)test.getRoad().getId(), (int)test.getSegmentStart(), (int)test.getSegmentEnd()));
                                b.append(other).append(" (").append(other.clusterId).append("), ");
                            }
                            String msg = String.format("%s can lead only to dual cluster %d - found %s (cluster %d): %s", pnt, pnt.dualPoint.clusterId, end, end.clusterId, b.toString());
                            System.err.println(HHRoutingUtilities.testGetGeometry(geometry));
                            System.err.println("BUG needs to be fixed " + msg);
                            System.err.println(msg);
                            throw new IllegalStateException(msg);
                        }
                        if (segment.dist < 0.0) {
                            throw new IllegalStateException(String.valueOf(segment) + " dist < " + segment.dist);
                        }
                        pnt.connected.add(segment);
                        if (!DEBUG_STORE_ALL_ROADS) continue;
                        HHRoutingUtilities.addWay(res.osmObjects, segment, "highway", "secondary");
                    }
                    if (DEBUG_VERBOSE_LEVEL >= 2) {
                        HHRoutingUtilities.logf("Run dijkstra %d point - %d shortcuts: %.2f ms (calc %.2f ms, load %.2f ms) - %s", pnt.index, result.size(), (double)(System.nanoTime() - nt2) / 1000000.0, (double)ctx.calculationProgress.timeToCalculate / 1000000.0, (double)ctx.calculationProgress.timeToLoad / 1000000.0, s.toString());
                    }
                    pnt.rt((boolean)false).rtDistanceFromStart = (double)(System.nanoTime() - nt2) / 1000000.0;
                    res.points.add(pnt);
                    res.progress.add(ctx.calculationProgress);
                    res.shortcuts.add(result.size());
                }
                catch (RuntimeException e) {
                    HHRoutingUtilities.logf("Error %s while processing %d road - %s (%d)", e.getMessage(), pnt.roadId / 64L, pnt.getPoint(), pnt.index);
                    throw e;
                }
            }
            this.segments = null;
            res.totalTime = (double)(System.nanoTime() - nt) / 1.0E9;
            return res;
        }
    }

    private static class BuildNetworkShortcutResult {
        List<HHRouteDataStructure.NetworkDBPoint> points = new ArrayList<HHRouteDataStructure.NetworkDBPoint>();
        List<RouteCalculationProgress> progress = new ArrayList<RouteCalculationProgress>();
        TIntArrayList shortcuts = new TIntArrayList();
        TLongObjectHashMap<Entity> osmObjects = new TLongObjectHashMap();
        double totalTime;
        int taskId;

        private BuildNetworkShortcutResult() {
        }
    }
}

