/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.TLongCollection;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.PropagateToNodes;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.IOsmStorageFilter;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OsmDbCreator
implements IOsmStorageFilter {
    public static String OSMAND_DELETE_TAG = "osmand_change";
    public static String OSMAND_DELETE_VALUE = "delete";
    private static final Log log = LogFactory.getLog(OsmDbCreator.class);
    public static final int SHIFT_ID = 6;
    public static final int BATCH_SIZE_OSM = 100000;
    final String[] tagsToIgnore = new String[]{"created_by", "converted_by"};
    DBDialect dialect;
    int currentCountNode = 0;
    private PreparedStatement prepNode;
    int allNodes = 0;
    private PreparedStatement selectNode;
    int currentRelationsCount = 0;
    private PreparedStatement prepRelations;
    int allRelations = 0;
    int currentWaysCount = 0;
    private PreparedStatement prepWays;
    int allWays = 0;
    int propagateCount = 0;
    private PreparedStatement prepPropagateNode;
    private PreparedStatement delNode;
    private PreparedStatement delRelations;
    private PreparedStatement delWays;
    private TLongHashSet nodeIds = new TLongHashSet();
    private TLongHashSet wayIds = new TLongHashSet();
    private TLongHashSet relationIds = new TLongHashSet();
    private Connection dbConn;
    private static boolean VALIDATE_DUPLICATES = false;
    private TLongObjectHashMap<Long> generatedIds = new TLongObjectHashMap();
    private TLongObjectHashMap<Long> hashes = new TLongObjectHashMap();
    private TLongSet idSetToValidateDuplicates = new TLongHashSet();
    private final int shiftId;
    private final int additionId;
    private final boolean generateNewIds;
    private final boolean addGeoHash;
    private long generatedId = -100L;
    private PropagateToNodes propagateToNodes;

    public OsmDbCreator(int additionId, int shiftId) {
        this.additionId = additionId;
        this.shiftId = shiftId;
        this.generateNewIds = false;
        this.addGeoHash = true;
    }

    public OsmDbCreator(boolean addGeoHash) {
        this.additionId = 0;
        this.shiftId = 0;
        this.generateNewIds = false;
        this.addGeoHash = addGeoHash;
    }

    public OsmDbCreator() {
        this.additionId = 0;
        this.shiftId = 0;
        this.generateNewIds = false;
        this.addGeoHash = true;
    }

    public long convertId(Entity e) {
        long id = e.getId();
        int ord = Entity.EntityType.valueOf((Entity)e).ordinal();
        if (e instanceof Node) {
            if (!this.addGeoHash || id < 0L) {
                return this.getSimpleConvertId(id, Entity.EntityType.NODE, true);
            }
            int hash = this.getNodeHash(e);
            return this.getConvertId(id, ord, hash);
        }
        if (e instanceof Way) {
            TLongArrayList lids = ((Way)e).getNodeIds();
            long hash = 0L;
            for (int i = 0; i < lids.size(); ++i) {
                Long ld;
                if (!this.addGeoHash || lids.get(i) < 0L) {
                    ld = this.getSimpleConvertId(lids.get(i), Entity.EntityType.NODE, false);
                } else {
                    ld = this.getGeneratedId(lids.get(i), 0);
                    Long hd = this.getHash(lids.get(i), 0);
                    if (hd != null) {
                        hash += hd.longValue();
                    }
                }
                if (ld == null) continue;
                lids.set(i, ld.longValue());
            }
            if (!this.addGeoHash || id < 0L) {
                return this.getSimpleConvertId(id, Entity.EntityType.WAY, true);
            }
            return this.getConvertId(id, ord, hash);
        }
        Relation r = (Relation)e;
        for (Relation.RelationMember i : r.getMembers()) {
            Long newId;
            long oldId = i.getEntityId().getId();
            Entity.EntityType entityType = i.getEntityId().getType();
            if (i.getEntityId().getType() == Entity.EntityType.RELATION || (newId = !this.addGeoHash || oldId < 0L ? Long.valueOf(this.getSimpleConvertId(oldId, entityType, false)) : this.getGeneratedId(oldId, entityType.ordinal())) == null) continue;
            r.update(i, new Entity.EntityId(entityType, newId));
        }
        if (!this.addGeoHash || id < 0L) {
            return this.getSimpleConvertId(id, Entity.EntityType.RELATION, true);
        }
        return id;
    }

    private long getSimpleConvertId(long id, Entity.EntityType type, boolean newId) {
        if (this.generateNewIds) {
            long key = (id << 2) + (long)type.ordinal();
            if (!this.generatedIds.contains(key) || newId) {
                id = this.generatedId--;
                this.generatedIds.put(key, (Object)id);
            } else {
                id = (Long)this.generatedIds.get(key);
            }
        }
        if (id < 0L) {
            long shiftedPositive = -id << this.shiftId;
            return -(shiftedPositive + (long)this.additionId);
        }
        return id;
    }

    private int getNodeHash(Entity e) {
        int y = MapUtils.get31TileNumberY((double)((Node)e).getLatitude());
        int x = MapUtils.get31TileNumberX((double)((Node)e).getLongitude());
        int hash = x + y >> 10;
        return hash;
    }

    private Long getHash(long l, int ord) {
        if (l < 0L) {
            long lid = (l << this.shiftId) + (long)this.additionId;
            long fid = (lid << 2) + (long)ord;
            return (Long)this.hashes.get(fid);
        }
        return (Long)this.hashes.get((l << 2) + (long)ord);
    }

    private Long getGeneratedId(long l, int ord) {
        if (l < 0L) {
            long lid = (l << this.shiftId) + (long)this.additionId;
            long fid = (lid << 2) + (long)ord;
            return (Long)this.generatedIds.get(fid);
        }
        return (Long)this.generatedIds.get((l << 2) + (long)ord);
    }

    private long getConvertId(long id, int ord, long hash) {
        if (id < 0L && (this.shiftId > 0 || this.additionId > 0)) {
            long lid = (id << this.shiftId) + (long)this.additionId;
            long fid = (lid << 2) + (long)ord;
            this.generatedIds.put(fid, (Object)lid);
            this.hashes.put(fid, (Object)hash);
            return lid;
        }
        int l = (int)(hash & 0x1FL);
        long cid = (id << 6) + (long)(ord % 2) + (long)(l << 1);
        long fid = (id << 2) + (long)ord;
        this.generatedIds.put(fid, (Object)cid);
        this.hashes.put(fid, (Object)hash);
        return cid;
    }

    public void initDatabase(DBDialect dialect, Object databaseConn, boolean create, OsmDbCreator previous) throws SQLException {
        this.dialect = dialect;
        this.dbConn = (Connection)databaseConn;
        Statement stat = this.dbConn.createStatement();
        if (create) {
            dialect.deleteTableIfExists("node", stat);
            stat.executeUpdate("create table node (id bigint primary key, latitude double, longitude double, tags blob, propagate boolean)");
            stat.executeUpdate("create index IdIndex ON node (id)");
            dialect.deleteTableIfExists("ways", stat);
            stat.executeUpdate("create table ways (id bigint, node bigint, ord smallint, tags blob, boundary smallint, primary key (id, ord))");
            stat.executeUpdate("create index IdWIndex ON ways (id)");
            dialect.deleteTableIfExists("relations", stat);
            stat.executeUpdate("create table relations (id bigint, member bigint, type smallint, role varchar(1024), ord smallint, tags blob, primary key (id, ord))");
            stat.executeUpdate("create index IdRIndex ON relations (id)");
            stat.close();
        } else if (previous != null) {
            this.nodeIds = previous.nodeIds;
            this.wayIds = previous.wayIds;
            this.relationIds = previous.relationIds;
        }
        this.prepNode = this.dbConn.prepareStatement("replace into node(id, latitude, longitude, tags, propagate) values (?, ?, ?, ?, ?)");
        this.prepWays = this.dbConn.prepareStatement("replace into ways(id, node, ord, tags, boundary) values (?, ?, ?, ?, ?)");
        this.prepRelations = this.dbConn.prepareStatement("replace into relations(id, member, type, role, ord, tags) values (?, ?, ?, ?, ?, ?)");
        this.prepPropagateNode = this.dbConn.prepareStatement("update node set propagate=1 where id=?");
        this.selectNode = this.dbConn.prepareStatement("select latitude, longitude from node where id=?");
        this.dbConn.setAutoCommit(false);
    }

    protected void initIds(String table, TLongHashSet col) throws SQLException {
        if (col.isEmpty()) {
            Statement s = this.dbConn.createStatement();
            ResultSet rs = s.executeQuery("select id from " + table);
            while (rs.next()) {
                col.add(rs.getLong(1));
            }
            s.close();
        }
    }

    public void finishLoading() throws SQLException {
        try {
            if (this.currentCountNode > 0) {
                this.prepNode.executeBatch();
            }
            this.prepNode.close();
            if (this.currentWaysCount > 0) {
                this.prepWays.executeBatch();
            }
            this.prepWays.close();
            if (this.currentRelationsCount > 0) {
                this.prepRelations.executeBatch();
            }
            if (this.propagateCount > 0) {
                this.prepPropagateNode.executeBatch();
            }
        }
        catch (SQLException ex) {
            log.error((Object)"TODO FIX: Could not save in db ", (Throwable)ex);
        }
        this.prepRelations.close();
        this.prepPropagateNode.close();
        if (this.delNode != null) {
            this.delNode.close();
        }
        if (this.delWays != null) {
            this.delWays.close();
        }
        if (this.delRelations != null) {
            this.delRelations.close();
        }
    }

    protected void checkEntityExists(Entity e, long id) throws SQLException {
        if (this.delNode == null) {
            this.delNode = this.dbConn.prepareStatement("delete from node where id = ?");
            this.delWays = this.dbConn.prepareStatement("delete from ways where id = ?");
            this.delRelations = this.dbConn.prepareStatement("delete from relations where id = ? ");
        }
        boolean present = false;
        if (e instanceof Node) {
            present = !this.nodeIds.add(id);
        } else if (e instanceof Way) {
            present = !this.wayIds.add(id);
        } else if (e instanceof Relation) {
            boolean bl = present = !this.relationIds.add(id);
        }
        if (!present) {
            return;
        }
        this.prepNode.executeBatch();
        this.prepWays.executeBatch();
        this.prepRelations.executeBatch();
        this.prepPropagateNode.executeBatch();
        this.currentWaysCount = 0;
        this.currentCountNode = 0;
        this.currentRelationsCount = 0;
        this.propagateCount = 0;
        if (e instanceof Node) {
            this.delNode.setLong(1, id);
            this.delNode.execute();
        } else if (e instanceof Way) {
            this.delWays.setLong(1, id);
            this.delWays.execute();
        } else if (e instanceof Relation) {
            this.delRelations.setLong(1, id);
            this.delRelations.execute();
        }
        this.dbConn.commit();
    }

    public boolean acceptEntityToLoad(OsmBaseStorage storage, Entity.EntityId entityId, Entity e) {
        long l;
        if (VALIDATE_DUPLICATES && !this.idSetToValidateDuplicates.add(l = (e.getId() << 2) + (long)entityId.getType().ordinal())) {
            throw new IllegalStateException("Duplicate id '" + e.getId() + "' " + String.valueOf(entityId.getType()));
        }
        try {
            e.removeTags(this.tagsToIgnore);
            ByteArrayOutputStream tags = new ByteArrayOutputStream();
            try {
                for (Map.Entry i : e.getTags().entrySet()) {
                    tags.write(((String)i.getKey()).getBytes("UTF-8"));
                    tags.write(0);
                    tags.write(((String)i.getValue()).getBytes("UTF-8"));
                    tags.write(0);
                }
            }
            catch (IOException es) {
                throw new RuntimeException(es);
            }
            long id = this.convertId(e);
            if (this.propagateToNodes != null && e instanceof Way) {
                boolean firstIteration = this.propagateToNodes.isNoRegisteredNodes();
                PropagateToNodes.PropagateWayWithNodes pnodes = this.propagateToNodes.propagateTagsFromWays((Way)e);
                if (pnodes != null && !pnodes.empty) {
                    if (firstIteration) {
                        this.executeNodesBatch(true);
                    }
                    TLongArrayList nodeIds = ((Way)e).getNodeIds();
                    TLongArrayList oldNodeIds = new TLongArrayList((TLongCollection)nodeIds);
                    nodeIds.clear();
                    long newInd = 0L;
                    for (int i = 0; i < pnodes.points.length; ++i) {
                        LatLon latLon;
                        PropagateToNodes.PropagateFromWayToNode pn = pnodes.points[i];
                        if (i % 2 == 0) {
                            nodeIds.add(oldNodeIds.get(i / 2));
                            if (pn == null) continue;
                            this.prepPropagateNode.setLong(1, pn.id);
                            this.prepPropagateNode.addBatch();
                            ++this.propagateCount;
                            this.propagateToNodes.registerNode(pn);
                            continue;
                        }
                        if (pnodes.points[i] == null || (latLon = pn.getLatLon(this.getNode(oldNodeIds.get(pn.start)), this.getNode(oldNodeIds.get(pn.end)))) == null) continue;
                        long wayId = e.getId();
                        if (wayId < 0L) {
                            wayId = Math.abs(wayId) % 0x4000000000L;
                        }
                        pn.id = 0x2000000000000L + (wayId << 11) + newInd++;
                        if (newInd > 2047L) {
                            log.error((Object)("Maximum number 2047 of propagated nodes reached for way:" + e.getId()));
                            nodeIds.clear();
                            nodeIds.addAll((TLongCollection)oldNodeIds);
                            break;
                        }
                        ++this.currentCountNode;
                        this.prepNode.setLong(1, pn.id);
                        this.prepNode.setDouble(2, latLon.getLatitude());
                        this.prepNode.setDouble(3, latLon.getLongitude());
                        this.prepNode.setBytes(4, new ByteArrayOutputStream().toByteArray());
                        this.prepNode.setBoolean(5, true);
                        this.prepNode.addBatch();
                        nodeIds.add(pn.id);
                        this.propagateToNodes.registerNode(pn);
                        this.executeNodesBatch(false);
                    }
                }
                if (this.propagateCount >= 100000) {
                    this.prepPropagateNode.executeBatch();
                    this.dbConn.commit();
                    this.propagateCount = 0;
                }
            }
            if (e instanceof Node) {
                ++this.currentCountNode;
                if (!e.getTags().isEmpty()) {
                    ++this.allNodes;
                }
                this.prepNode.setLong(1, id);
                this.prepNode.setDouble(2, ((Node)e).getLatitude());
                this.prepNode.setDouble(3, ((Node)e).getLongitude());
                this.prepNode.setBytes(4, tags.toByteArray());
                this.prepNode.setBoolean(5, false);
                this.prepNode.addBatch();
                this.executeNodesBatch(false);
            } else if (e instanceof Way) {
                ++this.allWays;
                ord = 0;
                TLongArrayList nodeIds = ((Way)e).getNodeIds();
                boolean city = City.CityType.valueFromString((String)((Way)e).getTag(OSMSettings.OSMTagKey.PLACE)) != null;
                int boundary = ((Way)e).getTag(OSMSettings.OSMTagKey.BOUNDARY) != null || city ? 1 : 0;
                for (int j = 0; j < nodeIds.size(); ++j) {
                    ++this.currentWaysCount;
                    if (ord == 0) {
                        this.prepWays.setBytes(4, tags.toByteArray());
                    }
                    this.prepWays.setLong(1, id);
                    this.prepWays.setLong(2, nodeIds.get(j));
                    this.prepWays.setLong(3, ord++);
                    this.prepWays.setInt(5, boundary);
                    this.prepWays.addBatch();
                }
                if (this.currentWaysCount >= 100000) {
                    this.prepWays.executeBatch();
                    this.dbConn.commit();
                    this.currentWaysCount = 0;
                }
            } else {
                ++this.allRelations;
                ord = 0;
                for (Relation.RelationMember i : ((Relation)e).getMembers()) {
                    ++this.currentRelationsCount;
                    if (ord == 0) {
                        this.prepRelations.setBytes(6, tags.toByteArray());
                    }
                    this.prepRelations.setLong(1, id);
                    this.prepRelations.setLong(2, i.getEntityId().getId());
                    this.prepRelations.setLong(3, i.getEntityId().getType().ordinal());
                    this.prepRelations.setString(4, i.getRole());
                    int n = ord;
                    ord = (short)(ord + 1);
                    this.prepRelations.setLong(5, n);
                    this.prepRelations.addBatch();
                }
                if (this.currentRelationsCount >= 100000) {
                    this.prepRelations.executeBatch();
                    this.dbConn.commit();
                    this.currentRelationsCount = 0;
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)("TODO FIX: Could not save in db (entity " + String.valueOf(entityId) + ") "), (Throwable)ex);
        }
        return false;
    }

    private void executeNodesBatch(boolean force) throws SQLException {
        if (this.currentCountNode >= 100000 || force) {
            this.prepNode.executeBatch();
            this.dbConn.commit();
            this.currentCountNode = 0;
        }
    }

    private Node getNode(long l) throws SQLException {
        this.selectNode.setLong(1, l);
        ResultSet q = this.selectNode.executeQuery();
        if (q.next()) {
            return new Node(q.getDouble(1), q.getDouble(2), l);
        }
        return null;
    }

    public int getAllNodes() {
        return this.allNodes;
    }

    public int getAllRelations() {
        return this.allRelations;
    }

    public int getAllWays() {
        return this.allWays;
    }

    public void setPropagateToNodes(PropagateToNodes propagateToNodes) {
        this.propagateToNodes = propagateToNodes;
    }
}

