/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.BeanInputFilterStream;
import org.xwiki.stability.Unstable;

@Unstable
public abstract class AbstractBeanInputFilterStream<P, F>
implements BeanInputFilterStream<P>,
Initializable {
    @Inject
    private FilterDescriptorManager filterDescriptorManager;
    protected Class<F> filterType;
    protected P properties;

    public AbstractBeanInputFilterStream() {
    }

    public AbstractBeanInputFilterStream(FilterDescriptorManager filterDescriptorManager, P properties) throws FilterException {
        this.filterDescriptorManager = filterDescriptorManager;
        this.setProperties(properties);
    }

    @Override
    public void setProperties(P properties) throws FilterException {
        this.properties = properties;
    }

    public void initialize() throws InitializationException {
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanInputFilterStream.class, this.getClass());
        this.filterType = ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[1]);
    }

    @Override
    public void read(Object filter) throws FilterException {
        Object proxyFilter = this.filterDescriptorManager.createFilterProxy(filter, this.filterType);
        this.read(filter, proxyFilter);
    }

    protected abstract void read(Object var1, F var2) throws FilterException;
}

