/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.osmand.util.Algorithms;

public class OpeningHoursParser {
    private static final String[] daysStr;
    private static String[] localDaysStr;
    private static final String[] monthsStr;
    private static String[] localMothsStr;
    private static final Map<String, String> additionalStrings;
    private static final int LOW_TIME_LIMIT = 120;
    private static final int WITHOUT_TIME_LIMIT = -1;
    private static final int CURRENT_DAY_TIME_LIMIT = -2;
    private static boolean twelveHourFormatting;
    private static DateFormat twelveHourFormatter;
    private static DateFormat twelveHourFormatterAmPm;
    private static String sunrise;
    private static String sunset;
    private static String endOfDay;

    private static void initLocalStrings() {
        OpeningHoursParser.initLocalStrings(null);
    }

    public static void initLocalStrings(Locale locale) {
        DateFormatSymbols dateFormatSymbols = locale == null ? DateFormatSymbols.getInstance() : DateFormatSymbols.getInstance(locale);
        localMothsStr = dateFormatSymbols.getShortMonths();
        localDaysStr = OpeningHoursParser.getLettersStringArray(dateFormatSymbols.getShortWeekdays(), 3);
    }

    public static void setTwelveHourFormattingEnabled(boolean enabled, Locale locale) {
        twelveHourFormatting = enabled;
        if (enabled) {
            OpeningHoursParser.initTwelveHourFormatters(locale);
        }
    }

    private static void initTwelveHourFormatters(Locale locale) {
        twelveHourFormatter = new SimpleDateFormat("h:mm", locale);
        twelveHourFormatterAmPm = DateFormat.getTimeInstance(3, locale);
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        twelveHourFormatter.setTimeZone(timeZone);
        twelveHourFormatterAmPm.setTimeZone(timeZone);
    }

    public static void setAdditionalString(String key, String value) {
        additionalStrings.put(key, value);
    }

    private static String[] getLettersStringArray(String[] strings, int letters) {
        String[] newStrings = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) continue;
            newStrings[i] = strings[i].length() > letters ? Algorithms.capitalizeFirstLetter(strings[i].substring(0, letters)) : Algorithms.capitalizeFirstLetter(strings[i]);
        }
        return newStrings;
    }

    private static int getDayIndex(int i) {
        switch (i) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 1;
            }
        }
        return -1;
    }

    public static void parseRuleV2(String r, int sequenceIndex, List<OpeningHoursRule> rules) {
        r = r.trim();
        String[] daysStr = new String[]{"mo", "tu", "we", "th", "fr", "sa", "su"};
        String[] monthsStr = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        String[] holidayStr = new String[]{"ph", "sh", "easter"};
        String sunrise = "07:00";
        String sunset = "21:00";
        String endOfDay = "24:00";
        r = r.replace('(', ' ');
        r = r.replace(')', ' ');
        BasicOpeningHourRule basic = new BasicOpeningHourRule(sequenceIndex);
        if (r.startsWith("|| ")) {
            r = r.replace("|| ", "");
            basic.fallback = true;
        }
        String localRuleString = r.replaceAll("(?i)sunset", sunset).replaceAll("(?i)sunrise", sunrise).replaceAll("\\+", "-" + endOfDay);
        boolean[] days = basic.getDays();
        boolean[] months = basic.getMonths();
        if ("24/7".equals(localRuleString)) {
            Arrays.fill(days, true);
            basic.hasDays = true;
            Arrays.fill(months, true);
            basic.addTimeRange(0, 1440);
            rules.add(basic);
            return;
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int startWord = 0;
        StringBuilder commentStr = new StringBuilder();
        boolean comment = false;
        for (int i = 0; i <= localRuleString.length(); ++i) {
            char ch = i == localRuleString.length() ? (char)' ' : (char)localRuleString.charAt(i);
            boolean delimiter = false;
            Token del = null;
            if (Character.isWhitespace(ch)) {
                delimiter = true;
            } else if (ch == ':') {
                del = new Token(TokenType.TOKEN_COLON, ":");
            } else if (ch == '-') {
                del = new Token(TokenType.TOKEN_DASH, "-");
            } else if (ch == ',') {
                del = new Token(TokenType.TOKEN_COMMA, ",");
            } else if (ch == '\"') {
                if (comment) {
                    if (commentStr.length() > 0) {
                        tokens.add(new Token(TokenType.TOKEN_COMMENT, commentStr.toString()));
                    }
                    startWord = i + 1;
                    commentStr.setLength(0);
                    comment = false;
                } else {
                    comment = true;
                    continue;
                }
            }
            if (comment) {
                commentStr.append(ch);
                continue;
            }
            if (!delimiter && del == null) continue;
            String wrd = localRuleString.substring(startWord, i).trim();
            if (wrd.length() > 0) {
                tokens.add(new Token(TokenType.TOKEN_UNKNOWN, wrd.toLowerCase()));
            }
            startWord = i + 1;
            if (del == null) continue;
            tokens.add(del);
        }
        for (Token t : tokens) {
            if (t.type == TokenType.TOKEN_UNKNOWN) {
                OpeningHoursParser.findInArray(t, daysStr, TokenType.TOKEN_DAY_WEEK);
            }
            if (t.type == TokenType.TOKEN_UNKNOWN) {
                OpeningHoursParser.findInArray(t, monthsStr, TokenType.TOKEN_MONTH);
            }
            if (t.type == TokenType.TOKEN_UNKNOWN) {
                OpeningHoursParser.findInArray(t, holidayStr, TokenType.TOKEN_HOLIDAY);
            }
            if (t.type == TokenType.TOKEN_UNKNOWN && ("off".equals(t.text) || "closed".equals(t.text))) {
                t.type = TokenType.TOKEN_OFF_ON;
                t.mainNumber = 0;
            }
            if (t.type != TokenType.TOKEN_UNKNOWN || !"24/7".equals(t.text) && !"open".equals(t.text)) continue;
            t.type = TokenType.TOKEN_OFF_ON;
            t.mainNumber = 1;
        }
        for (int i = tokens.size() - 1; i > 0; --i) {
            if (((Token)tokens.get((int)i)).type == TokenType.TOKEN_COLON) {
                if (i >= tokens.size() - 1 || ((Token)tokens.get((int)(i - 1))).type != TokenType.TOKEN_UNKNOWN || ((Token)tokens.get((int)(i - 1))).mainNumber == -1 || ((Token)tokens.get((int)(i + 1))).type != TokenType.TOKEN_UNKNOWN || ((Token)tokens.get((int)(i + 1))).mainNumber == -1) continue;
                ((Token)tokens.get((int)i)).mainNumber = 60 * ((Token)tokens.get((int)(i - 1))).mainNumber + ((Token)tokens.get((int)(i + 1))).mainNumber;
                ((Token)tokens.get((int)i)).type = TokenType.TOKEN_HOUR_MINUTES;
                tokens.remove(i + 1);
                tokens.remove(i - 1);
                continue;
            }
            if (((Token)tokens.get((int)i)).type != TokenType.TOKEN_OFF_ON || ((Token)tokens.get((int)(i - 1))).type != TokenType.TOKEN_OFF_ON) continue;
            tokens.remove(i - 1);
        }
        boolean monthSpecified = false;
        for (Token t : tokens) {
            if (t.type != TokenType.TOKEN_MONTH) continue;
            monthSpecified = true;
            break;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            Token t = (Token)tokens.get(i);
            if (t.type != TokenType.TOKEN_UNKNOWN || t.mainNumber < 0) continue;
            if (monthSpecified && t.mainNumber <= 31) {
                t.type = TokenType.TOKEN_DAY_MONTH;
                --t.mainNumber;
                continue;
            }
            if (t.mainNumber <= 1000) continue;
            t.type = TokenType.TOKEN_YEAR;
        }
        OpeningHoursParser.buildRule(basic, tokens, rules);
    }

    private static void buildRule(BasicOpeningHourRule basic, List<Token> tokens, List<OpeningHoursRule> rules) {
        TokenType currentParse = TokenType.TOKEN_UNKNOWN;
        TokenType currentParseParent = TokenType.TOKEN_UNKNOWN;
        ArrayList<Token[]> listOfPairs = new ArrayList<Token[]>();
        EnumSet<TokenType> presentTokens = EnumSet.noneOf(TokenType.class);
        Token[] currentPair = new Token[2];
        listOfPairs.add(currentPair);
        Token prevToken = null;
        Token prevYearToken = null;
        int indexP = 0;
        for (int i = 0; i <= tokens.size(); ++i) {
            Token t;
            Token token = t = i == tokens.size() ? null : tokens.get(i);
            if (i == 0 && t != null && t.type == TokenType.TOKEN_UNKNOWN) {
                return;
            }
            if (t == null || t.type.ord() > currentParse.ord()) {
                Token[] l;
                presentTokens.add(currentParse);
                if (currentParse == TokenType.TOKEN_MONTH || currentParse == TokenType.TOKEN_DAY_MONTH || currentParse == TokenType.TOKEN_DAY_WEEK || currentParse == TokenType.TOKEN_HOLIDAY) {
                    boolean tokenDayMonth;
                    boolean bl = tokenDayMonth = currentParse == TokenType.TOKEN_DAY_MONTH;
                    boolean[] array = currentParse == TokenType.TOKEN_MONTH ? basic.getMonths() : (boolean[])(tokenDayMonth ? null : basic.getDays());
                    for (Token[] pair : listOfPairs) {
                        Token firstMonthToken;
                        if (pair[0] != null && pair[1] != null) {
                            int startYear;
                            int ruleYear;
                            Token lastMonthToken;
                            firstMonthToken = pair[0].parent == null && pair[0].type == TokenType.TOKEN_MONTH ? pair[0] : pair[0].parent;
                            Token token2 = lastMonthToken = pair[1].parent == null && pair[1].type == TokenType.TOKEN_MONTH ? pair[1] : pair[1].parent;
                            if (tokenDayMonth && firstMonthToken != null) {
                                if (lastMonthToken != null && lastMonthToken.mainNumber != firstMonthToken.mainNumber) {
                                    Token[] p = new Token[]{firstMonthToken, lastMonthToken};
                                    OpeningHoursParser.fillRuleArray(basic.getMonths(), p);
                                    Token t1 = new Token(TokenType.TOKEN_DAY_MONTH, pair[0].mainNumber);
                                    Token t2 = new Token(TokenType.TOKEN_DAY_MONTH, 30);
                                    p = new Token[]{t1, t2};
                                    array = basic.getDayMonths(firstMonthToken.mainNumber);
                                    OpeningHoursParser.fillRuleArray(array, p);
                                    t1 = new Token(TokenType.TOKEN_DAY_MONTH, 0);
                                    t2 = new Token(TokenType.TOKEN_DAY_MONTH, pair[1].mainNumber);
                                    p = new Token[]{t1, t2};
                                    array = basic.getDayMonths(lastMonthToken.mainNumber);
                                    OpeningHoursParser.fillRuleArray(array, p);
                                    if (firstMonthToken.mainNumber <= lastMonthToken.mainNumber) {
                                        for (month = firstMonthToken.mainNumber + 1; month < lastMonthToken.mainNumber; ++month) {
                                            Arrays.fill(basic.getDayMonths(month), true);
                                        }
                                    } else {
                                        for (month = firstMonthToken.mainNumber + 1; month < 12; ++month) {
                                            Arrays.fill(basic.getDayMonths(month), true);
                                        }
                                        for (month = 0; month < lastMonthToken.mainNumber; ++month) {
                                            Arrays.fill(basic.getDayMonths(month), true);
                                        }
                                    }
                                } else {
                                    array = basic.getDayMonths(firstMonthToken.mainNumber);
                                    OpeningHoursParser.fillRuleArray(array, pair);
                                }
                            } else if (array != null) {
                                OpeningHoursParser.fillRuleArray(array, pair);
                            }
                            if ((ruleYear = basic.year) <= 0 && prevYearToken == null || firstMonthToken == null || lastMonthToken == null) continue;
                            int endYear = prevYearToken != null ? prevYearToken.mainNumber : ruleYear;
                            int n = startYear = ruleYear > 0 ? ruleYear : endYear;
                            if (basic.firstYearMonths == null) {
                                basic.firstYearMonths = new int[12];
                            }
                            Arrays.fill(basic.firstYearMonths, firstMonthToken.mainNumber, 12, startYear);
                            if (endYear <= startYear) continue;
                            if (basic.lastYearMonths == null) {
                                basic.lastYearMonths = new int[12];
                            }
                            Arrays.fill(basic.lastYearMonths, 0, lastMonthToken.mainNumber + 1, endYear);
                            if (endYear - startYear > 1) {
                                startInd = lastMonthToken.mainNumber + 1;
                                Arrays.fill(basic.lastYearMonths, startInd, 12, endYear - 1);
                            } else {
                                startInd = Math.max(lastMonthToken.mainNumber + 1, firstMonthToken.mainNumber);
                                Arrays.fill(basic.lastYearMonths, startInd, 12, startYear);
                            }
                            OpeningHoursParser.fillFirstLastYearsDayOfMonth(basic, pair);
                            if (firstMonthToken.mainNumber < lastMonthToken.mainNumber) continue;
                            Arrays.fill(basic.months, true);
                            continue;
                        }
                        if (pair[0] == null) continue;
                        if (pair[0].type == TokenType.TOKEN_HOLIDAY) {
                            if (pair[0].mainNumber == 0) {
                                basic.publicHoliday = true;
                                continue;
                            }
                            if (pair[0].mainNumber == 1) {
                                basic.schoolHoliday = true;
                                continue;
                            }
                            if (pair[0].mainNumber != 2) continue;
                            basic.easter = true;
                            continue;
                        }
                        if (pair[0].mainNumber < 0) continue;
                        firstMonthToken = pair[0].parent;
                        if (tokenDayMonth && firstMonthToken != null) {
                            array = basic.getDayMonths(firstMonthToken.mainNumber);
                        }
                        if (array == null) continue;
                        array[pair[0].mainNumber] = true;
                        if (prevYearToken == null) continue;
                        basic.year = prevYearToken.mainNumber;
                    }
                } else if (currentParse == TokenType.TOKEN_HOUR_MINUTES) {
                    for (Token[] pair : listOfPairs) {
                        if (pair[0] == null || pair[1] == null) continue;
                        basic.addTimeRange(pair[0].mainNumber, pair[1].mainNumber);
                    }
                } else if (currentParse == TokenType.TOKEN_OFF_ON) {
                    Token[] l2 = (Token[])listOfPairs.get(0);
                    if (l2[0] != null && l2[0].mainNumber == 0) {
                        basic.off = true;
                    }
                } else if (currentParse == TokenType.TOKEN_COMMENT) {
                    Token[] l3 = (Token[])listOfPairs.get(0);
                    if (l3[0] != null && !Algorithms.isEmpty(l3[0].text)) {
                        basic.comment = l3[0].text;
                    }
                } else if (currentParse == TokenType.TOKEN_YEAR && (l = (Token[])listOfPairs.get(0))[0] != null && l[0].mainNumber > 1000) {
                    prevYearToken = l[0];
                }
                listOfPairs.clear();
                currentPair = new Token[2];
                indexP = 0;
                listOfPairs.add(currentPair);
                currentPair[indexP++] = t;
                if (t != null) {
                    currentParseParent = currentParse = t.type;
                    if (t.type == TokenType.TOKEN_DAY_MONTH && prevToken != null && prevToken.type == TokenType.TOKEN_MONTH) {
                        t.parent = prevToken;
                        currentParseParent = prevToken.type;
                    } else if (t.type == TokenType.TOKEN_MONTH && prevToken != null && prevToken.type == TokenType.TOKEN_YEAR) {
                        basic.year = prevToken.mainNumber;
                    }
                }
            } else if (t.type.ord() < currentParseParent.ord() && indexP == 0 && tokens.size() > i) {
                BasicOpeningHourRule newRule = new BasicOpeningHourRule(basic.getSequenceIndex());
                newRule.setComment(basic.getComment());
                OpeningHoursParser.buildRule(newRule, tokens.subList(i, tokens.size()), rules);
                tokens = tokens.subList(0, i + 1);
            } else if (t.type == TokenType.TOKEN_COMMA) {
                if (tokens.size() > i + 1 && tokens.get(i + 1) != null && tokens.get((int)(i + 1)).type.ord() < currentParseParent.ord()) {
                    indexP = 0;
                } else {
                    currentPair = new Token[2];
                    indexP = 0;
                    listOfPairs.add(currentPair);
                }
            } else if (t.type != TokenType.TOKEN_DASH) {
                if (t.type == TokenType.TOKEN_YEAR) {
                    prevYearToken = t;
                } else if (t.type.ord() == currentParse.ord() && indexP < 2) {
                    currentPair[indexP++] = t;
                    if (t.type == TokenType.TOKEN_DAY_MONTH && prevToken != null && prevToken.type == TokenType.TOKEN_MONTH) {
                        t.parent = prevToken;
                    }
                }
            }
            prevToken = t;
        }
        if (!presentTokens.contains((Object)TokenType.TOKEN_MONTH)) {
            Arrays.fill(basic.getMonths(), true);
        }
        if (!(presentTokens.contains((Object)TokenType.TOKEN_DAY_WEEK) || presentTokens.contains((Object)TokenType.TOKEN_HOLIDAY) || presentTokens.contains((Object)TokenType.TOKEN_DAY_MONTH))) {
            Arrays.fill(basic.getDays(), true);
            basic.hasDays = true;
        } else if (presentTokens.contains((Object)TokenType.TOKEN_DAY_WEEK) || presentTokens.contains((Object)TokenType.TOKEN_HOLIDAY)) {
            basic.hasDays = true;
        }
        rules.add(0, basic);
    }

    private static void fillFirstLastYearsDayOfMonth(BasicOpeningHourRule basic, Token[] pair) {
        int startMonth = pair[0].parent == null ? pair[0].mainNumber : pair[0].parent.mainNumber;
        int startDayOfMonth = pair[0].parent == null ? 0 : pair[0].mainNumber;
        basic.firstYearDayMonth = new boolean[12][31];
        Arrays.fill(basic.firstYearDayMonth[startMonth], startDayOfMonth, 31, true);
        for (int month = startMonth + 1; month < 12; ++month) {
            Arrays.fill(basic.firstYearDayMonth[month], true);
        }
        int endMonth = pair[1].parent == null ? pair[1].mainNumber : pair[1].parent.mainNumber;
        int endDayOfMonth = pair[1].parent == null ? 30 : pair[1].mainNumber;
        basic.lastYearDayMonth = new boolean[12][31];
        Arrays.fill(basic.lastYearDayMonth[endMonth], 0, endDayOfMonth + 1, true);
        for (int month = 0; month < endMonth; ++month) {
            Arrays.fill(basic.lastYearDayMonth[month], true);
        }
    }

    private static void fillRuleArray(boolean[] array, Token[] pair) {
        if (pair[0].mainNumber <= pair[1].mainNumber) {
            for (int j = pair[0].mainNumber; j <= pair[1].mainNumber && j >= 0 && j < array.length; ++j) {
                array[j] = true;
            }
        } else {
            int j;
            for (j = pair[0].mainNumber; j >= 0 && j < array.length; ++j) {
                array[j] = true;
            }
            for (j = 0; j <= pair[1].mainNumber && j < array.length; ++j) {
                array[j] = true;
            }
        }
    }

    private static void findInArray(Token t, String[] list, TokenType tokenType) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(t.text)) continue;
            t.type = tokenType;
            t.mainNumber = i;
            break;
        }
    }

    private static List<List<String>> splitSequences(String format) {
        String[] sequences;
        if (format == null) {
            return null;
        }
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (String seq : sequences = format.split("(?= \\|\\| )")) {
            if ((seq = seq.trim()).length() == 0) continue;
            ArrayList<String> rules = new ArrayList<String>();
            boolean comment = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < seq.length(); ++i) {
                char c = seq.charAt(i);
                if (c == '\"') {
                    comment = !comment;
                    sb.append(c);
                    continue;
                }
                if (c == ';' && !comment) {
                    if (sb.length() <= 0) continue;
                    String s = sb.toString().trim();
                    if (s.length() > 0) {
                        rules.add(s);
                    }
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
            if (sb.length() > 0) {
                rules.add(sb.toString());
                sb.setLength(0);
            }
            res.add(rules);
        }
        return res;
    }

    public static void parseRules(String r, int sequenceIndex, List<OpeningHoursRule> rules) {
        OpeningHoursParser.parseRuleV2(r, sequenceIndex, rules);
    }

    public static OpeningHours parseOpenedHours(String format) {
        if (format == null) {
            return null;
        }
        OpeningHours rs = new OpeningHours();
        rs.setOriginal(format);
        List<List<String>> sequences = OpeningHoursParser.splitSequences(format);
        for (int i = 0; i < sequences.size(); ++i) {
            List<String> rules = sequences.get(i);
            ArrayList<BasicOpeningHourRule> basicRules = new ArrayList<BasicOpeningHourRule>();
            for (String r : rules) {
                ArrayList<OpeningHoursRule> rList = new ArrayList<OpeningHoursRule>();
                OpeningHoursParser.parseRules(r, i, rList);
                for (OpeningHoursRule rule : rList) {
                    if (!(rule instanceof BasicOpeningHourRule)) continue;
                    basicRules.add((BasicOpeningHourRule)rule);
                }
            }
            String basicRuleComment = null;
            if (sequences.size() > 1) {
                for (BasicOpeningHourRule bRule : basicRules) {
                    if (Algorithms.isEmpty(bRule.getComment())) continue;
                    basicRuleComment = bRule.getComment();
                    break;
                }
            }
            if (!Algorithms.isEmpty(basicRuleComment)) {
                for (BasicOpeningHourRule bRule : basicRules) {
                    bRule.setComment(basicRuleComment);
                }
            }
            rs.addRules(basicRules);
        }
        rs.setSequenceCount(sequences.size());
        return rs.rules.size() > 0 ? rs : null;
    }

    public static OpeningHours parseOpenedHoursHandleErrors(String format) {
        if (format == null) {
            return null;
        }
        OpeningHours rs = new OpeningHours();
        rs.setOriginal(format);
        List<List<String>> sequences = OpeningHoursParser.splitSequences(format);
        for (int i = sequences.size() - 1; i >= 0; --i) {
            List<String> rules = sequences.get(i);
            for (String r : rules) {
                if ((r = r.trim()).length() == 0) continue;
                ArrayList<OpeningHoursRule> rList = new ArrayList<OpeningHoursRule>();
                OpeningHoursParser.parseRules(r, i, rList);
                rs.addRules(rList);
            }
        }
        rs.setSequenceCount(sequences.size());
        return rs;
    }

    public static List<OpeningHours.Info> getInfo(String format) {
        OpeningHours openingHours = OpeningHoursParser.parseOpenedHours(format);
        if (openingHours == null) {
            return null;
        }
        return openingHours.getInfo();
    }

    private static void formatTimeRange(int startMinute, int endMinute, StringBuilder stringBuilder) {
        boolean sameDayPart;
        int startHour = startMinute / 60 % 24;
        int endHour = endMinute / 60 % 24;
        boolean bl = sameDayPart = Math.max(startHour, endHour) < 12 || Math.min(startHour, endHour) >= 12;
        if (twelveHourFormatting && sameDayPart) {
            boolean amPmOnLeft = OpeningHoursParser.isAmPmOnLeft(startMinute);
            OpeningHoursParser.formatTime(startMinute, stringBuilder, amPmOnLeft);
            stringBuilder.append("-");
            OpeningHoursParser.formatTime(endMinute, stringBuilder, !amPmOnLeft);
        } else {
            OpeningHoursParser.formatTime(startMinute, stringBuilder);
            stringBuilder.append("-");
            OpeningHoursParser.formatTime(endMinute, stringBuilder);
        }
    }

    private static boolean isAmPmOnLeft(int startMinute) {
        StringBuilder sb = new StringBuilder();
        OpeningHoursParser.formatTime(startMinute, sb);
        return !Character.isDigit(sb.charAt(0));
    }

    private static void formatTime(int minutes, StringBuilder sb) {
        OpeningHoursParser.formatTime(minutes, sb, true);
    }

    private static void formatTime(int minutes, StringBuilder sb, boolean appendAmPM) {
        int hour = minutes / 60;
        int time = minutes - hour * 60;
        OpeningHoursParser.formatTime(hour, time, sb, appendAmPM);
    }

    private static void formatTime(int hours, int minutes, StringBuilder b, boolean appendAmPm) {
        if (twelveHourFormatting) {
            long millis = ((long)hours * 60L + (long)minutes) * 60L * 1000L;
            Date date = new Date(millis);
            String time = appendAmPm ? twelveHourFormatterAmPm.format(date) : twelveHourFormatter.format(date);
            b.append(time);
        } else {
            if (hours < 10) {
                b.append("0");
            }
            b.append(hours).append(":");
            if (minutes < 10) {
                b.append("0");
            }
            b.append(minutes);
        }
    }

    static {
        additionalStrings = new HashMap<String, String>();
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(Locale.US);
        monthsStr = dateFormatSymbols.getShortMonths();
        daysStr = OpeningHoursParser.getLettersStringArray(dateFormatSymbols.getShortWeekdays(), 2);
        OpeningHoursParser.initLocalStrings();
        additionalStrings.put("off", "off");
        additionalStrings.put("is_open", "Open");
        additionalStrings.put("is_open_24_7", "Open 24/7");
        additionalStrings.put("will_open_at", "Will open at");
        additionalStrings.put("open_from", "Open from");
        additionalStrings.put("will_close_at", "Will close at");
        additionalStrings.put("open_till", "Open till");
        additionalStrings.put("will_open_tomorrow_at", "Will open tomorrow at");
        additionalStrings.put("will_open_on", "Will open on");
        sunrise = "07:00";
        sunset = "21:00";
        endOfDay = "24:00";
    }

    public static class BasicOpeningHourRule
    implements OpeningHoursRule {
        private boolean[] days = new boolean[7];
        private boolean hasDays = false;
        private boolean[] months = new boolean[12];
        private int[] firstYearMonths = null;
        private boolean[][] firstYearDayMonth;
        private int[] lastYearMonths = null;
        private boolean[][] lastYearDayMonth;
        private int year = 0;
        private boolean fallback;
        private boolean[][] dayMonths = null;
        private TIntArrayList startTimes = new TIntArrayList();
        private TIntArrayList endTimes = new TIntArrayList();
        private boolean publicHoliday = false;
        private boolean schoolHoliday = false;
        private boolean easter = false;
        private boolean off = false;
        private String comment;
        private int sequenceIndex;

        public BasicOpeningHourRule() {
            this.sequenceIndex = 0;
        }

        public BasicOpeningHourRule(int sequenceIndex) {
            this.sequenceIndex = sequenceIndex;
        }

        @Override
        public int getSequenceIndex() {
            return this.sequenceIndex;
        }

        @Override
        public boolean isFallbackRule() {
            return this.fallback;
        }

        public boolean[] getDays() {
            return this.days;
        }

        public boolean[] getDayMonths(int month) {
            if (this.dayMonths == null) {
                this.dayMonths = new boolean[12][31];
            }
            return this.dayMonths[month];
        }

        public boolean hasDayMonths() {
            return this.dayMonths != null;
        }

        public boolean[] getMonths() {
            return this.months;
        }

        public boolean appliesToPublicHolidays() {
            return this.publicHoliday;
        }

        public boolean appliesEaster() {
            return this.easter;
        }

        public boolean appliesToSchoolHolidays() {
            return this.schoolHoliday;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setStartTime(int s) {
            BasicOpeningHourRule.setSingleValueForArrayList(this.startTimes, s);
            if (this.endTimes.size() != 1) {
                BasicOpeningHourRule.setSingleValueForArrayList(this.endTimes, 0);
            }
        }

        public void setEndTime(int e) {
            BasicOpeningHourRule.setSingleValueForArrayList(this.endTimes, e);
            if (this.startTimes.size() != 1) {
                BasicOpeningHourRule.setSingleValueForArrayList(this.startTimes, 0);
            }
        }

        public void setStartTime(int s, int position) {
            if (position == this.startTimes.size()) {
                this.startTimes.add(s);
                this.endTimes.add(0);
            } else {
                this.startTimes.set(position, s);
            }
        }

        public void setEndTime(int s, int position) {
            if (position == this.startTimes.size()) {
                this.endTimes.add(s);
                this.startTimes.add(0);
            } else {
                this.endTimes.set(position, s);
            }
        }

        public int getStartTime() {
            if (this.startTimes.size() == 0) {
                return 0;
            }
            return this.startTimes.get(0);
        }

        public int getStartTime(int position) {
            return this.startTimes.get(position);
        }

        public int getEndTime() {
            if (this.endTimes.size() == 0) {
                return 0;
            }
            return this.endTimes.get(0);
        }

        public int getEndTime(int position) {
            return this.endTimes.get(position);
        }

        public TIntArrayList getStartTimes() {
            return new TIntArrayList((TIntCollection)this.startTimes);
        }

        public TIntArrayList getEndTimes() {
            return new TIntArrayList((TIntCollection)this.endTimes);
        }

        public void setDays(boolean[] days) {
            if (this.days.length == days.length) {
                this.days = days;
            }
        }

        @Override
        public boolean containsDay(Calendar cal) {
            int i = cal.get(7);
            int d = (i + 5) % 7;
            return this.days[d];
        }

        @Override
        public boolean containsNextDay(Calendar cal) {
            int i = cal.get(7);
            int p = (i + 6) % 7;
            return this.days[p];
        }

        @Override
        public boolean containsPreviousDay(Calendar cal) {
            int i = cal.get(7);
            int p = (i + 4) % 7;
            return this.days[p];
        }

        @Override
        public boolean containsMonth(Calendar cal) {
            int month = cal.get(2);
            int year = cal.get(1);
            if (!this.hasYears()) {
                return (this.year == 0 || this.year == year) && this.months[month];
            }
            if (this.year > year) {
                return false;
            }
            if (this.year < year) {
                if (this.lastYearMonths == null) {
                    return false;
                }
                int lastYear = this.lastYearMonths[month];
                return lastYear > 0 && year <= lastYear;
            }
            return this.firstYearMonths[month] > 0;
        }

        @Override
        public boolean isOpenedForTime(Calendar cal, boolean checkPrevious) {
            int d = this.getCurrentDay(cal);
            int p = this.getPreviousDay(d);
            int time = this.getCurrentTimeInMinutes(cal);
            for (int i = 0; i < this.startTimes.size(); ++i) {
                int endTime;
                int startTime = this.startTimes.get(i);
                if (startTime < (endTime = this.endTimes.get(i)) || endTime == -1) {
                    if (!this.days[d] || checkPrevious || time < startTime || endTime != -1 && time > endTime) continue;
                    return !this.off;
                }
                if (time >= startTime && this.days[d] && !checkPrevious) {
                    return !this.off;
                }
                if (time >= endTime || !this.days[p] || !checkPrevious) continue;
                return !this.off;
            }
            return false;
        }

        private int getCurrentDay(Calendar cal) {
            int i = cal.get(7);
            return (i + 5) % 7;
        }

        private int getPreviousDay(int currentDay) {
            int p = currentDay - 1;
            if (p < 0) {
                p += 7;
            }
            return p;
        }

        private int getNextDay(int currentDay) {
            int n = currentDay + 1;
            if (n > 6) {
                n -= 7;
            }
            return n;
        }

        private int getCurrentTimeInMinutes(Calendar cal) {
            return cal.get(11) * 60 + cal.get(12);
        }

        @Override
        public String toRuleString() {
            return this.toRuleString(false);
        }

        private String toRuleString(boolean useLocalization) {
            boolean allDays;
            String[] dayNames = useLocalization ? localDaysStr : daysStr;
            String[] monthNames = useLocalization ? localMothsStr : monthsStr;
            String offStr = useLocalization ? additionalStrings.get("off") : "off";
            StringBuilder b = new StringBuilder(25);
            boolean allMonths = true;
            for (int i = 0; i < this.months.length; ++i) {
                if (this.months[i]) continue;
                allMonths = false;
                break;
            }
            boolean bl = allDays = !this.hasDayMonths();
            if (!allDays) {
                boolean dash = false;
                boolean first = true;
                int monthAdded = -1;
                int dayAdded = -1;
                int excludedMonthEnd = -1;
                int excludedDayEnd = -1;
                int excludedMonthStart = -1;
                int excludedDayStart = -1;
                if (this.dayMonths[0][0] && this.dayMonths[11][30]) {
                    int day;
                    int month;
                    int prevMonth = 0;
                    int prevDay = 0;
                    for (month = 0; month < this.dayMonths.length; ++month) {
                        day = 0;
                        while (day < this.dayMonths[month].length) {
                            if (day == 1) {
                                prevMonth = month;
                            }
                            if (!this.dayMonths[month][day]) {
                                excludedMonthEnd = prevMonth;
                                excludedDayEnd = prevDay;
                                break;
                            }
                            prevDay = day++;
                        }
                        if (excludedDayEnd != -1) break;
                    }
                    prevMonth = this.dayMonths.length - 1;
                    prevDay = this.dayMonths[prevMonth].length - 1;
                    for (month = this.dayMonths.length - 1; month >= 0; --month) {
                        day = this.dayMonths[month].length - 1;
                        while (day >= 0) {
                            if (day == this.dayMonths[month].length - 2) {
                                prevMonth = month;
                            }
                            if (!this.dayMonths[month][day]) {
                                excludedMonthStart = prevMonth;
                                excludedDayStart = prevDay;
                                break;
                            }
                            prevDay = day--;
                        }
                        if (excludedDayStart != -1) break;
                    }
                }
                boolean yearAdded = false;
                for (int month = 0; month < this.dayMonths.length; ++month) {
                    for (int day = 0; day < this.dayMonths[month].length; ++day) {
                        if (excludedDayStart != -1 && excludedDayEnd != -1 && (month < excludedMonthEnd || month == excludedMonthEnd && day <= excludedDayEnd || month > excludedMonthStart || month == excludedMonthStart && day >= excludedDayStart) || !this.dayMonths[month][day] || day == 0 && dash && this.dayMonths[month][1]) continue;
                        if (day > 0 && this.dayMonths[month][day - 1] && (day < this.dayMonths[month].length - 1 && this.dayMonths[month][day + 1] || day == this.dayMonths[month].length - 1 && month < this.dayMonths.length - 1 && this.dayMonths[month + 1][0])) {
                            if (dash) continue;
                            dash = true;
                            if (first) continue;
                            b.append("-");
                            continue;
                        }
                        if (first) {
                            first = false;
                        } else if (!dash) {
                            b.append(", ");
                            monthAdded = -1;
                        }
                        yearAdded = this.appendYearString(b, dash ? this.lastYearMonths : this.firstYearMonths, month);
                        if (monthAdded != month || yearAdded) {
                            b.append(monthNames[month]).append(" ");
                            monthAdded = month;
                        }
                        dayAdded = day + 1;
                        b.append(dayAdded);
                        dash = false;
                    }
                }
                if (excludedDayStart != -1 && excludedDayEnd != -1) {
                    if (first) {
                        first = false;
                    } else if (!dash) {
                        b.append(", ");
                    }
                    this.appendYearString(b, this.firstYearMonths, excludedMonthStart);
                    b.append(monthNames[excludedMonthStart]).append(" ").append(excludedDayStart + 1).append("-");
                    this.appendYearString(b, this.lastYearMonths, excludedMonthEnd);
                    b.append(monthNames[excludedMonthEnd]).append(" ").append(excludedDayEnd + 1);
                } else if (yearAdded && !dash && monthAdded != -1 && this.lastYearMonths != null) {
                    b.append("-");
                    this.appendYearString(b, this.lastYearMonths, monthAdded);
                    b.append(monthNames[monthAdded]);
                    if (dayAdded != -1) {
                        b.append(" ").append(dayAdded);
                    }
                }
                if (!first) {
                    b.append(" ");
                }
            } else if (!allMonths) {
                this.addArray(this.months, monthNames, b);
            }
            this.appendDaysString(b, dayNames);
            if (this.startTimes == null || this.startTimes.size() == 0) {
                if (this.isOpened24_7()) {
                    b.setLength(0);
                    if (!this.isFallbackRule()) {
                        b.append("24/7 ");
                    }
                }
                if (this.off) {
                    b.append(offStr);
                }
            } else if (this.isOpened24_7()) {
                b.setLength(0);
                b.append("24/7");
            } else {
                for (int i = 0; i < this.startTimes.size(); ++i) {
                    int startTime = this.startTimes.get(i);
                    int endTime = this.endTimes.get(i);
                    if (i > 0) {
                        b.append(", ");
                    }
                    OpeningHoursParser.formatTimeRange(startTime, endTime, b);
                }
                if (this.off) {
                    b.append(" ").append(offStr);
                }
            }
            if (!Algorithms.isEmpty(this.comment)) {
                if (b.length() > 0) {
                    if (b.charAt(b.length() - 1) != ' ') {
                        b.append(" ");
                    }
                    b.append("- ").append(this.comment);
                } else {
                    b.append(this.comment);
                }
            }
            return b.toString();
        }

        private boolean appendYearString(StringBuilder b, int[] yearMonths, int month) {
            if (yearMonths != null && yearMonths[month] > 0) {
                b.append(yearMonths[month]).append(" ");
                return true;
            }
            if (this.year > 0) {
                b.append(this.year).append(" ");
                return true;
            }
            return false;
        }

        private void addArray(boolean[] array, String[] arrayNames, StringBuilder b) {
            boolean dash = false;
            boolean first = true;
            for (int i = 0; i < array.length; ++i) {
                if (!array[i]) continue;
                if (i > 0 && array[i - 1] && i < array.length - 1 && array[i + 1]) {
                    if (dash) continue;
                    dash = true;
                    b.append("-");
                    continue;
                }
                if (first) {
                    first = false;
                } else if (!dash) {
                    b.append(", ");
                }
                b.append(arrayNames == null ? Integer.valueOf(i + 1) : arrayNames[i]);
                dash = false;
            }
            if (!first) {
                b.append(" ");
            }
        }

        @Override
        public String toLocalRuleString() {
            return this.toRuleString(true);
        }

        @Override
        public boolean isOpened24_7() {
            boolean opened24_7 = this.isOpenedEveryDay();
            if (opened24_7) {
                if (this.startTimes != null && this.startTimes.size() > 0) {
                    for (int i = 0; i < this.startTimes.size(); ++i) {
                        int startTime = this.startTimes.get(i);
                        int endTime = this.endTimes.get(i);
                        if (startTime != 0 || endTime / 60 != 24) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        public boolean isOpenedEveryDay() {
            boolean openedEveryDay = true;
            for (int i = 0; i < 7; ++i) {
                if (this.days[i]) continue;
                openedEveryDay = false;
                break;
            }
            return openedEveryDay;
        }

        @Override
        public String getTime(Calendar cal, boolean checkAnotherDay, int limit, boolean opening) {
            Object res;
            StringBuilder sb = new StringBuilder();
            int d = this.getCurrentDay(cal);
            int ad = opening ? this.getNextDay(d) : this.getPreviousDay(d);
            int time = this.getCurrentTimeInMinutes(cal);
            for (int i = 0; i < this.startTimes.size(); ++i) {
                int diff;
                int startTime = this.startTimes.get(i);
                int endTime = this.endTimes.get(i);
                if (opening != this.off) {
                    if (startTime < endTime || endTime == -1) {
                        if (!this.days[d] || checkAnotherDay) continue;
                        diff = startTime - time;
                        if (limit != -1 && (time > startTime || diff > limit && limit != -2)) continue;
                        OpeningHoursParser.formatTime(startTime, sb);
                        break;
                    }
                    diff = -1;
                    if (time <= startTime && this.days[d] && !checkAnotherDay) {
                        diff = startTime - time;
                    } else if (time > endTime && this.days[ad] && checkAnotherDay) {
                        diff = 1440 - endTime + time;
                    }
                    if (limit != -1 && (diff == -1 || diff > limit) && limit != -2) continue;
                    OpeningHoursParser.formatTime(startTime, sb);
                    break;
                }
                if (startTime < endTime && endTime != -1) {
                    if (!this.days[d] || checkAnotherDay) continue;
                    diff = endTime - time;
                    if ((limit != -1 || diff < 0) && (time > endTime || diff > limit)) continue;
                    OpeningHoursParser.formatTime(endTime, sb);
                    break;
                }
                diff = -1;
                if (time <= endTime && this.days[d] && !checkAnotherDay) {
                    diff = 1440 - time + endTime;
                } else if (time < endTime && this.days[ad] && checkAnotherDay) {
                    diff = endTime - time;
                }
                if (limit != -1 && (diff == -1 || diff > limit)) continue;
                OpeningHoursParser.formatTime(endTime, sb);
                break;
            }
            if (((String)(res = sb.toString())).length() > 0 && !Algorithms.isEmpty(this.comment)) {
                res = (String)res + " - " + this.comment;
            }
            return res;
        }

        public String toString() {
            return this.toRuleString();
        }

        public void appendDaysString(StringBuilder builder) {
            this.appendDaysString(builder, daysStr);
        }

        public void appendDaysString(StringBuilder builder, String[] daysNames) {
            boolean dash = false;
            boolean first = true;
            for (int i = 0; i < 7; ++i) {
                if (!this.days[i]) continue;
                if (i > 0 && this.days[i - 1] && i < 6 && this.days[i + 1]) {
                    if (dash) continue;
                    dash = true;
                    builder.append("-");
                    continue;
                }
                if (first) {
                    first = false;
                } else if (!dash) {
                    builder.append(", ");
                }
                builder.append(daysNames[OpeningHoursParser.getDayIndex(i)]);
                dash = false;
            }
            if (this.publicHoliday) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("PH");
                first = false;
            }
            if (this.schoolHoliday) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("SH");
                first = false;
            }
            if (this.easter) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("Easter");
                first = false;
            }
            if (!first) {
                builder.append(" ");
            }
        }

        public void addTimeRange(int startTime, int endTime) {
            this.startTimes.add(startTime);
            this.endTimes.add(endTime);
        }

        public int timesSize() {
            return this.startTimes.size();
        }

        public void deleteTimeRange(int position) {
            this.startTimes.removeAt(position);
            this.endTimes.removeAt(position);
        }

        private static void setSingleValueForArrayList(TIntArrayList arrayList, int s) {
            if (arrayList.size() > 0) {
                arrayList.remove(0, arrayList.size());
            }
            arrayList.add(s);
        }

        @Override
        public boolean isOpenedForTime(Calendar cal) {
            int c = this.calculate(cal);
            return c > 0;
        }

        @Override
        public boolean contains(Calendar cal) {
            int c = this.calculate(cal);
            return c != 0;
        }

        @Override
        public boolean hasOverlapTimesOverDay() {
            for (int i = 0; i < this.startTimes.size(); ++i) {
                int endTime;
                int startTime = this.startTimes.get(i);
                if (startTime < (endTime = this.endTimes.get(i)) || endTime <= 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasOverlapTimes(Calendar cal, OpeningHoursRule r, boolean strictOverlap) {
            if (this.off) {
                return true;
            }
            if (r != null && r.contains(cal) && r instanceof BasicOpeningHourRule) {
                BasicOpeningHourRule rule = (BasicOpeningHourRule)r;
                if (this.startTimes.size() > 0 && rule.startTimes.size() > 0) {
                    for (int i = 0; i < this.startTimes.size(); ++i) {
                        int startTime = this.startTimes.get(i);
                        int endTime = this.endTimes.get(i);
                        if (endTime == -1) {
                            endTime = 1440;
                        } else if (startTime >= endTime) {
                            endTime = 1440 + endTime;
                        }
                        for (int k = 0; k < rule.startTimes.size(); ++k) {
                            int rStartTime = rule.startTimes.get(k);
                            int rEndTime = rule.endTimes.get(k);
                            if (rEndTime == -1) {
                                rEndTime = 1440;
                            } else if (rStartTime >= rEndTime) {
                                rEndTime = 1440 + rEndTime;
                            }
                            if (!(rStartTime >= startTime && (!strictOverlap ? rStartTime < endTime : rStartTime <= endTime)) && (startTime < rStartTime || !(strictOverlap ? startTime <= rEndTime : startTime < rEndTime))) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private int calculate(Calendar cal) {
            int year = cal.get(1);
            int month = cal.get(2);
            if (!this.containsMonth(cal)) {
                return 0;
            }
            int dmonth = cal.get(5) - 1;
            int i = cal.get(7);
            int day = (i + 5) % 7;
            int previous = (day + 6) % 7;
            boolean thisDay = true;
            if (this.hasYears()) {
                thisDay = this.isOpened(year, month, dmonth);
            } else if (thisDay && this.hasDayMonths()) {
                thisDay = this.dayMonths[month][dmonth];
            }
            if (thisDay && this.hasDays) {
                thisDay = this.days[day];
            }
            boolean previousDay = true;
            if (this.hasYears()) {
                if (dmonth > 0) {
                    previousDay = this.isOpened(year, month, dmonth - 1);
                }
            } else if (previousDay && this.hasDayMonths() && dmonth > 0) {
                previousDay = this.dayMonths[month][dmonth - 1];
            }
            if (previousDay && this.hasDays) {
                previousDay = this.days[previous];
            }
            if (!thisDay && !previousDay) {
                return 0;
            }
            int time = cal.get(11) * 60 + cal.get(12);
            for (i = 0; i < this.startTimes.size(); ++i) {
                int endTime;
                int startTime = this.startTimes.get(i);
                if (startTime < (endTime = this.endTimes.get(i)) || endTime == -1) {
                    if (time < startTime || endTime != -1 && time > endTime || !thisDay) continue;
                    return this.off ? -1 : 1;
                }
                if (time >= startTime && thisDay) {
                    return this.off ? -1 : 1;
                }
                if (time >= endTime || !previousDay) continue;
                return this.off ? -1 : 1;
            }
            if (thisDay && (this.startTimes == null || this.startTimes.isEmpty()) && !this.off) {
                return 1;
            }
            if (thisDay && (this.startTimes == null || this.startTimes.isEmpty() || !this.off)) {
                return -1;
            }
            return 0;
        }

        private boolean isOpened(int year, int month, int dmonth) {
            boolean opened;
            boolean bl = opened = this.hasDayMonths() && this.dayMonths[month][dmonth];
            if (this.hasYears()) {
                if (year < this.year) {
                    opened = false;
                } else if (year == this.year) {
                    if (this.firstYearDayMonth != null) {
                        opened = this.firstYearDayMonth[month][dmonth];
                    }
                } else {
                    int lastYear = this.lastYearMonths[month];
                    opened = year < lastYear ? true : (year == lastYear ? this.lastYearDayMonth[month][dmonth] : false);
                }
            }
            return opened;
        }

        private boolean hasYears() {
            return this.firstYearMonths != null;
        }
    }

    private static class Token {
        int mainNumber = -1;
        TokenType type;
        String text;
        Token parent;

        public Token(TokenType tokenType, String string) {
            this.type = tokenType;
            this.text = string;
            try {
                this.mainNumber = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public Token(TokenType tokenType, int tokenMainNumber) {
            this.type = tokenType;
            this.mainNumber = tokenMainNumber;
            this.text = Integer.toString(this.mainNumber);
        }

        public String toString() {
            if (this.parent != null) {
                return this.parent.text + " [" + String.valueOf((Object)this.parent.type) + "] (" + this.text + " [" + String.valueOf((Object)this.type) + "]) ";
            }
            return this.text + " [" + String.valueOf((Object)this.type) + "] ";
        }
    }

    private static enum TokenType {
        TOKEN_UNKNOWN(0),
        TOKEN_COLON(1),
        TOKEN_COMMA(2),
        TOKEN_DASH(3),
        TOKEN_YEAR(4),
        TOKEN_MONTH(5),
        TOKEN_DAY_MONTH(6),
        TOKEN_HOLIDAY(7),
        TOKEN_DAY_WEEK(7),
        TOKEN_HOUR_MINUTES(8),
        TOKEN_OFF_ON(9),
        TOKEN_COMMENT(10);

        public final int ord;

        private TokenType(int ord) {
            this.ord = ord;
        }

        public int ord() {
            return this.ord;
        }
    }

    public static class OpeningHours
    implements Serializable {
        public static final int ALL_SEQUENCES = -1;
        private ArrayList<OpeningHoursRule> rules;
        private String original;
        private int sequenceCount;

        public OpeningHours(ArrayList<OpeningHoursRule> rules) {
            this.rules = rules;
        }

        public OpeningHours() {
            this.rules = new ArrayList();
        }

        public List<Info> getInfo() {
            return this.getInfo(Calendar.getInstance());
        }

        public List<Info> getInfo(Calendar cal) {
            ArrayList<Info> res = new ArrayList<Info>();
            for (int i = 0; i < this.sequenceCount; ++i) {
                Info info = this.getInfo(cal, i);
                res.add(info);
            }
            return res.isEmpty() ? null : res;
        }

        public Info getCombinedInfo() {
            return this.getCombinedInfo(Calendar.getInstance());
        }

        public Info getCombinedInfo(Calendar cal) {
            return this.getInfo(cal, -1);
        }

        private Info getInfo(Calendar cal, int sequenceIndex) {
            Info info = new Info();
            boolean opened = this.isOpenedForTimeV2(cal, sequenceIndex);
            info.fallback = this.isFallBackRule(sequenceIndex);
            info.opened = opened;
            info.ruleString = this.getCurrentRuleTime(cal, sequenceIndex);
            if (opened) {
                info.opened24_7 = this.isOpened24_7(sequenceIndex);
                info.closingTime = this.getClosingTime(cal, sequenceIndex);
                info.nearToClosingTime = this.getNearToClosingTime(cal, sequenceIndex);
            } else {
                info.openingTime = this.getOpeningTime(cal, sequenceIndex);
                info.nearToOpeningTime = this.getNearToOpeningTime(cal, sequenceIndex);
                info.openingTomorrow = this.getOpeningTomorrow(cal, sequenceIndex);
                info.openingDay = this.getOpeningDay(cal, sequenceIndex);
            }
            return info;
        }

        public void addRule(OpeningHoursRule r) {
            this.rules.add(r);
        }

        public void addRules(List<? extends OpeningHoursRule> rules) {
            this.rules.addAll(rules);
        }

        public int getSequenceCount() {
            return this.sequenceCount;
        }

        public void setSequenceCount(int sequenceCount) {
            this.sequenceCount = sequenceCount;
        }

        public ArrayList<OpeningHoursRule> getRules() {
            return this.rules;
        }

        public ArrayList<OpeningHoursRule> getRules(int sequenceIndex) {
            if (sequenceIndex == -1) {
                return this.rules;
            }
            ArrayList<OpeningHoursRule> sequenceRules = new ArrayList<OpeningHoursRule>();
            for (OpeningHoursRule r : this.rules) {
                if (r.getSequenceIndex() != sequenceIndex) continue;
                sequenceRules.add(r);
            }
            return sequenceRules;
        }

        public boolean isOpenedForTimeV2(Calendar cal, int sequenceIndex) {
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            boolean overlap = this.hasRulesOverlapDayBackwardCompatible(rules);
            for (int i = rules.size() - 1; i >= 0; --i) {
                OpeningHoursRule rule = rules.get(i);
                if (!rule.contains(cal)) continue;
                boolean checkNextNotNeeded = overlap || !this.isCheckNextNeeded(cal, rules, i, rule);
                boolean open = rule.isOpenedForTime(cal);
                if (!open && checkNextNotNeeded) continue;
                return open;
            }
            return false;
        }

        public boolean isOpenedForTime(Calendar cal) {
            return this.isOpenedForTimeV2(cal, -1);
        }

        public boolean isOpenedForTime(Calendar cal, int sequenceIndex) {
            boolean isOpenDay = false;
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            for (OpeningHoursRule r : rules) {
                if (!r.containsDay(cal) || !r.containsMonth(cal)) continue;
                isOpenDay = r.isOpenedForTime(cal, false);
            }
            boolean isOpenPrevious = false;
            for (OpeningHoursRule r : rules) {
                if (!r.containsPreviousDay(cal) || !r.containsMonth(cal)) continue;
                isOpenPrevious = r.isOpenedForTime(cal, true);
            }
            return isOpenDay || isOpenPrevious;
        }

        public boolean isOpened24_7(int sequenceIndex) {
            boolean opened24_7 = false;
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            for (OpeningHoursRule r : rules) {
                opened24_7 = r.isOpened24_7();
            }
            return opened24_7;
        }

        public String getNearToOpeningTime(Calendar cal, int sequenceIndex) {
            return this.getTime(cal, 120, true, sequenceIndex);
        }

        public String getOpeningTime(Calendar cal, int sequenceIndex) {
            return this.getTime(cal, -2, true, sequenceIndex);
        }

        public String getNearToClosingTime(Calendar cal, int sequenceIndex) {
            return this.getTime(cal, 120, false, sequenceIndex);
        }

        public String getClosingTime(Calendar cal, int sequenceIndex) {
            return this.getTime(cal, -1, false, sequenceIndex);
        }

        public String getOpeningTomorrow(Calendar calendar, int sequenceIndex) {
            Calendar cal = (Calendar)calendar.clone();
            String openingTime = "";
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            cal.add(5, 1);
            Calendar openingTimeCal = null;
            OpeningHoursRule openingRule = null;
            for (OpeningHoursRule r : rules) {
                if (!r.contains(cal)) continue;
                String time = r.getTime(cal, false, -1, true);
                if (Algorithms.isEmpty(time) || openingTimeCal == null || cal.before(openingTimeCal) || r.hasOverlapTimes(cal, openingRule, false)) {
                    openingTime = time;
                    openingRule = r;
                }
                openingTimeCal = (Calendar)cal.clone();
            }
            return openingTime;
        }

        public String getOpeningDay(Calendar calendar, int sequenceIndex) {
            Calendar cal = (Calendar)calendar.clone();
            Object openingTime = "";
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            for (int i = 0; i < 7; ++i) {
                cal.add(5, 1);
                OpeningHoursRule openingRule = null;
                Calendar openingTimeCal = null;
                for (OpeningHoursRule r : rules) {
                    if (!r.contains(cal)) continue;
                    String time = r.getTime(cal, false, -1, true);
                    if (Algorithms.isEmpty(time) || openingTimeCal == null || cal.before(openingTimeCal) || r.hasOverlapTimes(cal, openingRule, false)) {
                        openingTime = time;
                        openingRule = r;
                    }
                    openingTimeCal = (Calendar)cal.clone();
                }
                if (Algorithms.isEmpty((CharSequence)openingTime)) continue;
                openingTime = (String)openingTime + " " + localDaysStr[cal.get(7)];
                break;
            }
            return openingTime;
        }

        private String getTime(Calendar cal, int limit, boolean opening, int sequenceIndex) {
            String time = this.getTimeDay(cal, limit, opening, sequenceIndex);
            if (Algorithms.isEmpty(time)) {
                time = this.getTimeAnotherDay(cal, limit, opening, sequenceIndex);
            }
            return time;
        }

        private String getTimeDay(Calendar cal, int limit, boolean opening, int sequenceIndex) {
            String atTime = "";
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            OpeningHoursRule prevRule = null;
            for (OpeningHoursRule r : rules) {
                if (r.containsDay(cal) && r.containsMonth(cal)) {
                    if (atTime.length() > 0 && prevRule != null && !r.hasOverlapTimes(cal, prevRule, true)) {
                        return atTime;
                    }
                    atTime = r.getTime(cal, false, limit, opening);
                }
                prevRule = r;
            }
            return atTime;
        }

        private String getTimeAnotherDay(Calendar cal, int limit, boolean opening, int sequenceIndex) {
            String atTime = "";
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            for (OpeningHoursRule r : rules) {
                if ((!opening || !r.containsPreviousDay(cal)) && (opening || !r.containsNextDay(cal)) || !r.containsMonth(cal)) continue;
                atTime = r.getTime(cal, true, limit, opening);
            }
            return atTime;
        }

        public String getCurrentRuleTime(Calendar cal) {
            return this.getCurrentRuleTime(cal, -1);
        }

        public boolean isFallBackRule(int sequenceIndex) {
            if (sequenceIndex != -1) {
                ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
                return !rules.isEmpty() && rules.get(0).isFallbackRule();
            }
            return false;
        }

        public String getCurrentRuleTime(Calendar cal, int sequenceIndex) {
            ArrayList<OpeningHoursRule> rules = this.getRules(sequenceIndex);
            String ruleClosed = null;
            boolean overlap = this.hasRulesOverlapDayBackwardCompatible(rules);
            for (int i = rules.size() - 1; i >= 0; --i) {
                OpeningHoursRule rule = rules.get(i);
                if (!rule.contains(cal)) continue;
                boolean checkNextNotNeeded = overlap || !this.isCheckNextNeeded(cal, rules, i, rule);
                boolean open = rule.isOpenedForTime(cal);
                if (open || !checkNextNotNeeded) {
                    return rule.toLocalRuleString();
                }
                ruleClosed = rule.toLocalRuleString();
            }
            return ruleClosed;
        }

        private boolean isCheckNextNeeded(Calendar cal, ArrayList<OpeningHoursRule> rules, int i, OpeningHoursRule rule) {
            boolean checkNext = true;
            if (i > 0) {
                for (int j = i; j > 0 && !(checkNext = rule.hasOverlapTimes(cal, rules.get(j - 1), false)); --j) {
                }
            }
            return checkNext;
        }

        private boolean hasRulesOverlapDayBackwardCompatible(ArrayList<OpeningHoursRule> rules) {
            boolean overlap = false;
            for (int i = rules.size() - 1; i >= 0; --i) {
                OpeningHoursRule r = rules.get(i);
                if (!r.hasOverlapTimesOverDay()) continue;
                overlap = true;
                break;
            }
            return overlap;
        }

        public String getCurrentRuleTimeV1(Calendar cal) {
            String ruleOpen = null;
            String ruleClosed = null;
            for (OpeningHoursRule r : this.rules) {
                if (!r.containsPreviousDay(cal) || !r.containsMonth(cal)) continue;
                if (r.isOpenedForTime(cal, true)) {
                    ruleOpen = r.toLocalRuleString();
                    continue;
                }
                ruleClosed = r.toLocalRuleString();
            }
            for (OpeningHoursRule r : this.rules) {
                if (!r.containsDay(cal) || !r.containsMonth(cal)) continue;
                if (r.isOpenedForTime(cal, false)) {
                    ruleOpen = r.toLocalRuleString();
                    continue;
                }
                ruleClosed = r.toLocalRuleString();
            }
            if (ruleOpen != null) {
                return ruleOpen;
            }
            return ruleClosed;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.rules.isEmpty()) {
                return "";
            }
            for (OpeningHoursRule r : this.rules) {
                s.append(r.toString()).append("; ");
            }
            return s.substring(0, s.length() - 2);
        }

        public String toLocalString() {
            StringBuilder s = new StringBuilder();
            if (this.rules.isEmpty()) {
                return "";
            }
            for (OpeningHoursRule r : this.rules) {
                s.append(r.toLocalRuleString()).append("; ");
            }
            return s.substring(0, s.length() - 2);
        }

        public void setOriginal(String original) {
            this.original = original;
        }

        public String getOriginal() {
            return this.original;
        }

        public static class Info {
            private boolean opened;
            private boolean opened24_7;
            private boolean fallback;
            private String openingTime;
            private String nearToOpeningTime;
            private String closingTime;
            private String nearToClosingTime;
            private String openingTomorrow;
            private String openingDay;
            private String ruleString;

            public boolean isOpened() {
                return this.opened;
            }

            public boolean isOpened24_7() {
                return this.opened24_7;
            }

            public boolean isFallback() {
                return this.fallback;
            }

            public String getInfo() {
                if (this.isOpened24_7()) {
                    if (!this.isFallback()) {
                        if (!Algorithms.isEmpty(this.ruleString)) {
                            return additionalStrings.get("is_open") + " " + this.ruleString;
                        }
                        return additionalStrings.get("is_open_24_7");
                    }
                    return !Algorithms.isEmpty(this.ruleString) ? this.ruleString : "";
                }
                if (!Algorithms.isEmpty(this.nearToOpeningTime)) {
                    return additionalStrings.get("will_open_at") + " " + this.nearToOpeningTime;
                }
                if (!Algorithms.isEmpty(this.openingTime)) {
                    return additionalStrings.get("open_from") + " " + this.openingTime;
                }
                if (!Algorithms.isEmpty(this.nearToClosingTime)) {
                    return additionalStrings.get("will_close_at") + " " + this.nearToClosingTime;
                }
                if (!Algorithms.isEmpty(this.closingTime)) {
                    return additionalStrings.get("open_till") + " " + this.closingTime;
                }
                if (!Algorithms.isEmpty(this.openingTomorrow)) {
                    return additionalStrings.get("will_open_tomorrow_at") + " " + this.openingTomorrow;
                }
                if (!Algorithms.isEmpty(this.openingDay)) {
                    return additionalStrings.get("will_open_on") + " " + this.openingDay + ".";
                }
                return !Algorithms.isEmpty(this.ruleString) ? this.ruleString : "";
            }
        }
    }

    public static interface OpeningHoursRule
    extends Serializable {
        public boolean isOpenedForTime(Calendar var1, boolean var2);

        public boolean isOpenedForTime(Calendar var1);

        public boolean containsPreviousDay(Calendar var1);

        public boolean containsDay(Calendar var1);

        public boolean containsNextDay(Calendar var1);

        public boolean containsMonth(Calendar var1);

        public boolean hasOverlapTimesOverDay();

        public boolean hasOverlapTimes(Calendar var1, OpeningHoursRule var2, boolean var3);

        public boolean contains(Calendar var1);

        public int getSequenceIndex();

        public boolean isFallbackRule();

        public String toRuleString();

        public String toLocalRuleString();

        public boolean isOpened24_7();

        public String getTime(Calendar var1, boolean var2, int var3, boolean var4);
    }

    public static class UnparseableRule
    implements OpeningHoursRule {
        private String ruleString;

        public UnparseableRule(String ruleString) {
            this.ruleString = ruleString;
        }

        @Override
        public boolean isOpenedForTime(Calendar cal, boolean checkPrevious) {
            return false;
        }

        @Override
        public boolean containsPreviousDay(Calendar cal) {
            return false;
        }

        @Override
        public boolean hasOverlapTimesOverDay() {
            return false;
        }

        @Override
        public boolean hasOverlapTimes(Calendar cal, OpeningHoursRule r, boolean strictOverlap) {
            return false;
        }

        @Override
        public boolean containsDay(Calendar cal) {
            return false;
        }

        @Override
        public boolean containsNextDay(Calendar cal) {
            return false;
        }

        @Override
        public boolean containsMonth(Calendar cal) {
            return false;
        }

        @Override
        public String toRuleString() {
            return this.ruleString;
        }

        @Override
        public String toLocalRuleString() {
            return this.toRuleString();
        }

        @Override
        public boolean isOpened24_7() {
            return false;
        }

        @Override
        public String getTime(Calendar cal, boolean checkAnotherDay, int limit, boolean opening) {
            return "";
        }

        public String toString() {
            return this.toRuleString();
        }

        @Override
        public boolean isOpenedForTime(Calendar cal) {
            return false;
        }

        @Override
        public boolean contains(Calendar cal) {
            return false;
        }

        @Override
        public int getSequenceIndex() {
            return 0;
        }

        @Override
        public boolean isFallbackRule() {
            return false;
        }
    }
}

