/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;

public abstract class AbstractPoiType {
    protected final String keyName;
    protected final MapPoiTypes registry;
    private List<PoiType> poiAdditionals = null;
    private List<PoiType> poiAdditionalsCategorized = null;
    private boolean topVisible;
    private String lang;
    private AbstractPoiType baseLangType;
    private boolean notEditableOsm;
    private String poiAdditionalCategory;
    private List<String> excludedPoiAdditionalCategories;
    private String synonyms;
    private String enTranslation;
    private String translation;
    private final String iconName;

    public AbstractPoiType(String keyName, MapPoiTypes registry) {
        this(keyName, registry, null);
    }

    public AbstractPoiType(String keyName, MapPoiTypes registry, String iconName) {
        this.keyName = keyName;
        this.registry = registry;
        this.iconName = iconName;
    }

    public void setBaseLangType(AbstractPoiType baseLangType) {
        this.baseLangType = baseLangType;
    }

    public AbstractPoiType getBaseLangType() {
        return this.baseLangType;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return this.lang;
    }

    public String getKeyName() {
        return this.keyName;
    }

    protected String getIconNameInternal() {
        return this.iconName;
    }

    public String getIconKeyName() {
        return this.formatKeyName(this.iconName != null ? this.iconName : this.getKeyName());
    }

    public String getFormattedKeyName() {
        return this.formatKeyName(this.getKeyName());
    }

    protected String formatKeyName(String kn) {
        if (kn.startsWith("osmand_")) {
            kn = kn.substring("osmand_".length());
        }
        return kn.replace(':', '_');
    }

    public void setTopVisible(boolean topVisible) {
        this.topVisible = topVisible;
    }

    public boolean isTopVisible() {
        return this.topVisible;
    }

    public boolean isAdditional() {
        return this instanceof PoiType && this.isAdditional();
    }

    public String getTranslation() {
        if (this.translation == null) {
            this.translation = this.registry.getTranslation(this);
        }
        return this.translation;
    }

    public String getSynonyms() {
        if (this.synonyms == null) {
            this.synonyms = this.registry.getSynonyms(this);
        }
        return this.synonyms;
    }

    public String getEnTranslation() {
        if (this.enTranslation == null) {
            this.enTranslation = this.registry.getEnTranslation(this);
        }
        return this.enTranslation;
    }

    public String getPoiAdditionalCategoryTranslation() {
        if (this.poiAdditionalCategory != null) {
            return this.registry.getPoiTranslation(this.poiAdditionalCategory);
        }
        return null;
    }

    public boolean hasValidTranslation() {
        return this.registry.hasValidTranslation(this);
    }

    public void addPoiAdditional(PoiType tp) {
        if (this.poiAdditionals == null) {
            this.poiAdditionals = new ArrayList<PoiType>();
        }
        this.poiAdditionals.add(tp);
        if (tp.getPoiAdditionalCategory() != null) {
            if (this.poiAdditionalsCategorized == null) {
                this.poiAdditionalsCategorized = new ArrayList<PoiType>();
            }
            this.poiAdditionalsCategorized.add(tp);
        }
    }

    public void addPoiAdditionalsCategorized(List<PoiType> tps) {
        if (this.poiAdditionals == null) {
            this.poiAdditionals = new ArrayList<PoiType>();
        }
        this.poiAdditionals.addAll(tps);
        if (this.poiAdditionalsCategorized == null) {
            this.poiAdditionalsCategorized = new ArrayList<PoiType>();
        }
        this.poiAdditionalsCategorized.addAll(tps);
    }

    public List<PoiType> getPoiAdditionals() {
        if (this.poiAdditionals == null) {
            return Collections.emptyList();
        }
        return this.poiAdditionals;
    }

    public List<PoiType> getPoiAdditionalsCategorized() {
        if (this.poiAdditionalsCategorized == null) {
            return Collections.emptyList();
        }
        return this.poiAdditionalsCategorized;
    }

    public boolean isNotEditableOsm() {
        return this.notEditableOsm;
    }

    public void setNotEditableOsm(boolean notEditableOsm) {
        this.notEditableOsm = notEditableOsm;
    }

    public String getPoiAdditionalCategory() {
        return this.poiAdditionalCategory;
    }

    public void setPoiAdditionalCategory(String poiAdditionalCategory) {
        this.poiAdditionalCategory = poiAdditionalCategory;
    }

    public List<String> getExcludedPoiAdditionalCategories() {
        return this.excludedPoiAdditionalCategories;
    }

    public void addExcludedPoiAdditionalCategories(String[] excludedPoiAdditionalCategories) {
        if (this.excludedPoiAdditionalCategories == null) {
            this.excludedPoiAdditionalCategories = new ArrayList<String>();
        }
        Collections.addAll(this.excludedPoiAdditionalCategories, excludedPoiAdditionalCategories);
    }

    public abstract Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> var1);

    public String getParentTypeName() {
        return "";
    }

    public String toString() {
        return this.keyName;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AbstractPoiType)) {
            return false;
        }
        AbstractPoiType that = (AbstractPoiType)other;
        return this.keyName != null && this.keyName.equals(that.keyName);
    }
}

