/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.routes;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.MainUtilities;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.OsmGpxWriteContext;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexRouteRelationCreator;
import net.osmand.obf.preparation.OsmDbAccessor;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.OsmDbCreator;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.RelationTagsPropagation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmBaseStoragePbf;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.shared.KException;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.io.KFile;
import okio.Okio;
import okio.Sink;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xmlpull.v1.XmlPullParserException;

public class RouteRelationExtractor {
    private static final Log log = LogFactory.getLog(RouteRelationExtractor.class);
    int countFiles;
    int countWays;
    int countNodes;
    DBDialect osmDBdialect = DBDialect.SQLITE;
    public static final String[] customStyles = new String[]{"default.render.xml", "routes.addon.render.xml"};
    public static final Map<String, String> customProperties = Map.of("whiteWaterSports", "true", "showCycleRoutes", "true", "showMtbRoutes", "true", "hikingRoutesOSMC", "walkingRoutesOSMC", "showDirtbikeTrails", "true", "horseRoutes", "true", "showFitnessTrails", "true", "showRunningRoutes", "true");
    private final int ICON_SEARCH_ZOOM = 19;
    private final RenderingRulesStorage renderingRules;
    private final MapRenderingTypesEncoder renderingTypes;
    private final RenderingRuleSearchRequest searchRequest;
    private final boolean keepTmpFiles;
    private final String inFilePath;
    private final String outFilePath;
    private final String tmpDirectoryPath;
    private final String generationWorkingDirectory;
    private final String gpxDirectoryPath;
    private final String dbFilePath;
    private final String travelOsmFilePath;
    private final String relationsOsmFilePath;
    final String[] nodeNameTags = new String[]{"name", "name:en"};
    final Map<String, String> skipNodeByTags = Map.of("information", "guidepost");

    public RouteRelationExtractor(String[] args) {
        MainUtilities.CommandLineOpts opts = new MainUtilities.CommandLineOpts(args);
        this.inFilePath = opts.getOpt("--in");
        this.outFilePath = opts.getOpt("--out");
        this.keepTmpFiles = opts.getBoolean("--keep-tmp-files");
        this.tmpDirectoryPath = Objects.requireNonNullElse(opts.getOpt("--tmp"), "/tmp");
        if (opts.getBoolean("--help") || this.inFilePath == null || this.outFilePath == null) {
            System.err.printf("%s\n", String.join((CharSequence)"\n", "", "Usage: route-relation-extractor [--options]", "", "--in=/path/to/input_osm_file.(gz|bz2|pbf)", "--out=/path/to/output_obf_file.obf", "--tmp=/path/to/tmp (/tmp)", "--keep-tmp-files", "--help", ""));
            System.exit(0);
        }
        String basename = Paths.get(this.inFilePath, new String[0]).getFileName().toString().replace('.', '-');
        this.dbFilePath = this.tmpDirectoryPath + "/" + basename + ".db";
        this.travelOsmFilePath = this.tmpDirectoryPath + "/" + basename + ".travel.osm";
        this.relationsOsmFilePath = this.tmpDirectoryPath + "/" + basename + ".relations.osm";
        this.generationWorkingDirectory = this.tmpDirectoryPath + "/" + basename + "-obf";
        this.gpxDirectoryPath = this.tmpDirectoryPath + "/" + basename + "-gpx";
        this.renderingTypes = new MapRenderingTypesEncoder("basemap");
        this.renderingRules = RenderingRulesStorage.initWithStylesFromResources((String[])customStyles);
        this.searchRequest = RenderingRuleSearchRequest.initWithCustomProperties((RenderingRulesStorage)this.renderingRules, (int)19, customProperties);
    }

    private void cleanupTmpFiles() throws IOException {
        if (!this.keepTmpFiles) {
            class Remover
            extends SimpleFileVisitor<Path> {
                Remover() {
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String name = file.getFileName().toString();
                    if (name.endsWith(".gpx.gz") || name.endsWith(".obf")) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            }
            if (Files.exists(Paths.get(this.generationWorkingDirectory, new String[0]), new LinkOption[0])) {
                Files.walkFileTree(Paths.get(this.generationWorkingDirectory, new String[0]), new Remover());
                Files.deleteIfExists(Paths.get(this.generationWorkingDirectory, new String[0]));
            }
            if (Files.exists(Paths.get(this.gpxDirectoryPath, new String[0]), new LinkOption[0])) {
                Files.walkFileTree(Paths.get(this.gpxDirectoryPath, new String[0]), new Remover());
                Files.deleteIfExists(Paths.get(this.gpxDirectoryPath, new String[0]));
            }
            Files.deleteIfExists(Paths.get(this.dbFilePath, new String[0]));
            Files.deleteIfExists(Paths.get(this.travelOsmFilePath, new String[0]));
            Files.deleteIfExists(Paths.get(this.relationsOsmFilePath, new String[0]));
            try {
                Files.deleteIfExists(Paths.get(this.tmpDirectoryPath, new String[0]));
            }
            catch (IOException e) {
                log.info((Object)("Unable to remove " + this.tmpDirectoryPath));
            }
        }
    }

    private void initTmpFiles() throws IOException {
        this.cleanupTmpFiles();
        Files.createDirectories(Paths.get(this.gpxDirectoryPath, new String[0]), new FileAttribute[0]);
        Files.createDirectories(Paths.get(this.generationWorkingDirectory, new String[0]), new FileAttribute[0]);
    }

    public static void main(String[] args) {
        RouteRelationExtractor rre = new RouteRelationExtractor(args);
        try {
            rre.initTmpFiles();
            rre.extractRoutes();
            rre.gpxDirectoryToObfFile();
        }
        catch (IOException | InterruptedException | SQLException | XMLStreamException | XmlPullParserException e) {
            log.error((Object)"Extract routes error: ", e);
        }
        finally {
            try {
                rre.cleanupTmpFiles();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private File getGpxDirectory() {
        return new File(this.gpxDirectoryPath);
    }

    private void gpxDirectoryToObfFile() throws IOException, SQLException, XmlPullParserException, InterruptedException {
        ArrayList<KFile> kFiles;
        File gpxDirectory = this.getGpxDirectory();
        File obfFile = new File(this.outFilePath);
        if (gpxDirectory.isDirectory()) {
            kFiles = new ArrayList<KFile>();
            for (File file : gpxDirectory.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".gpx.gz")) continue;
                kFiles.add(new KFile(file.getAbsolutePath()));
            }
            if (kFiles.isEmpty()) {
                throw new RuntimeException("No GPX-gz files in directory: " + gpxDirectory.getAbsolutePath());
            }
        } else {
            throw new RuntimeException("Wrong GPX directory: " + gpxDirectory.getAbsolutePath());
        }
        OsmGpxWriteContext.QueryParams qp = new OsmGpxWriteContext.QueryParams();
        qp.osmFile = new File(this.travelOsmFilePath);
        OsmGpxWriteContext ctx = new OsmGpxWriteContext(qp);
        File tmpFolder = new File(this.generationWorkingDirectory);
        String obfFileBaseName = Paths.get(this.outFilePath, new String[0]).getFileName().toString();
        ctx.writeObf(null, kFiles, tmpFolder, obfFileBaseName, obfFile);
    }

    private void extractRoutes() throws IOException, XmlPullParserException, XMLStreamException, SQLException, InterruptedException {
        long deltaTime;
        long endTime;
        Connection dbConn;
        OsmBaseStoragePbf startStorage;
        File sourceFile = new File(this.inFilePath);
        final File resultFile = new File(this.relationsOsmFilePath);
        File dbFile = new File(this.dbFilePath);
        long startTime = System.currentTimeMillis();
        Object sourceIs = sourceFile.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(sourceFile)) : (sourceFile.getName().endsWith(".bz2") ? new BZip2CompressorInputStream((InputStream)new FileInputStream(sourceFile)) : new FileInputStream(sourceFile));
        boolean pbfFile = sourceFile.getName().endsWith(".pbf");
        OsmBaseStorage endStorage = new OsmBaseStorage();
        OsmBaseStoragePbf osmBaseStoragePbf = startStorage = pbfFile ? new OsmBaseStoragePbf() : new OsmBaseStorage();
        if (!dbFile.exists()) {
            dbConn = this.osmDBdialect.getDatabaseConnection(dbFile.getAbsolutePath(), log);
            BufferedInputStream startStream = new BufferedInputStream((InputStream)sourceIs, 32768);
            OsmDbCreator dbCreator = new OsmDbCreator(false);
            dbCreator.initDatabase(this.osmDBdialect, dbConn, true, null);
            startStorage.getFilters().add(dbCreator);
            if (pbfFile) {
                startStorage.parseOSMPbf(startStream, IProgress.EMPTY_PROGRESS, true);
            } else {
                startStorage.parseOSM(startStream, IProgress.EMPTY_PROGRESS);
            }
            dbCreator.finishLoading();
            this.osmDBdialect.commitDatabase(dbConn);
            endTime = System.currentTimeMillis();
            deltaTime = (endTime - startTime) / 1000L;
            startTime = endTime;
            System.out.println("Parse " + sourceFile.getName() + ": " + deltaTime + " sec.");
            ((InputStream)startStream).close();
        } else {
            dbConn = this.osmDBdialect.getDatabaseConnection(dbFile.getAbsolutePath(), log);
        }
        final AccessorForRelationExtract accessor = new AccessorForRelationExtract();
        accessor.setDbConn(dbConn, this.osmDBdialect);
        accessor.initDatabase();
        final ArrayList resultRelations = new ArrayList();
        accessor.iterateOverEntities(new ConsoleProgressImplementation(1.0), Entity.EntityType.RELATION, new OsmDbAccessor.OsmDbVisitor(){

            @Override
            public void iterateEntity(Entity e, OsmDbAccessorContext ctx) throws SQLException {
                String route = e.getTag("route");
                if (route != null && this.accessedRoute(route)) {
                    ctx.loadEntityRelation((Relation)e);
                    resultRelations.add((Relation)e);
                    RouteRelationExtractor.this.saveGpx(e, accessor.getAdditionalEntities(), resultFile);
                    accessor.additionalEntities.clear();
                }
            }

            private boolean accessedRoute(@Nonnull String route) {
                return IndexRouteRelationCreator.isSupportedRouteType(route);
            }
        });
        for (Entity e : resultRelations) {
            endStorage.registerEntity(e, null);
        }
        for (Entity e : accessor.getAdditionalEntities().values()) {
            if (e == null) continue;
            endStorage.registerEntity(e, null);
        }
        endTime = System.currentTimeMillis();
        deltaTime = (endTime - startTime) / 1000L;
        startTime = endTime;
        log.info((Object)("Process all entities: " + deltaTime + " sec."));
        log.info((Object)String.format("Process %d files %d ways %d nodes\n ", this.countFiles, this.countWays, this.countNodes));
        resultFile.delete();
        OutputStream outputStream = new FileOutputStream(resultFile);
        if (resultFile.getName().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        } else if (resultFile.getName().endsWith(".bz2")) {
            outputStream = new BZip2CompressorOutputStream(outputStream);
        }
        new OsmStorageWriter().saveStorage(outputStream, endStorage, null, true);
        outputStream.close();
        endTime = System.currentTimeMillis();
        deltaTime = (endTime - startTime) / 1000L;
        System.out.println("Wrote result into " + resultFile.getName() + " in " + deltaTime + " sec.");
    }

    private void saveGpx(Entity relation, Map<Entity.EntityId, Entity> children, File resultFile) {
        GpxFile gpxFile = new GpxFile("OsmAndRouterV2");
        String mainName = relation.getTag("name");
        String enName = relation.getTag("name:en");
        if (mainName != null) {
            gpxFile.getMetadata().setName(mainName);
        } else if (enName != null) {
            gpxFile.getMetadata().setName(enName);
        }
        gpxFile.getMetadata().setDesc(relation.getTag("description"));
        Map gpxExtensions = gpxFile.getExtensionsToWrite();
        gpxExtensions.putAll(relation.getTags());
        gpxExtensions.put("width", "roadstyle");
        gpxExtensions.put("translucent_line_colors", "yes");
        gpxExtensions.put("route_id", "O" + relation.getId());
        File gpxDir = this.getGpxDirectory();
        try {
            if (!gpxDir.exists()) {
                Files.createDirectory(gpxDir.toPath(), new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Track track = new Track();
        track.setName(gpxFile.getMetadata().getName());
        gpxFile.getTracks().add(track);
        RelationTagsPropagation transformer = new RelationTagsPropagation();
        try {
            transformer.handleRelationPropogatedTags((Relation)relation, this.renderingTypes, null, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<Way> waysToJoin = new ArrayList<Way>();
        for (Map.Entry<Entity.EntityId, Entity> entry : children.entrySet()) {
            if (entry.getKey().getType() == Entity.EntityType.WAY) {
                Way way = (Way)entry.getValue();
                if ("yes".equals(way.getTag(OSMSettings.OSMTagKey.AREA))) continue;
                waysToJoin.add(way);
                transformer.addPropogatedTags(this.renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType.MAP, (Entity)way, way.getModifiableTags());
                gpxExtensions.putAll(IndexRouteRelationCreator.getShieldTagsFromOsmcTags(way.getTags(), relation.getId()));
                continue;
            }
            if (entry.getKey().getType() != Entity.EntityType.NODE) continue;
            this.addNode(gpxFile, (Node)entry.getValue());
        }
        this.joinWaysIntoTrackSegments(track, waysToJoin, relation.getId());
        File outFile = new File(gpxDir, relation.getId() + ".gpx.gz");
        try {
            OutputStream outputStream = new FileOutputStream(outFile);
            outputStream = new GZIPOutputStream(outputStream);
            KException ex = GpxUtilities.INSTANCE.writeGpx(null, (Sink)Okio.buffer((Sink)Okio.sink((OutputStream)outputStream)), gpxFile, null);
            if (ex != null) {
                throw new RuntimeException((Throwable)ex);
            }
            outputStream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        ++this.countFiles;
        if (this.countFiles % 100 == 0) {
            log.info((Object)(this.countFiles + " File " + outFile.getName() + " saved "));
        }
    }

    private void joinWaysIntoTrackSegments(Track track, List<Way> waysToJoin, long id) {
        ArrayList<Way> joinedWays = new ArrayList<Way>();
        IndexRouteRelationCreator.spliceWaysIntoSegments(waysToJoin, joinedWays, id, 0);
        for (Way way : joinedWays) {
            if (way.getNodes().isEmpty()) continue;
            ArrayList<WptPt> wpts = new ArrayList<WptPt>();
            for (Node n : way.getNodes()) {
                wpts.add(new WptPt(n.getLatitude(), n.getLongitude()));
            }
            TrkSegment segment = new TrkSegment();
            segment.getPoints().addAll(wpts);
            track.getSegments().add(segment);
        }
    }

    private void addNode(GpxFile gpxFile, Node node) {
        if (node != null && !node.getTags().isEmpty()) {
            for (String k : this.skipNodeByTags.keySet()) {
                String nodeTagValue = (String)node.getTags().get(k);
                if (nodeTagValue == null || !nodeTagValue.equals(this.skipNodeByTags.get(k))) continue;
                return;
            }
            Map<String, String> transformedTags = this.renderingTypes.transformTags(node.getTags(), Entity.EntityType.NODE, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
            String gpxIcon = this.searchRequest.searchIconByTags(transformedTags);
            if (gpxIcon == null) {
                return;
            }
            WptPt wptPt = new WptPt();
            wptPt.setLat(node.getLatitude());
            wptPt.setLon(node.getLongitude());
            wptPt.getExtensionsToWrite().put("icon", gpxIcon);
            wptPt.setExtensionsWriter("route_relation_node", serializer -> {
                for (Map.Entry entry : node.getTags().entrySet()) {
                    Object key = ((String)entry.getKey()).replace(":", "_-_");
                    if (!((String)key).startsWith("osmand:")) {
                        key = "osmand:" + (String)key;
                    }
                    GpxUtilities.INSTANCE.writeNotNullText(serializer, (String)key, (String)entry.getValue());
                }
            });
            Map tags = node.getTags();
            for (String tag : this.nodeNameTags) {
                String val = (String)tags.get(tag);
                if (val == null) continue;
                wptPt.setName(val);
                break;
            }
            gpxFile.addPoint(wptPt);
            ++this.countNodes;
        }
    }

    static class AccessorForRelationExtract
    extends OsmDbAccessor {
        Map<Entity.EntityId, Entity> additionalEntities = new LinkedHashMap<Entity.EntityId, Entity>();

        AccessorForRelationExtract() {
        }

        public Map<Entity.EntityId, Entity> getAdditionalEntities() {
            return this.additionalEntities;
        }

        @Override
        public void loadEntityRelation(Relation e) throws SQLException {
            ArrayList<Entity> parentRelations = new ArrayList<Entity>();
            this.loadEntityRelation(e, parentRelations);
        }

        public void loadEntityRelation(Relation e, List<Entity> parentRelations) throws SQLException {
            if (e.isDataLoaded()) {
                return;
            }
            if (parentRelations.contains(e)) {
                log.info((Object)("==== circular relation link " + e.getId() + " on parent " + String.valueOf(parentRelations)));
                return;
            }
            parentRelations.add((Entity)e);
            LinkedHashMap<Entity.EntityId, Object> map = new LinkedHashMap<Entity.EntityId, Object>();
            if (e.getMembers().isEmpty()) {
                this.pselectRelation.setLong(1, e.getId());
                if (this.pselectRelation.execute()) {
                    ResultSet rs = this.pselectRelation.getResultSet();
                    while (rs.next()) {
                        int ord = rs.getInt(4);
                        if (ord == 0) {
                            this.readTags((Entity)e, rs.getBytes(5));
                        }
                        e.addMember(Long.valueOf(rs.getLong(1)), Entity.EntityType.values()[rs.getInt(2)], rs.getString(3));
                    }
                    rs.close();
                }
            }
            List ids = e.getMembers();
            if (parentRelations.size() > 0) {
                for (Relation.RelationMember i : ids) {
                    if (i.getEntityId().getType() == Entity.EntityType.NODE) {
                        this.pselectNode.setLong(1, i.getEntityId().getId());
                        if (!this.pselectNode.execute()) continue;
                        ResultSet rs = this.pselectNode.getResultSet();
                        Node n = null;
                        while (rs.next()) {
                            if (n != null) continue;
                            n = new Node(rs.getDouble(1), rs.getDouble(2), i.getEntityId().getId().longValue());
                            this.readTags((Entity)n, rs.getBytes(3));
                        }
                        map.put(i.getEntityId(), n);
                        rs.close();
                        continue;
                    }
                    if (i.getEntityId().getType() == Entity.EntityType.WAY) {
                        Way way = (Way)this.additionalEntities.get(i.getEntityId());
                        if (way == null) {
                            way = new Way(i.getEntityId().getId().longValue());
                            this.loadEntityWay(way);
                            if (!way.getNodes().isEmpty()) {
                                map.put(i.getEntityId(), way);
                            }
                        }
                        for (Entity pr : parentRelations) {
                            if (way.getTag("route_relation_ref:" + pr.getId()) != null) continue;
                            way.putTag("route_relation_ref:" + pr.getId(), Long.toString(pr.getId()));
                        }
                        continue;
                    }
                    if (i.getEntityId().getType() != Entity.EntityType.RELATION) continue;
                    Relation rel = new Relation(i.getEntityId().getId().longValue());
                    this.loadEntityRelation(rel, parentRelations);
                    map.put(i.getEntityId(), rel);
                }
                e.initializeLinks(map);
                e.entityDataLoaded();
                parentRelations.remove(e);
                this.additionalEntities.putAll(map);
            }
        }
    }
}

