/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.map.OsmandRegions;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class GenerateRegionTags {
    private static final Log LOG = PlatformUtil.getLog(GenerateRegionTags.class);

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                args = new String[]{"/Users/victorshcherb/osmand/temp/proc_line_motorway_out.osm.bz2", "/Users/victorshcherb/osmand/temp/region_proc_line_motorway_out.osm.bz2"};
            }
            File inputFile = new File(args[0]);
            File targetFile = new File(args[1]);
            OsmandRegions or = new OsmandRegions();
            or.prepareFile();
            or.cacheAllCountries();
            GenerateRegionTags.process(inputFile, targetFile, or);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void process(File inputFile, File targetFile, OsmandRegions or) throws IOException, XmlPullParserException, XMLStreamException {
        InputStream fis = new FileInputStream(inputFile);
        if (inputFile.getName().endsWith(".gz")) {
            fis = new GZIPInputStream(fis);
        } else if (inputFile.getName().endsWith(".bz2")) {
            fis = new BZip2CompressorInputStream(fis);
        }
        OsmBaseStorage bs = new OsmBaseStorage();
        bs.parseOSM(fis, (IProgress)new ConsoleProgressImplementation());
        LOG.info((Object)"File was read");
        GenerateRegionTags.iterateOverEntities(bs.getRegisteredEntities(), or);
        OsmStorageWriter w = new OsmStorageWriter();
        OutputStream output = new FileOutputStream(targetFile);
        if (targetFile.getName().endsWith(".gz")) {
            output = new GZIPOutputStream(output);
        } else if (targetFile.getName().endsWith(".bz2")) {
            output = new BZip2CompressorOutputStream(output);
        }
        LOG.info((Object)"Entities processed. About to save the file.");
        w.saveStorage(output, bs, null, true);
        output.close();
        fis.close();
    }

    private static void iterateOverEntities(Map<Entity.EntityId, Entity> ids, OsmandRegions or) throws IOException {
        LinkedHashMap<Entity.EntityId, TreeSet<String>> mp = new LinkedHashMap<Entity.EntityId, TreeSet<String>>();
        LOG.info((Object)("About to process " + ids.size() + " entities"));
        LOG.info((Object)"Processing nodes...");
        long i = 0L;
        for (Entity e : ids.values()) {
            if (!(e instanceof Node)) continue;
            GenerateRegionTags.printProgress(++i, ids.size());
            int y = MapUtils.get31TileNumberY((double)((Node)e).getLatitude());
            int x = MapUtils.get31TileNumberX((double)((Node)e).getLongitude());
            List l = or.query(x, y);
            Entity.EntityId id = Entity.EntityId.valueOf((Entity)e);
            TreeSet<String> lst = new TreeSet<String>();
            mp.put(id, lst);
            for (BinaryMapDataObject b : l) {
                String dw;
                if (!OsmandRegions.contain((BinaryMapDataObject)b, (int)x, (int)y) || Algorithms.isEmpty((CharSequence)(dw = or.getDownloadName(b))) || !or.isDownloadOfType(b, "region_map")) continue;
                lst.add(dw);
            }
            if (e.getTags().isEmpty()) continue;
            e.putTag("osmand_region_name", GenerateRegionTags.serialize(lst));
        }
        LOG.info((Object)"Processing ways...");
        for (Entity e : ids.values()) {
            if (!(e instanceof Way)) continue;
            GenerateRegionTags.printProgress(++i, ids.size());
            Way w = (Way)e;
            TreeSet<String> lst = new TreeSet<String>();
            for (Entity.EntityId id : w.getEntityIds()) {
                TreeSet ls = (TreeSet)mp.get(id);
                if (ls == null) continue;
                lst.addAll(ls);
            }
            if (e.getTags().isEmpty()) continue;
            e.putTag("osmand_region_name", GenerateRegionTags.serialize(lst));
        }
    }

    private static void printProgress(long i, int size) {
        if (i % 10000L == 0L) {
            LOG.info((Object)("Processing objects " + i + "..."));
        }
    }

    private static String serialize(TreeSet<String> lst) {
        StringBuilder bld = new StringBuilder();
        for (String next : lst) {
            if (bld.length() > 0) {
                bld.append(",");
            }
            bld.append(next);
        }
        return bld.toString();
    }
}

